<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Contact form shortcode.
 */
function ux_cb_module_contact_form_shortcode($atts) {
	$moduleID = 'contact-form';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_contact_form' );
	
	$html = ux_cb_get_module_template($moduleID, $atts);
	return $html;
}
add_shortcode('ux_cb_contact_form', 'ux_cb_module_contact_form_shortcode');

/**
 * UX Content Builder Module Contact form container.
 */
function ux_cb_module_contact_form_container($module, $moduleUnique) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id($moduleUnique);
	
	//type
	$type = get_post_meta($post_id, '__ux_cb_module_contact_form_type', true);
	if(!$type){
		$type = 'contact_form';
	}

	//Name box placehold
	$namePlacehold = get_post_meta($post_id, '__ux_cb_module_contact_form_name_placehold', true);
	if ( ! $namePlacehold ) {
		$namePlacehold = esc_attr__('Name','bm-builder');
	}

	//Email box placehold
	$emailPlacehold = get_post_meta($post_id, '__ux_cb_module_contact_form_email_placehold', true);
	if ( ! $emailPlacehold ) {
		$emailPlacehold = esc_attr__('Email','bm-builder');
	} 

	//recipient email
	$recipientEmail = get_post_meta($post_id, '__ux_cb_module_contact_form_recipient_email', true);
	if( ! $recipientEmail ) {
		$recipientEmail = is_email(get_option('admin_email'));
	}

	//button text
	$buttonText = get_post_meta($post_id, '__ux_cb_module_contact_form_button_text', true);
	if(!$buttonText){
		$buttonText = esc_html__('Send','bm-builder');
	}

	//sending text
	$sendingText = get_post_meta($post_id, '__ux_cb_module_contact_form_sending_text', true);
	if(!$sendingText){
		$sendingText = esc_html__('Sending','bm-builder');
	}
	
	//comment placehold
	$commentPlacehold = get_post_meta($post_id, '__ux_cb_module_contact_form_comment_placehold', true);
	if(!$commentPlacehold){
		$commentPlacehold = esc_html__('Your message','bm-builder');
	}
	
	//message
	$message = get_post_meta($post_id, '__ux_cb_module_contact_form_message', true);
	if(!$message){
		$message = esc_html__('Your message has been successfully sent!','bm-builder');
	}
	
	//field text
	$fieldText = get_post_meta($post_id, '__ux_cb_module_contact_form_field_text', true);
	
	//animation
	$animationClass = ux_cb_module_field_animation_class($module);
	$animationEnd = ux_cb_module_field_animation_end($module);

	//private disable
	$privateDisable = '';
	
	//style
	if ( ! $module['is_frontend'] ) {
		$html .= '<style type="text/css">' . sanitize_text_field( ux_cb_module_contact_form_style( $post_id, $moduleUnique, $html ) ). '</style>';
	}

	switch($type){
		case 'contact_form':
 
			$html .= '<div class="contactform ux-mod-nobg ' .esc_attr($animationClass). '" data-animationend="' .esc_attr($animationEnd). '">';
			$html .=   '<form action="' .esc_url( $_SERVER['REQUEST_URI'] ). '" id="contact-form" class="contact_form" method="POST">';
			$html .=     '<div class="contactform-input"><input type="text" id="idi_name" name="idi_name" class="requiredField" placeholder="' .esc_attr( $namePlacehold ). '" value="" /></div>';
			$html .=     '<div class="contactform-input"><input type="text" id="idi_mail" name="idi_mail" class="requiredField email" placeholder="' .esc_attr( $emailPlacehold ). '" value="" /></div>';
			$html .=     '<div><textarea rows="4" name="idi_text" id="idi_text" cols="4" class="requiredField inputError" placeholder="' .esc_textarea( $commentPlacehold ). '" ></textarea></div>';
			$html .=     '<input type="hidden" class="info-tip" value="send" name="contact_form" data-message="' .esc_attr( $message ). '" data-sending="' .esc_attr( $sendingText ). '" />';
			
			if ( $privacyPolicy = get_post_meta( $post_id, '__ux_cb_module_contact_form_privacy_policy', true ) ) {
				if ( $privacyPolicy == 'on' ) {
					$privacyPolicyMessage = get_post_meta( $post_id, '__ux_cb_module_contact_form_privacy_policy_message', true );
					$privateDisable = ' disabled="disabled"';
					$html .= '<div class="privacy-policy"><input type="checkbox" name="idi_privacy_policy" id="idi_privacy_policy_'.esc_attr( $moduleUnique ).'" /><label for="idi_privacy_policy_'.esc_attr( $moduleUnique ).'">' .wp_kses_post( $privacyPolicyMessage ). '</label></div>';
				}
			}
			$html .=     '<div class="btnarea">';
			$html .=       '<input type="submit" class="idi_send" name="idi_send"'.sanitize_text_field( $privateDisable ).' value="' .esc_attr( $buttonText ). '" />';
			$html .=     '</div>';
			
			
			
			$html .=   '</form>';
			$html .= '</div>';
			
			if(isset($_POST['contact_form']) && $_POST['contact_form'] == 'send'){
				$name = isset($_POST['idi_name']) ? esc_html(trim(htmlspecialchars($_POST['idi_name']), ENT_QUOTES)) : '';
				$email = isset($_POST['idi_mail']) ? is_email(trim(htmlspecialchars(urldecode($_POST['idi_mail'])), ENT_QUOTES)) : '';
				$content = isset($_POST['idi_text']) ? esc_html(trim(htmlspecialchars($_POST['idi_text']), ENT_QUOTES)) : '';
				$post_content = "This mail was sent by  $name .  Content:  $content";
				$title = 'Mail from '. is_email($email);
				$headers = 'Content-type: text/html; charset=utf-8' . "\r\n";
				wp_mail(is_email($recipientEmail), $title, $post_content, $headers);
			}
		
		break;
		
		case 'single_field':
		
		break;
	}
	
	return $html;
}
add_filter( 'ux_cb_module_container_contact-form', 'ux_cb_module_contact_form_container', 10, 2 );
