<?php
/**
 * UX Content Builder page option interface.
 */
if ( ! function_exists( 'ux_cb_page_option_interface' ) ) {
	function ux_cb_page_option_interface( ) {
		$moduleFields = apply_filters( 'ux_cb_module_fields', array() );
		
		if ( isset( $_GET['page'] ) ) {
			wp_enqueue_script( 'ux-cb-backend-script' );
			wp_enqueue_script( 'ux-cb-backend-tools' );
			wp_enqueue_style( 'ux-cb-backend-style' );
			wp_enqueue_style( 'ux-cb-backend-tools' );
			
			$plugin_page = wp_unslash( $_GET['page'] );
			$fields = $moduleFields[ $plugin_page ];
			
			$fields = wp_parse_args( $fields, array(
				'video' => '',
				'saveBtn' => ''
			) );
			
			if ( $plugin_page == 'ux-cb-slugs-portfolio' ) {
				flush_rewrite_rules();
			}
			
			$html = '';
		
			$html .= '<div class="wrap __ux_theme_wrap" data-module-id="' .sanitize_text_field( $plugin_page ). '">';
			$html .=   '<h3><span class="__ux_h3_text">' .esc_html( $fields[ 'title' ] ). '</span>';
			
					if ( $fields['video'] != '' ) {
						$html .= '<span id="__ux_video_play_btn" class="__ux_video_play_btn">Video Guide</span>';
					}
			
					if ( $fields['saveBtn'] != 'hidden' ) {
						$html .= '<button type="button" class="__ux_theme_save_button" data-saving="' .esc_attr__( 'saving', 'bm-builder' ). '" data-saved="' .esc_attr__( 'saved', 'bm-builder' ). '" data-save="' .esc_attr__( 'save', 'bm-builder' ). '">' .esc_html__( 'save', 'bm-builder' ). '</button>';
					}
			
			$html .=   '</h3>';
			
			if ( $fields['video'] != '' ) {
				$html .= '<div class="__ux_video_wrap" id="__ux_video_wrap" style="display:none; padding-top:60.3%;"><span class="__ux_video_close" id="__ux_video_close"></span><iframe data-src="' .$fields['video']. '" width="100%" height="auto" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe></div>';
			}
			
			$html .=   '<input id="ux-cb-current-plugin_page" type="hidden" value="' .sanitize_text_field( $plugin_page ). '">';
			$html .= '</div>';
			
			echo $html;
		}
	}
}

/**
 * UX Content Builder the content.
 */
if ( ! function_exists( 'ux_cb_the_content' ) ) {
	function ux_cb_the_content( $content ) {
		$wp_version = get_bloginfo( 'version' );
		
		$postID = get_the_ID();
		$post = get_post( $postID );
		$appendTo = false;
		
		if ( version_compare( $wp_version, '5.0', '>=' ) ) {
			if ( function_exists( 'has_blocks' ) ) {
				if (false === strpos( $content, 'ux_cb_wrap' ) ) {
					$appendTo = true;
				}
			}
		}
		
		if ( $appendTo ) {
			if ( $uxCbContent = get_post_meta( $postID, 'ux-cb-content', true ) ) {
				$content .= $uxCbContent;
			}
		}
		
		return $content;
		
	}
	add_filter( 'the_content', 'ux_cb_the_content', 10 );
}