<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder tools add page menu.
 */
if ( ! function_exists( 'ux_cb_tools_add_page_menu' ) ) {
	function ux_cb_tools_add_page_menu( $menuFields ) {
		$menuFields[] = array(
			'page_title' => __( 'BM Tools', 'bm-builder' ),
			'menu_title' => __( 'BM Tools', 'bm-builder' ),
			'capability' => 'manage_options',
			'menu_slug' => 'ux-cb-tools',
			'function' => 'ux_cb_page_option_interface',
			'icon_url' => 'dashicons-admin-tools',
			'position' => 71
		);
		
		return $menuFields;
	}
	//add_filter( 'ux_cb_page_menu_fields', 'ux_cb_tools_add_page_menu' );
}

/**
 * UX Content Builder tools add page submenu.
 */
if ( ! function_exists( 'ux_cb_tools_add_page_submenu' ) ) {
	function ux_cb_tools_add_page_submenu( $menuFields ) {
		/*$menuFields[] = array(
			'parent_slug' => 'ux-cb-tools',
			'page_title' => __( 'Import', 'bm-builder' ),
			'menu_title' => __( 'Import', 'bm-builder' ),
			'capability' => 'manage_options',
			'menu_slug' => 'ux-cb-tools',
			'function' => 'ux_cb_page_option_interface'
		);
		
		$menuFields[] = array(
			'parent_slug' => 'ux-cb-tools-page',
			'page_title' => __( 'Export', 'bm-builder' ),
			'menu_title' => __( 'Export', 'bm-builder' ),
			'capability' => 'manage_options',
			'menu_slug' => 'ux-cb-tools-export',
			'function' => 'ux_cb_page_option_interface'
		);*/
		
		$fields = ux_cb_tools_fields( array() );
		foreach ( $fields as $menuSlug => $menu ) {
			$menuFields[] = array(
				'parent_slug' => $menu['parent_slug'],
				'page_title' => $menu['title'],
				'menu_title' => $menu['title'],
				'capability' => 'manage_options',
				'menu_slug' => $menuSlug,
				'function' => $menu['callback']
			);
		}
		
		return $menuFields;
	}
	add_filter( 'ux_cb_page_submenu_fields', 'ux_cb_tools_add_page_submenu' );
}
?>