<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder register post type for portfolio.
 */
if ( ! function_exists( 'ux_cb_register_portfolio_post' ) ) {
	function ux_cb_register_portfolio_post() {
		$rewriteSlug = 'ux-portfolio';
		if ( $getOptionSlugs = get_option( 'ux-post-type-slugs' ) ) {
			$rewriteSlug = $getOptionSlugs;
		}
		
		$labels = array(
			'name'               => __( 'Portfolio', 'bm-builder' ),
			'singular_name'      => __( 'Project', 'bm-builder' ),
			'menu_name'          => __( 'Portfolio', 'bm-builder' ),
			'name_admin_bar'     => __( 'Project', 'bm-builder' ),
			'add_new'            => __( 'Add New', 'bm-builder' ),
			'add_new_item'       => __( 'Add New Project', 'bm-builder' ),
			'new_item'           => __( 'New Project', 'bm-builder' ),
			'edit_item'          => __( 'Edit Project', 'bm-builder' ),
			'view_item'          => __( 'View Project', 'bm-builder' ),
			'all_items'          => __( 'All Portfolio', 'bm-builder' ),
			'search_items'       => __( 'Search Portfolio', 'bm-builder' ),
			'parent_item_colon'  => __( 'Parent Portfolio:', 'bm-builder' ),
			'not_found'          => __( 'No portfolio found.', 'bm-builder' ),
			'not_found_in_trash' => __( 'No portfolio found in Trash.', 'bm-builder' )
		);
	
		$args = array(
			'labels'             => $labels,
			'show_in_rest' 		 => true,
			'description'        => __( 'Description.', 'bm-builder' ),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'rewrite'            => array( 'slug' => $rewriteSlug ),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => false,
			'menu_position'      => 5,
			'menu_icon'          => 'dashicons-format-gallery',
			'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
		);
	
		register_post_type( 'ux-portfolio', $args );
		
		$labels = array(   
			'name' => 'Categories', 
			'singular_name' => 'Categories', 
			'menu_name' => 'Categories',   
		);  
		
		register_taxonomy(   
			'ux-portfolio-cat',   
			array( 'ux-portfolio' ),   
			array(   
				'hierarchical' => true,  
				'show_in_rest' => true, 
				'labels' => $labels,   
				'show_ui' => true,   
				'query_var' => true,
				'show_admin_column' => true,
				'rewrite' => array( 'slug' => 'ux-portfolio-cat' ),   
			)   
		); 
	}
	add_action( 'ux_cb_after_init', 'ux_cb_register_portfolio_post' );
}

/**
 * Register meta box(es).
 */
if ( ! function_exists( 'ux_cb_register_portfolio_post_meta_box' ) ) {
	function ux_cb_register_portfolio_post_meta_box() {
		//Second Featured Image
		add_meta_box(
			'alternative-featured-image', 
			__( 'Second Featured Image', 'bm-builder' ), 
			'ux_cb_portfolio_post_meta_box_featured_image', 
			array('ux-portfolio', 'post'), 
			'side', 
			'low', 
			array(
				'set_text' => __( 'second featured image', 'bm-builder' ),
				'desc' => __( 'the image is used for your portfolio list when you need the mouseover effect to show another image', 'bm-builder' ),
				'name' => '_alternative_featured_image'
				
			)
		);
		
		//Cover Image
		add_meta_box(
			'cover-image',
			__( 'Cover Image', 'bm-builder' ),
			'ux_cb_portfolio_post_meta_box_featured_image',
			'ux-portfolio',
			'side',
			'low', 
			array(
				'set_text' => __( 'cover image', 'bm-builder' ),
				'desc' => __( 'the image is used for your post page hero cover and some sliders', 'bm-builder' ),
				'name' => '_cover_image'
				
			)
		);
	
	}
	add_action( 'add_meta_boxes', 'ux_cb_register_portfolio_post_meta_box' );
}

/**
 * Featured Image Meta box display callback.
 *
 * @param WP_Post $post Current post object.
 */
if ( ! function_exists( 'ux_cb_portfolio_post_meta_box_featured_image' ) ) {
	function ux_cb_portfolio_post_meta_box_featured_image( $post, $metabox ) {
		$_wp_additional_image_sizes = wp_get_additional_image_sizes();
		$thumbnail_id = get_post_meta( $post->ID, esc_attr($metabox['args']['name']), true );

		$set_thumbnail_link = '<p class="hide-if-no-js"><a href="%s" class="set-portfolio-thumbnail-image" title="%s" data-title="%s">%s</a><span class="howto">%s</span></p>';
	
		$content = sprintf( $set_thumbnail_link,
			'#',
			esc_html($metabox['title']),
			esc_html($metabox['args']['set_text']),
			esc_html('Set ' .$metabox['args']['set_text']),
			esc_html($metabox['args']['desc'])
		);
		
		$hidden = 'hidden';
	
		if ( $thumbnail_id && get_post( $thumbnail_id ) ) {
			$size = isset( $_wp_additional_image_sizes['post-thumbnail'] ) ? 'post-thumbnail' : array( 266, 266 );
	
			$thumbnail_html = wp_get_attachment_image( $thumbnail_id, $size );
	
			if ( ! empty( $thumbnail_html ) ) {
				$content = sprintf( $set_thumbnail_link,
					'#',
					esc_html($metabox['title']),
					esc_html($metabox['args']['set_text']),
					$thumbnail_html,
					esc_html($metabox['args']['desc'])
					
				);
				
				$hidden = false;
			}
		}
		
		$content .= '<p class="hide-if-no-js howto ' .sanitize_html_class($hidden). '">' .esc_html__( 'Click the image to edit or update', 'bm-builder' ). '</p>';
		$content .= '<p class="hide-if-no-js ' .sanitize_html_class($hidden). '"><a href="#" class="remove-portfolio-thumbnail-image">' .esc_html('Remove ' .$metabox['args']['set_text']). '</a></p>';
	
		$content .= '<input type="hidden" id="' .esc_attr($metabox['args']['name']). '" name="' .esc_attr($metabox['args']['name']). '" value="' .esc_attr( $thumbnail_id ? $thumbnail_id : '-1' ). '" />'; 
		
		echo $content;
		
		do_action( 'ux_cb_portfolio_post_meta_box_featured_image', $post, $metabox );
	}
}

/**
 * Portfolio featured image set ajax.
 */
if ( ! function_exists( 'ux_cb_portfolio_featured_image_set_ajax' ) ) {
	function ux_cb_portfolio_featured_image_set_ajax(){
		$name = sanitize_text_field($_POST['name']);
		$post_id = intval($_POST['post_id']);
		$thumbnail_id = intval($_POST['thumbnail_id']);
		
		update_post_meta( $post_id, $name, $thumbnail_id );
		
		if ( $thumbnail_id && get_post( $thumbnail_id ) ) {
			$_wp_additional_image_sizes = wp_get_additional_image_sizes();
			$size = isset( $_wp_additional_image_sizes['post-thumbnail'] ) ? 'post-thumbnail' : array( 266, 266 );
	
			$thumbnail_html = wp_get_attachment_image( $thumbnail_id, $size );
	
			if ( ! empty( $thumbnail_html ) ) {
				echo $thumbnail_html;
			}
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_portfolio_featured_image_set_ajax', 'ux_cb_portfolio_featured_image_set_ajax' );
} 

/**
 * Portfolio featured image remove ajax.
 */
if ( ! function_exists( 'ux_cb_portfolio_featured_image_remove_ajax' ) ) {
	function ux_cb_portfolio_featured_image_remove_ajax(){
		$name = sanitize_text_field($_POST['name']);
		$post_id = intval($_POST['post_id']);
		$thumbnail_id = intval($_POST['thumbnail_id']);
		
		$delete = delete_post_meta( $post_id, $name, $thumbnail_id );
		
		if ( $delete ) {
			echo 'ok';
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_portfolio_featured_image_remove_ajax', 'ux_cb_portfolio_featured_image_remove_ajax' );
} 

/**
 * Portfolio featured image Brightness of Cover Image.
 */
if ( ! function_exists( 'ux_cb_portfolio_brightness_of_cover_image' ) ) {
	function ux_cb_portfolio_brightness_of_cover_image($post, $metabox){
		if($metabox['id'] == 'cover-image'){
			$brightness = get_post_meta( $post->ID, '_brightness_of_cover_image', true );
			$default = 'light-logo';
			
			if($brightness){
				$default = $brightness;
			}
			
			$content = '<h4>' .esc_html__( 'Brightness of Cover Image', 'bm-builder' ). '</h4>';
			$content .= '<select name="_brightness_of_cover_image" id="_brightness_of_cover_image">';
			$content .= '<option value="dark-logo" ' .selected( $default, 'dark-logo', false ). '>' .esc_html__( 'Light', 'bm-builder' ). '</option>';
			$content .= '<option value="light-logo" ' .selected( $default, 'light-logo', false ). '>' .esc_html__( 'Dark', 'bm-builder' ). '</option>';
			$content .= '</select>';
			
			echo $content;
		}
	}
	add_action( 'ux_cb_portfolio_post_meta_box_featured_image', 'ux_cb_portfolio_brightness_of_cover_image', 10, 2 );
} 

/**
 * Portfolio meta box save.
 */
if ( ! function_exists( 'ux_cb_portfolio_save_meta_boxes' ) ) {
	function ux_cb_portfolio_save_meta_boxes($post_id){
		// dont run if the post array is no set
		if ( empty( $_POST ) || empty( $_POST['post_ID'] ) ) 
			return;
		
		// don't run the saving if this is an auto save
		if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE )
			return;
		
		$old = get_post_meta($post_id, '_brightness_of_cover_image', true);  
		$new = @$_POST['_brightness_of_cover_image'];  
	
		if ($new && $new != $old) {
			update_post_meta($post_id, '_brightness_of_cover_image', $new);  
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, '_brightness_of_cover_image', $old);  
		}
	}
	add_action( 'save_post', 'ux_cb_portfolio_save_meta_boxes' );
} 

/**
 * Enqueue portfolio backend scripts.
 */
if ( ! function_exists( 'ux_cb_portfolio_backend_enqueue_scripts' ) ) {
	function ux_cb_portfolio_backend_enqueue_scripts(){
		wp_enqueue_script( 'ux_cb_portfolio_backend_script', ux_cb_asset_url( 'js/ux-portfolio/ux-portfolio-script.js' ), array( 'jquery' ), UX_CB_VERSION, true );
	}
	add_action( 'load-post-new.php', 'ux_cb_portfolio_backend_enqueue_scripts' );
	add_action( 'load-post.php', 'ux_cb_portfolio_backend_enqueue_scripts' );
}

/**
 * Enqueue portfolio admin menu.
 */
if ( ! function_exists( 'ux_cb_portfolio_add_page_submenu' ) ) {
	function ux_cb_portfolio_add_page_submenu( $menuFields ){
		$menuFields[] = array(
			'parent_slug' => 'theme-option',
			'page_title' => esc_html__( 'ux-portfolio slug', 'sea-theme' ),
			'menu_title' => esc_html__( 'ux-portfolio slug', 'sea-theme' ),
			'capability' => 'administrator',
			'menu_slug' => 'theme-option-portfolio-slug',
			'function' => 'ux_cb_theme_option_portfolio_interface'
		);
		
		return $menuFields;
	}
	//add_filter( 'ux_cb_page_submenu_fields', 'ux_cb_portfolio_add_page_submenu' );
}


?>