<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module field system status.
 */
if ( ! function_exists( 'ux_cb_module_field_system_status' ) ) {
	function ux_cb_module_field_system_status( $item, $post_id, $item_val ) {
		if ( $item['type'] == 'systemStatus' ) {
			$activeTheme = wp_get_theme();
			
			switch ( $item['name'] ) {
				case 'theme_name': echo esc_html( $activeTheme->name ); break;
				case 'current_version': echo esc_html( $activeTheme->version ); break;
				case 'theme_directory': echo esc_html( get_stylesheet_directory() ); break;
				case 'child_theme':
					if ( is_child_theme() ) {
						echo '<mark class="yes"><span class="dashicons dashicons-yes"></span></mark>';
					} else {
						/* Translators: %s docs link. */
						echo '<span class="dashicons dashicons-no-alt"></span> &ndash; ' . wp_kses_post( sprintf( __( 'If you are modifying theme that you did not build personally we recommend using a child theme. See: <a href="%s" target="_blank">How to create a child theme</a>', 'bm-builder' ), 'https://codex.wordpress.org/Child_Themes' ) );
					}
				break;
				case 'license_activated': break;
				case 'home_url': echo get_option( 'home' ); break;
				case 'site_url': echo get_option( 'siteurl' ); break;
				case 'wp_path': echo ABSPATH; break;
				case 'wp_content_path': echo WP_CONTENT_DIR; break;
				case 'wordpress_version':
					$latestVersion = get_transient( 'ux_cb_system_status_wp_version_check' );
					$wpVersion = get_bloginfo( 'version' );
					
					if ( false === $latestVersion ) {
						$versionCheck = wp_remote_get( 'https://api.wordpress.org/core/version-check/1.7/' );
						$apiResponse  = json_decode( wp_remote_retrieve_body( $versionCheck ), true );
	
						if ( $apiResponse && isset( $apiResponse['offers'], $apiResponse['offers'][0], $apiResponse['offers'][0]['version'] ) ) {
							$latestVersion = $apiResponse['offers'][0]['version'];
						} else {
							$latestVersion = $wpVersion;
						}
						set_transient( 'ux_cb_system_status_wp_version_check', $latestVersion, DAY_IN_SECONDS );
					}
					
					if ( version_compare( $wpVersion, $latestVersion, '<' ) ) {
						echo '<mark class="error"><span class="dashicons dashicons-warning"></span> ' . sprintf( esc_html__( '%1$s - There is a newer version of WordPress available (%2$s)', 'bm-builder' ), esc_html( $wpVersion ), esc_html( $latestVersion ) ) . '</mark>';
					} else {
						echo '<mark class="yes">' . esc_html( $wpVersion ) . '</mark>';
					}
				
				break;
				case 'wordpress_multisite': echo ( is_multisite() ) ? '<span class="dashicons dashicons-yes"></span>' : '&ndash;'; break;
				case 'wordpress_memory_limit':
					if ( function_exists( 'ini_get' ) ) {
						// WP memory limit.
						$wpMemoryLimit = ux_cb_let_to_num( WP_MEMORY_LIMIT );
						if ( function_exists( 'memory_get_usage' ) ) {
							$wpMemoryLimit = max( $wpMemoryLimit, ux_cb_let_to_num( @ini_get( 'memory_limit' ) ) );
						}
						
						if ( $wpMemoryLimit < 67108864 ) {
							/* Translators: %1$s: Memory limit, %2$s: Docs link. */
							echo '<mark class="error"><span class="dashicons dashicons-warning"></span> ' . sprintf( esc_html__( '%1$s - We recommend setting memory to at least 64MB. See: %2$s', 'bm-builder' ), esc_html( size_format( $wpMemoryLimit ) ), '<a href="https://codex.wordpress.org/Editing_wp-config.php#Increasing_memory_allocated_to_PHP" target="_blank">' . esc_html__( 'Increasing memory allocated to PHP', 'bm-builder' ) . '</a>' ) . '</mark>';
						} else {
							echo '<mark class="yes">' . esc_html( size_format( $wpMemoryLimit ) ) . '</mark>';
						}
					}
				break;
				case 'wordpress_debug_mode':
					if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
						echo '<mark class="yes"><span class="dashicons dashicons-yes"></span></mark>';
					} else {
						echo '<mark class="no">&ndash;</mark>';
					}
				break;
				case 'language': echo esc_html( get_locale() ); break;
				case 'server_info':
					if ( isset( $_SERVER['SERVER_SOFTWARE'] ) ) {
						echo ux_cb_clean( wp_unslash( $_SERVER['SERVER_SOFTWARE'] ) );
					}
				break;
				case 'php_version':
					$phpVersion = phpversion();
					if ( version_compare( $phpVersion, '7.2', '>=' ) ) {
						echo '<mark class="yes">' . esc_html( $phpVersion ) . '</mark>';
					} else {
						$updateLink = ' <a href="#" target="_blank">' . esc_html__( 'How to update your PHP version', 'bm-builder' ) . '</a>';
						$class = 'error';
	
						if ( version_compare( $phpVersion, '5.4', '<' ) ) {
							$notice = '<span class="dashicons dashicons-warning"></span> ' . __( 'Theme will run under this version of PHP, however, some features such as geolocation are not compatible. Support for this version will be dropped in the next major release. We recommend using PHP version 7.2 or above for greater performance and security.', 'bm-builder' ) . $updateLink;
						} elseif ( version_compare( $phpVersion, '5.6', '<' ) ) {
							$notice = '<span class="dashicons dashicons-warning"></span> ' . __( 'Theme will run under this version of PHP, however, it has reached end of life. We recommend using PHP version 7.2 or above for greater performance and security.', 'bm-builder' ) . $updateLink;
						} elseif ( version_compare( $phpVersion, '7.2', '<' ) ) {
							$notice = __( 'We recommend using PHP version 7.2 or above for greater performance and security.', 'bm-builder' ) . $updateLink;
							$class  = 'recommendation';
						}
	
						echo '<mark class="' . esc_attr( $class ) . '">' . esc_html( $phpVersion ) . ' - ' . wp_kses_post( $notice ) . '</mark>';
					}
				break;
				case 'php_post_max_size':
					if ( function_exists( 'ini_get' ) ) {
						echo esc_html( size_format( ux_cb_let_to_num( ini_get( 'post_max_size' ) ) ) );
					}
				break;
				case 'php_time_limit':
					if ( function_exists( 'ini_get' ) ) {
						echo esc_html( ini_get( 'max_execution_time' ) );
					}
				break;
				case 'php_max_input_vars':
					if ( function_exists( 'ini_get' ) ) {
						echo esc_html( ini_get( 'max_input_vars' ) );
					}
				break;
				case 'mysql_version':
					$databaseVersion = ux_cb_server_database_version();
					$mysqlVersion = $databaseVersion['number'];
					$mysqlVersionString = $databaseVersion['string'];
					
					if ( version_compare( $mysqlVersion, '5.6', '<' ) && ! strstr( $mysqlVersionString, 'MariaDB' ) ) {
						/* Translators: %1$s: MySQL version, %2$s: Recommended MySQL version. */
						echo '<mark class="error"><span class="dashicons dashicons-warning"></span> ' . sprintf( esc_html__( '%1$s - We recommend a minimum MySQL version of 5.6. See: %2$s', 'bm-builder' ), esc_html( $mysqlVersionString ), '<a href="https://wordpress.org/about/requirements/" target="_blank">' . esc_html__( 'WordPress requirements', 'bm-builder' ) . '</a>' ) . '</mark>';
					} else {
						echo '<mark class="yes">' . esc_html( $mysqlVersionString ) . '</mark>';
					}
				
				break;
				
				case 'active_plugins':
				
				break;
			}
		}
	}
	add_action( 'ux_cb_module_fields_field', 'ux_cb_module_field_system_status', 10, 3 );
}