<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! function_exists( 'ux_cb_add_page_menu' ) ) {
	function ux_cb_add_page_menu() {
		if ( $menuFields = apply_filters( 'ux_cb_page_menu_fields', array() ) ) {
			foreach ( $menuFields as $menu ) {
				$menu = wp_parse_args($menu, array(
					'page_title' => '',
					'menu_title' => '',
					'capability' => 'manage_options',
					'menu_slug' => '',
					'function' => '',
					'icon_url' => '',
					'position' => ''
				));
				
				add_menu_page( $menu['page_title'], $menu['menu_title'], $menu['capability'], $menu['menu_slug'], $menu['function'], $menu['icon_url'], $menu['position'] ); 
			}
		}
		
		if ( $menuFields = apply_filters( 'ux_cb_page_submenu_fields', array() ) ) {
			foreach ( $menuFields as $menu ) {
				$menu = wp_parse_args($menu, array(
					'parent_slug' => '',
					'page_title' => '',
					'menu_title' => '',
					'capability' => 'manage_options',
					'menu_slug' => '',
					'function' => ''
				));
				
				add_submenu_page( $menu['parent_slug'], $menu['page_title'], $menu['menu_title'], $menu['capability'], $menu['menu_slug'], $menu['function'] ); 
			}
		}
	}
	add_action( 'admin_menu', 'ux_cb_add_page_menu' );
}

?>