<?php
/**
 * UX Content Builder Module Slider Config.
 */

//slider config fields
function ux_cb_module_slider_fields( $fields ) {
	$fields['slider'] = array(
		'id'           => 'slider',
		'animation'    => true,
		'title'        => esc_html__( 'Slider', 'bm-builder' ),
		'content'      => '',
		'shortcodeTag' => 'ux_cb_slider', 
		'shortcode'    => '[ux_cb_slider unique="" col="12"]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__( 'General Settings', 'bm-builder' ),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									//Style
									array('title'   => esc_html__( 'Style', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'image-select',
										  'name'    => '__ux_cb_module_slider_style',
										  'style'   => 'width:120px; height: 68px;',
										  'default' => 'style-1',
										  'class'   => 'slider-style',
										  'fields'  => array(
											  array( esc_html__( 'Style 1', 'bm-builder' ), 'style-1' ),
											  array( esc_html__( 'Style 2', 'bm-builder' ), 'style-2' ),
											  array( esc_html__( 'Style 3', 'bm-builder' ), 'style-3' )
										  )),
										  
									array('type'    => 'divide' ),
										  
									array('class'   => 'add-slide-button',
										  'type'    => 'button',
										  'target'  => '.ux-cb-module-slider-slide-group',
										  'text'    => esc_html__( 'Add Slide', 'bm-builder' ),
										  'name'    => '__ux_cb_module_slider_add_slide',
										  'wrap'    => 'fullwidth' )
								)
							)
						)
					),
					
					array(
						'section-id'    => '',
						'section-class' => 'ux-cb-module-slider-slide-group',
						'section-name'  => '__ux_cb_module_slider_items',
						'section-type'  => 'slider',
						'section-mod'   => 'template',
						'group' => array(
							array(
								'items' => array(
									//Select Images
									array('title'   => esc_html__( 'Select Images', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'upload',
										  'name'    => '__ux_cb_module_slider_media_images' ),
										  
									array('type'    => 'divide'),
									
									//Text Color
									array('title'   => esc_html__( 'Text Color', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_slider_text_color',
										  'ctrl'    => '__ux_cb_module_slider_style,style-1|style-2' ),
									
									//Page Number Color
									array('title'   => esc_html__( 'Page Number Color', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_slider_page_number_color',
										  'ctrl'    => '__ux_cb_module_slider_style,style-1' ),
									
									//Arrow Color
									array('title'   => esc_html__( 'Arrow Color', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_slider_arrow_color',
										  'ctrl'    => '__ux_cb_module_slider_style,style-1' ),

									//Logo and Menu Color
									array('title'   => esc_html__( 'Logo Color', 'bm-builder' ),
										  'desc'    => esc_html__( 'It works on page top only', 'bm-builder' ),
										  'type'    => 'select',
										  'default' => 'default-logo',
										  'name'    => '__ux_cb_module_slider_logo_color',
										  'ctrl'    => '__ux_cb_module_slider_style,style-1|style-2',
										  'fields'  => array(
											  array( esc_html__( 'Default', 'bm-builder' ),   'default-logo' ),
											  array( esc_html__( 'Alternative', 'bm-builder' ), 'alt-logo' )
										  )),

									array('title'   => esc_html__( 'Menu Color', 'bm-builder' ),
										  'desc'    => esc_html__( 'It works on page top only', 'bm-builder' ),
										  'type'    => 'select',
										  'default' => 'default-menu',
										  'name'    => '__ux_cb_module_slider_menu_color',
										  'ctrl'    => '__ux_cb_module_slider_style,style-1|style-2',
										  'fields'  => array(
											  array( esc_html__( 'Default', 'bm-builder' ),   'default-menu' ),
											  array( esc_html__( 'Alternative', 'bm-builder' ), 'alt-menu' )
										  )),
									
								 )
							)
						)
					),
					
					/******************
					*
					* Style 1 section
					*    
					******************/
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_slider_style,style-1',
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__( 'Fit Image to Container', 'bm-builder' ),
										  'desc'    => esc_html__( 'The image will not be cutted if active this option.', 'bm-builder' ),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_fit_img_contain',
										  'default' => 'off' ),

									array('type'    => 'divide'),
									
									//Slider Height Type
									array('title'   => esc_html__( 'Slider Height Type', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_height_type',
										  'default' => 'auto',
										  'fields'  => array(
											  array( esc_html__( 'Auto', 'bm-builder' ),   'auto' ),
											  array( esc_html__( 'Custom', 'bm-builder' ), 'custom' )
										  ))
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_slider_style_1_height_type,custom',
								'items' => array(
									// array('type'    => 'divide'),
									
									//Height
									array('title'   => esc_html__( 'Height', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_height',
										  'default' => '60',
										  'fields'  => array(
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  )),

									//Screen Height Minus Header and Footer
									array('title'   => esc_html__( 'Screen Height Minus Header and Footer', 'bm-builder' ),
										  'desc'    => '', 
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_slider_style_1_100_height_min_header_footer',
										  'ctrl'    => '__ux_cb_module_slider_style_1_height,100',
										  'style'   => 'width: 12em; margin-right: 1em;',
									),
									
									//Top-Bottom spacing
									array('title'   => esc_html__( 'Top/Bottom Spacing', 'bm-builder' ),
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_height,100',
										  'name'    => '__ux_cb_module_slider_style_1_100_height_min_header_footer_tb_spacing' ),

									//Height - for Mobile
									array('title'   => esc_html__( 'Height for mobile', 'bm-builder' ),
										  'desc'    => esc_html__( 'It works on portrait mode only.', 'bm-builder' ),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_height_mobile',
										  'default' => '60',
										  'fields'  => array(
										  	  array( esc_html__( '20% of Screen Height', 'bm-builder' ),  '20' ),
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  )),

									//Screen Height Minus Header and Footer - for Mobile
									array('title'   => esc_html__( 'Screen Height Minus Header and Footer For Mobile', 'bm-builder' ),
										  'desc'    => '', 
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_slider_style_1_100_height_min_header_footer_mobile',
										  'ctrl'    => '__ux_cb_module_slider_style_1_height_mobile,100',
										  'style'   => 'width: 12em; margin-right: 1em;',
									),
									
									//Top-Bottom spacing - for Mobile
									array('title'   => esc_html__( 'Top/Bottom Spacing For Mobile', 'bm-builder' ),
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_height_mobile,100',
										  'name'    => '__ux_cb_module_slider_style_1_100_height_min_header_footer_tb_spacing_mobile' ),
								)
							),
							array(
								'items' => array(
									array('type'    => 'divide'),
										  
									//Show Title
									array('title'   => esc_html__( 'Show Title', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_show_title',
										  'default' => 'on'),
										  
									//Title Font
									array('title'   => esc_html__( 'Title Font', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_slider_style_1_title_font',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_title,on',
										  'fontval' => array( 'family' => 'Poppins', 'weight' => 'normal', 'size' => '24px', 'lineheight' => '1.5', 'letter_spacing' => 'normal', 'msize' => '14px' ) 
									), //family, size, line height, letter spacing, mobile

									//Title Padding Bottom
									array('title'   => esc_html__( 'Title Padding Bottom', 'bm-builder' ),
										  'desc'    => '', 
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_slider_style_1_title_padding_bottom',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_title,on',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									//Hide Title for mobile
									array('title'   => esc_html__( 'Hide Title on Mobile', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_hide_title_mobile',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_title,on',
										  'default' => 'off'),
										  
									//Show Caption
									array('title'   => esc_html__( 'Show Caption', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_show_caption',
										  'default' => 'off'),
										  
									//Caption Font
									array('title'   => esc_html__( 'Caption Font', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_slider_style_1_caption_font',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_caption,on',
										  'fontval' => array( 'family' => 'Poppins', 'weight' => 'normal', 'size' => '24px', 'lineheight' => '40px', 'letter_spacing' => 'normal', 'msize' => '14px' ) ), //family, weight, size, line height, letter spacing,

									//Caption Padding Bottom
									array('title'   => esc_html__( 'Caption Padding Bottom', 'bm-builder' ),
										  'desc'    => '', 
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'name'    => '__ux_cb_module_slider_style_1_caption_padding_bottom',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_caption,on' ,
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									//Hide Caption for mobile
									array('title'   => esc_html__( 'Hide Caption on Mobile', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_hide_caption_mobile',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_caption,on',
										  'default' => 'off'),
										  
									// array('type'    => 'divide'),
										  
									//Text Align
									array('title'   => esc_html__( 'Text Align', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_text_align',
										  'default' => 'bottom-left',
										  'fields'  => array(
											  array( esc_html__( 'Left', 'bm-builder' ),          'left' ),
											  array( esc_html__( 'Center', 'bm-builder' ),        'center' ),
											  array( esc_html__( 'Right', 'bm-builder' ),         'right' ),
											  array( esc_html__( 'Bottom Left', 'bm-builder' ),   'bottom-left' ),
											  array( esc_html__( 'Bottom Center', 'bm-builder' ), 'bottom-center' ),
											  array( esc_html__( 'Bottom Right', 'bm-builder' ),  'bottom-right' )
										  )
									),

									//Padding on Left/Right
									array('title'   => esc_html__( 'Text Padding on Left/Right', 'bm-builder' ),
										  'desc'    => '', 
										  'type'    => 'multipleInput',
										  'default' => array('40','20'),
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_slider_style_1_padding_left_right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									//Padding on Bottom
									array('title'   => esc_html__( 'Text Padding on Bottom', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('40','20'),
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_slider_style_1_padding_bottom',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )  
									),
										  
									array('type'    => 'divide'),
										  
									//Show Page Number
									array('title'   => esc_html__( 'Show Page Number', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_show_page_number',
										  'default' => 'off' ),

									//Hide Page Number for mobile
									array('title'   => esc_html__( 'Hide Page Number on Mobile', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_hide_page_number_mobile',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_page_number,on',
										  'default' => 'off' ),
										  
									//Page Number Font
									array('title'   => esc_html__( 'Page Number Font', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_slider_style_1_page_number_font',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_page_number,on',
										  'fontval' => array( 'family' => 'Poppins', 'weight' => 'normal', 'size' => '24px', 'lineheight' => '40px', 'letter_spacing' => 'normal', 'msize' => '14px' ) ), //family, weight, size, line height, letter spacing, mobile size
										  
									//Page Number Align
									array('title'   => esc_html__( 'Align', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_page_number,on',
										  'name'    => '__ux_cb_module_slider_style_1_page_number_align',
										  'default' => 'slide-number-bottom-right',
										  'fields'  => array(
											  array( esc_html__( 'Bottom Left', 'bm-builder' ),   'slide-number-bottom-left' ),
											  array( esc_html__( 'Bottom Center', 'bm-builder' ), 'slide-number-bottom-center' ),
											  array( esc_html__( 'Bottom Right', 'bm-builder' ),  'slide-number-bottom-right' )
										  )),

									//Padding on Left/Right
									array('title'   => esc_html__( 'Padding on Left/Right', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType' => 'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_page_number,on',
										  'name'    => '__ux_cb_module_slider_style_1_page_number_padding_left_right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									//Padding on Bottom
									array('title'   => esc_html__( 'Padding on Bottom', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType'=> 'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_show_page_number,on',
										  'name'    => '__ux_cb_module_slider_style_1_page_number_padding_bottom',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) ),
										  
									array('type'    => 'divide'),
										  
									//Show Arrow
									array('title'   => esc_html__( 'Show Arrow', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_show_arrow',
										  'default' => 'off' ),

								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_slider_style_1_show_arrow,on',
								'items' => array(

									//Arrow Position
									array('title'   => esc_html__( 'Arrow Position', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_position',
										  'default' => 'left-right',
										  'fields'  => array(
											  array( esc_html__( 'Left and Right', 'bm-builder' ),           'left-right' ),
											  array( esc_html__( 'Together on Right Bottom', 'bm-builder' ), 'right-bottom' ),
											  array( esc_html__( 'Together on Center Bottom', 'bm-builder' ), 'center-bottom' ),
											  //array( esc_html__( 'Arrow Go with Cursor', 'bm-builder' ),     'arrow-go' )
										  )),

									//mouse cursor 
									array('title'   => esc_html__( 'Mouse Cursor on the Arrows', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_cursor_on_arrow',
										  'default' => 'pointer',
										  'fields'  => array(
											  array( esc_html__( 'One Finger', 'bm-builder' ), 'pointer' ),
											  array( esc_html__( 'Default Arrow', 'bm-builder' ), 'default' )
										  )),
										  
									//Left Arrow
									array('title'   => esc_html__( 'Left Arrow', 'bm-builder' ),
										  'desc'    => esc_html__( 'Select image', 'bm-builder' ),
										  'type'    => 'upload',
										  'name'    => '__ux_cb_module_slider_style_1_left_arrow' ),
										  
									//Right Arrow
									array('title'   => esc_html__( 'Right Arrow', 'bm-builder' ),
										  'desc'    => esc_html__( 'Select image', 'bm-builder' ),
										  'type'    => 'upload',
										  'name'    => '__ux_cb_module_slider_style_1_right_arrow' ),

									//Icon Height
									array('title'   => esc_html__( 'Icon Height', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType'=> 'number',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_icon_height',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('60', '40'),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )  
									),

									//Padding on Left/Right
									array('title'   => esc_html__( 'Padding on Left/Right', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_arrow_position,left-right',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_padding_left_right' ),
										  
									//Padding on Right
									array('title'   => esc_html__( 'Padding on Right', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType'=>'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_arrow_position,right-bottom',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_padding_right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									//Padding on Bottom (Right Bottom)
									array('title'   => esc_html__( 'Padding on Bottom', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType'=>'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_arrow_position,right-bottom',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_padding_bottom',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									//Spacing Between Icons (Right Bottom)
									array('title'   => esc_html__( 'Spacing Between Icons', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType'=>'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_arrow_position,right-bottom',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_spacing',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									//Padding on Bottom (Center Bottom)
									array('title'   => esc_html__( 'Padding on Bottom', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType'=>'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_arrow_position,center-bottom',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_padding_bottom_center',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									//Spacing Between Icons (Center Bottom)
									array('title'   => esc_html__( 'Spacing Between Icons', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'default' => array('',''),
										  'inputType'=>'number',
										  'ctrl'    => '__ux_cb_module_slider_style_1_arrow_position,center-bottom',
										  'name'    => '__ux_cb_module_slider_style_1_arrow_spacing_center',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_slider_style_1_show_arrow,off',
								'items' => array(
									array('type'    => 'divide'),

									array('title'   => esc_html__( 'Custom Mouse Cursor', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_mouse_cursor',
										  'default' => 'off' ),

									//Left Arrow
									array('title'   => esc_html__( 'Custom Mouse Cursor on Left', 'bm-builder' ),
										  'desc'    => esc_html__( 'The image size must be less than 128×128px, png/svg format', 'bm-builder' ),
										  'type'    => 'upload',
										  'ctrl'	=>'__ux_cb_module_slider_style_1_mouse_cursor,on',
										  'name'    => '__ux_cb_module_slider_style_1_left_cursor' ),
										  
									//Right Arrow
									array('title'   => esc_html__( 'Custom Mouse Cursor on Right', 'bm-builder' ),
										  'desc'    => esc_html__( 'Select image', 'bm-builder' ),
										  'type'    => 'upload',
										  'ctrl'	=>'__ux_cb_module_slider_style_1_mouse_cursor,on',
										  'name'    => '__ux_cb_module_slider_style_1_right_cursor' ),

									)
							),
							array(
								'items' => array(
									array('type'    => 'divide'),

									array('title'   => esc_html__( 'Enable Mouse Drag', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_mouse_drag',
										  'default' => 'off' ),

									array('type'    => 'divide'),
										  
									//Slider Animation
									array('title'   => esc_html__( 'Slider Animation', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_slider_animation',
										  'default' => 'slide',
										  'fields'  => array(
											  array( esc_html__( 'Slide', 'bm-builder' ),   'slide' ),
											  array( esc_html__( 'Fade In', 'bm-builder' ), 'fade-in' )
										  )),
										  
									array('type'    => 'divide'),
										  
									//Auto Play
									array('title'   => esc_html__( 'Auto Play', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_auto_play',
										  'default' => 'off' ),

									//Time for Single Slide (s)
									array('title'   => esc_html__( 'Time for Single Slide (s)', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'text',
										  'ctrl'    => '__ux_cb_module_slider_style_1_auto_play,on',
										  'name'    => '__ux_cb_module_slider_style_1_auto_play_time' ),
										  
									array('type'    => 'divide'),

									//Transition Speed
									array('title'   => esc_html__( 'Slide Transition Speed', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_1_transition_speed',
										  'default' => '300',
										  'ctrl'    => '__ux_cb_module_slider_style_1_slider_animation,slide',
										  'fields'  => array(
											  array( esc_html__( '0.9s', 'bm-builder' ),   '900' ),
											  array( esc_html__( '0.8s', 'bm-builder' ), '800' ),
											  array( esc_html__( '0.7s', 'bm-builder' ), '700' ),
											  array( esc_html__( '0.6s', 'bm-builder' ), '600' ),
											  array( esc_html__( '0.5s', 'bm-builder' ), '500' ),
											  array( esc_html__( '0.4s', 'bm-builder' ), '400' ),
											  array( esc_html__( '0.3s', 'bm-builder' ), '300' ),
											  array( esc_html__( '0.2s', 'bm-builder' ), '200' ),
											  array( esc_html__( '0.1s', 'bm-builder' ), '100' ),
											  array( esc_html__( '0s', 'bm-builder' ), '1' )
										  )),
										  
									array('type'    => 'divide'),
										  
									//Enable link
									array('title'   => esc_html__( 'Enable link', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_enable_link',
										  'default' => 'on' ),
										  
									//Open Link in New Tab
									array('title'   => esc_html__( 'Open Link in New Tab', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_1_link_new_tab',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_slider_style_1_enable_link,on' ),

									//nofollow
									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_slider_style_1_link_nofollow',
										  'ctrl'    => '__ux_cb_module_slider_style_1_enable_link,on'),
								
								)
							)
						)
					),
					
					/******************
					*
					* Style 2 section
					*    
					******************/
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_slider_style,style-2',
						'group' => array(
							array(
								'items' => array(
									array('type'    => 'divide'),
										  
									//Height
									array('title'   => esc_html__( 'Height', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_2_height',
										  'default' => '80',
										  'fields'  => array(
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  )),
										  
									//Height for mobile
									array('title'   => esc_html__( 'Height for mobile', 'bm-builder' ),
										  'desc'    => esc_html__( 'note: height will work on portrait mode only.', 'bm-builder' ),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_2_height_mobile',
										  'default' => '60%',
										  'fields'  => array(
										      array( esc_html__( '20% of Screen Height', 'bm-builder' ),  '20' ),
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  )),
										  
									array('type'    => 'divide'),
										  
									//Title Font
									array('title'   => esc_html__( 'Title Font', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_slider_style_2_title_font',
										  'fontval' => array( 'family' => '0', 'size' => '24px', 'lineheight' => '1.5', 'letter_spacing' => 'normal', 'msize' => '14px' )
									), //family, weight, size, line height, letter spacing,

									//Spacing Between Items
									array('title'   => esc_html__( 'Spacing Between Items', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_slider_style_2_spacing', 
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),
										  
									//Align
									array('title'   => esc_html__( 'Align', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_2_align',
										  'default' => 'style2-text-left',
										  'fields'  => array(
											  array( esc_html__( 'Left', 'bm-builder' ),          'style2-text-left' ),
											  array( esc_html__( 'Center', 'bm-builder' ),        'style2-text-center' ),
											  array( esc_html__( 'Right', 'bm-builder' ),         'style2-text-right' ),
											  array( esc_html__( 'Bottom Left', 'bm-builder' ),   'style2-text-bottomleft' ),
											  array( esc_html__( 'Bottom Right', 'bm-builder' ),  'style2-text-bottomright' )
										  )),

									//highlight effect
									array('title'   => esc_html__('Highlight Effect for Activated Text','bm-builder'),
										  'type'    => 'select',
										  'default' => '',
										  'name'    => '__ux_cb_module_slider_style_2_text_highlight',
										  'fields'  => array(
											  array( esc_html__( 'Default', 'bm-builder' ),          '' ),
											  array( esc_html__( 'Underline', 'bm-builder' ),        'text-underline' )
										  )),

									//inline text
									array('title'   => esc_html__('Text Display Inline','bm-builder'),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_slider_style_2_text_inline'),

									//enable mask
									array('title'   => esc_html__('Enable Mask above Image','bm-builder'),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_slider_style_2_mask'),

									//mask Color
									array('title'   => esc_html__( 'Mask Color', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_slider_style_2_mask_color',
										  'ctrl'    => '__ux_cb_module_slider_style_2_mask,on' ),

									array('title'   => esc_html__('Transparent for Mask','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_2_mask_opacity',
										  'default' => '0.3',
										  'ctrl'    => '__ux_cb_module_slider_style_2_mask,on',
										  'fields'  => array(
											  array(esc_html__('100%','bm-builder'), '1'),
											  array(esc_html__('90%','bm-builder'),  '0.9'),
											  array(esc_html__('80%','bm-builder'),  '0.8'),
											  array(esc_html__('70%','bm-builder'),  '0.7'),
											  array(esc_html__('60%','bm-builder'),  '0.6'),
											  array(esc_html__('50%','bm-builder'),  '0.5'),
											  array(esc_html__('40%','bm-builder'),  '0.4'),
											  array(esc_html__('30%','bm-builder'),  '0.3'),
											  array(esc_html__('20%','bm-builder'),  '0.2'),
											  array(esc_html__('10%','bm-builder'),  '0.1'),
											  array(esc_html__('0%','bm-builder'),  '0.00000001'),
										  )),

									//enable Ken Burns
									array('title'   => esc_html__('Enable Ken Burns','bm-builder'),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_slider_style_2_kenburns'),

									//Padding on Left/Right
									array('title'   => esc_html__( 'Padding on Left/Right', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_slider_style_2_padding_left_right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )  
									),

									//Padding on Bottom
									array('title'   => esc_html__( 'Padding on Bottom', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_slider_style_2_padding_bottom',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )  
									),
									
								)
							)
						)
					),
					
					/******************
					*
					* Style 3 section
					*    
					******************/
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_slider_style,style-3',
						'group' => array(
							array(
								'items' => array(
									array('type'    => 'divide'),
										  
									//Height
									array('title'   => esc_html__( 'Height', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_3_height',
										  'default' => '60',
										  'fields'  => array(
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  )),

									//Height for mobile
									array('title'   => esc_html__( 'Height for mobile', 'bm-builder' ),
										  'desc'    => esc_html__( 'It will work on portrait mode only.', 'bm-builder' ),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_3_height_mobile',
										  'default' => '30',
										  'fields'  => array(
										  	  array( esc_html__( '20% of Screen Height', 'bm-builder' ),  '20' ),
											  array( esc_html__( '30% of Screen Height', 'bm-builder' ),  '30' ),
											  array( esc_html__( '40% of Screen Height', 'bm-builder' ),  '40' ),
											  array( esc_html__( '50% of Screen Height', 'bm-builder' ),  '50' ),
											  array( esc_html__( '60% of Screen Height', 'bm-builder' ),  '60' ),
											  array( esc_html__( '70% of Screen Height', 'bm-builder' ),  '70' ),
											  array( esc_html__( '80% of Screen Height', 'bm-builder' ),  '80' ),
											  array( esc_html__( '90% of Screen Height', 'bm-builder' ),  '90' ),
											  array( esc_html__( '100% of Screen Height', 'bm-builder' ), '100' )
										  )),

									//Spacing Between Slides
									array('title'   => esc_html__( 'Spacing Between Slides', 'bm-builder' ),
										  'name'    => '__ux_cb_module_slider_style_3_spacing',
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'inputType'=>'number',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array(40, 10),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),
										  
									array('type'    => 'divide'),
							

									//Show Arrow
									array('title'   => esc_html__( 'Show Arrow', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_3_show_arrow',
										  'default' => 'off' ),


								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_slider_style_3_show_arrow,on',
								'items' => array(

									//Arrow Position
									array('title'   => esc_html__( 'Arrow Position', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_3_arrow_position',
										  'ctrl'    => '__ux_cb_module_slider_style_3_show_arrow,on',
										  'default' => 'left-right',
										  'fields'  => array(
											  array( esc_html__( 'Left and Right', 'bm-builder' ),           'left-right' ),
											 // array( esc_html__( 'Arrow Go with Cursor', 'bm-builder' ),     'arrow-go' )
										  )),

									//mouse cursor 
									array('title'   => esc_html__( 'Mouse Cursor on the Arrows', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_slider_style_3_cursor_on_arrow',
										  'default' => 'pointer',
										  'fields'  => array(
											  array( esc_html__( 'One Finger', 'bm-builder' ), 'pointer' ),
											  array( esc_html__( 'Default Arrow', 'bm-builder' ), 'default' )
										  )),
										  
									//Left Arrow
									array('title'   => esc_html__( 'Left Arrow', 'bm-builder' ),
										  'desc'    => esc_html__( 'Select image', 'bm-builder' ),
										  'type'    => 'upload',
										  'ctrl'    => '__ux_cb_module_slider_style_3_show_arrow,on',
										  'name'    => '__ux_cb_module_slider_style_3_left_arrow' ),
										  
									//Right Arrow
									array('title'   => esc_html__( 'Right Arrow', 'bm-builder' ),
										  'desc'    => esc_html__( 'Select image', 'bm-builder' ),
										  'type'    => 'upload',
										  'ctrl'    => '__ux_cb_module_slider_style_3_show_arrow,on',
										  'name'    => '__ux_cb_module_slider_style_3_right_arrow' ),

									//Icon Height
									array('title'   => esc_html__( 'Icon Height', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'ctrl'    => '__ux_cb_module_slider_style_3_show_arrow,on',
										  'name'    => '__ux_cb_module_slider_style_3_arrow_icon_height' ),

									//Padding on Left/Right
									array('title'   => esc_html__( 'Padding on Left/Right', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'ctrl'    => '__ux_cb_module_slider_style_3_show_arrow,on',
										  'name'    => '__ux_cb_module_slider_style_3_arrow_padding_left_right' ),
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_slider_style_3_show_arrow,off',
								'items' => array(
									array('type'    => 'divide'),

									array('title'   => esc_html__( 'Custom Mouse Cursor', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_3_mouse_cursor',
										  'default' => 'off' ),

									//Left Arrow
									array('title'   => esc_html__( 'Custom Mouse Cursor on Left', 'bm-builder' ),
										  'desc'    => esc_html__( 'The image size must be less than 128×128px, png/svg format. The width and height must be set for SVG image', 'bm-builder' ),
										  'type'    => 'upload',
										  'ctrl'	=>'__ux_cb_module_slider_style_3_mouse_cursor,on',
										  'name'    => '__ux_cb_module_slider_style_3_left_cursor' ),
										  
									//Right Arrow
									array('title'   => esc_html__( 'Custom Mouse Cursor on Right', 'bm-builder' ),
										  'desc'    => esc_html__( 'Select image', 'bm-builder' ),
										  'type'    => 'upload',
										  'ctrl'	=>'__ux_cb_module_slider_style_3_mouse_cursor,on',
										  'name'    => '__ux_cb_module_slider_style_3_right_cursor' ),
								)
							),
							array(
								'items' => array(

									array('type'    => 'divide'),
									
									array('title'   => esc_html__( 'Enable Mouse Drag', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_3_mouse_drag',
										  'default' => 'off' ),

									array('type'    => 'divide'),

									//Auto Play
									array('title'   => esc_html__( 'Auto Play', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_3_auto_play',
										  'default' => 'off' ),

									//Time for Single Slide (s)
									array('title'   => esc_html__( 'Time for Single Slide (s)', 'bm-builder' ),
										  'desc'    => '',
										  'place'   => esc_html__( 'Enter a number here', 'bm-builder' ),
										  'type'    => 'text',
										  'ctrl'    => '__ux_cb_module_slider_style_3_auto_play,on',
										  'name'    => '__ux_cb_module_slider_style_3_auto_play_time' ),
										  
									array('type'    => 'divide'),
										  
									//Enable link
									array('title'   => esc_html__( 'Enable link', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_3_enable_link',
										  'default' => 'on' ),
										  
									//Open Link in New Tab
									array('title'   => esc_html__( 'Open Link in New Tab', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_slider_style_3_link_new_tab',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_slider_style_3_enable_link,on' ),

									//nofollow
									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_slider_style_3_link_nofollow',
										  'ctrl'    => '__ux_cb_module_slider_style_3_enable_link,on'),
									
								)
							)
						
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__( 'Advanced Settings', 'bm-builder' ),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array()
					)
				)
			)	
		)
	);
	
	return $fields;
	
}
add_filter( 'ux_cb_module_fields', 'ux_cb_module_slider_fields' );
?>