<?php
/* Template for Single Post */

get_header();
global $theme_options; ?>

<?php while (have_posts()) : the_post(); ?>

	<div id="page-banner">
		<div class="container">
			<h1><?php the_title(); ?></h1>

			<p class="entry-meta">
				<span class="entry-meta-date">
					<i class="fa fa-icon-time"></i> <?php the_time(get_option('date_format')); ?>
					<span>&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;</span>
				</span>
				<span class="entry-meta-author">
					<i class="fa fa-icon-user"></i> <?php the_author(); ?> 
					<span>&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;</span>
				</span>
				<span class="entry-meta-category">
					<i class="fa fa-icon-folder-open"></i> <?php the_category(', '); ?> 
				</span>
				<span class="entry-meta-comments">				
					<?php if($post->comment_status == 'open') { ?>
						<span>&nbsp;&nbsp;&nbsp;&middot;&nbsp;&nbsp;&nbsp;</span>
						<i class="fa fa-icon-comments"></i> <?php comments_popup_link(__('No Comments', 'sntheme'), __('1 Comment', 'sntheme'), __('% Comments', 'sntheme'), 'comments-link', __('Comments are disabled', 'sntheme')); ?>
					<?php } ?>
				</span>
			</p>
			
		</div>
	</div>
	
	<div id="main">
		<div class="container">
		
		<div id="content" class="<?php if(isset($theme_options['sidebar_on_post'])) { if($theme_options['sidebar_on_post']) { } else { echo ' fullwidth'; } } if(!is_active_sidebar('home-sidebar')) { echo ' fullwidth'; } ?>">
		
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						
			<?php
			/* Featured Image */
			if(has_post_thumbnail()) { ?>
			<p class="post-thumbnail">
				<?php the_post_thumbnail('full'); ?>
			</p>
			<?php } 
			
			the_content();
			
			the_tags('<p>'.__('Tags:', 'sntheme'),', ','</p>');
			
			/* Show post page links */
			wp_link_pages( array( 'before' => '<p>' . __( 'Pages:', 'sntheme' ), 'after' => '</p>' ) ); 
			?>
			
		</article><!-- end post -->
			
		<?php if($post->comment_status == 'open') { ?>
		<div class="post-comments">
			<?php comments_template(); ?>
		</div>
		<?php } ?>
			
	</div>
		
<?php endwhile; ?>
	
<?php if(isset($theme_options['sidebar_on_post'])) { if($theme_options['sidebar_on_post']) { get_sidebar(); } } ?>
<?php get_footer(); ?>