<?php
/* Template for Single Gallery */

 get_header();
global $theme_options; ?>

	<div id="page-banner">
		<div class="container">
			<h1><?php the_title(); ?></h1>
		</div>
	</div>
	
	<div id="main">
		<div class="container">

<?php while (have_posts()) : the_post(); ?>
		
		<div id="content" class="<?php if(isset($theme_options['sidebar_on_gallery'])) { if($theme_options['sidebar_on_gallery']) { } else { echo ' fullwidth'; } } if(!is_active_sidebar('sidebar')) { echo ' fullwidth'; } ?>">
		
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
									
			<?php the_content(); ?>

			<?php
			/* Get Gallery Images */
			$post_content = $post->post_content;
			preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $gallery_ids);
			if(isset($gallery_ids[1])) {
				$gallery_images = explode(",", $gallery_ids[1]);
				if(!empty($gallery_images)) { $gallery_count = count($gallery_images); }
			} else {
				$gallery_atts = array(
					'post_parent' => $post->ID, 
					'post_mime_type' => 'image', 
					'order'=> 'ASC'
				);
				$gallery_images = array();
				$gallery_image_posts = get_children($gallery_atts);
				foreach($gallery_image_posts as $gallery_image_post) {
					$gallery_images = $gallery_image_post->ID;
				}
				if(!empty($gallery_images)) { $gallery_count = count($gallery_images); }
			}
			?>
			
			<div class="sn-gallery" current="0">
				
				<a href="#" class="sn-button gallery-nav gallery-prev"><i class="fa fa-angle-left"></i></a>
				<a href="#" class="sn-button gallery-nav gallery-next"><i class="fa fa-angle-right"></i></a>
				
				<ul class="gallery-slides">
					<?php 
					/* Loop Gallery Images */
					foreach($gallery_images as $gallery_image) { 
						$gallery_image = get_post($gallery_image); 
						if(isset($gallery_image->ID)) { ?>
						<li>
							<?php $postimage = wp_get_attachment_image_src($gallery_image->ID, 'full'); ?>
							<img src="<?php echo $postimage[0]; ?>" alt="" />
							<?php if($gallery_image->post_excerpt) { ?>
								<span class="caption"><?php echo $gallery_image->post_excerpt; ?></span>
							<?php } ?>
						</li>
					<?php } } ?>
				</ul>
			
			</div>

			
		</article><!-- end post -->
			
		<?php if($post->comment_status == 'open') { ?>
		<div class="post-comments">
			<?php comments_template(); ?>
		</div>
		<?php } ?>
			
	</div>
		
<?php endwhile; ?>
	
<?php if(isset($theme_options['sidebar_on_gallery'])) { if($theme_options['sidebar_on_gallery']) { get_sidebar(); } } ?>
<?php get_footer(); ?>