<?php
/* Template for Single Fixture */

get_header();
global $theme_options; ?>

<?php while (have_posts()) : the_post(); ?>
		
	<div id="fixtures-bar">
		<div class="holder">
		<ul>
		<?php		
		$this_fixture = $post->ID;
		$this_team_term = get_the_terms($post->ID, 'team');
		if($this_team_term && !is_wp_error($this_team_term)) {
			foreach($this_team_term as $term) {
				$this_team = $term;
			}
		}
		$this_season_term = get_the_terms($post->ID, 'season');
		if($this_season_term && !is_wp_error($this_season_term)) {
			foreach($this_season_term as $season) {
				$this_season = $season;
			}
		}
		if(isset($this_team)) {
			if(isset($this_season)) {
				$this_team_fixtures_args = array(
					'posts_per_page' => -1,
					'post_type' => 'fixture',
					'orderby' => 'meta_value',
					'meta_key' => 'fixture_date',
					'order' => 'ASC',
					'tax_query' => array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'team',
							'field' => 'id',
							'terms' => $this_team->term_id
						),
						array(
							'taxonomy' => 'season',
							'field' => 'id',
							'terms' => $this_season->term_id
						)
					)
				);
			} else {
				$this_team_fixtures_args = array(
					'posts_per_page' => -1,
					'post_type' => 'fixture',
					'orderby' => 'meta_value',
					'meta_key' => 'fixture_date',
					'order' => 'ASC',
					'tax_query' => array(
						array(
							'taxonomy' => 'team',
							'field' => 'id',
							'terms' => $this_team->term_id
						)
					)
				);
			}
			$this_team_fixtures = get_posts($this_team_fixtures_args);
			$prev = '';
			$next = '';
			$get_prev = 1;
			$get_next = 0;
			$fixture_posts = array();
			foreach($this_team_fixtures as $fixture) {

				$fixture_time = get_post_meta($fixture->ID, 'fixture_time', true);
				if($fixture_time == "") { $fixture_time = '0:00'; }
				$fixture_seconds = date("U", strtotime(get_post_meta($fixture->ID, 'fixture_date', true).' '.$fixture_time));
				$fixture_posts[$fixture_seconds] = array($fixture_seconds, $fixture->ID);
			
			}
			$this_fixture = $post->ID;
			ksort($fixture_posts);
			foreach($fixture_posts as $fixture_post) { 
				query_posts('post_type=fixture&p='.$fixture_post[1]);
				while(have_posts()) : the_post();
				$fixture = $post;
				$fixture_date = get_post_meta($fixture->ID, 'fixture_date', true);
				if($fixture_date) {
					$fixture_date = str_split($fixture_date);
					$fixture_date = date(sn_evergreen_sports_date_format(), strtotime($fixture_date[0].$fixture_date[1].$fixture_date[2].$fixture_date[3].'-'.$fixture_date[4].$fixture_date[5].'-'.$fixture_date[6].$fixture_date[7]));
				}
				if(get_post_meta($fixture->ID, 'fixture_home_score', true)) {
					$home_score = get_post_meta($fixture->ID, 'fixture_home_score', true);
				} else { $home_score = 0; }
				if(get_post_meta($fixture->ID, 'fixture_away_score', true)) {
					$away_score = get_post_meta($fixture->ID, 'fixture_away_score', true);
				} else { $away_score = 0; }
				?>
				
				<li<?php if($fixture->ID == $this_fixture) { echo ' class="active"'; } ?>><a href="<?php echo get_permalink($fixture->ID); ?>">
					<span class="date"><?php echo $fixture_date; ?></span>
					<h4>
					<?php
						echo get_post_meta($fixture->ID, 'fixture_home_team_name', true).' <strong>'.$home_score.'</strong>';
						
						if(sn_evergreen_sports_date_is_vs()) {
							echo '- <strong>'.$away_score.'</strong> '.get_post_meta($fixture->ID, 'fixture_away_team_name', true).'';
						}
					 ?></h4>
				</a></li>
				
				<?php 
				endwhile; wp_reset_query();
			}
			
		} ?>
			</ul>
		</div>
	</div>
		

	<div id="main">
		<div class="container">
		
		<div id="content" class="<?php if(isset($theme_options['sidebar_on_fixture'])) { if($theme_options['sidebar_on_fixture']) { } else { echo ' fullwidth'; } } if(!is_active_sidebar('sidebar')) { echo ' fullwidth'; } ?>">
			
				<?php the_content(); ?>
		
			</div>
		
<?php endwhile; ?>
	
<?php if(isset($theme_options['sidebar_on_fixture'])) { if($theme_options['sidebar_on_fixture']) { get_sidebar(); } } ?>
<?php get_footer(); ?>