<?php

/* Theme Shortcodes */

function sn_galleries($atts, $content = null) {
	$galleries_code = '<div class="sn-galleries">';
	
	$galleries = get_posts('post_type=sn_gallery&posts_per_page=-1');
	foreach($galleries as $gallery) {
		
		if(has_post_thumbnail($gallery->ID)) {
			$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($gallery->ID), 'thumbnail' );
			$image = $thumb['0'];
		} else {
			$post_content = $gallery->post_content;
			preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $gallery_ids);
			if(isset($gallery_ids[1])) {
				$gallery_images = explode(",", $gallery_ids[1]);
				if(!empty($gallery_images)) { $gallery_count = count($gallery_images); }
			} else {
				$gallery_atts = array(
					'post_parent' => $gallery->ID, 
					'post_mime_type' => 'image', 
					'order'=> 'ASC'
				);
				$gallery_images = array();
				$gallery_image_posts = get_children($gallery_atts);
				foreach($gallery_image_posts as $gallery_image_post) {
					$gallery_images = $gallery_image_post->ID;
				}
				if(!empty($gallery_images)) { $gallery_count = count($gallery_images); }
			}
			$gallery_image = $gallery_images[0];
			$gallery_image = get_post($gallery_image); 
			if(isset($gallery_image->ID)) {
				$image = wp_get_attachment_image_src($gallery_image->ID, 'thumbnail');
				$image = $image[0];
			}
		} 
		
		$galleries_code .= '
		<div class="sn-gallery-archive">
			<h3><a href="'.get_permalink($gallery->ID).'">'.$gallery->post_title.'</a> <span class="gallery-count"><i class="fa fa-icon-camera"></i> '.$gallery_count.__(' images', 'sntheme').'</span></h3>';
				
			if($gallery->post_excerpt) {
				$galleries_code .= '<p>'.$gallery->post_excerpt.'</p>';
			}
		
			$galleries_code .= '<div class="images-holder"><ul>';
			
			foreach($gallery_images as $gallery_image) {
				$gallery_image = get_post($gallery_image);
				if(isset($gallery_image->ID)) {
					$image = wp_get_attachment_image_src($gallery_image->ID, 'medium');
					$galleries_code .= '<li><a href="'.get_permalink($gallery->ID).'"><img src="'.$image[0].'" alt="" /></a></li>';
				}
			}
			
		$galleries_code .= '</ul>
			<a href="'.get_permalink($gallery->ID).'" class="view-gallery"><i class="fa fa-icon-angle-right"></i></a>
		</div>';
		
		$galleries_code .= '</div>';
		
	}
	
	$galleries_code .= '</div>';
	
	return $galleries_code;
	return '<a href="'.$link.'" class="button">'.do_shortcode($content).'</a>';
}
add_shortcode('galleries', 'sn_galleries');