<?php 

/* Include admin files */
	require_once(get_template_directory().'/includes/admin/theme-options.php');
	
/* Enqueue Scripts */
	function sn_include_scripts($scripts_to_include) {
	
		foreach($scripts_to_include as $script_to_include) {
			
			if($script_to_include == "media_upload") {
				wp_enqueue_media();
				wp_enqueue_script( 'custom-header' );
			} else if($script_to_include == "chosen") {
				wp_enqueue_style('chosen_css', get_template_directory_uri().'/includes/admin/scripts/chosen/chosen.css');
			    wp_register_script('chosen_js', get_template_directory_uri().'/includes/admin/scripts/chosen/chosen.jquery.min.js');
				wp_enqueue_script('chosen_js');
			} else if($script_to_include == "sortable") {
				wp_enqueue_script('jquery-ui-sortable');
			} else if($script_to_include == "datepicker") {
				wp_enqueue_script('jquery-ui-core');
				wp_enqueue_script('jquery-ui-datepicker');
				wp_enqueue_style('datepicker-style', get_template_directory_uri().'/includes/admin/scripts/datepicker/jquery-ui-1.8.23.custom.css');
			} else if($script_to_include == "colourpicker") {
				wp_enqueue_style('wp-color-picker');          
			    wp_enqueue_script('wp-color-picker');   
			} else if($script_to_include == "icon_fonts") {
				wp_enqueue_style('admin-fontawesome', get_template_directory_uri().'/includes/admin/scripts/fonts/fontAwesome/css/font-awesome.css');
				wp_enqueue_style('admin-fontello', get_template_directory_uri().'/includes/admin/scripts/fonts/fontello/css/fontello.css');		
			} else if($script_to_include == "admin") {
				wp_enqueue_style('sn_admin_css', get_template_directory_uri().'/includes/admin/scripts/admin.css');
			    wp_register_script('sn_admin_js', get_template_directory_uri().'/includes/admin/scripts/admin.js');
				wp_enqueue_script('sn_admin_js');
			}
			
		}
	
	}


/* Theme Options */

	/* On theme activation */
	if(isset($_GET['activated'])) { wp_redirect(admin_url("themes.php?page=theme_options")); }
	
	/* Initialise the options */
	function sn_theme_options_init() { register_setting( 'sn_options', 'sn_theme_options', '' ); }
	add_action( 'admin_init', 'sn_theme_options_init' );
	
	/* Add options page to Appearance Menu */
	function sn_theme_options_add_page() {
		add_theme_page( __( 'Theme Options', 'sntheme' ), __( 'Theme Options', 'sntheme' ), 'edit_theme_options', 'theme_options', 'sn_theme_options_do_page' );
	}
	global $theme_options_fields; if(isset($theme_options_fields)) { add_action( 'admin_menu', 'sn_theme_options_add_page' ); }
	
	/* Create the options page */
	function sn_theme_options_do_page() {
		global $theme_options_fields;
		if(!isset($_REQUEST['settings-updated'])) { $_REQUEST['settings-updated'] = false; }
		
		/* Include the fields file */
		require_once (get_template_directory().'/includes/admin/admin-fields.php');
		
		/* Enqueue some scripts */
		$scripts_to_include = array('media_upload', 'chosen', 'sortable', 'datepicker', 'colourpicker', 'icon_fonts', 'admin');
		sn_include_scripts($scripts_to_include);
		
		/* Make the options form */
		?>
		<div class="wrap sn-theme-options-wrap">
		
			<?php
			/* Theme Options Tabs and Headings */
			screen_icon();
			echo '<h2 class="nav-tab-wrapper">'; _e('Theme Options', 'sntheme'); echo '&nbsp;';
			
				/* Loop through options array to get the heading tabs */
				$heading_i = 0; $i = 0; foreach($theme_options_fields as $options_field) {
					if($options_field['field'] == "heading") { $i++;
						if($i == 1) { $nav_tab_classes = "nav-tab nav-tab-active"; } else { $nav_tab_classes = "nav-tab"; }
						echo '<a href="#options_tab_'.$i.'" class="' . $nav_tab_classes . '">' . $options_field['label'] . "</a>";
				} } 
			
			echo '</h2>'; ?>
	
			<?php
			/* Updated message */
			if(false !== $_REQUEST['settings-updated']) { ?>
				<div class="updated fade"><p><strong><?php _e( 'Options saved', 'sntheme' ); ?></strong></p></div>
			<?php } ?>
	
			<form method="post" action="options.php">
				<?php settings_fields('sn_options');
				$options = get_option('sn_theme_options'); ?>
				
				<?php 
				/* Loop through the options array */
				$i = 0; foreach($theme_options_fields as $options_field) { $i++;
				
				global $repeater_counter; $repeater_counter = -1;
				
					/* Get field settings from array */
					$field_args = array();
					
					if(isset($options_field['field'])) { $field_args['type'] = $options_field['field']; }
					if(isset($options_field['label'])) { $field_args['label'] = $options_field['label']; }
					if(isset($options_field['class'])) { $field_args['class'] = $options_field['class']; }
					if(isset($options_field['name'])) { $field_args['name'] = $options_field['name']; }
					if(isset($options_field['default'])) { $field_args['default'] = $options_field['default']; }
					if(isset($options_field['description'])) { $field_args['description'] = $options_field['description']; }
					if(isset($options_field['choices'])) { $field_args['choices'] = $options_field['choices']; }
					if(isset($options_field['taxonomy'])) { $field_args['taxonomy'] = $options_field['taxonomy']; }
					if(isset($options_field['posttype'])) { $field_args['posttype'] = $options_field['posttype']; }
					if(isset($options_field['taxonomy'])) { $field_args['taxonomy'] = $options_field['taxonomy']; }
					if(isset($options_field['button_label'])) { $field_args['button_label'] = $options_field['button_label']; }
					if(isset($options_field['validate_as'])) { $field_args['validate_as'] = $options_field['validate_as']; }
					if(isset($options_field['repeater_prefix'])) { $field_args['repeater_prefix'] = $options_field['repeater_prefix']; }
					if(isset($options_field['repeater_options'])) { $field_args['repeater_options'] = $options_field['repeater_options']; }
					if(isset($options_field['repeater_showon'])) { $field_args['repeater_showon'] = $options_field['repeater_showon']; }
					if(isset($options_field['repeater_heading'])) { $field_args['repeater_heading'] = $options_field['repeater_heading']; }
									
					/* Get the field (includes/admin/admin-fields.php) */
					sn_get_field($field_args, $i); 
				
				} ?>
				
				</div><!-- end tabpane -->
			
				<p class="submit">
					<input type="submit" class="button-primary" value="<?php _e('Save Options', 'sntheme'); ?>" />
				</p>
			</form>
			</div>
				
		
		<?php
	}


/* Post Meta Fields */
	
	/* Add meta form */
	function sn_post_meta_form() {
		global $theme_post_meta_fields;
		
		/* Include the fields file */
		require_once (get_template_directory().'/includes/admin/admin-fields.php');
		
		/* Enqueue some scripts */
		$scripts_to_include = array('media_upload', 'chosen', 'sortable', 'datepicker', 'colourpicker', 'admin');
		sn_include_scripts($scripts_to_include);
		
		/* Make the options form */
		?>
		<div class="wrap sn-post-options-wrap">
		
			<?php
			/* Theme Options Tabs and Headings */
			echo '<h2 class="nav-tab-wrapper">';
			
				/* Loop through options array to get the heading tabs */
				$heading_i = 0; $i = 0; foreach($theme_post_meta_fields as $options_field) {
					if($options_field['field'] == "heading") { $i++;
						if($i == 1) { $nav_tab_classes = "nav-tab nav-tab-active"; } else { $nav_tab_classes = "nav-tab"; }
						echo '<a href="#options_tab_'.$i.'" class="' . $nav_tab_classes . '">' . $options_field['label'] . "</a>";
				} } 
			
			echo '</h2>';
			
			/* Loop through the options array */
			$i = 0; foreach($theme_post_meta_fields as $options_field) { $i++;
			
			global $repeater_counter; $repeater_counter = -1;
			
				/* Get field settings from array */
				$field_args = array();
				
				if(isset($options_field['field'])) { $field_args['type'] = $options_field['field']; }
				if(isset($options_field['label'])) { $field_args['label'] = $options_field['label']; }
				if(isset($options_field['class'])) { $field_args['class'] = $options_field['class']; }
				if(isset($options_field['name'])) { $field_args['name'] = $options_field['name']; }
				if(isset($options_field['default'])) { $field_args['default'] = $options_field['default']; }
				if(isset($options_field['description'])) { $field_args['description'] = $options_field['description']; }
				if(isset($options_field['choices'])) { $field_args['choices'] = $options_field['choices']; }
				if(isset($options_field['taxonomy'])) { $field_args['taxonomy'] = $options_field['taxonomy']; }
				if(isset($options_field['posttype'])) { $field_args['posttype'] = $options_field['posttype']; }
				if(isset($options_field['taxonomy'])) { $field_args['taxonomy'] = $options_field['taxonomy']; }
				if(isset($options_field['button_label'])) { $field_args['button_label'] = $options_field['button_label']; }
				if(isset($options_field['validate_as'])) { $field_args['validate_as'] = $options_field['validate_as']; }
				if(isset($options_field['repeater_prefix'])) { $field_args['repeater_prefix'] = $options_field['repeater_prefix']; }
				if(isset($options_field['repeater_options'])) { $field_args['repeater_options'] = $options_field['repeater_options']; }
				if(isset($options_field['repeater_showon'])) { $field_args['repeater_showon'] = $options_field['repeater_showon']; }
				if(isset($options_field['repeater_heading'])) { $field_args['repeater_heading'] = $options_field['repeater_heading']; }
								
				/* Get the field (includes/admin/admin-fields.php) */
				$field_args['meta'] = 1;
				sn_get_field($field_args, $i); 
			
			} ?>
			
		</div>
		
		<?php
	}

	/* Create post meta box */
	function sn_create_post_meta_box() {
		if(function_exists('add_meta_box')) {
			add_meta_box( 'sn-post-meta', 'Post Options', 'sn_post_meta_form', 'post', 'normal', 'high' );
		}
	}
	global $theme_post_meta_fields; if(isset($theme_post_meta_fields)) { add_action('admin_menu', 'sn_create_post_meta_box'); }
	

/* Page Meta Fields */
	
	/* Add meta form */
	function sn_page_meta_form() {
		global $theme_page_meta_fields;
		
		/* Include the fields file */
		require_once (get_template_directory().'/includes/admin/admin-fields.php');
		
		/* Enqueue some scripts */
		$scripts_to_include = array('media_upload', 'chosen', 'sortable', 'datepicker', 'colourpicker', 'admin');
		sn_include_scripts($scripts_to_include);
		
		/* Make the options form */
		?>
		<div class="wrap sn-post-options-wrap">
		
			<?php
			/* Theme Options Tabs and Headings */
			echo '<h2 class="nav-tab-wrapper">';
			
				/* Loop through options array to get the heading tabs */
				$heading_i = 0; $i = 0; foreach($theme_page_meta_fields as $options_field) {
					if($options_field['field'] == "heading") { $i++;
						if($i == 1) { $nav_tab_classes = "nav-tab nav-tab-active"; } else { $nav_tab_classes = "nav-tab"; }
						echo '<a href="#options_tab_'.$i.'" class="' . $nav_tab_classes . '">' . $options_field['label'] . "</a>";
				} } 
			
			echo '</h2>';
			
			/* Loop through the options array */
			$i = 0; foreach($theme_page_meta_fields as $options_field) { $i++;
			
			global $repeater_counter; $repeater_counter = -1;
			
				/* Get field settings from array */
				$field_args = array();
				
				if(isset($options_field['field'])) { $field_args['type'] = $options_field['field']; }
				if(isset($options_field['label'])) { $field_args['label'] = $options_field['label']; }
				if(isset($options_field['class'])) { $field_args['class'] = $options_field['class']; }
				if(isset($options_field['name'])) { $field_args['name'] = $options_field['name']; }
				if(isset($options_field['default'])) { $field_args['default'] = $options_field['default']; }
				if(isset($options_field['description'])) { $field_args['description'] = $options_field['description']; }
				if(isset($options_field['choices'])) { $field_args['choices'] = $options_field['choices']; }
				if(isset($options_field['taxonomy'])) { $field_args['taxonomy'] = $options_field['taxonomy']; }
				if(isset($options_field['posttype'])) { $field_args['posttype'] = $options_field['posttype']; }
				if(isset($options_field['taxonomy'])) { $field_args['taxonomy'] = $options_field['taxonomy']; }
				if(isset($options_field['button_label'])) { $field_args['button_label'] = $options_field['button_label']; }
				if(isset($options_field['validate_as'])) { $field_args['validate_as'] = $options_field['validate_as']; }
				if(isset($options_field['repeater_prefix'])) { $field_args['repeater_prefix'] = $options_field['repeater_prefix']; }
				if(isset($options_field['repeater_options'])) { $field_args['repeater_options'] = $options_field['repeater_options']; }
				if(isset($options_field['repeater_showon'])) { $field_args['repeater_showon'] = $options_field['repeater_showon']; }
				if(isset($options_field['repeater_heading'])) { $field_args['repeater_heading'] = $options_field['repeater_heading']; }
								
				/* Get the field (includes/admin/admin-fields.php) */
				$field_args['meta'] = 1;
				sn_get_field($field_args, $i); 
			
			} ?>
			
			</div>
		</div>
		
		<?php
	}

	/* Create post meta box */
	function sn_create_page_meta_box() {
		if(function_exists('add_meta_box')) {
			add_meta_box( 'sn-page-meta', 'Page Options', 'sn_page_meta_form', 'page', 'normal', 'high' );
		}
	}
	global $theme_page_meta_fields; if(isset($theme_page_meta_fields)) { add_action('admin_menu', 'sn_create_page_meta_box'); }
	
	
/* Save Meta Fields */

	function sn_save_meta_fields( $post_id ) {

		if(isset($_POST['post_type'])) { $saved_post_type = $_POST['post_type']; } else { $saved_post_type = ""; }
		
		if($saved_post_type == "post") {
			global $theme_post_meta_fields;
			if(isset($theme_post_meta_fields)) { $post_meta_fields_to_save = $theme_post_meta_fields; }
		} else if($saved_post_type == "page") {
			global $theme_page_meta_fields;
			if(isset($theme_page_meta_fields)) { $post_meta_fields_to_save = $theme_page_meta_fields; }
		}
				
		if(isset($post_meta_fields_to_save)) {
		
		    $is_autosave = wp_is_post_autosave( $post_id );
		    $is_revision = wp_is_post_revision( $post_id );
		 
		    if($is_autosave || $is_revision) {
		        return;
		    }
		    
		    foreach($post_meta_fields_to_save as $options_field) {
		    
		    	if($options_field['field'] == "repeater") {
			    	$repeater_fields = $options_field['repeater_options'];
			    	$repeater_prefix = $options_field['repeater_prefix'];
			    	
			    	foreach($repeater_fields as $repeater_field) {
				    	$i = 0; while($i < 100) { $i++;
				    		$repeater_field_name = $repeater_prefix.'_'.$repeater_field['name'].'__'.$i;
					    	if(isset($_POST[$repeater_field_name])) {
						    	$validate_as = "";
						    	if(isset($repeater_field['validate_as'])) { $validate_as = $repeater_field['validate_as']; }
						    	if(isset($repeater_field['name'])) {
							    	if($repeater_field['field'] == "checkbox") {
							    		if($_POST[$repeater_field_name] == 1) {
									    	update_post_meta($post_id, $repeater_field_name, $_POST[$repeater_field_name]);	
							    		} else {
									    	delete_post_meta($post_id, $repeater_field_name);
							    		}
							    	} else if($validate_as == "text") {
								    	update_post_meta($post_id, $repeater_field_name, sanitize_text_field($_POST[$repeater_field_name]));
							    	} else if($validate_as == "textarea") {
								    	update_post_meta($post_id, $repeater_field_name, esc_textarea($_POST[$repeater_field_name]));
							    	} else {
								    	update_post_meta($post_id, $repeater_field_name, $_POST[$repeater_field_name]);			    	
							    	}
							    }
					    	} else {
						    	delete_post_meta($post_id, $repeater_field_name);
					    	}
				    	}
			    	}
			    	
			    	
		    	}
		    
			    if(isset($options_field['name'])) {
					$field_id = $options_field['name'];
				}
			
				if(isset($field_id) && isset($_POST[$field_id])) {
				
			    	$validate_as = "";
			    	if(isset($options_field['validate_as'])) { $validate_as = $options_field['validate_as']; }
			    	if(isset($options_field['name'])) {
				    	if($options_field['field'] == "checkbox") {
				    		if($_POST[$options_field['name']] == 1) {
						    	update_post_meta($post_id, $options_field['name'], $_POST[$options_field['name']]);	
				    		} else {
						    	delete_post_meta($post_id, $options_field['name']);
				    		}
				    	} else if($validate_as == "text") {
					    	update_post_meta($post_id, $options_field['name'], sanitize_text_field($_POST[$options_field['name']]));
				    	} else if($validate_as == "textarea") {
					    	update_post_meta($post_id, $options_field['name'], esc_textarea($_POST[$options_field['name']]));
				    	} else {
					    	update_post_meta($post_id, $options_field['name'], $_POST[$options_field['name']]);			    	
				    	}
			    	}
			    	
			    }
			}
	    }    
	 
	}
	add_action( 'save_post', 'sn_save_meta_fields' );