<?php 
	
/* Set the theme options array */
	require_once(get_template_directory().'/includes/theme-arrays.php');
	$theme_options = get_option('sn_theme_options');

/* Frontend */
	if(!is_admin()) {
	
		/* Include Frontend Files */
		require_once(get_template_directory().'/includes/theme-functions.php');
		require_once(get_template_directory().'/includes/theme-shortcodes.php');
		
		/* Enqueue CSS and JS */
		function sntheme_enqueue_scripts() {
			
			/* Comments */
			if(is_singular() && comments_open() && get_option('thread_comments')) { wp_enqueue_script('comment-reply'); }
			
			/* Main CSS file */
			wp_enqueue_style('theme-stylesheet', get_stylesheet_uri());
			
			/* Additional CSS files */
			wp_enqueue_style('custom-responsive', get_template_directory_uri().'/responsive.css');
			wp_enqueue_style('custom-stylesheet', get_template_directory_uri().'/custom.css');
			
			/* Add icon fonts */
			wp_enqueue_style('custom-fontawesome', get_template_directory_uri().'/fonts/fontAwesome/css/font-awesome.min.css');
			wp_enqueue_style('custom-fontello', get_template_directory_uri().'/fonts/fontello/css/fontello.css');			
						
			/* Get Google Fonts, function can be found in includes/theme-functions.php */
			$protocol = is_ssl() ? 'https' : 'http';
			$google_heading_font_name = get_gwf_heading_font_name();
			if($google_heading_font_name) {
				wp_enqueue_style('gwf-heading', "$protocol://fonts.googleapis.com/css?family=$google_heading_font_name");
			}
			$google_paragraph_font_name = get_gwf_paragraph_font_name();
			if($google_paragraph_font_name != $google_heading_font_name) {
				if($google_paragraph_font_name) {
					wp_enqueue_style('gwf-paragraph', "$protocol://fonts.googleapis.com/css?family=$google_paragraph_font_name");
				}
			}
				
			/* Add JS */
			wp_register_script('custom-js', get_template_directory_uri().'/js/script.js', 'jquery', '', 1);
			wp_enqueue_script('jquery');
			wp_enqueue_script('custom-js');
			
		}
		add_action('wp_enqueue_scripts', 'sntheme_enqueue_scripts');
		
		/* Load Custom CSS */
		function sntheme_custom_css() { ?>
			<style type="text/css"><?php 
			/* Get custom css, this function can be found in includes/theme-functions.php */
			echo get_custom_css(); ?>
			</style><?php
		}
		add_action('wp_head', 'sntheme_custom_css');
		
	} else {
		
		/* Include Admin Files and Functions including theme options, post meta panels etc. */
		require_once(get_template_directory().'/includes/admin/admin-functions.php');
		
	}

/* Include Admin & Frontend Files */
	require_once(get_template_directory().'/includes/theme-menus.php');
	require_once(get_template_directory().'/includes/theme-widgets.php');

/* Theme Supports */
	if (function_exists('add_theme_support')) {
	
		/* Add Automatic Feed Links */
		add_theme_support('automatic-feed-links');
				
		/* Post Thumbnails */
	    add_theme_support('post-thumbnails');
		add_image_size('banner-image', 1120, 9999, false);
		add_image_size('post-image', 1040, 9999, false);
		add_image_size('large-thumb', 360, 360, true);
		
	}
	
/* Content Width */
	if(!isset($content_width)) { $content_width = 1040; }

/* Add Language Support */
	load_theme_textdomain('sntheme', get_template_directory() . '/languages');

/* Add Post Types */
	require_once(get_template_directory().'/includes/post-types/gallery.php');

add_filter("gform_field_value_timestamp", "gwiz_populate_timestamp");
function gwiz_populate_timestamp( $value ){ date_default_timezone_set("Asia/Kolkata");
    return date("dmyhis");
}

/*
 * Function creates post duplicate as a draft and redirects then to the edit post screen
 */
function rd_duplicate_post_as_draft(){
	global $wpdb;
	if (! ( isset( $_GET['post']) || isset( $_POST['post'])  || ( isset($_REQUEST['action']) && 'rd_duplicate_post_as_draft' == $_REQUEST['action'] ) ) ) {
		wp_die('No post to duplicate has been supplied!');
	}
 
	/*
	 * Nonce verification
	 */
	if ( !isset( $_GET['duplicate_nonce'] ) || !wp_verify_nonce( $_GET['duplicate_nonce'], basename( __FILE__ ) ) )
		return;
 
	/*
	 * get the original post id
	 */
	$post_id = (isset($_GET['post']) ? absint( $_GET['post'] ) : absint( $_POST['post'] ) );
	/*
	 * and all the original post data then
	 */
	$post = get_post( $post_id );
 
	/*
	 * if you don't want current user to be the new post author,
	 * then change next couple of lines to this: $new_post_author = $post->post_author;
	 */
	$current_user = wp_get_current_user();
	$new_post_author = $current_user->ID;
 
	/*
	 * if post data exists, create the post duplicate
	 */
	if (isset( $post ) && $post != null) {
 
		/*
		 * new post data array
		 */
		$args = array(
			'comment_status' => $post->comment_status,
			'ping_status'    => $post->ping_status,
			'post_author'    => $new_post_author,
			'post_content'   => $post->post_content,
			'post_excerpt'   => $post->post_excerpt,
			'post_name'      => $post->post_name,
			'post_parent'    => $post->post_parent,
			'post_password'  => $post->post_password,
			'post_status'    => 'draft',
			'post_title'     => $post->post_title,
			'post_type'      => $post->post_type,
			'to_ping'        => $post->to_ping,
			'menu_order'     => $post->menu_order
		);
 
		/*
		 * insert the post by wp_insert_post() function
		 */
		$new_post_id = wp_insert_post( $args );
 
		/*
		 * get all current post terms ad set them to the new post draft
		 */
		$taxonomies = get_object_taxonomies($post->post_type); // returns array of taxonomy names for post type, ex array("category", "post_tag");
		foreach ($taxonomies as $taxonomy) {
			$post_terms = wp_get_object_terms($post_id, $taxonomy, array('fields' => 'slugs'));
			wp_set_object_terms($new_post_id, $post_terms, $taxonomy, false);
		}
 
		/*
		 * duplicate all post meta just in two SQL queries
		 */
		$post_meta_infos = $wpdb->get_results("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$post_id");
		if (count($post_meta_infos)!=0) {
			$sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) ";
			foreach ($post_meta_infos as $meta_info) {
				$meta_key = $meta_info->meta_key;
				if( $meta_key == '_wp_old_slug' ) continue;
				$meta_value = addslashes($meta_info->meta_value);
				$sql_query_sel[]= "SELECT $new_post_id, '$meta_key', '$meta_value'";
			}
			$sql_query.= implode(" UNION ALL ", $sql_query_sel);
			$wpdb->query($sql_query);
		}
 
 
		/*
		 * finally, redirect to the edit post screen for the new draft
		 */
		wp_redirect( admin_url( 'post.php?action=edit&post=' . $new_post_id ) );
		exit;
	} else {
		wp_die('Post creation failed, could not find original post: ' . $post_id);
	}
}
add_action( 'admin_action_rd_duplicate_post_as_draft', 'rd_duplicate_post_as_draft' );
 
/*
 * Add the duplicate link to action list for post_row_actions
 */
function rd_duplicate_post_link( $actions, $post ) {
	if (current_user_can('edit_posts')) {
		$actions['duplicate'] = '<a href="' . wp_nonce_url('admin.php?action=rd_duplicate_post_as_draft&post=' . $post->ID, basename(__FILE__), 'duplicate_nonce' ) . '" title="Duplicate this item" rel="permalink">Duplicate</a>';
	}
	return $actions;
}
 
add_filter( 'post_row_actions', 'rd_duplicate_post_link', 10, 2 );
add_filter('page_row_actions', 'rd_duplicate_post_link', 10, 2);
