<?php
/* Template for Comments Area */

if(post_password_required())
	return;
?>

<div id="comments" class="comments-area">

	<?php if(have_comments()) : ?>
		<h2 class="comments-title">
			<?php
				printf( _nx('One comment on &ldquo;%2$s&rdquo;', '%1$s comments on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'sntheme'),
				number_format_i18n(get_comments_number()), '<span>' . get_the_title() . '</span>' );
			?>
		</h2>

		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'style'       => 'ol',
					'format'      => 'html5',
					'short_ping'  => true,
					'avatar_size' => 60,
				) );
			?>
		</ol>

		<?php
			/* Are there comments to navigate through? */
			if (get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
		<nav class="navigation comment-navigation" role="navigation">
			<h1 class="screen-reader-text section-heading"><?php _e( 'Comment navigation', 'sntheme' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'sntheme' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'sntheme' ) ); ?></div>
		</nav>
		<?php endif; ?>

		<?php if(!comments_open() && get_comments_number()) : ?>
		<p class="no-comments"><?php _e( 'Comments are closed.' , 'sntheme' ); ?></p>
		<?php endif; ?>

	<?php endif; /* end have_comments() */ ?>

	<?php comment_form( array( 'format' => 'html5' ) ); ?>

</div>