# How to contribute

Community made patches, bug reports, contributions, and translations are always welcome.

When contributing please ensure you follow the guidelines below so that we can keep on top of things.

__Note:__ 

GitHub is for *bug reports and contributions only* - if you have a support question or a request for a customization don't post here. Use [WordPress.org](http://wordpress.org/support/plugin/sportspress) for community support, and for customizations we recommend one of the following services:

- [Elto](https://www.elto.com/)
- [Codeable](https://codeable.io/)

## Getting Started

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Submit a ticket for your issue, assuming one does not already exist.
  * Clearly describe the issue including steps to reproduce when it is a bug.
  * Make sure you fill in the earliest version that you know has the issue.

## Making Changes

* Fork the repository on GitHub.
* Make the changes to your forked repository.
  * **Ensure you stick to the [WordPress Coding Standards](http://codex.wordpress.org/WordPress_Coding_Standards).**
  * Ensure you use LF line endings - no crazy windows line endings. :)
* When committing, reference your issue (#1234) and include a note about the fix.
* Push the changes to your fork and submit a pull request on the master branch of the SportsPress repository. Existing maintenance branches will be maintained by ThemeBoy.
* Please don't modify the changelog, this will be maintained by ThemeBoy.

At this point you're waiting on us to merge your pull request. We'll review all pull requests, and make suggestions and changes if necessary.

# Additional Resources

* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](http://help.github.com/send-pull-requests/)
* [SportsPress plugin page on WordPress.org](http://wordpress.org/plugins/sportspress/)