<?php
//define
define('SEA_UX_CB_DIR', get_template_directory_uri(). '/ux-content-builder' );

//remove module add inline style
remove_action( 'wp_enqueue_scripts', 'ux_cb_module_add_inline_style', 10 );

//customize tools button
function seatheme_ux_cb_customize_tools(){
	$fields = seatheme_theme_post_meta_fields();
		
	if(!empty($fields[get_post_type()])){
		$options = $fields[get_post_type()];
	
		foreach($options as $num => $option){
			$active = $num == 0 ? 'active' : false;
			$hidden = $num == 0 || $num == 1 ? false : 'hidden';
			echo '<button id="' .esc_html($option['id']). '" type="button" class="' .sanitize_html_class($active). ' ux-cb-button ' .sanitize_html_class($hidden). '">' .esc_html($option['title']). '</button>';
		}
	}
}

//interface post type control
function seatheme_ux_cb_posttype_control(){
	return 'page';
}
add_filter( 'seatheme_theme_post_meta_interface_posttype_control', 'seatheme_ux_cb_posttype_control' );

//interface option control
function seatheme_ux_cb_option_control(){
	return true;
}
add_filter( 'seatheme_theme_post_meta_interface_option_control', 'seatheme_ux_cb_option_control' );

//interface backend enqueue scripts
function seatheme_ux_cb_backend_enqueue_scripts(){
	wp_enqueue_script( 'seatheme_ux_cb_backend_script', SEA_UX_CB_DIR. '/assets/js/backend-script.js', array(), '1.0.0', true );
}

//has modules
function seatheme_ux_cb_page_has_modules( $hasModules ) {
	if ( ! $hasModules ) {
		$hasModules = array();
	}
	
	if ( $sectionID = seatheme_get_option( 'theme_option_show_portfolio_icon_page_id' ) ) {
		if ( $post = get_post( $sectionID ) ) {
			if ( $modules = get_post_meta( $sectionID, 'modules', true ) ) {
				$hasModules = array_merge( $modules, $hasModules );
			}
		}
	}
	
	if ( is_singular( 'ux-portfolio' ) ) {
		if ( $sectionID = seatheme_get_option( 'theme_option_show_generic_section_on_bottom_page_id' ) ) {
			if ( $post = get_post( $sectionID ) ) {
				if ( $modules = get_post_meta( $sectionID, 'modules', true ) ) {
					$hasModules = array_merge( $modules, $hasModules );
				}
			}
		}
	}
	
	$hasModules = array_unique( $hasModules );
	return $hasModules;
}
add_filter( 'ux_cb_page_has_modules', 'seatheme_ux_cb_page_has_modules' );

?>