<?php
$gallery_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_template');
$show_title = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_show_title');
$gallery_filled_or_not = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_style');
$gallery_filled_or_not_class = '';
$container = seatheme_get_option('theme_option_main_width_style') ? seatheme_get_option('theme_option_main_width_style') : 'container';

//If set Password 
if(post_password_required()){
	echo '<div class="container ux-password-form">'. wp_kses( get_the_password_form(), seatheme_shapeSpace_allowed_html() ).'</div>';
	return;
} else { 

if($gallery_template == 'none' && $show_title){
	//Title
	seatheme_get_template_part('single/project/title', false);  
}
		
//on left right template
if($gallery_template == 'on_left' || $gallery_template == 'on_right'){
	$pull_class = 'pull-right';
	$gallery_col_class = ' gallery-right';
	if($gallery_template == 'on_right'){
		$pull_class = '';
		$gallery_col_class = ' gallery-left';
	}

	if($gallery_filled_or_not=='filled'){
		$gallery_filled_or_not_class = ' single-gallery-col2-filled';
	}
	
	//width
	$gallery_col_width = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_col_width');
	
	$gallery_width_class = 'col-sm-12 col-md-6';
	switch($gallery_col_width){
		case '1/2': $gallery_width_class = 'col-sm-12 col-md-6'; break;
		case '3/5': $gallery_width_class = 'col-sm-12 col-md-5'; break;
		case '2/3': $gallery_width_class = 'col-sm-12 col-md-4'; break;
		case '3/4': $gallery_width_class = 'col-sm-12 col-md-3'; break;
	} ?>
    
	<div class="row single-gallery-col2<?php echo esc_attr( $gallery_filled_or_not_class ); ?><?php echo esc_attr( $gallery_col_class ); ?>">
        <div class="single-col2-text-wrap <?php echo esc_attr( $gallery_width_class ); ?> sticky_column <?php echo sanitize_html_class( $pull_class ); ?>">
            <?php
			//Title
			seatheme_get_template_part('single/project/title', false); ?>
            <div class="entry"><?php the_content(); ?><div class="clear"><?php wp_link_pages(); ?></div></div><!--End entry-->
        </div>
        <?php
        //Images
        seatheme_get_template_part('single/project/template', false); ?>
    </div>
<?php } else { ?>
    	<div class="entry"><?php the_content(); ?><div class="clear"><?php wp_link_pages(); ?></div></div><!--End entry-->
<?php
}

} //End set password

if(seatheme_get_option('theme_option_show_generic_section_on_bottom')){
	$genericSectionID = seatheme_get_option('theme_option_show_generic_section_on_bottom_page_id');
	$container_section_bottom = seatheme_get_option('theme_option_main_width_style') ? seatheme_get_option('theme_option_main_width_style') : 'container';
	$post = get_post($genericSectionID);
	if($post){
		setup_postdata($post);
		echo '<div class="'. sanitize_html_class( $container_section_bottom ) .'">'; the_content(); echo '</div>';
		wp_reset_postdata();
	}
}
?>