<?php 
$portfolio = seatheme_get_post_meta( get_the_ID(), 'theme_meta_portfolio' );
$image_lazyload = seatheme_get_option( 'theme_option_enable_image_lazyload' );
$thumb_padding_top = false;
$thumb_width = 600;
$thumb_height = 400;
if ( is_array( $portfolio ) ) {
	echo '<ul class="vertical-list">';
	foreach($portfolio as $image){
		$thumb = wp_get_attachment_image_src($image, 'full');
		$thumb_srcset = wp_get_attachment_image_srcset($image, 'full');
		$thumb_sizes = wp_get_attachment_image_sizes($image, 'full');
		$thumb_width = $thumb[1];
		$thumb_height = $thumb[2];
		$image_lazyload_img_style = 'src="' .esc_url( get_template_directory_uri() ). '/img/blank.gif" data-src="' .esc_url( $thumb[0] ). '" data-srcset="'.wp_kses_post($thumb_srcset).'" data-sizes="'.wp_kses_post($thumb_sizes).'"';
		$image_lazyload_img_class = 'lazy';
		if( !$image_lazyload ) {
			$image_lazyload_img_style = 'src="' .esc_url( $thumb[0] ). '" srcset="'.wp_kses_post($thumb_srcset).'" sizes="'.wp_kses_post($thumb_sizes).'"';
			$image_lazyload_img_class = '';
		}
		if( $thumb_height > 0 && $thumb_width > 0 ) {
			$thumb_padding_top = 'padding-top: ' . (intval( $thumb_height ) / intval( $thumb_width )) * 100 . '%;';
		}
		echo '<li class="vertical-list-item"><span class="ux-lazyload-wrap" style="'.wp_kses_post( $thumb_padding_top ).'"><img class="vertical-list-item-img '.sanitize_html_class( $image_lazyload_img_class ).'" alt="'.esc_attr( get_the_title( $image ) ).'" '.wp_kses( $image_lazyload_img_style, seatheme_shapeSpace_allowed_html() ).'></span></li>';
			 
	}
	echo '</ul>';
}

?>
<div class="entry clearfix"><?php the_content(); ?><div class="clear"><?php wp_link_pages(); ?></div></div>