<?php
$cookieConsentBar = seatheme_get_option( 'theme_option_cookie_consent_bar' );
$cookieConsentBarMassage = seatheme_get_option( 'theme_option_cookie_consent_bar_massage' );
$cookieConsentBarPosition = seatheme_get_option( 'theme_option_cookie_consent_bar_position' );

$barButtonPosition = 'sea-cookieconsent-bottom';
switch ( $cookieConsentBarPosition ) {
	case 'bottom': $barButtonPosition = 'sea-cookieconsent-bottom'; break;
	case 'top': $barButtonPosition = 'sea-cookieconsent-top'; break;
	case 'bottom-left': $barButtonPosition = 'sea-cookieconsent-corner sea-cookieconsent-bl'; break;
	case 'bottom-right': $barButtonPosition = 'sea-cookieconsent-corner sea-cookieconsent-br'; break;
	case 'top-left': $barButtonPosition = 'sea-cookieconsent-corner sea-cookieconsent-tl'; break;
	case 'top-right': $barButtonPosition = 'sea-cookieconsent-corner sea-cookieconsent-tr'; break;
}

$dismissBtnText = seatheme_get_option( 'theme_option_cookie_button_dismiss_label' );
$moreBtnText = seatheme_get_option( 'theme_option_cookie_button_more_label' );
$moreBtnURL = seatheme_get_option( 'theme_option_cookie_button_more_url' );

if ( isset( $_COOKIE['cookieConsentBar'] )) {
	$currentUserID = get_current_user_id();
	$cookieConsentBarVal = $_COOKIE['cookieConsentBar'];
	if ( intval( $cookieConsentBarVal ) == intval( $currentUserID ) ) {
		$cookieConsentBar = false;
	}
}

if ( $cookieConsentBar ) {
	$cookieConsentBarVal = false;
	if ( isset( $_COOKIE['cookieConsentBar'] ) ) {
		$cookieConsentBarVal = $_COOKIE['cookieConsentBar'];
	} ?>
	<div class="sea-cookie-consent <?php echo esc_attr( $barButtonPosition ); ?>">
		<div class="sea-cookieconsent-container">
			<div class="sea-cookieconsent-text"><?php echo esc_html( $cookieConsentBarMassage ); ?></div>
			<div class="sea-cookieconsent-btns">
				<span class="ux-btn sea-cookieconsent-btn" data-type="cookie-bar" data-cookie="<?php echo $cookieConsentBarVal; ?>"><?php echo esc_html( $dismissBtnText ); ?></span>
				<a href="<?php echo esc_url( $moreBtnURL ); ?>" class="ux-btn sea-cookieconsent-btn"><?php echo esc_html( $moreBtnText ); ?></a>
			</div>

		</div>
	</div>
<?php } ?>