<?php
//theme meta interface
function seatheme_theme_post_meta_interface( $post ) {
	$seatheme_theme_post_meta_fields = seatheme_theme_post_meta_fields();
		
	if ( ! empty( $seatheme_theme_post_meta_fields[ get_post_type() ] ) ) {
		$seatheme_theme_post_meta_posttype = $seatheme_theme_post_meta_fields[ get_post_type() ];
		$posttype_control = apply_filters( 'seatheme_theme_post_meta_interface_posttype_control', false );
	
		$option_switch = true;
		if ( $posttype_control ) {
			if ( ( $post && ( get_post_type() == $posttype_control ) ) || ( ! $post && ( get_post_type() != $posttype_control ) ) ) {
				$option_switch = false;
			}
		}
		
		if ( current_filter() == 'seatheme_edit_form_after_title' && get_post_type() == 'page' ) {
			$option_switch = true;
		} else if ( current_filter() == 'seatheme_edit_form_after_title' && get_post_type() != 'page' ) {
			$option_switch = false;
		}
		
		if ( $option_switch ) {
			foreach ( $seatheme_theme_post_meta_posttype as $num => $option ) {
				$option = wp_parse_args( $option, array(
					'title' => false,
					'id' => false,
					'format' => false
				) );
				
				$format = isset( $option['format'] ) ? 'data-format="' .esc_attr( $option['format'] ). '"' : false;
				
				$option_control = apply_filters( 'seatheme_theme_post_meta_interface_option_control', false );
				
				$hidden = false;
				if ( $option_control && ( get_post_type() == $posttype_control ) ) {
					$hidden = $num != 0 ? 'hidden' : $hidden;
				} ?>
				
				<div id="<?php echo esc_attr( $option['id'] ); ?>" class="postbox ux-theme-box ux-theme-meta-box <?php echo sanitize_html_class( $hidden ); ?>" <?php echo sanitize_text_field( ( $format ) ); ?>>
					<h3 class="hndle"><span><?php echo esc_html( $option['title'] ); ?></span></h3>
					<div class="inside">
						<?php if ( isset( $option['action'] ) ) {
							do_action( 'ux-theme-post-meta-interface', esc_attr( $option['id'] ) );
						} else {
							if ( isset( $option['section'] ) ) {
								seatheme_theme_post_meta_section( $option );
							}
						} ?>
					</div>
				</div>
			<?php } ?>
            <div class="ux-theme-box"><?php seatheme_theme_option_modal(); ?></div>
            <input type="hidden" name="custom_meta_box_nonce" value="<?php echo esc_attr( wp_create_nonce( ABSPATH ) ); ?>" />
        <?php
		}
	}
}
add_action('edit_form_after_editor', 'seatheme_theme_post_meta_interface');
add_action('ux_theme_meta_box_sidebar', 'seatheme_theme_post_meta_interface');

//theme meta section
function seatheme_theme_post_meta_section( $option ) {
	foreach ( $option['section'] as $section ) {
		$subclass = isset( $section['subclass'] ) ? 'theme-option-item-body' : false;
		$title = isset( $section['title'] ) ? $section['title'] : false;
		$super_control = isset( $section['super-control'] ) ? 'data-super="' .esc_attr( $section['super-control']['name'] ) . '" data-supervalue="' .esc_attr( $section['super-control']['value'] ). '"' : false; ?>
		
		<div class="theme-option-item" <?php echo sanitize_text_field( $super_control ); ?>>
			<?php if ( $title ) { ?>
				<h4 class="theme-option-item-heading">
					<?php echo '<span>' . esc_html( $title ) . '</span>'; ?>
				</h4>
			<?php } ?>
			<div class="<?php echo esc_attr( $subclass ); ?>">
				<?php if ( isset( $section['item'] ) ) {
					foreach ( $section['item'] as $item ) {
						$control = isset( $item['control'] ) ? 'data-name="' .esc_attr( $item['control']['name'] ). '" data-value="' .esc_attr( $item['control']['value'] ). '"' : false; 
						$item_format = isset( $item['format'] ) ? 'data-format="' .esc_attr( $item['format'] ). '"' : false;
						if ( $item['type'] == 'divider' || $item['type'] == 'description' ) {
							$item_name = false;
							?>
							<div class="<?php echo esc_attr( $item_name ); ?>" <?php echo sanitize_text_field( $control ); ?> <?php echo sanitize_text_field( $item_format ); ?>> 
								<?php seatheme_theme_option_getfield( $item, 'ux_theme_meta' ); ?>
							</div>
						<?php } else { ?>
							<div class="row <?php echo esc_attr( $item['name'] ); ?>" <?php echo sanitize_text_field( $control ); ?> <?php echo sanitize_text_field( $item_format ); ?>>
								<div class="col-xs-3">
									<?php if ( isset( $item['title'] ) ) { ?>
										<h5><?php echo esc_html( $item['title'] ); ?></h5>
									<?php } ?>
								</div>
								<div class="col-xs-9">
									<?php if ( isset( $item['bind'] ) ) {
										foreach ( $item['bind'] as $bind ) {
											if ( $bind['position'] == 'before' ) {
												seatheme_theme_option_getfield( $bind, 'ux_theme_meta' );
											}
										}
									}
									seatheme_theme_option_getfield( $item, 'ux_theme_meta' );
									
									if ( isset( $item['bind'] ) ) {
										foreach ( $item['bind'] as $bind ) {
											if ( $bind['position'] == 'after' ) {
												seatheme_theme_option_getfield( $bind, 'ux_theme_meta' );
											}
										}
									} ?>
									<?php if ( isset( $item['description'] ) ) { ?>
										<p class="text-muted"><?php echo esc_html( $item['description'] ); ?></p>
									<?php } ?>
								</div>
							</div>
						<?php
						}
					}
				} ?>
			</div>
		</div>
	<?php 
	}
}

function seatheme_theme_meta_box_callback( $post, $metabox ) {
	$option = $metabox['args']['option'];
	$format = isset( $option['format'] ) ? 'data-format="' .esc_attr( $option['format'] ). '"' : false; ?>
	<div class="ux-theme-box ux-theme-meta-box" <?php echo sanitize_text_field( ( $format ) ); ?>>
		<?php if ( isset( $option['action'] ) ) {
            do_action( 'ux-theme-post-meta-interface', esc_attr( $option['id'] ) );
        } else {
            if ( isset( $option['section'] ) ) {
                seatheme_theme_post_meta_section( $option );
            }
        } ?>
    </div>
<?php
}

function seatheme_theme_meta_box_hidden_fields( $post ) {
	if ( function_exists( 'use_block_editor_for_post' ) ) {
		if ( use_block_editor_for_post( $post ) ) { ?>
            <input type="hidden" name="custom_meta_box_nonce" value="<?php echo esc_attr( wp_create_nonce( ABSPATH ) ); ?>" />
        <?php
		}
	}
}
add_action( 'block_editor_meta_box_hidden_fields', 'seatheme_theme_meta_box_hidden_fields' );

//theme edit form after title
function seatheme_edit_form_after_title( $post ) {
	$switch = false;
	
	if ( $post->post_type == 'page' ) {
		if ( function_exists( 'use_block_editor_for_post' ) ) {
			if ( use_block_editor_for_post( $post ) ) {
				$switch = true;
			}
		}
		
		if ( current_filter() == 'edit_form_after_title' ) {
			$switch = true;
		}
		
		if ( $switch ) { ?>
            <div class="ux-theme-box-wrap">
                <div class="ux-theme-meta-box-tools">
                    <?php do_action( 'ux_theme_meta_box_tools' ); ?>
                    <?php
                    $postMetaFields = seatheme_theme_post_meta_fields();
                    if ( ! empty( $postMetaFields[ get_post_type() ] ) ) {
                        $postMetaPosttype = $postMetaFields[ get_post_type() ];
                        foreach ( $postMetaPosttype as $num => $option ) {
                            $option = wp_parse_args( $option, array(
                                'title_hidden' => false,
                            ) );
                            
                            $active = $num == 0 ? 'active' : false;
                            $hidden = $option[ 'title_hidden' ] ? 'hidden' : false;
                            echo '<button id="ux-theme-meta-options-' .$option[ 'id' ]. '" type="button" class="' .sanitize_html_class( $active ). ' ' .sanitize_html_class( $hidden ). '">' .esc_html( $option[ 'title' ] ). '</button>';
                        }
                    } ?>
                </div>
                <div class="ux-theme-meta-box-sidebar">
                    <?php do_action( 'ux_theme_meta_box_before_sidebar' ); ?>
                    <?php do_action( 'ux_theme_meta_box_sidebar' ); ?>
                    <?php do_action( 'ux_theme_meta_box_after_sidebar' ); ?>
                </div>
            </div>
        <?php
		}
	}
}
add_action( 'edit_form_after_title', 'seatheme_edit_form_after_title' );

?>