<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$uxThemeBox = false;
$themeConfigFields = apply_filters( 'seatheme_theme_options_config', array() );
if ( count( $themeConfigFields ) > 0 ) {
	if ( isset( $themeConfigFields['general'] ) ) {
		$uxThemeBox = 'general';
	} else {
		$uxThemeBox = 'old';
	}
} ?>

<div id="ux-option-interface" class="wrap">
    <div class="icon32" id="icon-themes"><br></div>
    <h2><?php esc_html_e( 'Theme Options', 'sea-theme' ); ?></h2>
    
    <?php if ( isset( $_GET['message'] ) ) {
		if ( $_GET['message'] == 'restore' ) { ?>
            <div id="restore-defaults-msg">
                <div class="updated below-h2"><p><?php esc_html_e( 'Restore Defaults', 'sea-theme' ) ?></p></div>
            </div>
        <?php
		}
	}
	
	seatheme_theme_option_save(); ?>
    
    <form id="ux-theme-option-form" action="<?php echo esc_url( admin_url( 'admin.php?page=theme-option' ) ); ?>" method="post">
        <input type="hidden" name="action" value="save" />
        <input type="hidden" name="_uxnonce" value="<?php echo wp_create_nonce( esc_url( admin_url( 'admin.php?page=theme-option' ) ) ); ?>" />
        <div class="ux-theme-box">
            <div class="ux-theme-tabs">
				<?php if ( $uxThemeBox == 'general' ) {  ?>
                    <ul class="nav nav-tabs">
                        <?php
                        $tabIndex = 0;
                        foreach ( $themeConfigFields as $areaSlug => $area ) {
                            $active = ( $tabIndex == 0 ) ? 'active' : false; $tabIndex++;
                            $area = wp_parse_args( $area, array(
                                'id' => '',
                                'title' => ''
                             ) ); ?>
                            <li class="<?php echo esc_attr( $active ); ?>">
                                <a href="<?php echo esc_attr( '#' .$area['id'] ); ?>" data-toggle="tab"><?php echo esc_html( $area['title'] ); ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                    
                    <div class="tab-content">
                        <?php
                        $tabIndex = 0;
                        foreach ( $themeConfigFields as $areaSlug => $area ) {
                            $active = ( $tabIndex == 0 ) ? 'active' : false; $tabIndex++;
                            $area = wp_parse_args( $area, array(
                                'id' => ''
                            ) ); ?>
                            <div id="<?php echo esc_attr( $area['id'] ); ?>" class="tab-pane <?php echo sanitize_html_class( $active ); ?>">
                                <?php foreach ( $area['region'] as $regionNum => $region ) {
                                    $region = wp_parse_args( $region, array(
                                        'region-id' => '',
                                        'title' => '',
                                        'region-ctrl' => 'false',
										'desc' => false
                                    ) );
                                    $regionDataTag = array( 'region-ctrl' => 'data-region-ctrl="' .$region['region-ctrl']. '"' );
                                    $regionDataTag = apply_filters( 'seatheme_theme_options_field_region_data_tag', $regionDataTag, $region ); ?>
                                    <div class="theme-option-field-region <?php echo esc_attr( seatheme_theme_options_hidden_items_field( $region['region-ctrl'] ) ); ?>" <?php echo sanitize_text_field( join( ' ', $regionDataTag ) ); ?>>
                                        <h3 class="theme-option-field-region-heading"><?php echo esc_html( $region['title'] ); ?></h3>
                                        <p class="description" id="<?php echo esc_attr( $region['region-id'] ); ?>-description"><?php echo wp_kses_post( $region['desc'] ); ?></p>
                                        <?php foreach ( $region['section'] as $sectionNum => $section ) {
                                            $section = wp_parse_args( $section, array(
                                                'section-ctrl' => 'false'
                                            ) );
                                            $sectionDataTag = array( 'section-ctrl' => 'data-section-ctrl="' .$section['section-ctrl']. '"' );
                                            $sectionDataTag = apply_filters( 'seatheme_theme_options_field_section_data_tag', $sectionDataTag, $section ); ?>
                                            <table class="form-table theme-option-field-section <?php echo esc_attr( seatheme_theme_options_hidden_items_field( $section['section-ctrl'] ) ); ?>" <?php echo sanitize_text_field( join( ' ', $sectionDataTag ) ); ?>>
                                                <?php foreach ( $section['group'] as $groupNum => $group ) {
                                                    $group = wp_parse_args( $group, array(
                                                        'group-ctrl' => 'false',
														'title' => false
                                                    ) );
                                                    $groupDataTag = array( 'group-ctrl' => 'data-group-ctrl="' .$group['group-ctrl']. '"' );
                                                    $groupDataTag = apply_filters( 'seatheme_theme_options_field_group_data_tag', $groupDataTag, $group ); ?>
                                                    <tbody class="theme-option-field-group <?php echo esc_attr( seatheme_theme_options_hidden_items_field( $group['group-ctrl'] ) ); ?>" <?php echo sanitize_text_field( join( ' ', $groupDataTag ) ); ?>>
                                                        <?php
														if ( $group['title'] ) { ?>
                                                            <tr><th scope="row" colspan="2"><h4 class="theme-option-field-region-heading"><?php echo esc_html( $group['title'] ); ?></h4></th></tr>
                                                        <?php	
														}
														
														foreach ( $group['items'] as $item ) {
                                                            $item = wp_parse_args( $item, array(
                                                                'title' => '',
                                                                'desc' => '',
                                                                'name' => '',
                                                                'type' => '',
                                                                'ctrl' => 'false'
                                                            ) );
                                                            $itemDataTag = array( 'item-ctrl' => 'data-item-ctrl="' .$item['ctrl']. '"', 'item-type' => 'data-item-type="' .$item['type']. '"' );
                                                            $itemDataTag = apply_filters( 'seatheme_theme_options_field_item_data_tag', $itemDataTag, $item ); ?>
                                                            <tr class="theme-option-field-item row-title <?php echo esc_attr( seatheme_theme_options_hidden_items_field( $item['ctrl'] ) ); ?>" <?php echo sanitize_text_field( join( ' ', $itemDataTag ) ); ?>>
                                                                <td scope="row" colspan="2"><label for="<?php echo esc_attr( $item['name'] ); ?>"><?php echo esc_html( $item['title'] ); ?></label></td>
                                                            </tr>
                                                            <tr class="theme-option-field-item row-content <?php echo esc_attr( seatheme_theme_options_hidden_items_field( $item['ctrl'] ) ); ?>" <?php echo sanitize_text_field( join( ' ', $itemDataTag ) ); ?>>
                                                                <td><?php seatheme_theme_options_get_field( $item ); ?></td>
                                                                <td style="width: 20%;"><p class="description" id="<?php echo esc_attr( $item['name'] ); ?>-description"><?php echo wp_kses_post($item['desc']); ?></p></td>
                                                            </tr>
                                                        <?php } ?>
                                                    </tbody>
                                                <?php } ?>
                                            </table>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } else if ( $uxThemeBox == 'old' ) { ?>
                    <ul class="nav nav-tabs">
                        <?php foreach ( $themeConfigFields as $i => $config ) {
                            $active = ( $i == 0 ) ? 'active' : false; ?>
                            <li class="<?php echo esc_attr( $active ); ?>"><a href="<?php echo esc_attr( '#' .$config['id'] ); ?>" data-toggle="tab"><?php echo esc_html( $config['name'] ); ?></a></li>
                        <?php } ?>
                    </ul>
                    
                    <div class="tab-content">
                        <?php foreach ( $themeConfigFields as $i => $config ) {
                            $active = ( $i == 0 ) ? 'active' : false; ?>
                            <div id="<?php echo esc_attr( $config['id'] ); ?>" class="tab-pane <?php echo esc_attr( $active ); ?>">
                                <?php if ( isset( $config['section'] ) ) {
                                    foreach ( $config['section'] as $i => $section ) {
                                        $border = ( $i != 0 ) ? 'border-top:1px dotted #ccc;' : false;
                                        $title = isset( $section['title'] ) ? $section['title'] : false; ?>
                                        <div class="theme-option-item" style=" <?php echo esc_attr( $border ); ?>">
                                            <h3 class="theme-option-item-heading"><?php echo esc_html( $title ); ?></h3>
                                            <?php if ( isset( $section['item'] ) ) {
                                                foreach ( $section['item'] as $item ) {
                                                    $no_margin_bottom = ( $item['type'] == 'switch-color' ) ? 'margin-bottom:0px;' : false;
                                                    $col_md_width = $item['type'] == 'color-scheme' ? 'col-md-12' : 'col-md-9';
                                                    $control = isset( $item['control'] ) ? 'data-name="' .esc_attr( $item['control']['name'] ). '" data-value="' .esc_attr( $item['control']['value'] ). '"' : false;  ?>
                                                    <div class="row <?php echo esc_attr( $item['name'] ); ?>" style=" <?php echo esc_attr( $no_margin_bottom ); ?>" <?php echo sanitize_text_field( $control ); ?>>
                                                        <?php if ( isset( $item['title'] ) && $item['type'] != 'switch-color' ) { ?>
                                                            <h5 class="col-md-12"><?php echo esc_html( $item['title'] ); ?></h5>
                                                        <?php } ?>
                                                        <div class="<?php echo esc_attr( $col_md_width ); ?>">
                                                            <?php if ( isset( $item['bind'] ) ) {
                                                                foreach ( $item['bind'] as $bind ) {
                                                                    if ( $bind['position'] == 'before' ) {
                                                                        seatheme_theme_option_getfield( $bind, 'ux_theme_option' );
                                                                    }
                                                                }
                                                            }
                                                            
                                                            seatheme_theme_option_getfield( $item, 'ux_theme_option' );
                                                            
                                                            if ( isset( $item['bind'] ) ) {
                                                                foreach ( $item['bind'] as $bind ) {
                                                                    if ( $bind['position'] == 'after' ) {
                                                                        seatheme_theme_option_getfield( $bind, 'ux_theme_option' );
                                                                    }
                                                                }
                                                            } ?>
                                                        </div>
                                                        <?php if ( $item['type'] != 'color-scheme' ) { ?>
                                                            <div class="col-md-3 text-muted">
                                                                <?php if ( isset( $item['description'] ) ) {
                                                                    echo esc_html( $item['description'] );
                                                                }
                                                                
                                                                if ( isset( $item['help_url'] ) ) { ?>
                                                                    <a title="<?php echo esc_attr( $item['help_url'] ); ?>" class="themeoption-help-a" target="_blank" href="<?php echo esc_url( $item['help_url'] ); ?>"><span class="themeoption-help">?</span></a>
                                                                <?php } ?>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                <?php
                                                }
                                            } ?>
                                        </div>
                                    <?php	
                                    }
                                } ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
                
                <div class="ux-theme-option-submit">
                    <div class="row">
                        <div class="col-sm-6">
                            <button type="button" class="btn btn-default btn-sm restore_defaults" data-notice="<?php esc_attr_e( 'All the settings you have done will be cover write to the default settings, are you sure you want to continue?', 'sea-theme' ); ?>"><?php esc_html_e( 'Restore Defaults', 'sea-theme' ); ?></button>
                            <a class="btn btn-default btn-sm" href="https://doc.seatheme.net/theme/sea" target="_blank"><?php esc_html_e( 'Documentation', 'sea-theme' ); ?></a><a class="btn btn-default btn-sm btn-support" href="http://www.uiueux.com/forums/" target="_blank"><?php esc_html_e( 'Support Forum', 'sea-theme' ); ?></a>
                        </div>
                        <div class="col-sm-6 text-right">
                            <button type="submit" class="btn btn-primary btn-sm" data-loading="<?php esc_attr_e( 'Please waitting...', 'sea-theme' ); ?>"><?php esc_html_e( 'Save Options','sea-theme' ); ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <?php seatheme_theme_option_modal(); ?>
        </div>
    </form>
</div>