<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field upload.
 */
if ( ! function_exists( 'seatheme_theme_options_field_upload' ) ) {
	function seatheme_theme_options_field_upload( $item, $key, $getValue ) {
		if ( $item['type'] == 'upload' ) {
			echo '<div class="input-group theme-option-upload">';
			echo   '<input type="text" id="' .esc_attr( $item['name'] ). '" name="' .esc_attr( $key. '[' .$item['name']. ']' ). '" placeholder="' .esc_attr( $item['place'] ). '" class="form-control" value="' .esc_attr( $getValue ). '" />';
			echo   '<span class="input-group-btn">';
			echo     '<button class="btn btn-default ux-theme-upload-image" type="button" data-title="' .esc_attr( $item['title'] ). '">' .esc_html__( 'Upload Image', 'sea-theme' ). '</button>';
            echo     '<button class="btn btn-danger ux-theme-remove-image" type="button">' .esc_html__( 'Remove', 'sea-theme' ). '</button>';
			echo   '</span>';
			echo '</div>';
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_upload', 10, 3 );
}
?>