<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field select.
 */
if ( ! function_exists( 'seatheme_theme_options_field_select' ) ) {
	function seatheme_theme_options_field_select( $item, $key, $getValue ) {
		if ( $item['type'] == 'select' ) {
			echo '<select class="form-control input-sm" id="' .esc_attr( $item['name'] ). '" name="' .esc_attr( $key. '[' .$item['name']. ']' ). '" data-name="' .esc_attr( $item['name'] ). '" style="' .esc_attr( $item['style'] ). '">';
				if ( $item['fields'] ) {
					foreach ( $item['fields'] as $field ) {
						echo '<option value="' .esc_attr( $field[1] ). '" ' .sanitize_text_field( selected( $getValue, $field[1], false ) ). '>' .esc_html( $field[0] ). '</option>';
					}
				} else {
					echo '<option selected="selected" value="0">' .esc_html__( 'No options', 'sea-theme' ). '</option>';
				}
				
			echo '</select>';
		}
		
		if ( $item['type'] == 'multipleSelect' ) {
			if ( count( $item['colSlug'] ) ) {
				foreach ( $item['colSlug'] as $mun => $colSlug ) {
					$getColValue = $getValue[$colSlug];
					echo '<select class="form-control input-sm span6" id="' .esc_attr( $item['name'] ). '_colSlug" name="' .esc_attr( $key. '[' .$item['name']. '][' .$colSlug. ']' ). '" data-name="' .esc_attr( $item['name'] ). '_' .$colSlug. '" style="' .esc_attr( $item['style'] ). '">';
						
						switch ( $colSlug ) {
							case 'desktop': echo '<option selected="selected" value="0">' .esc_html__( 'Desktop', 'sea-theme' ). '</option>'; break;
							case 'mobile': echo '<option selected="selected" value="0">' .esc_html__( 'Mobile', 'sea-theme' ). '</option>'; break;
						}
						
						if ( $item['fields'] ) {
							foreach ( $item['fields'] as $field ) {
								$fieldVal = $field[1];
								
								if ( $colSlug == 'mobile' ) {
									$fieldVal = $fieldVal. '_m';
								}
								
								echo '<option value="' .esc_attr( $fieldVal ). '" ' .sanitize_text_field( selected( $getColValue, $fieldVal, false ) ). '>' .esc_html( $field[0] ). '</option>';
							}
						} else {
							echo '<option selected="selected" value="0">' .esc_html__( 'No options', 'sea-theme' ). '</option>';
						}
					
					echo '</select>';
				}
			}
		}
		
		if ( $item['type'] == 'imageSelect' ) {
			$sizes = explode( ':', $item['size'] );
			$itemStyle = array();
			$itemStyle['width'] = 'width: ' .$sizes[0]. 'px;';
			$itemStyle['height'] = 'height: ' .$sizes[1]. 'px;';
			
			$dataAttr = array();
			if ( $item['data'] ) {
				foreach ( $item['data'] as $dataName => $dataValue ) {
					$dataAttr[$dataName] = 'data-' .$dataName. '="' .$dataValue. '"';
				}
			}
			
			echo '<div class="ux-theme-image-select" data-name="' .esc_attr( $item['name'] ). '" ' .sanitize_text_field( join( ' ', $dataAttr ) ). '>';
			
				if ( $item['fields'] ) {
					echo '<ul class="nav nav-pills">';
					foreach ( $item['fields'] as $field ) {
						$active = ( $getValue == $field[1] ) ? 'active' : false;
						echo '<li class="' .esc_attr( $active ). '" style="' .esc_attr( join( ' ', $itemStyle ) ). '">';
						echo   '<a href="#" class="' .esc_attr( $field[1] ). '" style="' .esc_attr( join( ' ', $itemStyle ) ). '"></a>';
						echo   '<span class="selected"></span>';
						echo '</li>';
					}
					echo '</ul>';
				}
			
			echo   '<input type="hidden" name="' .esc_attr( $key. '[' .$item['name']. ']' ). '" value="' .esc_attr( $getValue ). '">';
			echo '</div>';
			
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_select', 10, 3 );
}
?>