<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field post.
 */
if ( ! function_exists( 'seatheme_theme_options_field_post' ) ) {
	function seatheme_theme_options_field_post( $item, $key, $getValue ) {
		if ( $item['type'] == 'post' ) {
			$posts_per_page = 10;
			if ( $item['pType'] == 'page' ) {
				$posts_per_page = '-1';
			}
			
			$get_posts = get_posts( array(
				'posts_per_page' => $posts_per_page,
				'post_type' => $item['pType']
			) );
			
			if ( $get_posts ) {
				echo '<select id="ux-theme-options-' .esc_attr( $item['name'] ). '" name="' .esc_attr( $key. '[' .$item['name']. ']' ). '" class="form-control">';
				echo   '<option value="-1">' .esc_html__( 'Please pick up a page', 'sea-theme' ). '</option>';
				
					foreach ( $get_posts as $post ) {
						echo '<option value="' .esc_attr( $post->ID ). '" ' .sanitize_text_field( selected( $getValue, $post->ID, false ) ). '>' .esc_html( $post->post_title ). '</option>';
					}
				
				echo '</select>';
			}
			
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_post', 10, 3 );
}