<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field input.
 */
if ( ! function_exists( 'seatheme_theme_options_field_input' ) ) {
	function seatheme_theme_options_field_input( $item, $key, $getValue ) {
		if ( $item['type'] == 'input' ) {
			echo '<div class="form-group">';
			echo   '<input type="text" id="' .esc_attr( $item['name'] ). '" name="' .esc_attr( $key. '[' .$item['name']. ']' ). '" placeholder="' .esc_attr( $item['place'] ). '" class="form-control" value="' .esc_attr( stripslashes( $getValue ) ). '" style="' .esc_attr( $item['style'] ). '" />';
			echo '</div>';
		}
		
		if ( $item['type'] == 'multipleInput' ) {
			echo '<div class="ux-theme-option-multiple-input">';
			
			if ( ! is_array( $getValue ) ) { $getValue = array( $getValue ); }
			if ( ! is_array( $item['place'] ) ) { $item['place'] = array( $item['place'] ); }
			
			for ( $i=0; $i < $item['col']; $i++ ) {
				$select = false;
				if ( isset( $getValue[$i] ) ) { $select = $getValue[$i]; }
				
				$place = false;
				if ( isset( $item['place'][$i] ) ) { $place = $item['place'][$i]; }
				
				echo '<input name="' .esc_attr( $key. '[' .$item['name']. '][]' ). '" type="text" value="' .esc_attr( $select ). '" class="form-control input-sm" style="' .esc_attr( $item['style'] ). '" placeholder="' .esc_attr( $place ). '">';
			}
			
			
			echo '</div>';
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_input', 10, 3 );
}

?>