<?php
//woocommerce setting config fields
if ( ! function_exists( 'seatheme_theme_options_woocommerce_fields' ) ) {
	function seatheme_theme_options_woocommerce_fields( $fields ) {
		$fields['woocommerce'] = array(
			'id' => 'options-woocommerce',
			'title' => esc_html__( 'WooCommerce', 'sea-theme' ),
			'region' => array(
				array(
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
										//Show Woocomerce
										array('title'   => esc_html__( 'Show WooComerce Cart on Header', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_shopping_cart',
											  'default' => 'false' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_show_shopping_cart,true',
									'items' => array(
				
										//Cart height
										array('title'   => esc_html__( 'WooComerce Cart Icon Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ),
											  'name'    => 'theme_option_woo_icon_height' ),

										//Cart Icon left spacing
										array('title'   => esc_html__( 'Left Spacing for WooComerce Cart', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_cart_icon_left_spacing', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),

										//Show Woocomerce on mobile
										array('title'   => esc_html__( 'Show Woocomerce Cart on Mobile', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_shopping_cart_mobile',
											  'default' => 'false' ),
									)
								),
								array(
									'items' => array(
									
										// Archive Page Layout
										array('title'   => esc_html__( 'Archive Page Layout', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '126:80',
											  'name'    => 'fieldWooArchivePageLayout',
											  'default' => 'without-sidebar',
											  'data'    => array( 'position' => 'right bottom' ),
											  'fields'  => array(
												  array( esc_html__( 'Right Sidebar', 'sea-theme' ),  'right-sidebar' ),
												  array( esc_html__( 'Left Sidebar', 'sea-theme' ),   'left-sidebar' ),
												  array( esc_html__( 'Without Sidebar', 'sea-theme' ), 'without-sidebar' )
											  ) ),
									
										// Single Product Layout
										array('title'   => esc_html__( 'Single Product Layout', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '126:80',
											  'name'    => 'fieldWooSingleProductLayout',
											  'default' => 'without-sidebar',
											  'data'    => array( 'position' => 'right bottom' ),
											  'fields'  => array(
												  array( esc_html__( 'Right Sidebar', 'sea-theme' ),  'right-sidebar' ),
												  array( esc_html__( 'Left Sidebar', 'sea-theme' ),   'left-sidebar' ),
												  array( esc_html__( 'Without Sidebar', 'sea-theme' ), 'without-sidebar' )
											  )
										),

										//Shop Description (subtitle)
										array('title'   => esc_html__( 'The Description(subtitle) for Shop Page', 'sea-theme' ),
											  'type'    => 'textarea',
											  'style'   => 'width: 50%;',
											  'default' => esc_html__( 'Welcome to our shop!', 'sea-theme' ),
											  'name'    => 'theme_option_descriptions_woo_shop_des'
										),
									
										// Single Product Slider
										array('title'   => esc_html__( 'Slider on Product Page', 'sea-theme' ),
											  'type'    => 'select',
											  'style'   => 'width: 200px;',
											  'name'    => 'fieldWooSingleProductSlider',
											  'default' => 'minimal',
											  'fields'  => array(
												  array( esc_html__( 'Minimal Style', 'sea-theme' ),  'minimal' ),
												  array( esc_html__( 'WooCommerce Default', 'sea-theme' ), 'wooCommerce' )
											  ) 
										),

										array('title'   => esc_html__( 'Social Share Icon Size on Product Pages', 'sea-theme' ),
											  'desc'    => esc_html__( 'Activate "Enable Share Buttons for Posts" on "Social Networks" tab', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_social_share_icon_size_woo',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),
				
										array('title'   => esc_html__( 'Social Share Icon Spacing on Product Page', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_social_share_icon_spacing_woo',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),

										//Show title on Archive
										array('title'   => esc_html__( 'Show Title on Archive Pages', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_woo_archive_show_tit',
											  'default' => 'true'
										),

										// Sold Out on WooCommerce Shop Page
										array('title'   => esc_html__( 'The Descriptions Word "Sold Out" on WooCommerce Shop Page', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => esc_html__( 'Sold Out', 'sea-theme' ),
											  'name'    => 'theme_option_descriptions_woo_sold_out' 
										)
									)
								)
							)
						)
					)
				)
			)
		);
		
		return $fields;
		
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_woocommerce_fields' );
}
?>