<?php
/**
 * The template for displaying comments
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
$container = seatheme_get_option('theme_option_main_width_style') ? seatheme_get_option('theme_option_main_width_style') : 'container';
if ( is_single() && ! is_singular( 'ux-portfolio' ) ) {
	$container = false;
}
if ( post_password_required() ) {
	return;
}
?>

<?php if ( have_comments() ||  ('open' == $post->comment_status) ) { ?>
<div id="comments" class="comments-area <?php echo sanitize_html_class( $container ); ?>">
<?php } ?>
	<?php if ( have_comments() ) : ?>
		<h2 class="comments-title">
			<?php
				printf( _nx( 'One comment on &ldquo;%2$s&rdquo;', '%1$s comments on &ldquo;%2$s&rdquo;', get_comments_number(), 'Comments title', 'sea-theme' ),
					esc_html( number_format_i18n( get_comments_number() ) ), esc_html( get_the_title() ) );
			?>
		</h2>

		<?php seatheme_comment_nav(); ?>

		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'callback' => 'seatheme_comments',
					'style'       => 'ol',
					'short_ping'  => true,
					'avatar_size' => 56,
				) );
			?>
		</ol><!-- .comment-list -->

		<?php seatheme_comment_nav(); ?>

	<?php endif; // have_comments() ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'sea-theme' ); ?></p>
	<?php endif;  

if ( 'open' == $post->comment_status ) : 

 /* COMMENT ENTRY FORM  */ ?>
	<div id="respondwrap" class="comment-respond">
		<?php 
			$commenter = wp_get_current_commenter();
			$req = get_option( 'require_name_email' );
			$aria_req = ( $req ? " aria-required='true'" : '' ); 
			$name_text = seatheme_get_option('theme_option_descriptions_comment_name');
			$name_text = $name_text ? $name_text : esc_attr__('Name','sea-theme');
			$email_text = seatheme_get_option('theme_option_descriptions_comment_email');
			$email_text = $email_text ? $email_text : esc_attr__('Email','sea-theme');
			$website_text = seatheme_get_option('theme_option_descriptions_comment_website');
			$website_text = $website_text ? $website_text : esc_attr__('Website','sea-theme');
			$review_text = seatheme_get_option('theme_option_descriptions_your_message');
			$review_text = $review_text ? $review_text : esc_attr__('Leave your comment here','sea-theme');
			$review_tit  = seatheme_get_option('theme_option_descriptions_comment_title');
			$review_tit  = $review_tit ? $review_tit : esc_attr__( 'Leave a Comment','sea-theme' );
			$review_submit = seatheme_get_option('theme_option_descriptions_comment_submit');
			$review_submit = $review_submit ? $review_submit : esc_attr__( 'Send Comment','sea-theme' );

			if(esc_attr( $commenter['comment_author'] )){
			$fields =  array(
				'author' => '<p><input id="author" name="author" type="text" class="requiredFieldcomm" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' .sanitize_text_field( $aria_req ). ' tabindex="1" placeholder="'.esc_attr( $name_text ).'" /></p>',
				'email' => '<p><input id="email" name="email" type="text" class="email requiredFieldcomm" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30"' .sanitize_text_field( $aria_req ). ' tabindex="2" placeholder="'.esc_attr( $email_text ).'" /></p>',
				'url' => '<p><input id="url" name="url" type="text" class="url requiredFieldcomm" value="' . esc_url( $commenter['comment_author_url'] ) . '" size="30"' .sanitize_text_field( $aria_req ). ' tabindex="3" placeholder="'.esc_attr( $website_text ).'" /></p>'
			);
			}else{
			$fields =  array(
				'author' => '<p><input id="author" name="author" type="text" class="requiredFieldcomm" value="" size="30"' .sanitize_text_field( $aria_req ). ' tabindex="1" placeholder="'.esc_attr( $name_text ).'" /></p>',
				'email' => '<p><input id="email" name="email" type="text" class="email requiredFieldcomm" value="" size="30"' .sanitize_text_field( $aria_req ). ' tabindex="2" placeholder="'.esc_attr( $email_text ).'" /></p>',
				'url' => '<p><input id="url" name="url" type="text" class="url requiredFieldcomm" value="" size="30"' .sanitize_text_field( $aria_req ). ' tabindex="3" placeholder="'.esc_attr( $website_text ).'" /></p>'
			);
			}
		
			$privacyPolicyMessageHtml = '';
			if ( is_user_logged_in() ) {
				
				if ( $privacyPolicy = seatheme_get_option( 'theme_option_cookie_comment_message' ) ) {
					$privacyPolicyMessage = seatheme_get_option( 'theme_option_cookie_comment_message_text' );
					$privacyPolicyMessageHtml = '<div class="privacy-policy"><input type="checkbox" name="idi_privacy_policy" id="idi_privacy_policy_comment" /><label for="idi_privacy_policy_comment">' .wp_kses_post( stripslashes( $privacyPolicyMessage ) ). '</label></div>';
				}
			}
		
			$comments_args = array(
			    'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
			    'title_reply'          => '<span class="comm-reply-title">'.esc_html( $review_tit ).'</span>',
			    'title_reply_to'       => esc_html__( 'Leave a Comment to %s','sea-theme' ),
			    'cancel_reply_link'    => esc_html__( 'Cancel Reply','sea-theme' ),
			    'label_submit'         => esc_html( $review_submit ),
			    'comment_field'		   => '<p><textarea id="comment" name="comment" class="requiredFieldcomm" cols="100%" tabindex="4" aria-required="true" placeholder="'.esc_textarea( $review_text ).'"></textarea></p>',
                'comment_notes_after'  => $privacyPolicyMessageHtml,
                'comment_notes_before'  =>''
			);
        ?>
		<?php comment_form( $comments_args ); ?>
	</div>
<?php endif; ?> 
<?php if ( have_comments() || ('open' == $post->comment_status) ) { ?>
</div>
<?php } ?>