<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Post Navigation shortcode.
 */
function ux_cb_module_post_navi_shortcode( $atts ) {
	$moduleID = 'post-navi';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_post_navi' );
	
	$html = ux_cb_get_module_template( $moduleID, $atts );
	return $html;
}
add_shortcode( 'ux_cb_post_navi', 'ux_cb_module_post_navi_shortcode' );

/**
 * UX Content Builder Module Post Navigation container.
 */
function ux_cb_module_post_navi_container( $module, $moduleUnique ) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
	$postID = get_the_ID();
	
	if ( ! $module['is_frontend'] ) {
		if ( isset( $_POST['postID'] ) ) {
			$postID = $_POST['postID'];
		}
	}
	
	$naviClass = array();
	$imageClass = 'middle-ux';
	
	$adjacent = false;
	$nextPrevious = get_post_meta( $post_id, '__ux_cb_module_post_navi_next_previous', true );
	if ( $nextPrevious == 'previous' ) {
		$adjacent = true;
	}
	
	$currentPost = get_post( $postID );
	$taxonomy = 'category';
	$postType = $currentPost->post_type;
	if ( $postType == 'ux-portfolio' ) { $taxonomy = 'ux-portfolio-cat'; }
	$category = get_post_meta( $post_id, '__ux_cb_module_post_navi_category_' .$postType, true );
	$itemsShow = intval( get_post_meta( $post_id, '__ux_cb_module_post_navi_items_show', true ) );
	
	$showImage = get_post_meta( $post_id, '__ux_cb_module_post_navi_show_image', true );
	$naviAlign = get_post_meta( $post_id, '__ux_cb_module_post_navi_align', true );
	if ( $showImage == 'image' ) {
		switch( $naviAlign ) {
			case 'right': $naviClass[] = 'post-navi-img-right'; break;
			case 'center': $naviClass[] = 'post-navi-img-center'; $imageClass = ''; break;
		}
	} else {
		$naviClass[] = 'post-navi-bg';
		switch( $naviAlign ) {
			case 'right': $naviClass[] = 'ux-right'; break;
			case 'center': $naviClass[] = 'ux-center'; break;
		}
	}
	
	$inSameTerm = false;
	if ( $category ) {
		$inSameTerm = true;
	}
	
	$excludedTerms = array();
	$terms = get_the_terms( $postID, $taxonomy );
	if ( $terms && ! is_wp_error( $terms ) ) {
		foreach ( $terms as $term ) {
			if ( $category ) {
				if ( $term->term_id != $category ) {
					$excludedTerms[] = $term->term_id;
				}
			}
		}
	}
	
	$adjacentPosts = ux_cb_get_adjacent_post( $inSameTerm, $excludedTerms, $adjacent, $taxonomy, $itemsShow, $postID );
	if ( ! empty( $adjacentPosts ) ) {
		$thumbnailUrl = false;
		$thumbnailStyle = false;
		foreach ( $adjacentPosts as $adjacentPost ) {
			if ( $showImage == 'image' ) {
				if ( ! $thumbnailUrl ) {
					if ( has_post_thumbnail( $adjacentPost ) ) {
						$thumbnailUrl = wp_get_attachment_url( get_post_thumbnail_id( $adjacentPost ) );
					}
				}
			}
			
			if ( $showImage == 'bg-image' ) {
				if ( ! $thumbnailStyle ) {
					if ( has_post_thumbnail( $adjacentPost ) ) {
						$thumbnailUrl = wp_get_attachment_url( get_post_thumbnail_id( $adjacentPost ) );
						$thumbnailStyle = 'background-image: url(' .$thumbnailUrl. ');';
					}
				}
			}
		}
		
		//style
		if ( ! $module['is_frontend'] ) {
			$html .= '<style type="text/css">' .ux_cb_module_post_navi_style( $post_id, $moduleUnique, $html ). '</style>';
		}
		
		if ( ( $showImage == 'image' && $itemsShow > 1 )  || ( $showImage == 'bg-image' && $itemsShow > 1 ) ) {
			$sliderWrapClass = array();
			
			//text align
			$sliderWrapClass['text-align'] = 'style2-text-left';
			if ( $naviAlign ) {
				switch( $naviAlign ) {
					case 'right': $sliderWrapClass['text-align'] = 'style2-text-right'; break;
					case 'center': $sliderWrapClass['text-align'] = 'style2-text-center'; break;
				}
			}
			
			$lazyClass = 'lazy';
			if ( ! $module['is_frontend'] ) {
				$lazyClass = '';
			}
			
			$html .= '<div class="post-navi ' .esc_attr( join( ' ', $naviClass ) ). '">';
			$html .= '<div class="slider-mod-wrap slider-style2 ' .esc_html( join( ' ', $sliderWrapClass ) ). '">';
			$html .=   '<div class="bm-tab-slider">';
			$html .=     '<nav class="bm-tab-slider-trigger">';
			
					foreach ( $adjacentPosts as $num => $adjacentPost ) {
						$active = $num == 0 ? 'bm-active' : false;
						$html .= '<div class="bm-tab-slider-trigger-item">';
						$html .=   '<a data-id="post-' .esc_attr( intval( $num ) ). '-' .esc_attr( $adjacentPost->ID ). '" data-logocolor="default-logocolor" data-menucolor="default-menucolor" class="bm-tab-slider-trigger-tilte ' .sanitize_html_class( $active ). '" href="' .esc_url( get_permalink( $adjacentPost ) ). '">' .esc_html( get_the_title( $adjacentPost ) ). '</a>';
						$html .= '</div>';
					}
					
			$html .=     '</nav>';
			$html .=     '<ul class="bm-tab-slider-img">';
					
					foreach ( $adjacentPosts as $num => $adjacentPost ) {
						$active = $num == 0 ? 'bm-active' : false;
						$thumbnailUrl = false;
						$thumbnailBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
						if ( has_post_thumbnail( $adjacentPost ) ) {
							$thumbnailUrl = wp_get_attachment_url( get_post_thumbnail_id( $adjacentPost ) );
						}
						$thumbFullSrcset = wp_get_attachment_image_srcset( $adjacentPost->ID, 'full' );
						$thumbFullSizes = wp_get_attachment_image_sizes( $adjacentPost->ID, 'full' );
						if ( ! $module['is_frontend'] ) {
							$thumbSrc = 'src="'.esc_url( $thumbnailUrl ).'"';
						} else {
							$thumbSrc = 'src="' .esc_attr( $thumbnailBlank ). '" data-src="' .esc_url( $thumbnailUrl ). '"';
						}
						$html .= '<li id="post-' .esc_attr( intval( $num ) ). '-' .esc_attr( intval( $adjacentPost->ID ) ). '" class="bm-tab-slider-img-item ux-background-img ' .sanitize_html_class( $active ). '"><img class="grid-item-img post-navi-img '.sanitize_html_class( $lazyClass ).'" '.wp_kses_post( $thumbSrc ).' alt="' .esc_attr( $adjacentPost->post_excerpt ). '" data-srcset="' .wp_kses_post( $thumbFullSrcset ). '" data-sizes="' .wp_kses_post( $thumbFullSizes ). '"></li>';
					}
					
			$html .=     '</ul>';
			$html .=   '</div>';
			$html .= '</div><!--End slider-mod-wrap-->';
			$html .= '</div>';
		} else {
		
			$html .= '<div class="post-navi ' .esc_attr( join( ' ', $naviClass ) ). '" style="' .sanitize_text_field( $thumbnailStyle ). '">';
			$html .=   '<div class="post-navi-tit-wrap">';
			
				//show label
				$showLabel = get_post_meta( $post_id, '__ux_cb_module_post_navi_show_label', true );
				if ( $showLabel == 'on' ) {
					//label text
					$labelText = get_post_meta( $post_id, '__ux_cb_module_post_navi_label_text', true );
					
					$html .= '<span class="post-navi-tag">' .esc_html( $labelText ). '</span>';
				}
			foreach ( $adjacentPosts as $adjacentPost ) {
				$html .= '<h3 class="post-navi-tit"><a class="post-navi-tit-a" href="' .esc_url( get_permalink( $adjacentPost ) ). '" title="' .esc_attr( get_the_title( $adjacentPost ) ). '">' .esc_html( get_the_title( $adjacentPost ) ). '</a></h3>';
			}
			
			$html .=   '</div>';
			
				//show image
				if ( $showImage == 'image' ) {
					$html .= '<img class="post-navi-img ' .sanitize_html_class( $imageClass ). '" src="' .esc_url( $thumbnailUrl ). '" alt="' .esc_attr( get_the_title( $adjacentPost ) ). '" />';
				}
			
			$html .= '</div>';
		}
	}
	
	return $html;
}
add_filter( 'ux_cb_module_container_post-navi', 'ux_cb_module_post_navi_container', 10, 2 );

function ux_cb_get_adjacent_post( $in_same_term = false, $excluded_terms = '', $previous = true, $taxonomy = 'category', $itemsShow = 0, $postID ){
	global $wpdb;

	if ( ( ! $post = get_post( $postID ) ) || ! taxonomy_exists( $taxonomy ) ) {
		return null;
	}

	$current_post_date = $post->post_date;

	$join     = '';
	$whereTO  = '';
	$adjacent = $previous ? 'previous' : 'next';

	if ( ! empty( $excluded_terms ) && ! is_array( $excluded_terms ) ) {
		if ( false !== strpos( $excluded_terms, ' and ' ) ) {
			_deprecated_argument( __FUNCTION__, '3.3.0', sprintf( __( 'Use commas instead of %s to separate excluded terms.' ), "'and'" ) );
			$excluded_terms = explode( ' and ', $excluded_terms );
		} else {
			$excluded_terms = explode( ',', $excluded_terms );
		}

		$excluded_terms = array_map( 'intval', $excluded_terms );
	}

	if ( $in_same_term || ! empty( $excluded_terms ) ) {
		if ( $in_same_term ) {
			$join  .= " INNER JOIN $wpdb->term_relationships AS tr ON p.ID = tr.object_id INNER JOIN $wpdb->term_taxonomy tt ON tr.term_taxonomy_id = tt.term_taxonomy_id";
			$whereTO .= $wpdb->prepare( 'AND tt.taxonomy = %s', $taxonomy );

			if ( ! is_object_in_taxonomy( $post->post_type, $taxonomy ) ) {
				return '';
			}
			$term_array = wp_get_object_terms( $post->ID, $taxonomy, array( 'fields' => 'ids' ) );
			$term_array = array_diff( $term_array, (array) $excluded_terms );
			$term_array = array_map( 'intval', $term_array );

			if ( ! $term_array || is_wp_error( $term_array ) ) {
				return '';
			}

			$whereTO .= ' AND tt.term_id IN (' . implode( ',', $term_array ) . ')';
		}
	}

	if ( is_user_logged_in() ) {
		$user_id = get_current_user_id();

		$post_type_object = get_post_type_object( $post->post_type );
		if ( empty( $post_type_object ) ) {
			$post_type_cap    = $post->post_type;
			$read_private_cap = 'read_private_' . $post_type_cap . 's';
		} else {
			$read_private_cap = $post_type_object->cap->read_private_posts;
		}

		$private_states = get_post_stati( array( 'private' => true ) );
		$whereTO       .= " AND ( p.post_status = 'publish'";
		foreach ( (array) $private_states as $state ) {
			if ( current_user_can( $read_private_cap ) ) {
				$whereTO .= $wpdb->prepare( ' OR p.post_status = %s', $state );
			} else {
				$whereTO .= $wpdb->prepare( ' OR (p.post_author = %d AND p.post_status = %s)', $user_id, $state );
			}
		}
		$whereTO .= ' )';
	} else {
		$whereTO .= " AND p.post_status = 'publish'";
	}

	$op    = $previous ? '>' : '<';
	$order = $previous ? 'ASC' : 'DESC';

	$join = apply_filters( "get_{$adjacent}_post_join", $join, $in_same_term, $excluded_terms, $taxonomy, $post );
	$where = apply_filters( "get_{$adjacent}_post_where", $wpdb->prepare( "WHERE p.post_date $op %s AND p.post_type = %s $whereTO", $current_post_date, $post->post_type ), $in_same_term, $excluded_terms, $taxonomy, $post );

	$sort = apply_filters( "get_{$adjacent}_post_sort", "ORDER BY p.post_date $order LIMIT " .$itemsShow, $post, $order );

	$result = ux_cb_get_adjacent_post_result( $wpdb, $join, $where, $sort );
	
	if ( count( $result ) < $itemsShow ) {
		if ( $result ) {
            if ( is_array( $result ) ) {
				$itemsShow = $itemsShow - count( $result );
				
				$endResult = end( $result );
				$post = get_post( $endResult->ID );
				$current_post_date = $post->post_date;
				$resultReverse = ux_cb_get_adjacent_post_result_reverse( $wpdb, $join, $whereTO, $itemsShow, $current_post_date, $post, $previous, $order );
				$result = array_merge( $result, $resultReverse );
            }
        } else {
			$result = ux_cb_get_adjacent_post_result_reverse( $wpdb, $join, $whereTO, $itemsShow, $current_post_date, $post, $previous, $order );
        }
	}
	
	if ( $result ) {
		if ( is_array( $result ) ) {
			$rs = array();
			foreach ( $result as $r ) {
				$rs[] = get_post( $r->ID );
			}
			$result = $rs;
		} else {
			$result = get_post( $result );
		}
	}

	return $result;
	
}

function ux_cb_get_adjacent_post_result( $wpdb, $join, $where, $sort ) {
	$query     = "SELECT p.ID FROM $wpdb->posts AS p $join $where $sort";
	$query_key = 'adjacent_post_' . md5( $query );

	$result = $wpdb->get_results( $query );
	if ( null === $result ) {
		$result = '';
	}
	
	return $result;
}

function ux_cb_get_adjacent_post_result_reverse( $wpdb, $join, $whereTO, $itemsShow, $current_post_date, $post, $previous, $order ) {
	$op    = $previous ? '<' : '>';
    $where = $wpdb->prepare( "WHERE p.post_date $op %s AND p.post_type = %s $whereTO", $current_post_date, $post->post_type );
    $sort = "ORDER BY p.post_date $order LIMIT " .$itemsShow;
    $result = ux_cb_get_adjacent_post_result( $wpdb, $join, $where, $sort );
	
	return $result;
	
}