<?php
/**
 * Main UX_CB_Module_Fields Class.
 *
 * @class UX_CB_Module_Fields
 * @version	1.0.0
 */
if ( ! class_exists( 'UX_CB_Module_Fields' ) ) {

	class UX_CB_Module_Fields {
		
		function templates($module, $atts, $default=false, $content=false){
			$html = '';
			
			$colWidth = '12/12';
			
			switch($atts['col']){
				case '12': $colWidth = '12/12'; break;
				case '11': $colWidth = '11/12'; break;
				case '10': $colWidth = '10/12'; break;
				case '9': $colWidth = '9/12'; break;
				case '8': $colWidth = '8/12'; break;
				case '7': $colWidth = '7/12'; break;
				case '6': $colWidth = '6/12'; break;
				case '5': $colWidth = '5/12'; break;
				case '4': $colWidth = '4/12'; break;
				case '3': $colWidth = '3/12'; break;
				case '2': $colWidth = '2/12'; break;
				case '1': $colWidth = '1/12'; break;
				case '0': $colWidth = 'fullwidth'; break;
			}
			
			$post_id = ux_cb_get_the_module_post_id($atts['unique']);
			
			//padding
			$paddingStyle = '';
			$paddingTop = 0;
			if($paddingTop = get_post_meta($post_id, '__ux_cb_module_top_padding', true)){
				if($paddingTop == 'zero'){
					$paddingTop = 0;
				}
				$paddingStyle .= 'margin-top: ' .$paddingTop. 'px;';
			}
			$paddingBottom = 0;
			if($paddingBottom = get_post_meta($post_id, '__ux_cb_module_bottom_padding', true)){
				if($paddingBottom == 'zero'){
					$paddingBottom = 0;
				}
				$paddingStyle .= 'margin-bottom: ' .$paddingBottom. 'px;';
			}
			
			//padding mobile
			$paddingTopMobile = 0;
			if($paddingTopMobile = get_post_meta($post_id, '__ux_cb_module_top_padding_mobile', true)){
				if($paddingTopMobile == 'zero'){
					$paddingTopMobile = 0;
				}
			}
			$paddingBottomMobile = 0;
			if($paddingBottomMobile = get_post_meta($post_id, '__ux_cb_module_bottom_padding_mobile', true)){
				if($paddingBottomMobile == 'zero'){
					$paddingBottomMobile = 0;
				}
			}

			$isFrontend = false;
			if(isset($module['is_frontend'])){
				if($module['is_frontend']){
					$isFrontend = true;
				}
			}
			$module['is_frontend'] = $isFrontend;

			//Cols number
			$col_number = false;
			switch ($atts['col']) {
				case '0':
					$col_number = esc_attr__('Fullwidth','bm-builder');
					break;
				
				default:
					$col_number = $atts['col'] . esc_attr__('/12','bm-builder');
					break;
			}
			
			//module content style
			$moduleContentStyle = array();
			$moduleContentClass = array();
			$moduleClass = array();
			$moduleDataTag = array();
			$moduleInsideClass = array();
			
			//offset
			$offsetNum = 0;
			if ( $offset = get_post_meta( $post_id, '__ux_cb_module_offset_base', true ) ) {
				$moduleClass[] = $offset; 
				$offsetNum = str_replace('col-offset-', '', $offset);
			}
			$moduleDataTag['offset'] = 'data-offset="' .$offsetNum. '"';
			
			//droppable
			$moduleClass['droppable'] = 'no-droppable';
			if ( $module['id'] == 'group' ) {
				$moduleClass['droppable'] = 'has-droppable';
			}
			
			//Disable Gap
			if( 'on' === get_post_meta( $post_id, '__ux_cb_module_group_disable_gap', true ) ) {
				$moduleClass[] = 'bm-wrap-no-gap';
			}
			
			//sub module sortable
			if ( $module['id'] == 'group' ) {
				$moduleContentClass[] = 'sub-module-sortable';
			}

			//module inside class
			$moduleInsideClass = apply_filters( 'ux_cb_module_template_frontend_module_inside_class', $moduleInsideClass, $module['id'], $post_id );
			$moduleContentStyle = apply_filters( 'ux_cb_module_template_module_content_style', $moduleContentStyle, $module['id'], $post_id );
			$moduleContentClass = apply_filters( 'ux_cb_module_template_module_content_class', $moduleContentClass, $module['id'], $post_id );
			$moduleClass = apply_filters( 'ux_cb_module_template_module_class', $moduleClass, $module['id'], $post_id );
			$moduleDataTag = apply_filters( 'ux_cb_module_template_module_data_tag', $moduleDataTag, $module['id'], $post_id );
			
			$html .= '<div class="item module col-' .esc_attr($atts['col']). ' module-id-'.esc_attr($atts['unique']).' ' .join( ' ', $moduleClass). '" data-module-shortcodetag="' .$module['shortcodeTag']. '" data-module-unique="' .esc_attr($atts['unique']). '" data-module-id="' .esc_attr($module['id']). '" data-module-title="' .esc_attr($module['title']). '" data-module-width="' .esc_attr($colWidth). '" data-module-col="' .esc_attr($atts['col']). '" data-default="' .esc_attr($default). '" style="' .esc_attr($atts['style']). '" data-padding-top="' .intval($paddingTop). '" data-padding-bottom="' .intval($paddingBottom). '" data-padding-top-mobile="' .intval($paddingTopMobile). '" data-padding-bottom-mobile="' .intval($paddingBottomMobile). '" ' .join( ' ', $moduleDataTag ). '>';
			$html .=  '<div class="module-inside '.esc_attr( join( ' ', $moduleInsideClass ) ).'" style="'.esc_attr($paddingStyle).'">';
			$html .=   '<div class="module-content ' .esc_attr( join( ' ', $moduleContentClass ) ). '" style="' .esc_attr( join( ' ', $moduleContentStyle ) ). '">';
			$html .=     apply_filters('ux_cb_module_container_' .$module['id'], $module, $atts['unique'], $content);
			$html .=   '</div>';
			$html .=   '<div class="module-edit-tools">';
			//$html .=     '<span class="dashicons dashicons-move"></span>';
			$html .=     '<button class="move-up" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="move-down" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="increase" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="decrease" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="offset-left-right" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="offset-left hidden" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="offset-right hidden" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="spacer-top-bottom" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="increase-spacer-bottom hidden" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="decrease-spacer-bottom hidden" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="increase-spacer-top hidden" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="decrease-spacer-top hidden" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="edit" type="button"><span class="tools-svg"></span></button>';
			
			if ( $module['id'] == 'group' ) {
				$html .= '<button class="group-save-layout" type="button"><span class="tools-svg">2</span></button>';
			}
			
			$html .=     '<button class="clone" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="trash" type="button"><span class="tools-svg"></span></button>';
			$html .=     '<button class="add-module" type="button"><span class="tools-svg"></span></button>';
			$html .=   '</div>';
			$html .=   '<div class="module-border">';
			$html .=     '<span class="text-info col-number hidden">' .esc_attr($col_number). '</span>';
			$html .=     '<span class="text-info spacer-top-info hidden">' .esc_attr($paddingTop). '</span>';
			$html .=     '<span class="text-info spacer-bottom-info hidden">' .esc_attr($paddingBottom). '</span>';
			$html .=   '</div>';
			$html .=   '<div class="module-shortcode">' .balanceTags( $module['shortcode'] ). '</div>';
			$html .= ' </div>';
			$html .= '</div>';
			
			return $html;
		}
		
		function fields($module_id, $item){
			$html = '';
			
			$item = wp_parse_args($item, array(
				'title' => '',
				'default' => '',
				'style' => '',
				'fields' => false,
				'taxonomy' => 'category',
				'text' => false,
				'nosave' => false,
				'id' => $item['name'],
				'place' => false,
				'text' => '',
				'key' => false,
				'class' => '',
				'target' => false,
				'source' => '',
				'ptype' => 'category',
				'catname' => '',
				'count' => 4,
				'group' => false,
				'format' => 'image',
				'dataType' => 'postmeta',
				'disabled' => false,
				'item-text' => esc_html__('Item','bm-builder'),
				'fontval' => array( 'family' => '0', 'weight' => 'normal', 'size' => '14px', 'lineheight' => '24px', 'letter_spacing' => 'normal', 'msize' => '14px' ), //family, weight, size, line height, letter spacing
				'inputType' => 'text', //text, email, url, number, range, date, month, week, time, datetime, datetime-local, search, color
				'col' => 0,
				'current' => false
			));
			
			$get_val = false;
			$post_id = false;
			if(isset($_POST['moduleUnique'])){
				$post_id = ux_cb_get_the_module_post_id($_POST['moduleUnique']);
			}
			
			if($post_id){
				$get_val = get_post_meta($post_id, $item['name'], true);
			}
			
			if ( $item['dataType'] == 'option' ) {
				$get_val = get_option( $item['name'] );
			}
			
			$item_val = $item['default'];
			if($get_val){
				$item_val = $get_val;
			}
			
			if($item['nosave']){
				$item['name'] = '';
			}
			
			switch($item['type']){
				case 'numberGroup':
					$numberGroupVal = $item['default'];
					if ( $module_id != 'button' ) {
						$numberGroupVal = $item_val;
					}
					
					if ( is_array( $numberGroupVal ) ) {
						foreach ( $numberGroupVal as $num => $numberInput ) {
							$place = false;
							if ( is_array( $item['place'] ) ) {
								if ( isset( $item['place'][$num] ) ) {
									$place = $item['place'][$num];
								}
							}
							
							echo '<input name="' .esc_attr( $item['name'] ). '" type="number" id="' .esc_attr( $item['id']. '_' .$num ). '" value="' .esc_attr( $numberInput ). '" class="regular-text" style="' .esc_attr( $item['style'] ). '" placeholder="' .esc_attr( $place ). '">';
						}
					}
				break;
				
				case 'textarea':
                    echo '<textarea name="' .esc_attr($item['name']). '" class="regular-text" rows="3" style="' .esc_attr($item['style']). '">' .esc_textarea($item_val). '</textarea>';
                break;
				
				case 'multipleSelect':
					for ( $i=0; $i<$item['col']; $i++ ) {
						if ( ! is_array( $item_val ) ) { $item_val = array( $item_val, 0 ); }
						$select = $item_val[$i];
						
						$place = false;
						if ( is_array( $item['place'] ) ) {
							if ( isset( $item['place'][$i] ) ) {
								$place = $item['place'][$i];
							}
						}
						
						echo '<select name="' .esc_attr( $item['name'] ). '" id="' .esc_attr( $item['id'] ). '_' .esc_attr( $i ). '" style="' .esc_attr( $item['style'] ). '">';
						if ( $item['fields'] ) {
							echo '<option selected="selected" value="0">' .esc_html__( $place ). '</option>';
							foreach ( $item['fields'] as $field ) {
								echo '<option value="' .esc_attr( $field[1] ). '" ' .selected( $select, $field[1], false ). '>' .esc_html( $field[0] ). '</option>';
							}
						}else{
							echo '<option selected="selected" value="0">' .esc_html__( 'No options','bm-builder' ). '</option>';
						}
						echo '</select>';
					}
				break;
				
				case 'select':
					echo '<select name="' .esc_attr($item['name']). '" id="' .esc_attr($item['id']). '" style="' .esc_attr($item['style']). '" class="ux-cb-module-field-select">';
					if($item['fields']){
						foreach($item['fields'] as $field){
							echo '<option value="' .esc_attr($field[1]). '" ' .selected($item_val, $field[1], false). '>' .esc_html($field[0]). '</option>';
						}
					}else{
						echo '<option selected="selected" value="0">' .esc_html__('No options','bm-builder'). '</option>';
					}
					echo '</select>';
				break;
				
				case 'image-select':
					if ( $item['fields'] ) {
						echo '<ul class="ux-cb-module-field-image-select ' .sanitize_html_class( $item['class'] ). '">';
						foreach ( $item['fields'] as $field ) {
							$selected = $item_val == $field[1] ? 'selected' : false;
							echo '<li data-value="' .esc_attr( $field[1] ). '" style="' .esc_attr( $item['style'] ). '" class="' .sanitize_html_class( $selected ). '"><span>' .esc_html( $field[0] ). '</span></li>';
						}
						echo '</ul>';
						echo '<input type="hidden" name="' .esc_attr( $item['name'] ). '" value="' .esc_attr( $item_val ). '">';
					}
				break;
				
				case 'switch':
					$switch_text_on = esc_attr__('On','bm-builder');
					$switch_text_off = esc_attr__('Off','bm-builder');
					$switch_text = $item_val == 'on' ? $switch_text_on : $switch_text_off;
					if($item['text']){
						$switch_text = $item['text'];
					}
					
					echo '<button type="button" class="ux-cb-module-field-switch ' .esc_attr($item_val). '" data-text-on="' .esc_attr($switch_text_on). '" data-text-off="' .esc_attr($switch_text_off). '">';
					echo esc_html($switch_text);
					echo '</button>';
					echo '<input type="hidden" name="' .esc_attr($item['name']). '" id="' .esc_attr($item['id']). '" value="' .esc_attr($item_val). '">';
				break;
				
				case 'bg-color':
					global $ux_cb_module_theme_color;
					if(count($ux_cb_module_theme_color)){
						echo '<div class="ux-cb-module-field-theme-color">';
							foreach($ux_cb_module_theme_color as $color){
								$active = $color['id'] == $item_val ? 'active' : '';
								echo '<button type="button" class="color ' .sanitize_html_class($active). '" data-value="' .esc_attr($color['id']). '" style="background-color: ' .esc_attr($color['rgb']). ';"><span class="dashicons dashicons-yes"></span></button>';
							}
							echo '<button type="button" data-value="" class="cancel"></button>';
							echo '<input type="hidden" name="' .esc_attr($item['name']). '" value="' .esc_attr($item_val). '">';
						echo '</div>';
                    }
				break;
				
				case 'summernote':
					if(isset($_POST['textContent'])){
						if($_POST['textContent'] != ''){
							$item_val = stripslashes_deep($_POST['textContent']);
						}
					}
					
					echo '<div class="ux-summernote-wrap">';
					echo '<div class="ux-summernote" data-id="' .esc_attr($item['id']). '">' .balanceTags($item_val). '</div>';
					echo '<textarea class="hidden" name="' .esc_attr($item['name']). '">' .balanceTags($item_val). '</textarea>';
					echo '</div>';
				break;
				
				case 'upload':
					$hidden_placeholder = false;
					$hidden_remove = 'hidden';
					if($item_val){
						$hidden_placeholder = 'hidden';
						$hidden_remove = false;
					}
				
					echo '<div class="ux-cb-module-field-upload" data-format="' .esc_attr($item['format']). '">';
					echo '<div class="image"><div class="placeholder ' .sanitize_html_class($hidden_placeholder). '">' . esc_html__('No image set','bm-builder'). '</div>';
					
					if($item_val){
						$image_src = wp_get_attachment_image_src($item_val, 'full');
						echo '<img src="' .esc_url($image_src[0]). '">';
						echo '<input type="hidden" name="' .esc_attr($item['name']). '-url" value="' .esc_url($image_src[0]). '">';
					}
					
					echo '</div>';
					echo '<button type="button" class="button add">' . esc_html__('Add new image','bm-builder'). '</button>';
					echo '<button type="button" class="button remove ' .sanitize_html_class($hidden_remove). '">' . esc_html__('Remove image','bm-builder'). '</button>';
					echo '<input type="hidden" name="' .esc_attr($item['name']). '" value="' .esc_attr($item_val). '">';
					echo '</div>';
				break;
				
				case 'items':
					echo '<button type="button" class="button add">' .esc_html__('Add','bm-builder'). ' ' .esc_html($item['item-text']). '</button>';
					echo '<ul class="ux-cb-module-field-items" data-set-name="' .esc_attr($item['name']). '">';
					
					$items_count = $item['count'];
					$hidden_class = false;
					if($item['count'] == 0){
						$items_count = 1;
						$hidden_class = 'hidden';
					}
					
					if($item_val){
						$item_fields = array();
						foreach($item_val as $num => $item_row){
							foreach($item_row as $field){
								$item_fields[$num][$field['name']] = $field['value'];
							}
						}
						$items_count = count($item_val);
						$item_val = $item_fields;
						$hidden_class = false;
					}
					
					//button clone
					$cloneHidden = false;
					if ( $module_id != 'button' ) {
						$cloneHidden = 'hidden';
					}
					
					//fonts definition
					if($module_id == 'ux-cb-fonts-definition'){
						$items_count = 0;
						$item_val = get_option('ux-font-lists');
						if ( $item_val ) {
							$hidden_class = false;
							$items_count = count( $item_val );
						}
						
						if ( $items_count == 0 ) {
							$items_count = 1;
						}
					}
					
					for($i = 0; $i < $items_count; $i++){
						$item_text = esc_html($item['item-text']). ' ' .($i + 1);
						if($module_id == 'ux-cb-fonts-definition'){
							$unique = trim( $item_val[$i]['value'] );
							$fontFields = get_option('ux-font-' .$unique);
							if($fontFields){
								$item_text = $fontFields[0]['value'];
							}
						}else{
							if(isset($item_val[$i]['__ux_cb_module_button_item_text'])){
								$item_text = $item_val[$i]['__ux_cb_module_button_item_text'];
							}elseif(isset($item_val[$i]['__ux_cb_module_fonts_style_name'])){
								$item_text = $item_val[$i]['__ux_cb_module_fonts_style_name'];
							}elseif(isset($item_val[$i]['__ux_cb_module_social_media_item_name'])){
								$item_text = $item_val[$i]['__ux_cb_module_social_media_item_name'];
								
							}
						}
						
						echo '<li class="' .sanitize_html_class($hidden_class). '">';
						echo '<h6>' .esc_html($item_text). '</h6>';
						//echo '<div class="icon"><span class="dashicons dashicons-edit"></span></div>';
						echo '<button type="button" class="button clone ' .sanitize_html_class( $cloneHidden ). '"><span class="dashicons dashicons-admin-page"></span></button>';
						echo '<button type="button" class="button edit"><span class="dashicons dashicons-edit"></span></button>';
						echo '<button type="button" class="button remove"><span class="dashicons dashicons-no-alt"></span></button>';
						
						if($module_id != 'ux-cb-fonts-definition'){
							if(isset($item_val[$i])){
								foreach($item_val[$i] as $field_name => $field_value){
									echo '<input type="hidden" name="' .$field_name. '" value="' .$field_value. '">';
								}
							}
						}else{
							//$field_value = $item_val[$i]['__ux_cb_module_fonts_style_name']
							echo '<input type="hidden" name="' .esc_attr($item['name']). '" value="' .trim( $item_val[$i]['value'] ). '">';
						}
						
						echo '</li>';
					}
					
					echo '</ul>';
				
				break;
				
				case 'button':
					$buttonData = array();
					$buttonData['data-target'] = 'data-target="' .esc_attr( $item['target'] ). '"';
					if ( $item['key'] ) {
						if ( $googleApiKey = get_option( '_ux_cb_module_fonts_google_api_key' ) ) {
							$buttonData['data-googlekey'] = 'data-googlekey="' .esc_attr( $googleApiKey ). '"';
						}
					}
					
					echo '<button type="button" class="button ux-cb-module-field-button ' .sanitize_html_class( $item['class'] ). '" ' .join( ' ', $buttonData ). ' ' .disabled( true, $item['disabled'], false ). '>' .esc_html( $item['text'] ). '</button>';
				break;
				
				case 'custom-grid-layouts':
					
					echo '<button id="' .esc_attr($item['id']). '" type="button" class="ux-cb-module-field-custom-grid-layouts" data-catname="' .esc_attr($item['catname']). '" data-source="' .esc_attr($item['source']). '">' .esc_html($item['text']). '</button>';
				break;
				
				case 'source':
					$get_post_types = get_post_types(array('public'=>true), 'objects');
					
					$getTaxonomy = $item['taxonomy'];
					$disabled = false;
					if ( $item['current'] ) {
						$disabled = true;
						if ( isset( $_POST['postType'] ) ) {
							switch ( $_POST['postType'] ) {
								case 'post': $getTaxonomy = 'category'; break;
								case 'ux-portfolio': $getTaxonomy = 'ux-portfolio-cat'; break;
							}
							$item_val = $_POST['postType'];
						}
					}
					echo '<select name="' .esc_attr( $item['name'] ). '" id="' .esc_attr( $item['id'] ). '" style="' .esc_attr( $item['style'] ). '" class="ux-cb-module-field-select" data-taxonomy="' .esc_attr( $getTaxonomy ). '" ' .disabled( true, $disabled, false ). '>';
					if ( $item['fields'] ) {
						foreach ( $item['fields'] as $field ) {
							if ( $get_post_types ) {
								foreach ( $get_post_types as $post_type ) {
									if ( $field[1] == $post_type->name ) {
										echo '<option value="' .esc_attr( $field[1] ). '" ' .selected( $item_val, $field[1], false ). '>' .esc_html( $field[0] ). '</option>';
									}
								}
							}else{
								echo '<option selected="selected" value="0">' .esc_html__( 'No Source', 'bm-builder' ). '</option>';
							}
						}
					}else{
						echo '<option selected="selected" value="0">' .esc_html__( 'No Source', 'bm-builder' ). '</option>';
					}
					echo '</select>';
				break;
				
				case 'single-category':
					$terms = get_terms( array(
						'hide_empty' => false,
                        'taxonomy' => $item['ptype']
                    ) );
					
					
					if ( $item['current'] ) {
						if ( isset( $_POST['postID'] ) ) {
							$terms = get_the_terms( $_POST['postID'], $item['ptype'] );
						}
					}
					
					echo '<select name="' .esc_attr( $item['name'] ). '" id="' .esc_attr( $item['id'] ). '" style="' .esc_attr( $item['style'] ). '" class="ux-cb-module-field-select" data-taxonomy="' .esc_attr( $item['ptype'] ). '">';
					if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
						echo '<option value="0">' .esc_html__( 'Select a Category', 'bm-builder' ). '</option>';
						foreach ( $terms as $term ) {
							echo '<option value="' .esc_attr( $term->term_id ). '" ' .selected( $item_val, $term->term_id, false ).'>' .esc_html( $term->name ). '</option>';
						}
					}else{
						echo '<option selected="selected" value="0">' .esc_html__( 'No Categories', 'bm-builder' ). '</option>';
					}
					echo '</select>';
					
					$item['name'] = $item['name']. '_tax';
					$item_val = $item['ptype'];
					$get_val = get_post_meta( $post_id, $item['name'], true );
					if ( $get_val ) {
						$item_val = $get_val;
					}
					echo '<input type="hidden" name="' .esc_attr( $item['name'] ). '" value="' .esc_attr( $item_val ). '">';
				break;
				
				case 'category-orderby':
					$item['fields'] = array(
						array(esc_html__('Please Select','bm-builder'), 'none'),
						array(esc_html__('Title','bm-builder'),         'title'),
						array(esc_html__('Date','bm-builder'),          'date'),
						array(esc_html__('ID','bm-builder'),            'id'),
						array(esc_html__('Modified','bm-builder'),      'modified'),
						array(esc_html__('Author','bm-builder'),        'author'),
						array(esc_html__('Random','bm-builder'),        'rand'),
						array(esc_html__('Comment count','bm-builder'), 'comment_count')
					);
				
					echo '<select name="' .esc_attr($item['name']). '" id="' .esc_attr($item['id']). '" style="' .esc_attr($item['style']). '">';
					if($item['fields']){
						foreach($item['fields'] as $field){
							echo '<option value="' .esc_attr($field[1]). '" ' .selected($item_val, $field[1], false).'>' .esc_html($field[0]). '</option>';
						}
					}else{
						echo '<option selected="selected" value="0">' .esc_html__('No options','bm-builder'). '</option>';
					}
					echo '</select>';
					
					$item['name'] = $item['name']. '_order';
					$item_val = 'DESC';
					$get_val = get_post_meta($post_id, $item['name'], true);
					if($get_val){
						$item_val = $get_val;
					}
					$item['fields'] = array(
						array(esc_html__('Ascending','bm-builder'),  'ASC'),
						array(esc_html__('Descending','bm-builder'), 'DESC')
					);
					
					echo '<select name="' .esc_attr($item['name']). '" id="' .esc_attr($item['id']). '" style="' .esc_attr($item['style']). '">';
					if($item['fields']){
						foreach($item['fields'] as $field){
							echo '<option value="' .esc_attr($field[1]). '" ' .selected($item_val, $field[1], false).'>' .esc_html($field[0]). '</option>';
						}
					}else{
						echo '<option selected="selected" value="0">' .esc_html__('No options','bm-builder'). '</option>';
					}
					echo '</select>';
                break;
				
				case 'ratio': ?>
                    <div class="ux-cb-module-field-ratio">
                        <div class="field-ratio">
                            <?php
							$item_val_w_name = $item['name']. '_w';
							$item_val_w = '';
							$get_val = get_post_meta($post_id, $item_val_w_name, true);
							if($get_val){
								$item_val_w = $get_val;
							} ?>
                            <input type="text" name="<?php echo esc_attr($item_val_w_name); ?>" value="<?php echo esc_attr($item_val_w); ?>">
                        </div>
                        <div class="field-ratio">:</div>
                        <div class="field-ratio">
                            <?php
							$item_val_h_name = $item['name']. '_h';
							$item_val_h = '';
							$get_val = get_post_meta($post_id, $item_val_h_name, true);
							if($get_val){
								$item_val_h = $get_val;
							} ?>
                            <input type="text" name="<?php echo esc_attr($item_val_h_name); ?>" value="<?php echo esc_attr($item_val_h); ?>">
                        </div>
                    </div>
                <?php
                break;
				
				case 'checkbox-group':
					if($item['fields']){
						echo '<div class="ux-cb-module-field-checkbox-group">';
						foreach($item['fields'] as $num => $field){
							$checked = $item_val;
							if(is_array($item_val)){
								if(in_array($field[1], $item_val)){
									$checked = $field[1];
								}
							}
							
							echo '<label><input id="' .esc_attr($item['id']. '_' .$num). '" type="checkbox" name="' .esc_attr($item['name']). '" value="' .esc_attr($field[1]). '" ' .checked($checked, $field[1], false). '>' .esc_html($field[0]). '</label>';
						}
						echo '</div>';
					}
                break;
				
				case 'gallery': ?>
                    <button type="button" class="ux-cb-module-field-gallery-button" data-gallery-name="<?php echo esc_attr($item['name']); ?>"><?php esc_html_e('Select Images','bm-builder'); ?></button>
                    
                    <div class="ux-cb-module-field-gallery-lists">
						<?php
						if(is_array($item_val) && $module_id != 'masonry-grid'){
							foreach($item_val as $image){
								$thumbnail = wp_get_attachment_image_src($image, 'thumbnail'); ?>
								<div class="gallery-item">
									<button type="button" class="gallery-button-remove"><span class="dashicons dashicons-no-alt"></span></button>
									<a href="#" class="thumbnail"><img src="<?php echo esc_url($thumbnail[0]); ?>" /></a>
									<input type="hidden" name="<?php echo esc_attr($item['name']); ?>" value="<?php echo esc_attr($image); ?>" />
								</div>
							<?php    
							}
						} ?>
                    </div>
				<?php
				break;
				
				case 'resource-wrap':
					echo '<div id="' .esc_attr($item['name']). '" class="ux-cb-module-fonts-resource-wrap ux-cb-module-field-fonts"></div>';
				break;
				
				case 'upload-font':
					echo '<div class="ux-cb-module-field-upload-fonts">';
					if($item['fields']){
						foreach($item['fields'] as $field){
							echo '<div class="ux-cb-module-field-upload">';
							echo   '<input type="text" name="' .esc_attr($item['name']). '_' .esc_attr($field[1]). '" placeholder="' .esc_attr($field[0]). '" class="regular-text" value="' .esc_attr($item_val). '">';
							echo   '<button type="button" class="button add">' . esc_html__('Upload','bm-builder'). '</button>';
							echo   '<button type="button" class="button remove">' . esc_html__('Remove','bm-builder'). '</button>';
							echo '</div>';
							
						}
					}
					echo '</div>';
				break;
				
				case 'adobe-typekit':
					echo '<div class="ux-cb-module-fonts-adobe-typekit"><input type="text" name="' .esc_attr($item['name']). '" class="regular-text" value="' .esc_attr($item_val). '"><button type="button" class="button">' . esc_html__('Submit','bm-builder'). '</button></div>';
				break;
				
				case 'overlay':
					echo '<div class="ux-cb-module-field-overlay"></div>';
				break;
				
				case 'fonts-group':
					$groupFontSize = array('Size', '6px', '7px', '8px','10px', '11px', '12px', '13px', '14px', '15px', '16px', '17px', '18px', '19px', '20px', '21px', '22px', '23px', '24px', '25px', '26px', '27px', '28px', '29px', '30px', '32px','34px', '36px', '38px', '40px', '42px', '44px', '46px', '48px', '50px', '52px', '54px', '56px', '58px', '60px', '62px', '64px', '66px', '68px', '70px', '72px', '74px', '76px', '78px', '80px', '82px', '84px', '86px', '90px','92px', '96px', '98px', '120px', '144px', '168px', '196px', '1vw', '1.2vw', '1.4vw', '1.6vw', '1.8vw', '2vw', '2.2vw', '2.4vw', '2.6vw', '2.8vw', '3vw', '3.4vw', '3.8vw', '4vw', '4.4vw', '4.8vw', '5vw', '5.4vw', '5.8vw', '6vw', '6.4vw', '6.8vw', '7vw', '7.4vw', '7.8vw', '8vw', '8.4vw', '8.8vw', '9vw', '9.4vw', '9.8vw', '10vw');
					$groupFontSpacing = array('Spacing','0px','1px', '2px', '3px', '4px', '5px', '6px', '7px', '8px', '9px', '10px', '11px', '12px', '13px', '14px', '15px');
					$groupFontMobileSize = array('Mobile Size', '6px', '7px', '8px','10px', '11px', '12px', '13px', '14px', '15px', '16px', '17px', '18px', '19px', '20px', '21px', '22px', '23px', '24px', '25px', '26px', '27px', '28px', '29px', '30px', '32px','34px', '36px', '38px', '40px', '42px', '44px', '46px', '48px', '50px', '52px', '54px', '56px', '58px', '60px', '62px', '64px', '66px', '68px', '70px', '72px', '74px', '76px', '78px', '80px', '82px', '84px', '86px', '90px','92px', '96px', '98px', '120px', '144px', '168px', '196px', '1vw', '1.2vw', '1.4vw', '1.6vw', '1.8vw', '2vw', '2.2vw', '2.4vw', '2.6vw', '2.8vw', '3vw', '3.4vw', '3.8vw', '4vw', '4.4vw', '4.8vw', '5vw', '5.4vw', '5.8vw', '6vw', '6.4vw', '6.8vw', '7vw', '7.4vw', '7.8vw', '8vw', '8.4vw', '8.8vw', '9vw', '9.4vw', '9.8vw', '10vw');
					$groupFontLineheight = array('Line Height', '1.0', '1.1','1.2','1.3','1.4','1.5','1.6','1.7','1.8','1.9', '2.0', '2.1','2.2','2.3','2.4','2.5','2.6','2.7','2.8','2.9', '3.0', '3.5', '4.0', '4.5', '5.0');
					echo '<div class="ux-cb-module-field-fonts-group">';
					
					if ( $item['group'] ) {
						$group = explode( '|', $item['group'] );
						$item_val = $item['default'];
						$fontAssignment = get_option( 'ux-font-assignment' );
						$fontAssignmentNot = true;
						if ( $fontAssignment ) {
							$fontAssignmentNot = false;
							//$item_val = $fontAssignment;
							$fontAssignmentNot = false;
							$item_val = array();
							foreach ( $fontAssignment as $fontName => $fontValue ) {
								if ( isset( $fontValue['name'] ) ) {
									$item_val[$fontValue['name']] = $fontValue['value'];
								} else {
									$item_val[$fontName] = $fontValue;
								}
							}
						} else {
							if ( is_array( $item_val ) ) {
								$itemValArray = array();
								foreach ( $item_val as $itemType => $itemVal ) {
									$itemValArray[$item['name']. '_' .$itemType] = $itemVal;
								}
								$item_val = $itemValArray;
							}
						}
						
						foreach ( $group as $groupType ) {
							$typeName = $item['name']. '_' .$groupType;
							$typeValue = false;
							if ( isset( $item_val[$typeName] ) ) {
								$typeValue = $item_val[$typeName];
							}
							echo '<select name="' .esc_attr($typeName). '" class="group-font-' .$groupType. '">';
							$dataLists = array();
							switch ( $groupType ) {
								case 'family':
									$fontLists = get_option( 'ux-font-lists' );
									if ( $fontLists ) {
										$dataLists[] = array( 'name' => 'Default', 'value' => '-1' );
										foreach ( $fontLists as $fontItem ) {
											$unique = trim( $fontItem['value'] );
											$fontFields = get_option( 'ux-font-' .$unique );
											$dataLists[] = array( 'name' => $fontFields[0]['value'], 'value' => $unique );
										}
									}
								break;
								
								case 'spacing':
									foreach ( $groupFontSpacing as $fontSpacing ) { 
										$dataLists[] = array( 'name' => $fontSpacing, 'value' => $fontSpacing );
									}
								break;
								
								case 'size':
									foreach ( $groupFontSize as $fontSize ) { 
										$dataLists[] = array( 'name' => $fontSize, 'value' => $fontSize );
									}
								break;
								
								case 'm-size':
									foreach ( $groupFontMobileSize as $fontSize ) { 
										$dataLists[] = array( 'name' => $fontSize, 'value' => $fontSize );
									}
								break;

								case 'line_height':
									foreach ( $groupFontLineheight as $fontLineheight ) { 
										$dataLists[] = array( 'name' => $fontLineheight, 'value' => $fontLineheight );
									}
								break;
							}
							
							if ( count( $dataLists ) ) {
								foreach ( $dataLists as $dataItem ) {
									$dataItemSelected = selected( $typeValue, $dataItem['value'], false );
									if ( $fontAssignmentNot ) {
										$dataItemSelected = selected( $typeValue, $dataItem['name'], false );
									}
									echo '<option value="' .esc_attr( $dataItem['value'] ). '" ' .esc_attr( $dataItemSelected ). '>' .esc_html( $dataItem['name'] ). '</option>';
								}
							}else{
								echo '<option selected="selected" value="0">' .esc_html__( 'No options', 'bm-builder' ). '</option>';
							}
							echo '</select>';
						}
					}
					
					echo '</div>';
				break;
				
				case 'import-demo':
					echo '<p><strong>' .$item['title']. '</strong></p>';
					
					$method = 'direct';
					$url = wp_nonce_url( 'admin.php?page=ux-cb-tools' );
					if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
						return true;
					}
					
					if ( ! WP_Filesystem( $creds ) ) {
						request_filesystem_credentials( $url, $method, true, false, false );
						return true;
					}
					
					global $wp_filesystem;
					
					$themeDir = get_stylesheet_directory(). '/demo-data';
					$themeUri = get_stylesheet_directory_uri(). '/demo-data';
					
					if ( $dirlist = $wp_filesystem->dirlist( $themeDir ) ) {
						echo '<ul class="module-template-section">';
						foreach ( $dirlist as $demoSlug => $demoData ) {
							$screenshot = false;
							$domeName = $demoData['name'];
							$fileCount = 0;
							
							if ( $demoData['type'] == 'd' ) {
								if ( $fileList = $wp_filesystem->dirlist( $themeDir. '/' .$demoSlug ) ) {
									foreach ( $fileList as $fileSlug => $file ) {
										if ( $file['type'] == 'f' ) {
											$screenshotFile = $themeUri. '/' .$demoSlug. '/' .$fileSlug;
											$mimeType = wp_check_filetype( $screenshotFile );
											
											if ( $mimeType['type'] == 'image/jpeg' || $mimeType['type'] == 'image/png' ) {
												if ( ! $screenshot ) {
													$screenshot = $screenshotFile;
												}
											}
										} else if ( $file['type'] == 'd' ) {
											if ( $postList = $wp_filesystem->dirlist( $themeDir. '/' .$demoSlug. '/' .$fileSlug ) ) {
												foreach ( $postList as $postSlug => $postFile ) {
													if ( $fileSlug == 'options' ) {
														if ( $postSlug != 'images' ) {
															$fileCount++;
														}
													} else {
														$fileCount++;
													}
												}
											}
										}
									}
								}
								
								echo '<li data-name="' .esc_attr( $domeName ). '" data-count="' .esc_attr( $fileCount ). '">';
								echo   '<div class="item">';
								
									  if ( $screenshot ) { echo '<img src="' .esc_url( $screenshot ). '" />'; }
								
								echo     '<div class="item-name">' .$domeName. '</div>';
								echo     '<span class="loading"><span class="bar"></span></span>';
								echo   '</div>';
								echo '</li>';
							}
							
						}
						
						echo '</ul>';
					}
					
					$checkHtml  = '<script type="text/template" id="tmpl-import-data-check">';
					$checkHtml .=   '<button class="import-data-check" type="button">' .esc_html__( 'Check', 'bm-builder' ). '</button>';
					$checkHtml .=   '<h3 class="module-layout-title">' .esc_attr__( 'Import Data Check', 'bm-builder' ). '</h3>';
					$checkHtml .=   '<div class="module-layout-content">';
					$checkHtml .=     '<h4 class="import-data-name">333</h4>';
					$checkHtml .=     '<table class="form-table"><tbody>';
					$checkHtml .=       '<tr><th data-id="local">' .esc_attr__( 'Local Data', 'bm-builder' ). '</th><th data-id="source">' .esc_attr__( 'Source Data', 'bm-builder' ). '</th></tr>';
					$checkHtml .=       '<tr><td class="import-local-data"></td><td class="import-source-data"></td></tr>';
					$checkHtml .=     '</tbody></table>';
					$checkHtml .=   '</div>';
					$checkHtml .= '</script>';
					
					$checkHtml .= '<script type="text/template" id="tmpl-import-data-check-pop">';
					$checkHtml .=   '<h3 class="module-layout-title">' .esc_attr__( 'Data details', 'bm-builder' ). '</h3>';
					$checkHtml .=   '<div class="module-layout-content">';
					$checkHtml .=     '<table class="form-table"><tbody>';
					$checkHtml .=       '<tr><td colspan="3"><textarea name="import-data-check-pop"></textarea></td></tr>';
					$checkHtml .=       '<tr><td align="center"><button data-click="check-local" type="button">' .esc_html__( 'Check local data', 'bm-builder' ). '</button></td>';
					$checkHtml .=           '<td align="center"><button data-click="check-source" type="button">' .esc_html__( 'Check source data', 'bm-builder' ). '</button></td>';
					$checkHtml .=           '<td align="center"><button data-click="reimport" type="button">' .esc_html__( 'Reimport', 'bm-builder' ). '</button></td></tr>';
					$checkHtml .=     '</tbody></table>';
					$checkHtml .=   '</div>';
					$checkHtml .= '</script>';
					
					echo $checkHtml;
					
				break;
			}
			
			do_action( 'ux_cb_module_fields_field', $item, $post_id, $item_val, $get_val );
		}
	}
	
}
?>