<?php
// ajax call to get wp_editor
add_action( 'wp_ajax_wp_editor_box_editor_html', 'wp_editor_box::editor_html' );
add_action( 'wp_ajax_nopriv_wp_editor_box_editor_html', 'wp_editor_box::editor_html' );

// used to capture javascript settings generated by the editor
add_filter( 'tiny_mce_before_init', 'wp_editor_box::tiny_mce_before_init', 10, 2 );
add_filter( 'quicktags_settings', 'wp_editor_box::quicktags_settings', 10, 2 );

class wp_editor_box {

    /*
    * AJAX Call Used to Generate the WP Editor
    */

    public static function editor_html() {
        $content = stripslashes( $_POST['content'] );
        wp_editor($content, $_POST['id']);
        $mce_init = self::get_mce_init($_POST['id']);
        $qt_init = self::get_qt_init($_POST['id']); ?>
        <script type="text/javascript">
            tinyMCEPreInit.mceInit = jQuery.extend( tinyMCEPreInit.mceInit, <?php echo $mce_init ?>);
            tinyMCEPreInit.qtInit = jQuery.extend( tinyMCEPreInit.qtInit, <?php echo $qt_init ?>);
        </script>
        <?php
        die();
    }

    /*
    * Used to retrieve the javascript settings that the editor generates
    */

    private static $mce_settings = null;
    private static $qt_settings = null;

    public static function quicktags_settings( $qtInit, $editor_id ) {
        self::$qt_settings = $qtInit;
                    return $qtInit;
    }

    public static function tiny_mce_before_init( $mceInit, $editor_id ) {
        self::$mce_settings = $mceInit;
                    return $mceInit;
    }

    /*
    * Code coppied from _WP_Editors class (modified a little)
    */
    private function get_qt_init($editor_id) {
        if ( !empty(self::$qt_settings) ) {
            $options = self::_parse_init( self::$qt_settings );
            $qtInit .= "'$editor_id':{$options},";
            $qtInit = '{' . trim($qtInit, ',') . '}';
        } else {
            $qtInit = '{}';
        }
        return $qtInit;
    }

    private function get_mce_init($editor_id) {
        if ( !empty(self::$mce_settings) ) {
            $options = self::_parse_init( self::$mce_settings );
            $mceInit .= "'$editor_id':{$options},";
            $mceInit = '{' . trim($mceInit, ',') . '}';
        } else {
            $mceInit = '{}';
        }
        return $mceInit;
    }

    private static function _parse_init($init) {
        $options = '';

        foreach ( $init as $k => $v ) {
            if ( is_bool($v) ) {
                $val = $v ? 'true' : 'false';
                $options .= $k . ':' . $val . ',';
                continue;
            } elseif ( !empty($v) && is_string($v) && ( ('{' == $v{0} && '}' == $v{strlen($v) - 1}) || ('[' == $v{0} && ']' == $v{strlen($v) - 1}) || preg_match('/^\(?function ?\(/', $v) ) ) {
                $options .= $k . ':' . $v . ',';
                continue;
            }
            $options .= $k . ':"' . $v . '",';
        }

        return '{' . trim( $options, ' ,' ) . '}';
    }

}

?>