<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Current content builder page options
 */
if ( ! defined( 'UX_CB_PAGE_OPTIONS' ) ) {
	/**
	 *
	 */
	define( 'UX_CB_PAGE_OPTIONS', 'true' );
}

/**
 * UX Content Builder Page Option Button.
 */
if ( ! function_exists( 'ux_cb_page_option_button' ) ) {
	function ux_cb_page_option_button( $post ) {
		$switch = false;
		
		if ( current_filter() == 'in_admin_header' ) {
			if ( function_exists( 'use_block_editor_for_post' ) ) {
				global $post, $pagenow;
				if ( use_block_editor_for_post( $post ) ) {
					if ( $pagenow == 'post-new.php' || $pagenow == 'post.php' ) {
						$switch = true;
					}
				}
			}
		} else {
			$switch = true;
		}
		
		if ( $switch ) {
			if ( $post->post_type == 'page' || $post->post_type == 'post' || $post->post_type == 'ux-portfolio' ) {
				ux_cb_include_template( 'pages/page-options-button.php' );
				do_action( 'ux_cb_page_option_button', $post );
			}
		}
	}
	add_action( 'edit_form_after_title', 'ux_cb_page_option_button' );
	add_action( 'in_admin_header', 'ux_cb_page_option_button' );
}

/**
 * UX Content Builder Page Option template save as layout.
 */
if ( ! function_exists( 'ux_cb_page_template_save_as_layout' ) ) {
	function ux_cb_page_template_save_as_layout() { ?>
        <div class="ux-cb-page-template-save-as-container no-touchevents">
            <div class="theme-option-item">
                <div class="row">
                    <div class="col-xs-3">
                        <h5><?php esc_html_e( 'My Template', 'bm-builder' ); ?></h5>
                    </div>
                    <div class="col-xs-9">
                        <select id="ux-cb-choose-templates" class="form-control input-sm">
                            <option value="0" selected="selected"><?php esc_html_e( 'Select Template', 'bm-builder' ); ?></option>
							<?php
                            $get_template = get_posts( array(
								'posts_per_page' => -1,
								'post_status' => 'publish',
								'post_type' => 'ux-cb-template'
							) );
							
							if ( $get_template ) {
								foreach ( $get_template as $template ) {
									echo '<option value="' .$template->ID. '">' .$template->post_title. '</option>';
								}
							}
                            
                            ?>
                        </select>
                        <p class="text-muted"><?php esc_html_e( 'Append previously saved template to the current layout.', 'bm-builder' ); ?></p>
                    </div>
                </div>
            </div>
            
            <button type="button" class="ux-cb-page-template-save-as-button ux-cb-button"><?php esc_html_e( 'Save Current Layout as New Template', 'bm-builder' ); ?></button>
            <div class="ux-cb-page-template-save-as-layout animation-scroll-ux flip-y-translate">
                <div class="layout-field">
                    <div class="layout-field-title"><?php esc_html_e( 'Template name', 'bm-builder' ); ?></div>
                    <div class="layout-field-input"><input name="layout-field-name" type="text"></div>
                </div>
                
                <div class="layout-field">
                    <div class="layout-field-input"><button type="button" class="ux-cb-page-template-save-as-submit"><?php esc_html_e( 'Save', 'bm-builder' ); ?></button></div>
                </div>
            </div>
        </div>
    <?php	
	}
	//add_action( 'ux_cb_customize_after_sidebar', 'ux_cb_page_template_save_as_layout' );
}