<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module field multiple input.
 */
if ( ! function_exists( 'ux_cb_module_field_multiple_input' ) ) {
	function ux_cb_module_field_multiple_input( $item, $post_id, $item_val, $get_val ) {
		if ( $item['type'] == 'multipleInput' ) {
			for ( $i=0; $i<$item['col']; $i++ ) {
				if ( ! is_array( $item_val ) ) { $item_val = array( $item_val, '' ); }
				$select = $item_val[$i];
				
				$place = false;
				if ( is_array( $item['place'] ) ) {
					if ( isset( $item['place'][$i] ) ) {
						$place = $item['place'][$i];
					}
				}
				
				echo '<input name="' .esc_attr( $item['name'] ). '" type="' .esc_attr( $item['inputType'] ). '" id="' .esc_attr( $item['id'] ). '_' .esc_attr( $i ). '" value="' .esc_attr( $select ). '" class="regular-text" style="' .esc_attr( $item['style'] ). '" placeholder="' .esc_attr( $place ). '">';
			}
		}
	}
	add_action( 'ux_cb_module_fields_field', 'ux_cb_module_field_multiple_input', 10, 4 );
}

/**
 * UX Content Builder Module output multiple input style.
 */
if ( ! function_exists( 'ux_cb_module_output_multiple_input_style' ) ) {
	function ux_cb_module_output_multiple_input_style( $post_id, $name ) {
		$setting = array( 0, 0 );
		
		if ( $getSetting = get_post_meta( $post_id, $name, true ) ) { $setting = $getSetting; }
		if ( ! is_array( $setting ) ) { $setting = array( $setting, 0 ); }
		
		return $setting;
	}
}

?>