<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'UX_CB_TYPEKIT_TOKEN', 'afe8d0a14e26b6dcad2a34f0e3110b47ea091611' );

/**
 * UX Content Builder Ajax Load Module Fields.
 */
function ux_cb_ajax_load_module_fields( $type='template' ) {
	global $ux_cb_module_fields;
	
	$moduleID = $_POST['moduleID'];
	$post = false;
	
	if ( $moduleID ) {
		$moduleFields = apply_filters( 'ux_cb_module_fields', array() );
		
		if ( count( $moduleFields ) ) {
			foreach ( $moduleFields as $module_id => $module ) {
				if ( $moduleID == $module_id ) { ?>
                    
					<div class="ux-cb-module-fields-container">
						<input type="hidden" name="module_id" value="<?php echo esc_attr( $module_id ); ?>">
						<?php foreach ( $module['region'] as $num => $region ) {
							$region = wp_parse_args( $region, array(
								'hidden' => false
							 ) );
							
                            $region_active = $num == 0 ? 'active' : '';
							$region_hidden = $region['hidden'] ? 'hidden' : ''; ?>
                            <button type="button" class="ux-cb-module-field-region-tab <?php echo sanitize_html_class( $region_active ); ?> <?php echo sanitize_html_class( $region_hidden ); ?>" data-id="<?php echo esc_attr( $region['region-id'] ); ?>" data-hidden="<?php echo esc_attr( $region['hidden'] ); ?>"><?php echo $region['title']; ?></button>
                        <?php
                        }
                        
                        foreach ( $module['region'] as $num => $region ) {
							$region = wp_parse_args( $region, array(
								'class' => '',
								'hidden' => false, 
								'trigger' => false
							) );
                            $region_hidden = $num == 0 ? '' : 'hidden';
							
							if ( $moduleID == 'ux-cb-tools-system-status' ) {
								echo '<h1 class="system-status-title">' .$region['title']. '</h1>';
							} ?>
                            
                            <div id="<?php echo esc_attr( $region['region-id'] ); ?>" class="ux-cb-module-field-region-content <?php echo sanitize_html_class( $region_hidden ); ?> <?php echo sanitize_html_class( $region['class'] ); ?>" data-hidden="<?php echo esc_attr( $region['hidden'] ); ?>">
                                <?php foreach ( $region['section'] as $num_section => $section ) {
									if ( $region['region-id'] == 'advanced-settings' ) {
										
										if ( $num_section == count( $region['section'] ) - 1 ) {
											if ( isset( $module['animation'] ) ) {
												if ( $module['animation'] ) {
													$animation = ux_cb_module_field_animation();
													$section['group'][]['items'] = $animation;
												}
											}
										
											/*$offset = ux_cb_module_field_offset();
											$section['group'][]['items'] = $offset;*/
										}
									}
									
									$section = wp_parse_args( $section, array(
                                        'section-ctrl' => 'false',
										'section-class' => false,
										'section-name' => false,
										'section-type' => false,
										'section-mod' => false,
                                        'name' => ''
									) );
									
									if ( $region['trigger'] ) { ?>
                                        <div class="region-trigger"></div>
                                        <div class="region-trigger left"></div>
                                    <?php } ?>
                                    
                                    <table class="form-table <?php echo ux_cb_module_hidden_items_fields( $post, $section['section-ctrl'], $module ); ?> <?php echo sanitize_html_class( $section['section-class'] ); ?>" data-section-ctrl="<?php echo esc_attr( $section['section-ctrl'] ); ?>" data-section-name="<?php echo esc_attr( $section['section-name'] ); ?>" data-section-mod="<?php echo esc_attr( $section['section-mod'] ); ?>">
                                        <?php if ( $section['section-type'] == 'slider' ) { ?>
                                            <caption class="ux-cb-module-slider-slide-group-title">
                                                <?php echo esc_html__( 'Slide', 'bm-builder' ); ?> <?php echo esc_html( $num_section + 1 ); ?>
                                            </caption>
                                            <caption class="ux-cb-module-slider-slide-group-tools">
                                                <button type="button" class="slide-duplicate"><?php echo esc_html__( 'Duplicate', 'bm-builder' ); ?></button>
                                                <button type="button" class="slide-remove"><span class="dashicons dashicons-no-alt"></span></button>
                                            </caption>
                                        <?php
                                        }
                                        
                                        foreach ( $section['group'] as $num_group => $group ) {
                                            $group = wp_parse_args( $group, array(
                                                'group-ctrl' => 'false',
                                                'name' => ''
                                            ) ); ?>
                                            
                                            <tbody class="<?php echo ux_cb_module_hidden_items_fields( $post, $group['group-ctrl'], $module ); ?>" data-group-ctrl="<?php echo esc_attr( $group['group-ctrl'] ); ?>">
                                                <?php foreach ( $group['items'] as $item ) {
                                                    $item = wp_parse_args( $item, array(
                                                        'title' => '',
                                                        'ctrl' => 'false',
                                                        'desc' => '',
                                                        'name' => '',
                                                        'thstyle' => '',
                                                        'type' => '',
                                                        'default' => '',
														'wrap' => ''
                                                    ) );
                                                    
                                                    switch( $item['type'] ) {
                                                        case 'ajax-content': ?>
                                                            <tr><td colspan="2"><div class="ux-cb-module-field-ajax-content"></div></td></tr>
                                                        <?php
                                                        break;
                                                        
                                                        case 'divide': ?>
                                                            <tr class="ux-cb-module-field-item-row-divide"><td colspan="2"><hr /></td></tr>
                                                        <?php
                                                        break;
                                                        
                                                        default: ?>
                                                            <tr class="<?php echo esc_attr( $item['name'] ); ?> <?php echo ux_cb_module_hidden_items_fields( $post, $item['ctrl'], $module ); ?> ux-cb-module-field-item-row" data-ctrl="<?php echo esc_attr( $item['ctrl'] ); ?>" data-row-type="<?php echo esc_attr( $item['type'] ); ?>">
                                                                <?php if ( $item['wrap'] == 'fullwidth' ) { ?>
																	<td colspan="2"><h1><?php echo esc_html( $item['title'] ); ?></h1>
																<?php } else { ?>
                                                                    <th scope="row" style=" <?php echo esc_attr( $item['thstyle'] ); ?>">
                                                                        <label for="<?php echo esc_attr( $item['name'] ); ?>"><?php echo esc_html( $item['title'] ); ?></label>
                                                                        <?php do_action( 'ux_cb_module_fields_after_title', $item ); ?>
                                                                    </th>
                                                                    <td>
                                                                <?php
																} echo $ux_cb_module_fields->fields( $module_id, $item ); ?>
                                                                    <p class="description" id="<?php echo esc_attr( $item['name'] ); ?>-description"><?php echo $item['desc']; ?></p>
                                                                </td>
                                                            </tr>
                                                        <?php
                                                        break;
                                                    }
                                                } ?>
                                            </tbody>
                                        <?php } ?>
                                    </table>
								<?php } ?>
                            </div>
                        <?php } ?>
                    </div>
				<?php
				}
			}
		}
	}
	
	exit;

}
add_action( 'wp_ajax_ux_cb_ajax_load_module_fields', 'ux_cb_ajax_load_module_fields' );

/**
 * UX Content Builder Ajax Save Module Fields.
 */
function ux_cb_ajax_save_module_fields() {
	$moduleID = $_POST['moduleID'];
	$moduleUnique = $_POST['moduleUnique'];
	$moduleFields = $_POST['moduleFields'];
	$postID = $_POST['postID'];
	$moduleShortcode = $_POST['moduleShortcode'];
	
	$fields = array();
	if ( count( $moduleFields ) ) {
		foreach ( $moduleFields as $field ) {
			if ( isset( $fields[$field['name']] ) ) {
				if ( $fields[$field['name']] != '' ) {
					if ( is_array( $fields[$field['name']] ) ) {
						if ( isset( $field['value'] ) ) {
							array_push( $fields[$field['name']], $field['value'] );
						}
					} else {
						$fields[$field['name']] = array( $fields[$field['name']] );
						
						$fieldValue = $field['value'];
						if ( $field['value'] == 'inherit' ) {
							$fieldValue = '';
						}
						
						array_push( $fields[$field['name']], $fieldValue );
					}
				}
			} else {
				$fields[$field['name']] = $field['value'];
			}
		}
	}
	
	$module = apply_filters( 'ux_cb_module_fields', array() );
	$module = $module[$moduleID];
	
	if ( is_array( $module ) ) {
		$module['is_frontend'] = false;
		$module['unique'] = $moduleUnique;
		$module['postID'] = $postID;
	}
	
	$get_posts = get_posts(array(
		'posts_per_page' => -1,
		'name' => $moduleUnique,
		'post_type' => 'ux-cb-modules'
	 ) );
	
	if ( $get_posts ) {
		$post_id = $get_posts[0]->ID;
	}else{
		$post_fields = array(
			'post_title' => $moduleUnique,
			'post_name' => $moduleUnique,
			'post_status' => 'publish',
			'post_type' => 'ux-cb-modules'
		 );
		
		$post_id = wp_insert_post( $post_fields );
	}
	
	if ( $post_id ) {
		foreach ( $fields as $name => $value ) {
			if ( $name == '__ux_cb_module_top_padding' || $name == '__ux_cb_module_bottom_padding' || $name == '__ux_cb_module_top_padding_mobile' || $name == '__ux_cb_module_bottom_padding_mobile' ) {
				if ( $value == 0 || $value == '0' ) {
					$value = 'zero';
				}
			}
			
			$old = get_post_meta( $post_id, $name, true );  
			$new = $value;
		
			//if ( $new && $new != $old ) {
				update_post_meta( $post_id, $name, $new );  
			//} elseif ( '' == $new && $old ) {
				//delete_post_meta( $post_id, $name, $old );  
			//}
		}
		
		$content = false;
		switch( $moduleID ) {
			case 'text':
				$content = stripslashes_deep( $fields['__ux_cb_module_content'] );
			break;
			
			case 'masonry-grid':
				if ( isset( $_POST['layoutMap'] ) ) {
					$layoutMap = $_POST['layoutMap']; 
					update_post_meta( $post_id, '_ux_cb_module_layouts_-1', $layoutMap );
					if ( ! $oldLayouts = get_post_meta( $post_id, '__module_old_layouts', true ) ) {
						update_post_meta( $post_id, '__module_old_layouts', 1 );
					}
				}
			break;
			
			case 'group':
				$moduleShortcode = stripslashes_deep( $_POST['moduleShortcode'] );
				$moduleCol = $_POST['moduleCol'];
				if( $moduleShortcode != '' ){
					//$moduleShortcode = preg_replace('/\[ux_cb_group unique=\"' .$moduleUnique. '\" col=\"' .$moduleCol. '\"\]/', '', $moduleShortcode);
					//$content = str_replace('[/ux_cb_group]', '', $moduleShortcode);
				}
			break;
		}
		echo apply_filters( 'ux_cb_module_container_' .$moduleID, $module, $moduleUnique, $content );
	}
	
	exit;
}
add_action( 'wp_ajax_ux_cb_ajax_save_module_fields', 'ux_cb_ajax_save_module_fields' );

/**
 * UX Content Builder Ajax Save Module Fields.
 */
function ux_cb_ajax_save_module_field() {
	$moduleUnique = $_POST['unique'];
	$value = $_POST['value'];
	$field = $_POST['field'];
	$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
	
	switch ( $field ) {
		case 'offset': $offset = 'col-offset-' .$value; update_post_meta( $post_id, '__ux_cb_module_offset_base', $offset ); break;
		case 'margin-top': update_post_meta( $post_id, '__ux_cb_module_top_padding', (string) $value ); break;
		case 'margin-bottom': update_post_meta( $post_id, '__ux_cb_module_bottom_padding', (string) $value ); break;
	}
	
	exit;
}
add_action( 'wp_ajax_ux_cb_ajax_save_module_field', 'ux_cb_ajax_save_module_field' );

/**
 * Edit Portfolio list layout for Module.
 */
function ux_cb_module_field_custom_grid_layouts_ajax() {
	$catID = intval( $_POST['catID'] );
	$postID = intval( $_POST['postID'] );
	$moduleUnique = $_POST['moduleUnique'];
	$source = sanitize_text_field( $_POST['source'] );
	$taxonomy = sanitize_text_field( $_POST['taxonomy'] );
	
	if ( $postID ) {
		if ( $source == 'attachment' ) {
			$catID = -1;
		}
	
        $layout_array = array();
        $post_id = ux_cb_get_the_module_post_id( $moduleUnique );
		$list_layout = get_post_meta( $post_id, '_ux_cb_module_layouts_' .$catID, true );
		$oldLayouts = get_post_meta( $post_id, '__module_old_layouts', true );
		$layoutMultiple = 1;
		$layoutTemplate = false;
		
		if ( ! $oldLayouts ) {
			$layoutMultiple = 2;
		}
		
		if ( $originalFields = get_post_meta( $post_id, 'originalFields', true ) ) {
			$gridName = '__ux_cb_module_masonry_grid_';
			$layoutTemplate = get_post_meta( $post_id, '_ux_cb_module_layouts_template', true );
		}
		
		
		
		$itemStyle = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_item_style', true );
		$itemTitlePaddingTop = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_top_spacing', true );
        $itemTitleSize = '';
        if($source === 'attachment') {
        	$itemTitleSize = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_caption_text_font_size', true);
        } else {
        	$itemTitleSize = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_title_text_font_size', true);
        }
        if ( $list_layout ) {
            $layout_array = $list_layout;
        }
		
        $category = false;
        if ( $catID ) {
            //$category = array( $catID );
			if ( $catID != '0' ) {
				$category = $catID;
			}
        }
		
		$terms = get_terms( array(
			'taxonomy' => $taxonomy,
			'hide_empty' => false,
			'parent' => $catID
		 ) );
        
        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
			$category = array( $category );
            foreach ( $terms as $term ) {
                array_push( $category, $term->term_id );
            }
        }
			
		$the_query = array();
		if ( $source == 'attachment' ) {
			if ( isset( $_POST['galleryImages'] ) ) {
				$images = $_POST['galleryImages'];
				if ( ! $images ) {
					foreach ( $layout_array as $layout ) {
						array_push( $the_query, $layout['post_id'] );
					}
				}else{
					if ( $list_layout ) {
						foreach ( $layout_array as $layout ) {
							array_push( $the_query, $layout['post_id'] );
						}
					}
					
					foreach ( $images as $image ) {
						array_push( $the_query, $image );
					}
				}
			}
		}else{
			$query_args = array(
				'posts_per_page' => -1,
				'post_type' => $source,
				'meta_key' => '_thumbnail_id',
				'post_status' => 'publish'
			);
			 
			if ( $category ) {
				$query_args['tax_query'] = array(
					array(
						'taxonomy' => $taxonomy,
						'field' => 'term_id',
						'terms' => $category,
					)
				);
			}
			$get_posts = get_posts( $query_args );
			
			foreach ( $get_posts as $post ) {
				array_push( $the_query, $post->ID );
			}
		}
			
        if ( $the_query ) {
            $i = 0;
            $width = 3;
            $height = 3;
            $col = 24 / $width;
            $row = 0;
			
			echo '<div class="grid-stack '.esc_attr($itemStyle).'" data-ux-col="24">'; 
			
			if ( $layoutTemplate ) {
				if ( count( $layoutTemplate ) ) {
					$postNum = 0;
					foreach ( $the_query as $post__id ) {
						foreach ( $layoutTemplate as $num => $layout ) {
							if ( $num == $postNum ) {
								$layoutTemplate[$num]['post_id'] = $post__id;
							}
						}
						$postNum++;
					}
					$layout_array = $layoutTemplate;
				}
			}
			
			if ( count( $layout_array ) ) {
				foreach ( $layout_array as $layout ) {
					$x = $layout['x'] * $layoutMultiple;
					$y = $layout['y'] * $layoutMultiple;
					$width = $layout['width'] * $layoutMultiple;
					$height = $layout['height'] * $layoutMultiple;
					$post__id = $layout['post_id'];
					
					if ( in_array( $post__id, $the_query ) ) {
						$bg_style = false;
						$thumbnail_id = false;
						
						if ( has_post_thumbnail( $post__id ) ) {
							$thumbnail_id = get_post_thumbnail_id( $post__id );
						}elseif ( $source == 'attachment' ) {
							$thumbnail_id = $post__id;
						}
						
						if ( $thumbnail_id ) {
							$thumb = wp_get_attachment_image_src( $thumbnail_id, 'medium_large' );
							$bg_style = 'background-image:url( ' .esc_url( $thumb[0] ). ' );';
						} ?>
						
						<div class="grid-stack-item" data-postid="<?php echo esc_attr( $post__id ); ?>"
							data-gs-x="<?php echo esc_attr( $x ); ?>" data-gs-y="<?php echo esc_attr( $y ); ?>"
							data-gs-width="<?php echo esc_attr( $width ); ?>" data-gs-height="<?php echo esc_attr( $height ); ?>">
								<div class="grid-stack-item-content" style=" <?php if( $itemStyle != 'image-text' ) { echo esc_attr( $bg_style ); } ?>">
									<?php if ( ! $thumbnail_id ) {
										echo '<div class="title">' .get_the_title( $post__id ). '</div>';
									} ?>
									<?php if( $itemStyle == 'image-text' ) { 
										echo '<div class="grid-stack-item-content-img" style="'.esc_attr( $bg_style ).'"></div>';
										echo '<div class="title-show" style="padding-top:'.esc_attr( $itemTitlePaddingTop ).'px; font-size:' .esc_attr( $itemTitleSize ). ';">' .get_the_title( $post__id ). '</div>';
									} ?>
								</div>
							   
						</div>
					<?php
					}
				}
				
			}else{
				foreach ( $the_query as $t_num => $post__id ) {
					if ( $i > 0 && $i % $col == 0 ) {
						$row++;
					}
					
					$x = ( $i % $col ) * $width;
					$y = $row * $height;
					
					if ( count( $layout_array ) ) {
						foreach ( $layout_array as $l_num => $layout ) {
							if ( $l_num == $t_num ) {
								$x = $layout['x'];
								$y = $layout['y'];
								$width = $layout['width'];
								$height = $layout['height'];
							}
						}
					}
					
					$bg_style = false;
					$thumbnail_id = false;
					
					if ( has_post_thumbnail( $post__id ) ) {
						$thumbnail_id = get_post_thumbnail_id( $post__id );
					}elseif ( $source == 'attachment' ) {
						$thumbnail_id = $post__id;
					}
					
					if ( $thumbnail_id ) {
						$thumb = wp_get_attachment_image_src( $thumbnail_id, 'medium_large' );
						$bg_style = 'background-image:url( ' .esc_url( $thumb[0] ). ' );';
					} ?>
					
					<div class="grid-stack-item" data-postid="<?php echo esc_attr( $post__id ); ?>"
						data-gs-x="<?php echo esc_attr( $x ); ?>" data-gs-y="<?php echo esc_attr( $y ); ?>"
						data-gs-width="<?php echo esc_attr( $width ); ?>" data-gs-height="<?php echo esc_attr( $height ); ?>">
							<div class="grid-stack-item-content" style=" <?php if($itemStyle != 'image-text') { echo esc_attr( $bg_style ); } ?>">
								<?php if ( ! $thumbnail_id ) {
									echo '<div class="title">' .get_the_title( $post__id ). '</div>';
								} ?>
								<?php if($itemStyle == 'image-text') { 
									echo '<div class="grid-stack-item-content-img" style="'.esc_attr( $bg_style ).'"></div>';
									echo '<div class="title-show" style="padding-top:'.esc_attr($itemTitlePaddingTop).'px; font-size:'.esc_attr($itemTitleSize).';">' .get_the_title( $post__id ). '</div>';
								} ?>
							</div>
						   
					</div>
					<?php
					$i ++;
				}
			}
			
			echo '</div>';
			
			if ( count( $layout_array ) ) {
				$layoutPostIDs = array();
				foreach ( $layout_array as $layout ) {
					array_push( $layoutPostIDs, $layout['post_id'] );
				}
				foreach ( $the_query as $post__id ) {
					if ( ! in_array( $post__id, $layoutPostIDs ) ) {
						$bg_style = false;
						$thumbnail_id = false;
						
						if ( has_post_thumbnail( $post__id ) ) {
							$thumbnail_id = get_post_thumbnail_id( $post__id );
						}elseif ( $source == 'attachment' ) {
							$thumbnail_id = $post__id;
						}
						
						if ( $thumbnail_id ) {
							$thumb = wp_get_attachment_image_src( $thumbnail_id, 'medium_large' );
							$bg_style = 'background-image:url( ' .esc_url( $thumb[0] ). ' );';
						} ?>
						
						<div class="grid-stack-item" data-postid="<?php echo esc_attr( $post__id ); ?>">
                            <div class="grid-stack-item-content" style=" <?php if( $itemStyle != 'image-text' ) { echo esc_attr( $bg_style ); } ?>">
                                <?php if ( ! $thumbnail_id ) {
                                    echo '<div class="title">' .get_the_title( $post__id ). '</div>';
                                } ?>
                                <?php if( $itemStyle == 'image-text' ) { 
                                    echo '<div class="grid-stack-item-content-img" style="'.esc_attr( $bg_style ).'"></div>';
                                    echo '<div class="title-show" style="padding-top:'.esc_attr( $itemTitlePaddingTop ).'px; font-size:' .esc_attr( $itemTitleSize ). ';">' .get_the_title( $post__id ). '</div>';
                                } ?>
                            </div>
						</div>
					<?php
					}
				}
			}
        }
    }
	exit;
}
add_action( 'wp_ajax_ux_cb_module_field_custom_grid_layouts_ajax', 'ux_cb_module_field_custom_grid_layouts_ajax' );

/**
 * Save Portfolio list layout for Module.
 */
function ux_cb_module_field_custom_grid_layouts_save_ajax() {
	$layoutMap = $_POST['layoutMap']; 
	$catID = intval( $_POST['catID'] );
	$postID = intval( $_POST['postID'] );
	$moduleUnique = $_POST['moduleUnique'];
	$source = sanitize_text_field( $_POST['source'] );
	$rs = false;
	
	$get_posts = get_posts(array(
		'posts_per_page' => -1,
		'name' => $moduleUnique,
		'post_type' => 'ux-cb-modules'
	 ) );
	
	if ( $get_posts ) {
		$post_id = $get_posts[0]->ID;
	}else{
		$post_fields = array(
			'post_title' => $moduleUnique,
			'post_name' => $moduleUnique,
			'post_status' => 'publish',
			'post_type' => 'ux-cb-modules'
		 );
		
		$post_id = wp_insert_post( $post_fields );
	}
	
	if ( $post_id ) {
		$layouts = array();
		
		if ( $source == 'attachment' ) {
			$catID = -1;
		}
		
		$get_layoutMap = get_post_meta( $post_id, '_ux_cb_module_layouts_' .$catID, true );
		if ( $get_layoutMap == $layoutMap ) {
			$rs = 'ok';
		}else{
			$result = update_post_meta( $post_id, '_ux_cb_module_layouts_' .$catID, $layoutMap );
			if ( $result ) {
				$rs = 'ok';
			}
		}
	}
	
	if ( $rs ) {
		echo $rs;
		
		if ( ! $oldLayouts = get_post_meta( $post_id, '__module_old_layouts', true ) ) {
			 update_post_meta( $post_id, '__module_old_layouts', 1 );
		}
		
		delete_post_meta( $post_id, '_ux_cb_module_layouts_template' );
		delete_post_meta( $post_id, 'originalFields' );
	}
	
	exit;
}
add_action( 'wp_ajax_ux_cb_module_field_custom_grid_layouts_save_ajax', 'ux_cb_module_field_custom_grid_layouts_save_ajax' );

/**
 * Save Portfolio list layout for Module.
 */
function ux_cb_module_clone_ajax() {
	$postID = intval( $_POST['postID'] );
	$moduleShortcode = $_POST['moduleShortcode'];
	$moduleUnique = $_POST['moduleUnique'];
	$moduleTargetUnique = $_POST['moduleTargetUnique'];
	
	$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
	
	if ( $post_id ) {
		$custom_keys = get_post_custom_keys( $post_id );
		
		$target_post_id = ux_cb_get_the_module_post_id( $moduleTargetUnique );
		if ( ! $target_post_id ) {
			$post_fields = array(
				'post_title' => $moduleTargetUnique,
				'post_name' => $moduleTargetUnique,
				'post_status' => 'publish',
				'post_type' => 'ux-cb-modules'
			 );
			
			$target_post_id = wp_insert_post( $post_fields );
		}
		
		foreach ( $custom_keys as $key ) {
			$values = get_post_meta( $post_id, $key, true );
			update_post_meta( $target_post_id, $key, $values );
		}
		
		if ( $target_post_id ) {
			echo do_shortcode(stripslashes_deep( $moduleShortcode ) );
		}
	}
	
	exit;
}
function ux_cb_module_clone_ajax_new() {
	
}
add_action( 'wp_ajax_ux_cb_module_clone_ajax', 'ux_cb_module_clone_ajax' );

/**
 * Customize Preview Container.
 */
function ux_cb_customize_preview_container_ajax() {
	$content = $_POST['content'];
	$postID = $_POST['postID'];
	
	if ( $content ) {
		$content = str_replace( '&nbsp;', ' ', $content );
		$content = htmlspecialchars_decode( $content );
		
		if ( false === strpos( $content, 'ux_cb_wrap' ) ) {
			echo 'not_ux_cb_wrap';
		}else{
			echo do_shortcode(stripslashes_deep( $content ) );
		}
		//echo do_shortcode(ux_cb_module_filter_shortcode(stripslashes_deep( $content ) ) );
	}
	exit;
}
add_action( 'wp_ajax_ux_cb_customize_preview_container_ajax', 'ux_cb_customize_preview_container_ajax' );

/**
 * Page Option Save.
 */
function ux_cb_page_options_save() {
	$moduleUniqueArray = $_POST['moduleUniqueArray'];
	$postID = $_POST['postID'];
	$content = $_POST['content'];
	$editorName = $_POST['editorName'];
	
	if ( $content ) {
		$content = str_replace( '&nbsp;', ' ', $content );
		$content = htmlspecialchars_decode( $content );
	}
	
	if ( $postID ) {
		update_post_meta( $postID, 'modules', $moduleUniqueArray );
		update_post_meta( $postID, 'ux-cb-content', $content );
		
		$post_fields = false;
		if ( $editorName == 'classic-editor' ) {
			$post_fields = array(
				'ID' => $postID,
				'post_content' => $content
			);
		} elseif ( $editorName == 'block-editor' ) {
			if ( $post = get_post( $postID ) ) {
				if ( $post->post_status == 'auto-draft' ) {
					$post_fields = array(
						'ID' => $postID,
						'post_status' => 'pending'
					);
				}
			}
		}
		
		if ( $post_fields ) {
			wp_update_post( $post_fields );
		}
		
		$result = get_post_meta( $postID, 'modules', true );
		if ( $result ) {
			echo 'ok';
		}
	}
	exit;
}
add_action( 'wp_ajax_ux_cb_page_options_save', 'ux_cb_page_options_save' );


/**
 * Page Option Save after.
 */
function ux_cb_page_options_save_after() {
	$postID = $_POST['postID'];
	$editorName = $_POST['editorName'];
	
	if ( $postID ) {
		if ( $uxHasCB = get_post_meta( $postID, 'ux_has_cb', true ) ) {
			if ( $uxHasCB == 'C' ) {
				if ( delete_post_meta( $postID, 'ux_has_cb' ) ) {
					wp_update_post( array(
						'ID' => $postID,
						'post_content' => ''
					) );
					echo 'ok';
				}
			}
		}
	}
	exit;
}
add_action( 'wp_ajax_ux_cb_page_options_save_after', 'ux_cb_page_options_save_after' );

/**
 * Page Template Save AS.
 */
function ux_cb_page_template_save_as_ajax() {
	$postTitle = $_POST['postTitle'];
	$postID = $_POST['postID'];
	$content = $_POST['content'];
	$moduleUniqueArray = $_POST['moduleUniqueArray'];
	
	if ( $content ) {
		$content = str_replace( '&nbsp;', ' ', $content );
		$content = htmlspecialchars_decode( $content );
	}
	
	if ( $postID ) {
		$post_fields = array(
			'post_title' => $postTitle,
			'post_status' => 'publish',
			'post_type' => 'ux-cb-template'
		 );
		
		$post_id = wp_insert_post( $post_fields );
		
		if ( $post_id ) {
			$moduleTargetUniqueArray = array();
			foreach ( $moduleUniqueArray as $moduleUnique ) {
				$loop_post_id = ux_cb_get_the_module_post_id( $moduleUnique );
					
				if ( $loop_post_id ) {
					$custom_keys = get_post_custom_keys( $loop_post_id );
					list( $t1, $t2 ) = explode( ' ', microtime() ); 
					$moduleTargetUnique = $t2 .  ceil( ( $t1 * 1000 ) );
					
					$target_post_id = ux_cb_get_the_module_post_id( $moduleTargetUnique );
					if ( ! $target_post_id ) {
						$post_fields = array(
							'post_title' => $moduleTargetUnique,
							'post_name' => $moduleTargetUnique,
							'post_status' => 'publish',
							'post_type' => 'ux-cb-modules'
						 );
						
						$target_post_id = wp_insert_post( $post_fields );
						
						$content = str_replace( $moduleUnique, $moduleTargetUnique, $content );
					}
					
					foreach ( $custom_keys as $key ) {
						$values = get_post_meta( $loop_post_id, $key, true );
						update_post_meta( $target_post_id, $key, $values );
					}
					
					array_push( $moduleTargetUniqueArray, $moduleTargetUnique );
				}
				
				$post_fields = array(
					'ID' => $post_id,
					'post_content' => $content
				 );
				
				wp_update_post( $post_fields );
			}
			
			if ( count( $moduleTargetUniqueArray ) ) {
				update_post_meta( $post_id, 'modules', $moduleTargetUniqueArray );
			}
			
			$ux_theme_meta = get_post_meta( $postID, 'ux_theme_meta', true );
			if ( $ux_theme_meta ) {
				update_post_meta( $post_id, 'ux_theme_meta', $ux_theme_meta );
			}
			
			echo 'ok';
		}
	}
	
	exit;
}
add_action( 'wp_ajax_ux_cb_page_template_save_as_ajax', 'ux_cb_page_template_save_as_ajax' );


/**
 * Page choose template.
 */
function ux_cb_page_choose_template_ajax() {
	$postID = $_POST['postID'];
	$templateID = $_POST['templateID'];
	$post_update = false;
	
	if ( $postID ) {
		$get_post = get_post( $templateID );
		if ( $get_post ) {
			$content = $get_post->post_content; 
			
			$moduleUniqueArray = get_post_meta( $templateID, 'modules', true );
			$moduleTargetUniqueArray = array();
			foreach ( $moduleUniqueArray as $moduleUnique ) {
				$loop_post_id = ux_cb_get_the_module_post_id( $moduleUnique );
					
				if ( $loop_post_id ) {
					$custom_keys = get_post_custom_keys( $loop_post_id );
					list( $t1, $t2 ) = explode( ' ', microtime() ); 
					$moduleTargetUnique = $t2 .  ceil( ( $t1 * 1000 ) );
					
					$target_post_id = ux_cb_get_the_module_post_id( $moduleTargetUnique );
					if ( ! $target_post_id ) {
						$post_fields = array(
							'post_title' => $moduleTargetUnique,
							'post_name' => $moduleTargetUnique,
							'post_status' => 'publish',
							'post_type' => 'ux-cb-modules'
						 );
						
						$target_post_id = wp_insert_post( $post_fields );
						
						$content = str_replace( $moduleUnique, $moduleTargetUnique, $content );
					}
					
					foreach ( $custom_keys as $key ) {
						$values = get_post_meta( $loop_post_id, $key, true );
						update_post_meta( $target_post_id, $key, $values );
					}
					
					array_push( $moduleTargetUniqueArray, $moduleTargetUnique );
				}
				
				
			}
			
			$post_fields = array(
				'ID' => $postID,
				'post_content' => $content,
				'post_status' => 'publish',
			 );
			
			$post_update = wp_update_post( $post_fields );
			
			if ( count( $moduleTargetUniqueArray ) ) {
				update_post_meta( $postID, 'modules', $moduleTargetUniqueArray );
			}
			
			$ux_theme_meta = get_post_meta( $templateID, 'ux_theme_meta', true );
			if ( $ux_theme_meta ) {
				update_post_meta( $postID, 'ux_theme_meta', $ux_theme_meta );
			}
		}
	}
	
	if ( $post_update ) {
		echo get_edit_post_link( $postID, '&' );
	}
	
	exit;
}
add_action( 'wp_ajax_ux_cb_page_choose_template_ajax', 'ux_cb_page_choose_template_ajax' );

/**
 * UX Content Builder Fonts Management load Resource Ajax.
 */
if ( ! function_exists( 'ux_cb_fonts_load_resource' ) ) {
	function ux_cb_fonts_load_resource() {
		$resource = $_POST['resource'];
		$name = $_POST['name'];
		
		switch( $resource ) {
			case 'google-font':
				$googlefont = get_option( 'ux_theme_googlefont' );
				if ( ! $googlefont ) {
					$method = 'direct';
					$url = wp_nonce_url( 'admin.php?page=ux-cb-fonts-definition' );
					if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
						return true;
					}
					
					if ( ! WP_Filesystem( $creds ) ) {
						request_filesystem_credentials( $url, $method, true, false, false );
						return true;
					}
					
					global $wp_filesystem;
					
					if ( $googleFontsJson = $wp_filesystem->get_contents( ux_cb_asset_url( 'lib/googlefonts.json' ) ) ) {
						$googlefont = $googleFontsJson;
						update_option( 'ux_theme_googlefont', $googlefont );
					}
					
					
					/*if ( $googleApiKey = get_option( '_ux_cb_module_fonts_google_api_key' ) ) {
						$response = wp_remote_get( 'https://www.googleapis.com/webfonts/v1/webfonts?key=' .$googleApiKey, array( 'sslverify' => false ) );
						if ( ! is_wp_error( $response ) ) {
							if ( isset( $response['body'] ) && $response['body'] ) {
								if ( strpos( $response['body'], 'error' ) === false ) {
									$googlefont = $response['body'];
									update_option( 'ux_theme_googlefont', $googlefont );
								}
							}
						}
					}*/
				}
				
				$selectName = $name. '_google-font_family';
				echo '<select name="' .esc_attr( $selectName ). '">';
				
				if ( $googlefont ) {
					$fontsObject = json_decode( $googlefont );
					echo '<option value="-1">' .esc_html__( '-- Select Font --','bm-builder' ). '</option>';
					if ( $fontsObject && is_object( $fontsObject ) ) {
						if ( $fontsObject->items && is_array( $fontsObject->items ) ) {
							$fonts = $fontsObject->items;
							foreach ( $fonts as $item ) {
								$familyVal = str_replace( ' ', '+', $item->family );
								echo '<option value="' .sanitize_text_field( $familyVal ). '">' .esc_html( $item->family ). '</option>';
							}
						}
					}
				} else {
					echo '<option value="-1">no font</option>';
				}
				
				echo '</select>';
			break;
			
			case 'system-font':
				$systemfont = ux_cb_fonts_management_system_fonts();
				$fields = array( 'family' => 'Font', 'weight' => 'Weight', 'style' => 'Style' );
				
				foreach ( $fields as $fieldSlug => $fieldName ) {
					$selectName = $name. '_' .$resource. '_' .$fieldSlug;
					echo '<select name="' .esc_attr( $selectName ). '">';
					echo '<option value="-1">' .esc_html__( '-- Select ' .$fieldName. ' --','bm-builder' ). '</option>';
					foreach ( $systemfont[$fieldSlug] as $slug => $value ) {
						$selected = false;
						if ( isset( $_POST['triggerResult'] ) ) {
							foreach ( $_POST['triggerResult'] as $field ) {
								if ( $field['name'] == $selectName ) {
									$selected = selected( $slug, $field['value'], false );
								}
							}
						}
						
						$title = $value;
						if ( $fieldSlug == 'family' ) {
							$title = $value['name'];
						}
						echo '<option value="' .sanitize_text_field( $slug ). '" ' .$selected. '>' .esc_html( $title ). '</option>';
					}
					echo '</select>';
				}
			break;
			
			case 'adobe-typekit':
				if ( isset( $_POST['kitID'] ) ){
					$kitID = $_POST['kitID'];
					//$response = wp_remote_get( 'https://typekit.com/api/v1/json/kits/' .$kitID. '/published' );
					//$api_response = json_decode( wp_remote_retrieve_body( $response ) );
					
					$typekit_font = get_option( 'ux_theme_typekit_font_' .$kitID );
					if ( ! $typekit_font ) {
						$response = wp_remote_get( 'https://typekit.com/api/v1/json/kits/' .$kitID. '/published' );
						if ( ! is_wp_error( $response ) ) {
							if ( isset( $response['body'] ) && $response['body'] ) {
								if ( strpos( $response['body'], 'error' ) === false ) {
									$typekit_font = $response['body'];
									update_option( 'ux_theme_typekit_font_' .$kitID, $typekit_font );
								}
							}
						}else{
							echo esc_html__( 'KidID invalid','bm-builder' );
						}
					}
					
					if ( $typekit_font ) {
						$fontsObject = json_decode( $typekit_font );
						$selectName = $name. '_adobe-typekit_family';
						echo '<select name="' .esc_attr( $selectName ). '">';
						echo '<option value="-1">' .esc_html__( '-- Select Font --','bm-builder' ). '</option>';
						if ( $fontsObject && is_object( $fontsObject ) ) {
							foreach ( $fontsObject->kit->families as $fontsObject ) {
								echo '<option value="' .sanitize_text_field( $fontsObject->id ). '">' .esc_html( $fontsObject->name ). '</option>';
							}
						}
						echo '</select>';
					}
				}
			break;
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_fonts_load_resource', 'ux_cb_fonts_load_resource' );
}

/**
 * UX Content Builder Fonts Management load fonts style Ajax.
 */
if ( ! function_exists( 'ux_cb_fonts_load_fonts_style' ) ) {
	function ux_cb_fonts_load_fonts_style() {
		$name = $_POST['name'];

		$fontFamily = $_POST['fontFamily'];
		$resource = $_POST['resource'];
		
		switch( $resource ) {
			case 'google-font':
				$googlefont = get_option( 'ux_theme_googlefont' );
				if ( $googlefont ) {
					$fontsObject = json_decode( $googlefont );
					if ( $fontsObject && is_object( $fontsObject ) ) {
						if ( $fontsObject->items && is_array( $fontsObject->items ) ) {
							$fonts = $fontsObject->items;
							foreach ( $fonts as $item ) {
								$familyVal = str_replace( ' ', '+', $item->family );
								if ( $familyVal == $fontFamily ) {
									if ( isset( $item->variants ) ) {
										$selectName = $name. '_google-font_style';
										echo '<select name="' .esc_attr( $selectName ). '">';
										foreach ( $item->variants as $variant ) {
											$selected = false;
											if ( isset( $_POST['triggerResult'] ) ) {
												foreach ( $_POST['triggerResult'] as $field ) {
													if ( $field['name'] == $selectName ) {
														$selected = selected( $variant, $field['value'], false );
													}
												}
											}
											
											echo '<option value="' .sanitize_text_field( $variant ). '" ' .$selected. '>' .esc_html( $variant ). '</option>';
										}
										echo '</select>';
									}
									
									if ( isset( $item->subsets ) ) {
										echo '<div class="ux-cb-module-field-checkbox-group">';
										echo '<h4>' .esc_html__( 'Languages','bm-builder' ). '</h4>';
										$languages = ux_cb_fonts_management_google_font_languages();
										$inputName = $name. '_google-font_subset';
										$checkedResult = array();
										if ( isset( $_POST['triggerResult'] ) ) {
											foreach ( $_POST['triggerResult'] as $field ) {
												if ( $field['name'] == $inputName ) {
													$checkedResult[] = $field['value'];
												}
											}
										}
										
										foreach ( $item->subsets as $num => $subset ) {
											$inputID = $name. '_google-font_subset_' .$num;
											$checked = false;
											if ( in_array( $subset, $checkedResult ) ) {
												$checked = 'checked="checked"';
											}
											
											echo '<label><input id="' .esc_attr( $inputID ). '" type="checkbox" name="' .esc_attr( $inputName ). '" value="' .esc_attr( $subset ). '" ' .$checked. '>' .esc_html( $languages[$subset] ). ' <span class="supported">( ' .esc_html__( 'Supported by','bm-builder' ). ' ' .$item->family. ' )</span></label>';
											
											
										}
										echo '</div>';
									}
								}
							}
						}
					}
				}else{
					echo 'nofonts';
				}
			break;
			
			case 'adobe-typekit':
				if ( isset( $_POST['kitID'] ) && isset( $_POST['kitToken'] ) ){
					$kitID = $_POST['kitID'];
					$kitToken = $_POST['kitToken'];
					
					//Font Family 
					$typekitFontFamily = get_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily );
					if ( ! $typekitFontFamily ) {
						$response = wp_remote_get( 'https://typekit.com/api/v1/json/kits/' .$kitID. '/families/' .$fontFamily, array( 'headers' => 'X-Typekit-Token:' .$kitToken ) );
						if ( ! is_wp_error( $response ) ) {
							if ( isset( $response['body'] ) && $response['body'] ) {
								if ( strpos( $response['body'], 'error' ) === false ) {
									$typekitFontFamily = $response['body'];
									update_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily, $typekitFontFamily );
								}
							}
						}
					}
					
					if ( $typekitFontFamily ) {
						$api_response = json_decode( $typekitFontFamily );
						if ( $api_response ) {
							if ( isset( $api_response->family->variations ) ) {
								$selectName = $name. '_adobe-typekit_style';
								echo '<select name="' .esc_attr( $selectName ). '">';
								foreach ( $api_response->family->variations as $variation ) {
									$variations = ux_cb_fonts_management_adobe_typekit_variation();
									$variationName = $variations[$variation]['name'];
									
									$selected = false;
									if ( isset( $_POST['triggerResult'] ) ) {
										foreach ( $_POST['triggerResult'] as $field ) {
											if ( $field['name'] == $selectName ) {
												$selected = selected( $variation, $field['value'], false );
											}
										}
									}
									echo '<option value="' .sanitize_text_field( $variation ). '" ' .$selected. '>' .esc_html( $variationName ). '</option>';
								}
								echo '</select>';
							}
						}
					}
					
					//Language
					$typekitFontLanguage = get_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily. '_language' );
					if ( ! $typekitFontLanguage ) {
						$response = wp_remote_get( 'https://typekit.com/api/v1/json/families/' .$fontFamily, array( 'headers' => 'X-Typekit-Token:' .$kitToken ) );
						if ( ! is_wp_error( $response ) ) {
							if ( isset( $response['body'] ) && $response['body'] ) {
								if ( strpos( $response['body'], 'error' ) === false ) {
									$typekitFontLanguage = $response['body'];
									update_option( 'ux_theme_typekit_font_' .$kitID. '_' .$fontFamily. '_language', $typekitFontLanguage );
								}
							}
						}
					}
					
					if ( $typekitFontLanguage ) {
						$api_response = json_decode( $typekitFontLanguage );
						if ( $api_response ) {
							if ( isset( $api_response->family->browse_info->language ) ) {
								echo '<div class="ux-cb-module-field-checkbox-group">';
								echo '<h4>' .esc_html__( 'Languages','bm-builder' ). '</h4>';
								$inputName = $name. '_adobe-typekit_subset';
								$languages = ux_cb_fonts_management_adobe_typekit_languages();
								
								if ( isset( $_POST['triggerResult'] ) ) {
									foreach ( $_POST['triggerResult'] as $field ) {
										if ( $field['name'] == $inputName ) {
											$checkedResult[] = $field['value'];
										}
									}
								}
								
								foreach ( $api_response->family->browse_info->language as $num => $subset ) {
									$inputID = $name. '_adobe-typekit_subset_' .$num;
									$checked = false;
									if (in_array( $subset, $checkedResult ) ) {
										$checked = 'checked="checked"';
									}
									echo '<label><input id="' .esc_attr( $inputID ). '" type="checkbox" name="' .esc_attr( $inputName ). '" value="' .esc_attr( $subset ). '" ' .$checked. '>' .esc_html( $languages[$subset] ). '</label>';
									
									
								}
								echo '</div>';
							}
						}
					}
				}
			break;
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_fonts_load_fonts_style', 'ux_cb_fonts_load_fonts_style' );
}

/**
 * UX Content Builder Fonts Management fonts definition save.
 */
if ( ! function_exists( 'ux_cb_fonts_definition_save' ) ) {
	function ux_cb_fonts_definition_save() {
		$itemFields = $_POST['itemFields'];
		$itemUnique = $_POST['itemUnique'];
		
		if(!$itemUnique){
			list( $t1, $t2 ) = explode( ' ', microtime() ); 
			$itemUnique = $t2 .  ceil( ( $t1 * 1000 ) );
		}
		
		$itemUnique = trim( $itemUnique );
		
		if ( $itemFields ) {
			$oldItemFields = get_option( 'ux-font-' .$itemUnique );
			if($itemFields == $oldItemFields){
				echo $itemUnique;
			}else if ( update_option( 'ux-font-' .$itemUnique, $itemFields ) ) {
				echo $itemUnique;
			}
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_fonts_definition_save', 'ux_cb_fonts_definition_save' );
}

/**
 * UX Content Builder Fonts Management font lists save.
 */
if ( ! function_exists( 'ux_cb_fonts_lists_save' ) ) {
	function ux_cb_fonts_lists_save() {
		$itemFields = $_POST['itemFields'];
		$moduleID = $_POST['moduleID'];
		if ( $itemFields ) {
			if ( $moduleID == 'ux-cb-fonts-assignment' ) {
				$fields = array();
				if ( count( $itemFields ) ) {
					foreach ( $itemFields as $field ) {
						if ( isset( $fields[$field['name']] ) ) {
							if ( $fields[$field['name']] != '' ) {
								if ( is_array( $fields[$field['name']] ) ) {
									if ( isset( $field['value'] ) ) {
										array_push( $fields[$field['name']], $field['value'] );
									}
								} else {
									$fields[$field['name']] = array( $fields[$field['name']] );
									
									$fieldValue = $field['value'];
									if ( $field['value'] == 'inherit' ) {
										$fieldValue = '';
									}
									
									array_push( $fields[$field['name']], $fieldValue );
								}
							}
						} else {
							$fields[$field['name']] = $field['value'];
						}
					}
				}
				
				if ( count( $fields ) ) {
					$itemFields = $fields;
				}
			}
			
			$name = false;
			switch( $moduleID ) {
				case 'ux-cb-fonts-definition'    : $name = 'ux-font-lists'; break;
				case 'ux-cb-fonts-assignment'    : $name = 'ux-font-assignment'; break;
				case 'ux-cb-fonts-google-api-key': 
					if ( is_array( $itemFields ) ) {
						foreach ( $itemFields as $itemField ) {
							if ( $itemField['name'] == '_ux_cb_module_fonts_google_api_key' ) {
								$name = $itemField['name'];
								$itemFields = $itemField['value'];
							}
						}
					}
				break;
			}
			
			if ( $name ) {
				$oldItemFields = get_option( $name );
				if ( $itemFields == $oldItemFields ) {
					echo 'ok';
				} else if ( update_option( $name, $itemFields ) ) {
					echo 'ok';
				}
			}
		} else {
			$name = false;
			switch( $moduleID ) {
				case 'ux-cb-fonts-definition' : $name = 'ux-font-lists'; break;
				case 'ux-cb-fonts-assignment' : $name = 'ux-font-assignment'; break;
			}
			
			if ( $name ) {
				delete_option( $name );
				echo 'ok';
			}
			
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_fonts_lists_save', 'ux_cb_fonts_lists_save' );
}

/**
 * UX Content Builder Post type slugs save.
 */
if ( ! function_exists( 'ux_cb_post_type_slugs_save' ) ) {
	function ux_cb_post_type_slugs_save() {
		$itemFields = $_POST['itemFields'];
		$moduleID = $_POST['moduleID'];
		$name = false;
		$slugs = array();
		
		if ( $itemFields ) {
			if ( is_array( $itemFields ) ) {
				foreach ( $itemFields as $itemField ) {
					if ( $itemField['name'] == 'ux-post-type-slugs' ) {
						$name = $itemField['name'];
						$itemFields = $itemField['value'];
					}
				}
			}
			
			if ( $name ) {
				$oldItemFields = get_option( $name );
				if ( $itemFields == $oldItemFields ) {
					echo 'ok';
				} else if ( update_option( $name, $itemFields ) ) {
					echo 'ok';
				}
			}
		} else {
			if ( $name ) {
				delete_option( $name );
				echo 'ok';
			}
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_post_type_slugs_save', 'ux_cb_post_type_slugs_save' );
}

/**
 * UX Content Builder Fonts Management font load font.
 */
if ( ! function_exists( 'ux_cb_fonts_load_font' ) ) {
	function ux_cb_fonts_load_font() {
		$unique = $_POST['unique'];
		
		if ( $fontFields = get_option( 'ux-font-' .trim( $unique ) ) ) {
			echo json_encode( $fontFields );
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_fonts_load_font', 'ux_cb_fonts_load_font' );
}

/**
 * UX Content Builder Update google fonts.
 */
if ( ! function_exists( 'ux_cb_update_google_fonts' ) ) {
	function ux_cb_update_google_fonts() {
		$data = stripslashes_deep( $_POST['data'] );
		
		if ( $data ) {
			update_option( 'ux_theme_googlefont', $data );
			echo 'ok';
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_update_google_fonts', 'ux_cb_update_google_fonts' );
}

/**
 * UX Content Builder Update google fonts refresh.
 */
if ( ! function_exists( 'ux_cb_update_google_fonts_refresh' ) ) {
	function ux_cb_update_google_fonts_refresh() {
		$googlefont = get_option( 'ux_theme_googlefont' );
		if ( $googlefont ) {
			$fontsObject = json_decode( $googlefont );
			echo '<option value="-1">' .esc_html__( '-- Select Font --','bm-builder' ). '</option>';
			if ( $fontsObject && is_object( $fontsObject ) ) {
				if ( $fontsObject->items && is_array( $fontsObject->items ) ) {
					$fonts = $fontsObject->items;
					foreach ( $fonts as $item ) {
						$familyVal = str_replace( ' ', '+', $item->family );
						echo '<option value="' .sanitize_text_field( $familyVal ). '">' .esc_html( $item->family ). '</option>';
					}
				}
			}
		}
		exit;
	}
	add_action( 'wp_ajax_ux_cb_update_google_fonts_refresh', 'ux_cb_update_google_fonts_refresh' );
}

/**
 * Module Slider slide fields ajax
 */
if ( ! function_exists( 'ux_cb_module_slider_slide_fields_ajax' ) ) {
	function ux_cb_module_slider_slide_fields_ajax() {
		$postID = $_POST['postID'];
		$moduleUnique = $_POST['moduleUnique'];
		$slideFields = $_POST['slideFields'];
		$newFields = array();
		
		if ( $slideFields ) {
			if ( is_array( $slideFields ) ) {
				$post_id = false;
				if(isset($_POST['moduleUnique'])){
					$post_id = ux_cb_get_the_module_post_id( $_POST['moduleUnique'] );
				}
				foreach ( $slideFields as $field ) {
					if ( $getVal = get_post_meta( $post_id, $field['name'], true ) ) {
						//$newFields[$field['name']] = $get_val;
						if ( ! is_array( $getVal ) ) { $getVal = array( $getVal ); }
						foreach ( $getVal as $num => $val ) {
							$newFields[$num][$field['name']] = $val;
						}
					}
				}
			}
		}
		
		echo json_encode( $newFields );
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_module_slider_slide_fields_ajax', 'ux_cb_module_slider_slide_fields_ajax' );
}

/**
 *  Field upload get image
 */
if ( ! function_exists( 'ux_cb_field_upload_get_image' ) ) {
	function ux_cb_field_upload_get_image() {
		$postID = $_POST['postID'];
		
		if ( $postID ) {
			$post = get_post( $postID );
			echo json_encode($post);
		}
		
		exit;
	}
	add_action( 'wp_ajax_ux_cb_field_upload_get_image', 'ux_cb_field_upload_get_image' );
}

require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-ajax/ajax-tools.php' );
?>