<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Slider shortcode.
 */
function ux_cb_module_slider_shortcode($atts, $content=false) {
	$moduleID = 'slider';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_slider' );
	
	$html = ux_cb_get_module_template( $moduleID, $atts, $content );
	return $html;
}
add_shortcode( 'ux_cb_slider', 'ux_cb_module_slider_shortcode' );

/**
 * UX Content Builder Module Slider container.
 */
function ux_cb_module_slider_container( $module, $moduleUnique, $content=false ) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
	
	//slider style
	$sliderStyle = get_post_meta( $post_id, '__ux_cb_module_slider_style', true );
	
	//default arrow wrap
	$leftArrowWrap = '<svg width="72" height="72" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"><path fill="#010101" d="M68 19.1l-38.3 30 38.3 30 1.2-1.5-36.3-28.5 36.3-28.5-1.2-1.5z"/></svg>';
	$rightArrowWrap = '<svg width="72" height="72" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"><path fill="#010101" d="M30.4 20.6l36.3 28.5-36.3 28.5 1.2 1.5 38.3-30-38.3-30-1.2 1.5z"/></svg>';
				
	switch ( $sliderStyle ) {
		case 'style-1':
			$sliderWrapClass = array();
			$sliderDataTag = array();
			
			//slider style
			$heightType = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_height_type', true );
			if ( $heightType == 'auto' ) {
				$sliderDataTag['data-autoheight'] = 'data-autoheight="true"';
				$sliderWrapClass[] = 'slider-height-auto';
			}

			//fit image to container
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_fit_img_contain', true ) ) {
				$sliderWrapClass[] = 'slider-img-fit-contain';
			}
			
			//text align
			$sliderWrapClass['text-align'] = 'slide-des-bottom-left';
			if ( $textAlign = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_text_align', true ) ) {
				$sliderWrapClass['text-align'] = 'slide-des-' .$textAlign;
			}
			
			//show page number
			$sliderDataTag['data-nav'] = 'data-nav="false"';
			$hidePagenumberMobileClass = ''; 
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_page_number', true ) ) {
				$sliderWrapClass[] = 'slide-number-show';
				$sliderWrapClass[] = 'slide-number-bottom-right';
				//$sliderDataTag['data-nav'] = 'data-nav="true"';
				if ( $pageNumberAlign = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_align', true ) ) {
					$sliderWrapClass[] = $pageNumberAlign;
				}
				if('on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_hide_page_number_mobile', true )){ 
					$hidePagenumberMobileClass = 'hidden-slider-pagenumber-mobile'; 
				}
			}
			
			//show arrow
			$showArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_arrow', true );
			if ( $showArrow == 'on' ) {
				$sliderWrapClass[] = 'slide-arrow-show';
			}
			
			//animation
			if ( 'fade-in' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_slider_animation', true ) ) {
				$sliderDataTag['data-animateout'] = 'data-animateout="fadeOut"';
			}

			//Mouse Drag
			$sliderDataTag['data-mousedrag'] = 'data-mousedrag="false"';
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_mouse_drag', true ) ) {
				$sliderDataTag['data-mousedrag'] = 'data-mousedrag="true"';
			}

			//transition speed
			$sliderDataTag['data-transition'] = 'data-transition="300"';
			if ( $sliderTransiSpeed  = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_1_transition_speed', true ) ) ) {
				$sliderDataTag['data-transition'] = 'data-transition="'.esc_attr( $sliderTransiSpeed ).'"';
			}
			
			//auto play
			$sliderDataTag['data-auto'] = 'data-auto="false"';
			$sliderDataTag['data-autoplayTimeout'] = 'data-autoplayTimeout="100"';
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_auto_play', true ) ) {
				$sliderDataTag['data-auto'] = 'data-auto="true"';
				if ( $autoPlayTime = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_1_auto_play_time', true ) ) ) {
					$autoPlayTime = $autoPlayTime * 1000;
					$sliderDataTag['data-autoplayTimeout'] = 'data-autoplayTimeout="' .esc_attr( $autoPlayTime ). '"';
				}
			}
			
			//arrow position
			$sliderWrapClass['arrow-show-bottom'] = 'slide-arrow-show-default';
			$arrowPosition = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_position', true );
			switch ( $arrowPosition ) {
				case 'right-bottom': $sliderWrapClass['arrow-show-bottom'] = 'slide-arrow-show-bottom'; break;
				case 'center-bottom': $sliderWrapClass['arrow-show-bottom-center'] = 'slide-arrow-show-bottom slide-arrow-show-bottom-center'; break;
				//case 'arrow-go': $sliderWrapClass[] = 'slide-arrows-on-cursor'; break;
			}

			$arrowGoCursor = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_mouse_cursor', true );
			if ( $showArrow == 'off' && $arrowGoCursor== 'on' ) {
				$sliderWrapClass[] = 'slide-arrows-on-cursor';
			}
			
			if ( $showArrow == 'on' ) {
				$leftArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_left_arrow', true );
				$rightArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_right_arrow', true );
			}

			$leftArrowWrap = '';
			$rightArrowWrap = '';

			$html .= '<div class="slider-mod-wrap slider-style1 ' .esc_html(join( ' ', $sliderWrapClass ) ). '">';
			if ( $showArrow == 'on' ) {
				if ( $leftArrow ) {
					$leftArrow = get_post( $leftArrow );
					if ( $leftArrow ) {
						$arrowIsSvg = $leftArrow->post_mime_type == 'image/svg+xml' ? 'arrow-is-svg' : false;
						$leftArrowWrap = wp_get_attachment_image( $leftArrow->ID, 'full', '', array( 'class' => $arrowIsSvg ) );
					}
				}
				if ( $rightArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_right_arrow', true ) ) {
					$rightArrow = get_post( $rightArrow );
					if ( $rightArrow ) {
						$arrowIsSvg = $rightArrow->post_mime_type == 'image/svg+xml' ? 'arrow-is-svg' : false;
						$rightArrowWrap = wp_get_attachment_image( $rightArrow->ID, 'full', '', array( 'class' => $arrowIsSvg ) );
					}
				}
			}
			if ( $showArrow == 'on' ) { if ( $arrowPosition == 'right-bottom' || $arrowPosition == 'center-bottom' ) { $html .= '<div class="slider-arrows-bottom-together">'; } }
			$html .= '<div id="slider-arrow-left" class="slider-arrow-left slider-arrow">' .wp_kses_post( $leftArrowWrap ). '</div>';
			$html .= '<div id="slider-arrow-right" class="slider-arrow-right slider-arrow">' .wp_kses_post( $rightArrowWrap ). '</div>';
			if ( $showArrow == 'on' ) { if ( $arrowPosition == 'right-bottom' || $arrowPosition == 'center-bottom' ) { $html .= '</div>'; } }
			

			//Mobile 
			$hideTitleMobileClass = '';
			if('on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_hide_title_mobile', true )){
				$hideTitleMobileClass = 'hidden-mobile';
			}
			$hideCaptionMobileClass = '';
			if( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_hide_caption_mobile', true )){
				$hideCaptionMobileClass = 'hidden-mobile';
			}
			
			$owlClassName = "owl-carousel";

			if ( !$module['is_frontend'] ) {
				$owlClassName = "owl-carousel-prev";
			}

			$html .=   '<div class="'. sanitize_html_class( $owlClassName ) .' '. sanitize_html_class( $hidePagenumberMobileClass ).'" data-item="1" data-mobileitem="1" data-center="false" data-margin="0" data-marginmobile="0" data-autowidth="false" data-slideby="1" data-showdot="true" data-loop="true" data-lazy="true" ' .sanitize_text_field( join( ' ', $sliderDataTag ) ). '>';
					
					//media images
					if ( $mediaImages = get_post_meta( $post_id, '__ux_cb_module_slider_media_images', true ) ) {
						if ( ! is_array( $mediaImages ) ) { $mediaImages = array( $mediaImages ); }
						
						foreach ( $mediaImages as $num => $image ) {
							$sliderImgWrapStyle = array();
							$sliderImgTag = false;
							//caption
							$imageCaption = isset( get_post( $image )->post_excerpt ) ? get_post( $image )->post_excerpt : '';
							
							//thumb
							$thumbFull = wp_get_attachment_image_src( $image, 'full' );
							$thumbFullSrcset = wp_get_attachment_image_srcset( $image, 'full' );
							$thumbFullSizes = wp_get_attachment_image_sizes( $image, 'full' );
							$thumbFullSizes = '(max-width: 480px) 320px,(max-width: 767px) 500px,'. $thumbFullSizes;
							$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
							$thumbSrc = '';
							
							if ( $thumbFull ) {
								$thumbSrc = esc_url($thumbFull[0]);
								if ( $heightType == 'auto' ) {
									if($thumbFull[1] > 0 && $thumbFull[2] > 0){
										$sliderImgWrapStyle['padding-top'] = 'padding-top: ' .( intval( $thumbFull[2] ) / intval( $thumbFull[1] ) ) * 100 . '%;';
									}
								}
							}
							
							$sliderImgTag = '<img src="'.esc_attr( $thumbBlank ).'" data-src="' .esc_url( $thumbSrc ). '" alt="'.esc_attr( $imageCaption ).'" data-srcset="'.wp_kses_post( $thumbFullSrcset ).'" data-sizes="'.wp_kses_post( $thumbFullSizes ).'" class="grid-item-img owl-lazy lazy" >';
							if ( !$module['is_frontend'] ) {
								$sliderImgTag = '<img src="' .esc_url( $thumbSrc ). '" class="grid-item-img">';
							}
							//link
							$linkBeforeWrap = false;
							$linkAfterWrap = false;
							$linkTargetTag = false;
							$linkRel = '';
							if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_enable_link', true ) ) {
								$linkNewTab = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_link_new_tab', true );
								if ( $linkNewTab === 'on' ) {
									$linkTargetTag = ' target="_blank"';
									$linkRel .= 'noopener noreferrer ';
								}
								if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_link_nofollow', true ) ) {
									$linkRel .= 'nofollow ';
								}
								$permalink = '#';
								if ( $customUrl = get_post_meta( $image, 'what_thumbnail_does', true ) ) {
									$permalink = $customUrl;
								}
								
								$linkBeforeWrap = '<a href="' .esc_url( $permalink ). '" class="slider-item-link" title="' .esc_attr( get_the_title( $image ) ). '" ' .sanitize_text_field( $linkTargetTag ). ' rel="'.esc_attr( $linkRel ).'">';
								$linkAfterWrap = '</a>';
							}

							//logo menu color
							$logoColor = get_post_meta( $post_id, '__ux_cb_module_slider_logo_color', true );
							$logoColorName = isset( $logoColor[$num] ) ? $logoColor[$num] : 'default-logo';
							$menuColor = get_post_meta( $post_id, '__ux_cb_module_slider_menu_color', true );
							$menuColorName = isset( $menuColor[$num] ) ? $menuColor[$num] : 'default-menu';
							
							$html .= '<section class="item" data-logocolor="'.esc_attr( $logoColorName ).'" data-menucolor="'.esc_attr( $menuColorName ).'" data-id="post-' .esc_attr( intval( $num ) ). '-' .esc_attr( intval( $image ) ). '">';
							$html .=   '<div class="slide-item-wrap">';
							$html .=     '<div class="slide-item-des">';
							$html .=       '<div class="slide-item-des-wrap">';
							
								if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_title', true ) ) {
									$html .= '<h2 class="slide-item-wrap-tit '.sanitize_html_class( $hideTitleMobileClass ).'">' .esc_html( get_the_title( $image ) ). '</h2>';
								}
						  
								if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_caption', true ) ) {
									$html .= '<h3 class="slide-item-wrap-caption '.sanitize_html_class( $hideCaptionMobileClass ).'">' .esc_html( $imageCaption ). '</h3>';
								}
							
							$html .=       '</div>';
							$html .=     '</div>';
							$html .=     '<div class="carousel-img-wrap" style="' .sanitize_text_field( join( ' ', $sliderImgWrapStyle ) ). '">'.wp_kses_post( $linkBeforeWrap ) . $sliderImgTag . wp_kses_post( $linkAfterWrap ).'</div>';
							$html .=   '</div>';
							$html .= '</section>';
						}
					}
					
			$html .=   '</div><!--End owl -->';
			$html .= '</div>';
		break;
		
		case 'style-2':
			$sliderWrapClass = array();
			
			//text align
			$sliderWrapClass['text-align'] = 'style2-text-left';
			if ( $textAlign = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_align', true ) ) {
				$sliderWrapClass['text-align'] = $textAlign;
			}
			if ( $textHighLight = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_text_highlight', true ) ) {
				$sliderWrapClass['hightlight'] = $textHighLight;
			}
			if ( 'on' == get_post_meta( $post_id, '__ux_cb_module_slider_style_2_text_inline', true ) ) {
				$sliderWrapClass['inline'] = 'slider-text-inline';
			}
			if ( 'on' == get_post_meta( $post_id, '__ux_cb_module_slider_style_2_mask', true ) ) {
				$sliderWrapClass['imagemask'] = 'slider-mask';
			}
			if ( 'on' == get_post_meta( $post_id, '__ux_cb_module_slider_style_2_kenburns', true ) ) {
				$sliderWrapClass['imagekenburns'] = 'slider-kenburns';
			}
			$lazyClass = 'lazy';
			if ( ! $module['is_frontend'] ) {
				$lazyClass = '';
			}
			$html .= '<div class="slider-mod-wrap slider-style2 ' .esc_html(join( ' ', $sliderWrapClass )). '">';
			$html .=   '<div class="bm-tab-slider">';
			
					//media images
					if ( $mediaImages = get_post_meta( $post_id, '__ux_cb_module_slider_media_images', true ) ) {
						if ( ! is_array( $mediaImages ) ) { $mediaImages = array( $mediaImages ); }
						
						$html .= '<nav class="bm-tab-slider-trigger">';
						foreach ( $mediaImages as $num => $image ) {
							$active = $num == 0 ? 'bm-active' : false;
							//data-color
							$logoColor = get_post_meta( $post_id, '__ux_cb_module_slider_logo_color', true );
							$menuColor = get_post_meta( $post_id, '__ux_cb_module_slider_menu_color', true );
							$logoColorName = isset( $logoColor[$num] ) ? $logoColor[$num] : 'default-logocolor';
							$menuColorName = isset( $menuColor[$num] ) ? $menuColor[$num] : 'default-menucolor';
							$permalink = '#';
							if ( $customUrl = get_post_meta( $image, 'what_thumbnail_does', true ) ) {
								$permalink = $customUrl;
							} else {
								$permalink = get_permalink( $image );
							}

							$html .= '<div class="bm-tab-slider-trigger-item">';
							$html .=   '<a data-id="post-' .esc_attr( intval( $num ) ). '-' .esc_attr( intval( $image ) ). '" data-logocolor="'.esc_attr( $logoColorName ).'" data-menucolor="'.esc_attr( $menuColorName ).'" class="bm-tab-slider-trigger-tilte ' .sanitize_html_class( $active ). '" href="' .esc_url( $permalink ). '">' .esc_html( get_the_title( $image ) ). '</a>';
							$html .= '</div>';
						}
						$html .= '</nav>';
						
						
						$html .= '<ul class="bm-tab-slider-img">';
						foreach ( $mediaImages as $num => $image ) {
							$active = $num == 0 ? 'bm-active' : false;
							
							//thumb
							$thumbSrc = '';
							$thumbFull = wp_get_attachment_image_src( $image, 'full' );
							$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
							$imageCaption = isset( get_post( $image )->post_excerpt ) ? get_post( $image )->post_excerpt : '';
							if ( $thumbFull ) {
								$thumbSrc = esc_url( $thumbFull[0] );
							}
							$thumbFullSrcset = wp_get_attachment_image_srcset( $image, 'full' );
							$thumbFullSizes = wp_get_attachment_image_sizes( $image, 'full' );
							if ( !$module['is_frontend'] ) {
								$thumbSrc = 'src="'.esc_url( $thumbSrc ).'"';
							} else {
								$thumbSrc = 'src="'.esc_attr( $thumbBlank ).'" data-src="'.esc_url( $thumbSrc ).'"';
							}
							$html .= '<li id="post-' .esc_attr( intval( $num ) ). '-' .esc_attr( intval( $image ) ). '" class="bm-tab-slider-img-item ux-background-img ' .sanitize_html_class( $active ). '"><img class="grid-item-img '.sanitize_html_class( $lazyClass ).'" '.wp_kses_post( $thumbSrc ).' alt="'.esc_attr( $imageCaption ).'" data-srcset="'.wp_kses_post( $thumbFullSrcset ).'" data-sizes="'.wp_kses_post( $thumbFullSizes ).'"></li>';
						}
						$html .= '</ul>';
					}
					
			$html .=   '</div>';
			$html .= '</div><!--End slider-mod-wrap-->';
		break;
		
		case 'style-3':
			$sliderWrapClass = array();
			$sliderDataTag = array();
			$slider3PrevMargin = '';
			
			//spacing
			$sliderDataTag['data-margin'] = 'data-margin="40"';
			$sliderDataTag['data-marginmobile'] = 'data-marginmobile="10"';

			$getSliderSpacing = get_post_meta( $post_id, '__ux_cb_module_slider_style_3_spacing', true );
			if ( ! is_array( $getSliderSpacing ) ) { $getSliderSpacing = array( $getSliderSpacing, 0 ); } 
			$sliderSpacing = intval( $getSliderSpacing[0] ); 
			$sliderSpacingMobile = intval( $getSliderSpacing[1] );
			if ( $sliderSpacing ) {
				$sliderDataTag['data-margin'] = 'data-margin="' .esc_attr( $sliderSpacing ). '"';
				if ( !$module['is_frontend'] ) {
					$slider3PrevMargin = 'style="margin-right:' .esc_attr( $sliderSpacing ). 'px;"';
				}
			}
			if ( $sliderSpacingMobile ) {
				$sliderDataTag['data-marginmobile'] = 'data-marginmobile="' .esc_attr( $sliderSpacingMobile ). '"';
			}
			$sliderDataTag['data-mousedrag'] = 'data-mousedrag="false"';
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_mouse_drag', true ) ) {
				$sliderDataTag['data-mousedrag'] = 'data-mousedrag="true"';
			}
			
			//show arrow
			$showArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_3_show_arrow', true );
			if ( $showArrow == 'on' ) {
				$sliderWrapClass[] = 'slide-arrow-show';
			}
			
			//arrow position
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_mouse_cursor', true ) && $showArrow == 'off' ) {
			//if ( 'arrow-go' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_arrow_position', true ) ) {
				$sliderWrapClass[] = 'slide-arrows-on-cursor';
			}
			
			//auto play
			$sliderDataTag['data-auto'] = 'data-auto="false"';
			$sliderDataTag['data-autoplayTimeout'] = 'data-autoplayTimeout="100"';
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_auto_play', true ) ) {
				$sliderDataTag['data-auto'] = 'data-auto="true"';
				if ( $autoPlayTime = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_3_auto_play_time', true ) ) ) {
					$autoPlayTime = $autoPlayTime * 1000;
					$sliderDataTag['data-autoplayTimeout'] = 'data-autoplayTimeout="' .$autoPlayTime. '"';
				}
			}
			
			$html .= '<div class="slider-mod-wrap slider-style3 ' .esc_html( join( ' ', $sliderWrapClass ) ). '">';
			
			$leftArrowWrap = '';
			$rightArrowWrap = '';
			if ( $showArrow == 'on' ) {
				if ( $leftArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_3_left_arrow', true ) ) {
					if ( $leftArrow = get_post( $leftArrow ) ) {
						$arrowIsSvg = $leftArrow->post_mime_type == 'image/svg+xml' ? 'arrow-is-svg' : false;
						$leftArrowWrap = wp_get_attachment_image( $leftArrow->ID, 'full', '', array( 'class' => $arrowIsSvg ) );
					}
				}
				if ( $rightArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_3_right_arrow', true ) ) {
					if ( $rightArrow = get_post( $rightArrow ) ) {
						$arrowIsSvg = $rightArrow->post_mime_type == 'image/svg+xml' ? 'arrow-is-svg' : false;
						$rightArrowWrap = wp_get_attachment_image( $rightArrow->ID, 'full', '', array( 'class' => $arrowIsSvg ) );
					}
				}
			}	
				$html .= '<div id="slider-arrow-left" class="slider-arrow slider-arrow-left">' . wp_kses_post( $leftArrowWrap ) . '</div>';
				$html .= '<div id="slider-arrow-right" class="slider-arrow slider-arrow-right">' . wp_kses_post( $rightArrowWrap ) . '</div>';
			

			$owlClassName = "owl-carousel";

			if ( !$module['is_frontend'] ) {
				$owlClassName = "owl-carousel-prev";
			}

			$html .=   '<div class="'.sanitize_html_class( $owlClassName ).'" data-item="1" data-mobileitem="3" data-center="true" data-autowidth="true" data-slideby="1" data-showdot="false" data-nav="false" data-loop="true" data-lazy="true" ' .sanitize_text_field( join( ' ', $sliderDataTag ) ). '>';
			
					//media images
					if ( $mediaImages = get_post_meta( $post_id, '__ux_cb_module_slider_media_images', true ) ) {
						if ( ! is_array( $mediaImages ) ) { $mediaImages = array( $mediaImages ); }
						
						foreach ( $mediaImages as $num => $image ) {
							$active = $num == 0 ? 'bm-active' : false;
							
							//thumb
							$thumbFull = wp_get_attachment_image_src( $image, 'full' );
							$thumbPlaceholder = wp_get_attachment_image_src( $image, 'medium' );
							$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';

							$thumbSrcset = wp_get_attachment_image_srcset($image, 'full');
							$thumbSizes = wp_get_attachment_image_sizes($image, 'full');
							$thumbSizes = '(max-width: 480px) 320px,(max-width: 767px) 500px,'. $thumbSizes;
							$thumbWidth = $thumbFull[1];
							$thumbHeight = $thumbFull[2];
							//link
							$linkBeforeWrap = false;
							$linkAfterWrap = false;
							$linkTargetTag = false;
							$linkRel = false;
							if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_enable_link', true ) ) {
								$linkNewTab = get_post_meta( $post_id, '__ux_cb_module_slider_style_3_link_new_tab', true );
								if ( $linkNewTab === 'on' ) {
									$linkTargetTag = ' target="_blank"';
									$linkRel .= 'noopener noreferrer ';
								}
								if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_link_nofollow', true ) ) {
									$linkRel .= 'nofollow ';
								}
								
								$permalink = '#';
								if ( $customUrl = get_post_meta( $image, 'what_thumbnail_does', true ) ) {
									$permalink = $customUrl;
								}
								
								$linkBeforeWrap = '<a href="' .esc_url( $permalink ). '" title="' .esc_attr( get_the_title( $image ) ). '" ' .sanitize_text_field( $linkTargetTag ). ' rel="'.esc_attr( $linkRel ).'">';
								$linkAfterWrap = '</a>';
							}
							//caption
							$imageCaption = isset( get_post( $image )->post_title ) ? get_post( $image )->post_title : '';
							
							$html .= '<section class="item">';
							$html .=   '<div class="carousel-img-wrap" '.sanitize_text_field( $slider3PrevMargin ).'>';
							$html .=     wp_kses_post( $linkBeforeWrap );

							if ( !$module['is_frontend'] ) {
								$html .=     wp_get_attachment_image( $image, 'full', '', array( 'class' => 'single-fullwidth-slider-carousel-img attachment-all size-all' ) );
							} else {
								$html .= 		'<img width="'.esc_attr( $thumbWidth ).'" height="'.esc_attr( $thumbHeight ).'" src="'. esc_attr( $thumbPlaceholder[0] ) .'" data-src="'.esc_url( $thumbFull[0] ).'" class="single-fullwidth-slider-carousel-img attachment-all size-all owl-lazy" alt="'.esc_attr( $imageCaption ).'">';
							}
							$html .=     wp_kses_post( $linkAfterWrap );
							$html .=   '</div>';
							$html .= '</section>';
						}
					}
					
			$html .=   '</div>';
			$html .= '</div><!--End slider-wrap-->';
		break;
	}
	
	return $html;
}
add_filter( 'ux_cb_module_container_slider', 'ux_cb_module_slider_container', 10, 3 );

/**
 * UX Content Builder Module Slider frontend module class.
 */
function ux_cb_module_slider_module_inside_class( $moduleClass, $moduleID, $post_id ) {
	if ( $moduleID == 'slider' ) {
		//media images
		if ( $mediaImages = get_post_meta( $post_id, '__ux_cb_module_slider_media_images', true ) ) {
			if ( ! is_array( $mediaImages ) ) { $mediaImages = array( $mediaImages ); }
			
			if ( isset( $mediaImages[0] ) ) {
				$moduleClass[] = 'post-0-' .intval( $mediaImages[0] );
			}
		}
	}
	return $moduleClass;
}
add_filter( 'ux_cb_module_template_frontend_module_inside_class', 'ux_cb_module_slider_module_inside_class', 10, 3 );

/**
 * Module Style for module slider
 */
function ux_cb_module_slider_style( $post_id, $moduleUnique, $style ) {
	$style .= "\r\n";
	$moduleUniqueClass = '.module-id-' .esc_attr( $moduleUnique );
	
	//slider style
	$sliderStyle = get_post_meta( $post_id, '__ux_cb_module_slider_style', true );
	
	//text color
	$textColor = get_post_meta( $post_id, '__ux_cb_module_slider_text_color', true );
	
	//page number color
	$pageNumberColor = get_post_meta( $post_id, '__ux_cb_module_slider_page_number_color', true );
	
	//left arrow color
	$ArrowColor = get_post_meta( $post_id, '__ux_cb_module_slider_arrow_color', true );
	
	//media images
	if ( $mediaImages = get_post_meta( $post_id, '__ux_cb_module_slider_media_images', true ) ) {
		if ( ! is_array( $mediaImages ) ) { $mediaImages = array( $mediaImages ); }
		
		foreach ( $mediaImages as $num => $image ) {
			$imagePostID = 'post-' .intval( $num ). '-' .intval( $image );
			$imageClassName = $moduleUniqueClass. ' .' .esc_attr( $imagePostID );
			switch ( $sliderStyle ) {
				case 'style-1':
					if ( $textColor ) {
						if ( $textColor[$num] != '' &&  $textColor[$num] != 'inherit' ) {
							$style .= esc_html( $imageClassName ). ' * { color: ' .esc_attr( $textColor[$num] ). '; }';
							$style .= "\r\n";
						}
					}
					if ( $pageNumberColor ) {
						if ( $pageNumberColor[$num] != '' &&  $pageNumberColor[$num] != 'inherit' ) {
							$style .= esc_html( $imageClassName ). ' .slider-mod-wrap .owl-dot, ';
							$style .= "\r\n";
							$style .= esc_html( $imageClassName ). ' .slider-mod-wrap .owl-dots { color: ' .esc_attr( $pageNumberColor[$num] ). '; }';
							$style .= "\r\n";
						}
					}
					if ( $ArrowColor ) {
						if ( $ArrowColor[$num] != '' &&  $ArrowColor[$num] != 'inherit' ) {
							$style .= esc_html( $imageClassName ). ' .slider-arrow-left svg *,'.esc_html( $imageClassName ).' .slider-arrow-right svg * { fill: ' .esc_attr( $ArrowColor[$num] ). '; }';
							$style .= "\r\n";
						}
					}
				break;
				
				case 'style-2':
					if ( $textColor ) {
						if ( $textColor[$num] != '' ) {
							$style .= esc_html( $imageClassName ). ' .bm-tab-slider-trigger-item, '.esc_html( $imageClassName ).' .bm-tab-slider-trigger-tilte.bm-active { color: ' .esc_attr( $textColor[$num] ). '; }';
							$style .= "\r\n";
						}
					}
				break;
			}
		}
	}
	
	switch ( $sliderStyle ) {
		case 'style-1':
			//height
			$heightType = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_height_type', true );
			$heightImgWrap = '80vh';
			$sliderStagePadding = '';
			$heightImgWrapM = '60vh';
			$sliderStagePaddingM = '';
			$height100MinHeaderFooter = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_100_height_min_header_footer', true );
			$height100MinHeaderFooterM = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_100_height_min_header_footer_mobile', true );
			$height100TbSpacing =  intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_1_100_height_min_header_footer_tb_spacing', true ) );
			$height100TbSpacingM = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_1_100_height_min_header_footer_tb_spacing_mobile', true ) );
			$showArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_arrow', true );

			if ( $heightType == 'custom' ) {
				if ( $height = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_1_height', true ) ) ) {
					//If 100% screen height
					if ( $height == '100' ) {
						//If set "Screen Height Minus Header and Footer"
						if ( $height100MinHeaderFooter === 'on' ) {
							$height = 'calc(100vh - var(--header-height, 0px) - var(--footer-height, 0px))';
							//If set top bottom spacing
							if( $height100TbSpacing ) {
								$heightImgWrap = 'calc(100vh - var(--header-height, 0px) - var(--footer-height, 0px) - '.esc_attr( $height100TbSpacing ).'px - '.esc_attr( $height100TbSpacing ).'px)'; 
								$sliderStagePadding = 'padding-top:'.esc_attr( $height100TbSpacing ).'px;';
							} else {
								$heightImgWrap = $height;
							}
						} else {
							$height = '100vh';
							$heightImgWrap = $height;
							if( $height100TbSpacing ) {
								$heightImgWrap = 'calc(100vh - '.esc_attr( $height100TbSpacing ).'px - '.esc_attr( $height100TbSpacing ).'px)'; 
								$sliderStagePadding = 'padding-top:'.esc_attr( $height100TbSpacing ).'px;';
							}
						}
					} else {
						$height = $height.'vh';
						$heightImgWrap = $height;
					}
					
					$style .= esc_html( $moduleUniqueClass ).' .slider-mod-wrap, ' .esc_html( $moduleUniqueClass ). ' .slider-style1 .owl-carousel { height: ' .esc_attr( $height ). '; }';
					$style .= esc_html( $moduleUniqueClass ).' .slider-style1 .carousel-img-wrap { height: ' .esc_attr( $heightImgWrap ). '; }';
					$style .= esc_html( $moduleUniqueClass ).' .slider-style1 .owl-stage {'.esc_attr( $sliderStagePadding ).'}';
					$style .= "\r\n";
				}
				if ( $mobileHeight = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_1_height_mobile', true ) ) ) {
					if ( $mobileHeight == '100' ) {
						$mobileHeight = '100vh';
						$heightImgWrapM = $mobileHeight;
						//If min header footer
						if ( $height100MinHeaderFooterM ==='on' ) {
							$mobileHeight = 'calc(100vh - var(--header-height, 0px) - var(--footer-height, 0px))';
							$heightImgWrapM = $mobileHeight;
							if ( $height100TbSpacingM ) {
								$sliderStagePaddingM = 'padding-top:'.esc_attr( $height100TbSpacingM ).'px;';
								$heightImgWrapM = 'calc(100vh - var(--header-height, 0px) - var(--footer-height, 0px) - '.esc_attr( $height100TbSpacingM ).'px - '.esc_attr( $height100TbSpacingM ).'px)';
							}
							$style .= '@media (max-width: 767px) and (orientation: portrait){';
							$style .= '.bm-builder .module'.esc_html( $moduleUniqueClass ).' .slider-mod-wrap, .bm-builder .module'.esc_html( $moduleUniqueClass ). ' .slider-style1 .owl-carousel { height: ' .esc_attr( $mobileHeight ). '; }';
							$style .= '.bm-builder .module'.esc_html( $moduleUniqueClass ).' .slider-style1 .carousel-img-wrap { height: ' .esc_attr( $heightImgWrapM ). '; }';
							$style .= '.bm-builder .module'.esc_html( $moduleUniqueClass ).' .slider-style1 .owl-stage { '.esc_attr( $sliderStagePaddingM ).' }';
							$style .= '}'; 
						} else {
							if ( $height100TbSpacingM ) {
								$sliderStagePaddingM = 'padding-top:'.esc_attr( $height100TbSpacingM ).'px;';
								$heightImgWrapM = 'calc(100vh - '.esc_attr( $height100TbSpacingM ).'px - '.esc_attr( $height100TbSpacingM ).'px)';
								$style .= '@media (max-width: 767px) and (orientation: portrait){';
								$style .= '.bm-builder .module'.esc_html( $moduleUniqueClass ).' .slider-style1 .carousel-img-wrap { height: ' .esc_attr( $heightImgWrapM ). '; }';
								$style .= '.bm-builder .module'.esc_html( $moduleUniqueClass ).' .slider-style1 .owl-stage { '.esc_attr( $sliderStagePaddingM ).' }';
								$style .= '}'; 
							}
							$style .= esc_html( $moduleUniqueClass ).'{ --slider-height-style1-m: ' .esc_attr( $mobileHeight ). '; }'; 
						}
					} else {
						$style .= esc_html( $moduleUniqueClass ).'{ --slider-height-style1-m: ' .esc_attr( $mobileHeight ). 'vh; }'; 
					}
					$style .= "\r\n";
				}
			}
			
			//title style
			$titleStyle = array();
			$titleStyleMobile = array();
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_title', true ) ) {
				if ( $titleStyleFont = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_title_font_font', true ) ) {
					$titleStyle['font-family'] = ux_cb_fonts_load_font_data( $titleStyleFont );
				}
				if ( $titleStyleFontSize = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_title_font_size', true ) ) {
					$titleStyle['font-size'] = 'font-size: ' .sanitize_text_field( $titleStyleFontSize ). ';';
				}
				if ( $titleStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_title_font_msize', true ) ) {
					$titleStyleMobile['font-size'] = '--font-size-slider-style1-title-m: ' .sanitize_text_field( $titleStyleFontSizeMobile ). ';';
				}
				if ( $titleStyleFontLineheight = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_title_font_lineheight', true ) ) {
					$titleStyle['line-height'] = 'line-height: ' .sanitize_text_field( $titleStyleFontLineheight ). '!important;';
				}
				if ( $titleStyleFontLetterSpacing = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_title_font_letter_spacing', true ) ) {
					$titleStyle['letter-spacing'] = 'letter-spacing: ' .intval( esc_attr( $titleStyleFontLetterSpacing ) ). 'px;';
				}
				$getTitleStylePaddingBottom = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_title_padding_bottom', true );
				if ( ! is_array( $getTitleStylePaddingBottom ) ) { $getTitleStylePaddingBottom = array( $getTitleStylePaddingBottom, 0 ); }
				$titleStylePaddingBottom = intval( $getTitleStylePaddingBottom[0] );
				$titleStylePaddingBottomMobile = intval( $getTitleStylePaddingBottom[1] );
				if ( $titleStylePaddingBottom )	{ 
					$titleStyle['padding-bottom'] = 'padding-bottom:' .esc_attr( $titleStylePaddingBottom ). 'px;';
				}
				if ( $titleStylePaddingBottomMobile )	{ 
					$titleStyle['padding-bottom-m'] = '--paddingbottom-slider1-tit-m:' .esc_attr( $titleStylePaddingBottomMobile ). 'px;';
				}
				$style .= esc_html( $moduleUniqueClass ). ' .slide-item-wrap-tit{' .sanitize_text_field( join( ' ', $titleStyle ) ). '}';
				$style .= "\r\n";
			}
			
			//caption style
			$captionStyle = array();
			$captionStyleMobile = array();
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_caption', true ) ) {
				if ( $captionStyleFont = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_caption_font_font', true ) ) {
					$captionStyle['font-family'] = ux_cb_fonts_load_font_data( $captionStyleFont );
				}
				if ( $captionStyleFontSize = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_caption_font_size', true ) ) {
					$captionStyle['font-size'] = 'font-size: ' .esc_attr( $captionStyleFontSize ). ';';
				}
				if ( $captionStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_caption_font_msize', true ) ) {
					$captionStyleMobile['font-size'] = '--font-size-slider-style1-caption-m: ' .sanitize_text_field( $captionStyleFontSizeMobile ). ';';
				}
				if ( $captionStyleFontLineheight = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_caption_font_lineheight', true ) ) {
					$captionStyle['line-height'] = 'line-height: ' .esc_attr( $captionStyleFontLineheight ). ';';
				}
				if ( $captionStyleFontLetterSpacing = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_caption_font_letter_spacing', true ) ) {
					$captionStyle['letter-spacing'] = 'letter-spacing: ' .intval( esc_attr( $captionStyleFontLetterSpacing ) ). 'px;';
				}
				$getCaptionStylePaddingBottom = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_caption_padding_bottom', true );
				if ( ! is_array( $getCaptionStylePaddingBottom ) ) { $getCaptionStylePaddingBottom = array( $getCaptionStylePaddingBottom, 0 ); }
				$captionStylePaddingBottom = intval( $getCaptionStylePaddingBottom[0] );
				$captionStylePaddingBottomMobile = intval( $getCaptionStylePaddingBottom[1] );
				if ( $captionStylePaddingBottom )	{ 
					$captionStyle['padding-bottom'] = 'padding-bottom:' .esc_attr( $captionStylePaddingBottom ). 'px;';
				}
				if ( $captionStylePaddingBottomMobile )	{ 
					$captionStyle['padding-bottom-m'] = '--paddingbottom-slider1-caption-m:' .esc_attr( $captionStylePaddingBottomMobile ). 'px;';
				}
				//
				$style .= esc_html( $moduleUniqueClass ). ' .slider-mod-wrap.slider-style1 .slide-item-wrap-caption{' .sanitize_text_field( join( ' ', $captionStyle ) ). '}';
				$style .= "\r\n";
			}
			
			//padding
			$paddingStyle = array();
			$getPaddingLeftRight = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_padding_left_right', true );
			if( ! is_array($getPaddingLeftRight) ) { $getPaddingLeftRight = array( $getPaddingLeftRight, 0 ); }
			$paddingLeftRight = intval( $getPaddingLeftRight[0] );
			$paddingLeftRightMobile = intval( $getPaddingLeftRight[1] );
			$paddingStyle['padding-left'] = 'padding-left:' .esc_attr( $paddingLeftRight ). 'px;';
			$paddingStyle['padding-right'] = 'padding-right:' .esc_attr( $paddingLeftRight ). 'px;';
			$paddingStyle['padding-leftright-m'] = '--paddingleftright-slider-text-m:'.esc_attr( $paddingLeftRightMobile ).'px;';
			
			$getPaddingBottom = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_padding_bottom', true );
			if( ! is_array($getPaddingBottom) ) { $getPaddingBottom = array( $getPaddingBottom, 0 ); }
			$paddingBottom = intval( $getPaddingBottom[0] );
			$paddingBottomMobile = intval( $getPaddingBottom[1] );
			if( $paddingBottom ) {
				$paddingStyle['padding-bottom'] = 'padding-bottom:' .esc_attr( $paddingBottom ). 'px;';
			}
			if( $paddingBottomMobile ) {
				$paddingStyle['padding-bottom-m'] = '--paddingbottom-slider-text-m:' .esc_attr( $paddingBottomMobile ). 'px;';
			}
			if ( $paddingStyle ) {
				$style .= esc_html( $moduleUniqueClass ). ' .slide-item-des{' .sanitize_text_field( join( ' ', $paddingStyle ) ). '}';
				$style .= "\r\n";
			}
			
			//page number style
			$pageNumberStyle = array();
			$pageNumberStyleMobile = array();
			$pageNumberStyleFontStyle = array();
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_show_page_number', true ) ) {
				if ( $pageNumberStyleFont = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_font_font', true ) ) {
					$pageNumberStyle['font-family'] = ux_cb_fonts_load_font_data( $pageNumberStyleFont );
					$pageNumberStyleFontStyle['font-family'] = ux_cb_fonts_load_font_data( $pageNumberStyleFont );
				}
				if ( $pageNumberStyleFontSize = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_font_size', true ) ) {
					$pageNumberStyle['font-size'] = 'font-size: ' .sanitize_text_field($pageNumberStyleFontSize). ';';
				}
				if ( $pageNumberStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_font_msize', true ) ) {
					$pageNumberStyleMobile['font-size'] = '--font-size-slider-style1-number-m: ' .$pageNumberStyleFontSizeMobile. ';';
				}
				if ( $pageNumberStyleFontLineheight = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_font_lineheight', true ) ) {
					$pageNumberStyle['line-height'] = 'line-height: ' .$pageNumberStyleFontLineheight. ';';
				}
				if ( $pageNumberStyleFontLetterSpacing = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_font_letter_spacing', true ) ) {
					$pageNumberStyle['letter-spacing'] = 'letter-spacing: ' .intval( esc_attr( $pageNumberStyleFontLetterSpacing ) ). 'px;';
				}
				
				$getPageNumberStylePaddingLeftRight = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_padding_left_right', true );
				if( ! is_array( $getPageNumberStylePaddingLeftRight ) ) { $getPageNumberStylePaddingLeftRight = array( $getPageNumberStylePaddingLeftRight, 0 ); }
				$pageNumberStylePaddingLeftRight = intval( $getPageNumberStylePaddingLeftRight[0] );
				$pageNumberStylePaddingLeftRightMobile = intval( $getPageNumberStylePaddingLeftRight[1] );
				if( $pageNumberStylePaddingLeftRight ) {
					$pageNumberStyle['margin-left'] = 'margin-left:' .esc_attr( $pageNumberStylePaddingLeftRight ). 'px;';
					$pageNumberStyle['margin-right'] = 'margin-right:' .esc_attr( $pageNumberStylePaddingLeftRight ). 'px;';
				}
				if( $pageNumberStylePaddingLeftRightMobile ) {
					$pageNumberStyle['margin-rightright-m'] = '--margin-rightleft-pagenum-m:' .esc_attr( $pageNumberStylePaddingLeftRightMobile ). 'px;';
				}
				
				$getPageNumberStylePaddingBottom = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_page_number_padding_bottom', true );
				if( ! is_array( $getPageNumberStylePaddingBottom ) ) { $getPageNumberStylePaddingBottom == array( $getPageNumberStylePaddingBottom, 0 ); }
				$pageNumberStylePaddingBottom = intval( $getPageNumberStylePaddingBottom[0] );
				$pageNumberStylePaddingBottomMobile = intval( $getPageNumberStylePaddingBottom[1] );
				if( $pageNumberStylePaddingBottom ) {
					$pageNumberStyle['margin-bottom'] = 'margin-bottom: ' .esc_attr( $pageNumberStylePaddingBottom ). 'px;';
				}
				if( $pageNumberStylePaddingBottomMobile ) {
					$pageNumberStyle['margin-bottom-m'] = '--margin-bottom-pagenum-m:'.esc_attr( $pageNumberStylePaddingBottomMobile ). 'px;';
				}
				$style .= esc_html( $moduleUniqueClass ). ' .slider-mod-wrap.slider-style1 .owl-dots{' .sanitize_text_field( join( ' ', $pageNumberStyle ) ). ' }';
				$style .= esc_html( $moduleUniqueClass ). ' .slider-mod-wrap.slider-style1 .owl-dot{' .sanitize_text_field( join( ' ', $pageNumberStyleFontStyle ) ). ' }';
				$style .= "\r\n";
			}
			
			//arrow style
			if ( $showArrow === 'on' ) {
				$getArrowIconHeight = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_icon_height', true );
				if ( ! is_array( $getArrowIconHeight ) ) { $getArrowIconHeight = array( $getArrowIconHeight, 0 ); }
				$arrowIconHeight = intval( $getArrowIconHeight[0] );
				$arrowIconHeightMobile = intval( $getArrowIconHeight[1] );
					if ( $arrowIconHeight ) {
						$style .= esc_html( $moduleUniqueClass ). ' .slider-arrow svg,' .esc_html( $moduleUniqueClass ). ' .slider-arrow img{height: ' .esc_attr( $arrowIconHeight ). 'px!important; width:auto; }';
						$style .= "\r\n";
					}
					if ( $arrowIconHeightMobile ) {
						$style .= esc_html( $moduleUniqueClass ).'{--height-arrow-slider: '.esc_attr( $arrowIconHeightMobile ).'px;}'; 
						$style .= "\r\n";
					}
					
				
				if ( $arrowPosition = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_position', true ) ) {
					if ( 'default' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_cursor_on_arrow', true ) ) {
						$style .= esc_html( $moduleUniqueClass ). ' .slider-arrow{cursor: default;}';
						$style .= "\r\n";
					}
					switch ( $arrowPosition ) {
						case 'left-right':
							$arrowPaddingLeftRight = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_padding_left_right', true ) );
							$style .= esc_html( $moduleUniqueClass ). ' .slider-arrow{margin-left:' .esc_attr( $arrowPaddingLeftRight ). 'px;margin-right:' .esc_attr( $arrowPaddingLeftRight ). 'px;}';
							$style .= "\r\n";
						break;
						
						case 'right-bottom':
							$getArrowSpacing = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_spacing', true );
							if ( ! is_array( $getArrowSpacing ) ) { $getArrowSpacing = array( $getArrowSpacing, 0 ); }
							$arrowSpacing = intval( $getArrowSpacing[0] );
							$arrowSpacingMobile = intval( $getArrowSpacing[1] );
							if ( $arrowSpacing ) {
 								$style .= esc_html( $moduleUniqueClass ). ' .slider-arrows-bottom-together .slider-arrow-right{margin-left:' .esc_attr( $arrowSpacing ). 'px;}';
								$style .= "\r\n";
							}
							if ( $arrowSpacingMobile ) {
								$style .= esc_html( $moduleUniqueClass ). '{--spacing-arrowtogether-spacing:'.esc_attr( $arrowSpacingMobile ).'px;}';
								$style .= "\r\n";
							}
							$getArrowPaddingRight = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_padding_right', true );
							if ( ! is_array( $getArrowPaddingRight ) ) { $getArrowPaddingRight = array( $getArrowPaddingRight, 0 ); }
							$arrowPaddingRight = intval( $getArrowPaddingRight[0] );
							$arrowPaddingRightMobile = intval( $getArrowPaddingRight[1] ); 
							if ( $arrowPaddingRight ) {
								$style .= esc_html( $moduleUniqueClass ). ' .slider-arrows-bottom-together{margin-right:' .esc_attr( $arrowPaddingRight ). 'px;}';
								$style .= "\r\n";
							}
							if ( $arrowPaddingRightMobile ) {
								$style .= esc_html( $moduleUniqueClass ). '{--marginright-arrowtogether-m:' .esc_attr( $arrowPaddingRightMobile ). 'px;}';
								$style .= "\r\n";
							}
							$getArrowPaddingBottom = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_padding_bottom', true );
							if ( ! is_array( $getArrowPaddingBottom ) ) { $getArrowPaddingBottom = array( $getArrowPaddingBottom, 0 ); }
							$arrowPaddingBottom = intval( $getArrowPaddingBottom[0] );
							$arrowPaddingBottomMobile = intval( $getArrowPaddingBottom[1] );
							if ( ! is_array( $arrowPaddingBottom ) ) {
								$style .= esc_html( $moduleUniqueClass ). ' .slider-arrows-bottom-together{margin-bottom:' .esc_attr( $arrowPaddingBottom ). 'px;}';
								$style .= "\r\n";
							}
							if ( ! is_array( $arrowPaddingBottomMobile ) ) {
								$style .= esc_html( $moduleUniqueClass ). '{--marginbottom-arrowtogether-m:' .esc_attr( $arrowPaddingBottomMobile ). 'px;}';
								$style .= "\r\n";
							}
						break;

						case 'center-bottom':
							$getArrowSpacingRb = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_spacing_center', true );
							if ( ! is_array( $getArrowSpacingRb ) ) { $getArrowSpacingRb = array( $getArrowSpacingRb, 0 ); }
							$arrowSpacingRb = intval( $getArrowSpacingRb[0] );
							$arrowSpacingRbMobile = intval( $getArrowSpacingRb[1] );
							if ( $arrowSpacingRb ) {
 								$style .= esc_html( $moduleUniqueClass ). ' .slider-arrows-bottom-together .slider-arrow-right{padding-left:' .esc_attr( $arrowSpacingRb ). 'px;}';
								$style .= "\r\n";
							}
							if ( $arrowSpacingRbMobile ) {
								$style .= esc_html( $moduleUniqueClass ). '{--spacing-arrowtogether-rb-spacing:'.esc_attr( $arrowSpacingRbMobile ).'px;}';
								$style .= "\r\n";
							}

							$getArrowPaddingBottomCenter = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_arrow_padding_bottom_center', true );
							if ( ! is_array( $getArrowPaddingBottomCenter ) ) { $getArrowPaddingBottomCenter = array( $getArrowPaddingBottomCenter, 0 ); }
							$arrowPaddingBottomCenter = intval( $getArrowPaddingBottomCenter[0] );
							$arrowPaddingBottomCenterMobile = intval( $getArrowPaddingBottomCenter[1] );
							if ( ! is_array( $arrowPaddingBottomCenter ) ) {
								$style .= esc_html( $moduleUniqueClass ). ' .slider-arrows-bottom-together{margin-bottom:' .esc_attr( $arrowPaddingBottomCenter ). 'px;}';
								$style .= "\r\n";
							}
							if ( ! is_array( $arrowPaddingBottomCenterMobile ) ) {
								$style .= esc_html( $moduleUniqueClass ). '{--marginbottom-arrowtogether-br-m: ' .esc_attr( $arrowPaddingBottomCenterMobile ). 'px;}';
								$style .= "\r\n";
							}
						break;
					}
				}
			} else {

				if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_1_mouse_cursor', true ) ) {
				//arrow on cursor
					if ( $leftArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_left_cursor', true ) ) {
						$leftArrowSrc = wp_get_attachment_image_src( $leftArrow, 'full' );
						$style .= esc_html( $moduleUniqueClass ). ' .slide-arrows-on-cursor .slider-arrow-left{cursor: url(' .esc_url( $leftArrowSrc[0] ). '), auto;}';
						$style .= "\r\n";
					}
					if ( $rightArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_1_right_cursor', true ) ) {
						$rightArrowSrc = wp_get_attachment_image_src( $rightArrow, 'full' );
						$style .= esc_html( $moduleUniqueClass ). ' .slide-arrows-on-cursor .slider-arrow-right{cursor: url(' .esc_url( $rightArrowSrc[0] ). '), auto;}';
						$style .= "\r\n";
					}
				}
			}
			
			//mobile
			$style .= "\r\n";
				if ( $titleStyleMobile ) {
					$style .= esc_html( $moduleUniqueClass ). '{' .sanitize_text_field( join( ' ', $titleStyleMobile ) ). '}';
					$style .= "\r\n";
				}
				if ( $captionStyleMobile ) {
					$style .= esc_html( $moduleUniqueClass ). '{' .sanitize_text_field( join( ' ', $captionStyleMobile ) ). '}';
					$style .= "\r\n";
				}
				if ( $pageNumberStyleMobile ) {
					$style .= esc_html( $moduleUniqueClass ). '{' .sanitize_text_field( join( ' ', $pageNumberStyleMobile ) ). '}';
					$style .= "\r\n";
				}
			$style .= "\r\n";
		
		break;
		
		case 'style-2':
			//height
			if ( $height = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_2_height', true ) ) ) {
				$style .= esc_html( $moduleUniqueClass ). ' .slider-mod-wrap.slider-style2 .bm-tab-slider{height: ' .esc_attr( $height ). 'vh;}';
				$style .= "\r\n";
			}
			if ( $mobileHeight = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_2_height_mobile', true ) ) ) {
				$style .= esc_html( $moduleUniqueClass ). '{--slider-height-style2-m: ' .esc_attr( $mobileHeight ). 'vh;}';
				$style .= "\r\n";
			}
			
			//title style
			$titleStyle = array();
			$titleStyleMobile = array();
			if ( $titleStyleFont = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_title_font_font', true ) ) {
				$titleStyle['font-family'] = ux_cb_fonts_load_font_data( $titleStyleFont );
			}
			if ( $titleStyleFontSize = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_title_font_size', true ) ) {
				$titleStyle['font-size'] = 'font-size:' .$titleStyleFontSize. ';';
			}
			if ( $titleStyleFontSizeMobile = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_title_font_msize', true ) ) {
				$titleStyleMobile['font-size'] = '--font-size-slider-style2-title-m:' .$titleStyleFontSizeMobile. ';';
			}
			if ( $titleStyleFontLineheight = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_title_font_lineheight', true ) ) {
				$titleStyle['line-height'] = 'line-height:' .$titleStyleFontLineheight. ';';
			}
			if ( $titleStyleFontLetterSpacing = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_title_font_letter_spacing', true ) ) {
				$titleStyle['letter-spacing'] = 'letter-spacing:' .intval( esc_attr( $titleStyleFontLetterSpacing ) ). 'px;';
			}
			$style .= esc_html( $moduleUniqueClass ). ' .bm-tab-slider-trigger-item{' . sanitize_text_field( join( ' ', $titleStyle ) ). '}';
			$style .= "\r\n";
			
			//spacing between items
			$spacingGet = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_spacing', true );
			if ( ! is_array( $spacingGet ) ) {
				$spacingGet = array( $spacingGet, 0 );
			}
			$spacing = intval( $spacingGet[0] );
			$spacingMobile = intval( $spacingGet[1] );

			if ( $spacing ) { 
				$style .= esc_html( $moduleUniqueClass ). ' .bm-tab-slider-trigger-item:not(:first-child){margin-top: ' .esc_attr( $spacing ). 'px;}';
				$style .= "\r\n";
			}
			if ( $spacingMobile ) {
				$style .= esc_html( $moduleUniqueClass ). '{--margintop-slider-trigger-item:' .esc_attr( $spacingMobile ). 'px;}';
				$style .= "\r\n";
			}
			
			//padding
			$paddingStyle = array();
			//Padding right left
			$paddingLeftRightGet = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_padding_left_right', true );
			if ( ! is_array( $paddingLeftRightGet ) ) {
				$paddingLeftRightGet = array( $paddingLeftRightGet, 0 );
			}
			$paddingLeftRight = intval( $paddingLeftRightGet[0] );
			$paddingLeftRightMobile = intval( $paddingLeftRightGet[1] );
			if ( $paddingLeftRight ) {
				$paddingStyle['padding-left'] = 'margin-left:' .esc_attr( $paddingLeftRight ). 'px;';
				$paddingStyle['padding-right'] = 'margin-right:' .esc_attr( $paddingLeftRight ). 'px;';
			}
			if ( $paddingLeftRightMobile ) {
				$paddingStyle['mobile-right'] = '--margin-lr-slider-trigger:'.esc_attr( $paddingLeftRightMobile ).'px;';
			}
			//Padding bottom
			$paddingBottomGet = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_padding_bottom', true );
			if ( ! is_array( $paddingBottomGet ) ) {
				$paddingBottomGet = array( $paddingBottomGet, 0 );
			}
			$paddingBottom = intval( $paddingBottomGet[0] );
			$paddingBottomMobile = intval( $paddingBottomGet[1] );
			if ( $paddingBottom ) { 
				$paddingStyle['padding-bottom'] = 'margin-bottom: ' .esc_attr( $paddingBottom ). 'px;';
			}
			if ( $paddingBottomMobile ) {
				$paddingStyle['mobile-mobile'] = '--margin-bottom-slider-trigger:'.esc_attr( $paddingBottomMobile ).'px;';
			}
			if ( $paddingStyle ) {
				$style .= esc_html( $moduleUniqueClass ). ' .bm-tab-slider-trigger{' . sanitize_text_field( join( ' ', $paddingStyle ) ). ' }';
				$style .= "\r\n";
			}
			
			//mobile
			$style .= "\r\n";
			if ( $titleStyleMobile ) {
				$style .= esc_html( $moduleUniqueClass ). ' { ' .sanitize_text_field( join( ' ', $titleStyleMobile) ). ' }';
				$style .= "\r\n";
			}
			$style .= "\r\n";

			if ( 'on' == get_post_meta( $post_id, '__ux_cb_module_slider_style_2_mask', true ) ) {
				$maskStyle = array(); 
				if ( $maskColor = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_mask_color', true ) ) {
					$maskStyle['background-color'] = 'background-color:'.esc_attr( $maskColor ).';';
				}
				if ( $maskOpacity = get_post_meta( $post_id, '__ux_cb_module_slider_style_2_mask_opacity', true ) ) {
					$maskStyle['opacity'] = 'opacity:'.esc_attr( $maskOpacity ).';';
				}
				if( $maskStyle ) {
					$style .= esc_html( $moduleUniqueClass ). ' .slider-mask .bm-tab-slider-img:before{ ' .sanitize_text_field( join( ' ', $maskStyle) ). ' }';
					$style .= "\r\n";
				}
			}

		break;
		
		case 'style-3':
			//height
			if ( $height = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_3_height', true ) ) ) {
				$style .= esc_html( $moduleUniqueClass ). ' .slider-mod-wrap.slider-style3, ' .esc_html( $moduleUniqueClass ). ' .slider-mod-wrap.slider-style3 .owl-carousel .owl-item img { height: ' .esc_attr( $height ). 'vh; }';
				$style .= "\r\n";
			}
			if ( $mobileHeight = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_3_height_mobile', true ) ) ) {
				$style .= esc_attr($moduleUniqueClass) . '{--slider-height-style3-m: '.esc_attr($mobileHeight).'vh;}';
				$style .= "\r\n";
			}
			
			//arrow style
			if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_show_arrow', true ) ) {
				if ( 'default' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_cursor_on_arrow', true ) ) {
					$style .= esc_html( $moduleUniqueClass ). ' .slider-arrow{cursor: default;}';
					$style .= "\r\n";
				}
				if ( $arrowIconHeight = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_3_arrow_icon_height', true ) ) ) {
					$style .= esc_html( $moduleUniqueClass ). ' div.slider-arrow svg, ' .esc_html( $moduleUniqueClass ). ' div.slider-arrow img { height: ' .esc_attr( $arrowIconHeight ). 'px!important; }';
					$style .= "\r\n";
				}
				if ( 'left-right' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_arrow_position', true ) ) {
					$arrowPaddingLeftRight = intval( get_post_meta( $post_id, '__ux_cb_module_slider_style_3_arrow_padding_left_right', true ) );
					$style .= esc_html( $moduleUniqueClass ). ' div.slider-arrow { margin-left: ' .esc_attr( $arrowPaddingLeftRight ). 'px;margin-right: ' .esc_attr( $arrowPaddingLeftRight ). 'px;}';
					$style .= "\r\n";
				}
			} else {
				if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_slider_style_3_mouse_cursor', true ) ) {
				//arrow on cursor
					if ( $leftArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_3_left_cursor', true ) ) {
						$leftArrowSrc = wp_get_attachment_image_src( $leftArrow, 'full' );
						$style .= esc_html( $moduleUniqueClass ). ' .slide-arrows-on-cursor .slider-arrow-left{cursor: url(' .esc_url( $leftArrowSrc[0] ). '), auto;}';
						$style .= "\r\n";
					}
					if ( $rightArrow = get_post_meta( $post_id, '__ux_cb_module_slider_style_3_right_cursor', true ) ) {
						$rightArrowSrc = wp_get_attachment_image_src( $rightArrow, 'full' );
						$style .= esc_html( $moduleUniqueClass ). ' .slide-arrows-on-cursor .slider-arrow-right{cursor: url(' .esc_url( $rightArrowSrc[0] ). '), auto;}';
						$style .= "\r\n";
					}
				}
			}
		break;
	}
	
	return $style;
}


?>