<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Main manager.
 */
if ( ! function_exists( 'ux_content_builder' ) ) {
	/**
	 * Content Builder manager.
	 * @since 1.0.0
	 * @return UX_ContentBuilder
	 */
	function ux_content_builder() {
		return UX_ContentBuilder::getInstance();
	}
}
if ( ! function_exists( 'ux_cb_path_dir' ) ) {
	/**
	 * Get file/directory path in Vc.
	 *
	 * @param string $name - path name
	 * @param string $file
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function ux_cb_path_dir( $name, $file = '' ) {
		return ux_content_builder()->path( $name, $file );
	}
}
if ( ! function_exists( 'ux_cb_template' ) ) {
	/**
	 * @param $file
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function ux_cb_template( $file ) {
		return ux_cb_path_dir( 'TEMPLATES_DIR', $file );
	}
}
if ( ! function_exists( 'ux_cb_asset_url' ) ) {
	/**
	 * Get full url for assets.
	 *
	 * @param string $file
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function ux_cb_asset_url( $file ) {
		return ux_content_builder()->assetUrl( $file );
	}
}
if ( ! function_exists( 'ux_cb_placehold_url' ) ) {
	/**
	 * Get full url for placehold.
	 *
	 * @param string $file
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function ux_cb_placehold_url( $file ) {
		return ux_content_builder()->placeholdUrl( $file );
	}
}
if ( ! function_exists( 'ux_cb_module_hidden_items_fields' ) ) {
	/**
	 * Hidden fields.
	 */
	function ux_cb_module_hidden_items_fields($post, $current_item_ctrl, $module){
		$item_hidden = '';
		$item_hidden_array = array();
						
		if($current_item_ctrl != 'false'){
			$item_ctrl = explode(',', $current_item_ctrl);
			$item_ctrl_name = $item_ctrl[0];
			$item_ctrl_array = explode('|', $item_ctrl[1]);
			
			$item_ctrl_value = false;
			if(isset($_POST['moduleUnique']) && isset($_POST['postID'])){
				$post_id =  ux_cb_get_the_module_post_id($_POST['moduleUnique']);
				$item_ctrl_meta = get_post_meta($post_id, $item_ctrl_name, true);
				if($item_ctrl_meta){
					$item_ctrl_value = $item_ctrl_meta;
				}
			}
			
			if($item_ctrl_value){
				if(!in_array($item_ctrl_value, $item_ctrl_array)){
					$item_hidden = 'hidden';
				}
			}else{
				foreach($module['region'] as $region){
					foreach($region['section'] as $section){
						if(isset($module['animation'])){
							if($module['animation'] && $region['region-id'] == 'advanced-settings'){
								$animation = ux_cb_module_field_animation();
								$section['group'][]['items'] = $animation;
							}
						}
						
						foreach($section['group'] as $group){
							$group = wp_parse_args($group, array(
								'items' => array()
							));
							foreach($group['items'] as $item){
								$item = wp_parse_args($item, array(
									'default' => '',
									'name' => '',
									'current' => false
								));
								if($item['name'] == $item_ctrl_name){
									$itemDefault = $item['default'];
									if ( $item['type'] == 'source' && $item['current'] ) {
										if ( isset( $_POST['postType'] ) ) {
											$itemDefault = $_POST['postType'];
										}
									}
									
									if(!in_array($itemDefault, $item_ctrl_array)){
										$item_hidden = 'hidden';
									}
								}
							}
						}
					}
				}
			}
		}
		
		return sanitize_html_class($item_hidden);
	}
}
if ( ! function_exists( 'ux_cb_module_theme_color' ) ) {
	/**
	 * UX CB Module Theme Color.
	 */
	function ux_cb_module_theme_color(){
		$theme_color = array(
			array('id' => 'color1', 'value' => 'theme-color-1', 'rgb' => '#F9885C'),
			array('id' => 'color2', 'value' => 'theme-color-2', 'rgb' => '#BD9DD1'),
			array('id' => 'color3', 'value' => 'theme-color-3', 'rgb' => '#F1A1C3'),
			array('id' => 'color4', 'value' => 'theme-color-4', 'rgb' => '#92C3E3'),
			array('id' => 'color5', 'value' => 'theme-color-5', 'rgb' => '#5B6A81'),
			array('id' => 'color6', 'value' => 'theme-color-6', 'rgb' => '#858687'),
			array('id' => 'color7', 'value' => 'theme-color-7', 'rgb' => '#69CE9B'),
			array('id' => 'color8', 'value' => 'theme-color-8', 'rgb' => '#fbd44d'),
			array('id' => 'color9', 'value' => 'theme-color-9', 'rgb' => '#c9b69d'),
			array('id' => 'color10', 'value' => 'theme-color-10', 'rgb' => '#313139')
		);	
		
		return $theme_color;
	}
}
if ( ! function_exists( 'ux_cb_module_switch_theme_color' ) ) {
	/**
	 * UX CB Module Switch Theme Color.
	 */
	function ux_cb_module_switch_theme_color($key, $to='value'){
		global $ux_cb_module_theme_color;
		$theme_color = false;
		if(count($ux_cb_module_theme_color)){
			foreach($ux_cb_module_theme_color as $color){
				if($color['id'] == $key){
					if($to = 'rgb'){
						$theme_color = $color[$to];
					}else{
						$theme_color = $color[$to];
					}
				}
			}
		}
		return $theme_color;
	}
}
if ( ! function_exists( 'ux_cb_module_filter_shortcode' ) ) {
	/**
	 * UX CB Module Filter Shortcode.
	 */
	function ux_cb_module_filter_shortcode($content){
		$html = '';
		
		$moduleFields = apply_filters('ux_cb_module_fields', array());
		
		$pattern = get_shortcode_regex(); 
		
		preg_match_all( '/'. $pattern .'/s', $content, $matches);
		
		$shortcode_order = array();
		if(array_key_exists(2, $matches)){
			foreach($matches[2] as $num => $shortcodeTag){
				foreach($moduleFields as $module){
					if(isset($module['shortcodeTag'])){
						if($shortcodeTag == $module['shortcodeTag']){
							$shortcode_order[] = $num;
						}
					}
				}
			}
		}
		
		foreach($matches[0] as $num => $shortcode){
			foreach($shortcode_order as $order){
				if($num == $order){
					$html .= $shortcode;
				}
			}
		}
		
		return $html;
	}
}
if ( ! function_exists( 'ux_cb_module_filter_shortcode' ) ) {
	/**
	 * UX CB Module Display Modal.
	 */
	function ux_cb_module_display_modal($item){
		$html = '';
		$html .= '<div class="ux-modal ux-fade" id="ux-modal-' .esc_attr($item['name']). '">';
		$html .=   '<div class="ux-modal-dialog">';
		$html .=     '<div class="ux-modal-content">';
		$html .=       '<div class="ux-modal-header">';
		$html .=         '<button type="button" class="close" data-event="close"><span aria-hidden="true">&times;</span></button>';
		$html .=         '<h4 class="ux-modal-title">' .esc_html($item['title']). '</h4>';
		$html .=       '</div>';
		$html .=       '<div class="ux-modal-body">';
		$html .=       '</div>';
		$html .=       '<div class="ux-modal-footer">';
		$html .=         '<button type="button" class="btn btn-default" data-event="close">' .esc_attr__('Close','bm-builder'). '</button>';
		$html .=         '<button type="button" class="btn btn-primary">' .esc_attr__('Save','bm-builder'). '</button>';
		$html .=       '</div>';
		$html .=     '</div>';
		$html .=   '</div>';
		$html .= '</div>';
		
		return $html;
	}
}
if ( ! function_exists( 'ux_cb_get_the_category' ) ) {
	/**
	 * Get The Category
	 */
	function ux_cb_get_the_category($separator=' ', $class='', $taxonomy='category', $post_id=false){
		if(!$post_id){
			$post_id = get_the_ID();
		}
		
		$categories = get_the_terms($post_id, $taxonomy);
		$output = ''; 
		
		if(!empty($categories)){
			foreach( $categories as $category ) {
				$output .= '<a href="' .esc_url(get_category_link($category->term_id)). '" title="' .esc_attr(sprintf(__('View all posts in %s','bm-builder'), $category->name)). '" class="' .sanitize_html_class($class). '">' .esc_html($category->name). '</a>' .$separator;
			}
			return trim($output, $separator);
		}
	}
}
if ( ! function_exists( 'ux_cb_get_the_module_post_id' ) ) {
	/**
	 * Get The Module post_id
	 */
	function ux_cb_get_the_module_post_id($moduleUnique){
		$post_id = false;
		
		if($moduleUnique){
			$get_posts = get_posts(array(
				'posts_per_page' => -1,
				'name' => $moduleUnique,
				'post_type' => 'ux-cb-modules'
			));
			$post_id = $get_posts ? $get_posts[0]->ID : false;
		}
		
		return $post_id;
	}
}
if ( ! function_exists( 'ux_cb_get_the_post_id' ) ) {
	/**
	 * Get The post_id
	 */
	function ux_cb_get_the_post_id(){
		//global $post;
		
		$post_id = get_the_ID();
		if(isset($_REQUEST['action'])){
			if($_REQUEST['action'] == 'edit'){
				$post_id = $_REQUEST['post'];
			}
		}
		
		if(isset($_POST['postID'])){
			$post_id = $_POST['postID'];
		}
		return $post_id;
	}
}
if ( ! function_exists( 'ux_cb_wpautop' ) ) {
	/**
	 * Get The wpautop
	 */
	function ux_cb_wpautop($content){
		if(strpos($content, 'ux_cb_wrap')){
			remove_filter( 'the_content', 'wpautop' );
		}
		
		return $content;
	}
	add_filter( 'the_content', 'ux_cb_wpautop', 9);
}
if ( ! function_exists( 'ux_cb_get_module_template' ) ) {
	/**
	 * Get The Module Template
	 */
	function ux_cb_get_module_template($moduleID, $atts, $content=false){
		global $ux_cb_module_fields;
		$html = '';
		
		$module = apply_filters('ux_cb_module_fields', array());
		$module = $module[$moduleID];
		
		$post_id = ux_cb_get_the_module_post_id($atts['unique']);
		
		$is_frontend = false;
		if(isset($_REQUEST['action']) || isset($_POST['postID'])){
			if($_REQUEST['action'] == 'edit' || $_POST['postID']){
				$is_frontend = false;
			}
		}else{
			$is_frontend = true;
		}
		
		if(isset($_REQUEST['isFrontend'])){
			if($_REQUEST['isFrontend'] == 'theme'){
				$is_frontend = true;
			}
		}
		
		$atts['default'] = false;
		if(!$post_id){
			$atts['default'] = true;
		}
		
		$module['postID'] = ux_cb_get_the_post_id();
		$module['unique'] = $atts['unique'];
		$module['is_frontend'] = false;
		if($is_frontend){
			//module class
			$moduleClass = array( 'module', 'col-' .esc_attr($atts['col']), 'module-id-' .esc_attr($atts['unique']) );
			$moduleClass = apply_filters( 'ux_cb_module_template_frontend_module_class', $moduleClass, $moduleID, $post_id );
			
			//module data tag
			$moduleDataTag = array( 'data-module-col="' .esc_attr($atts['col']). '"' );
			$moduleDataTag = apply_filters( 'ux_cb_module_template_frontend_module_data_tag', $moduleDataTag, $moduleID, $post_id );
			
			//module inside style
			$moduleInsideStyle = array();
			$moduleInsideStyle = apply_filters( 'ux_cb_module_template_frontend_module_inside_style', $moduleInsideStyle, $moduleID, $post_id );
			
			//module inside class
			$moduleInsideClass = array();
			$moduleInsideClass = apply_filters( 'ux_cb_module_template_frontend_module_inside_class', $moduleInsideClass, $moduleID, $post_id );
			
			//animation
			if($scrollInAnimation = get_post_meta($post_id, '__ux_cb_module_scroll_in_animation', true)){
				if($scrollInAnimation == 'on'){
					$moduleClass[] = 'moudle_has_animation';
				}
			}

			//Group height
			$groupHeightType = false;
			$groupHeightType = get_post_meta($post_id, '__ux_cb_module_group_height_type', true);
			if( $groupHeightType === 'auto') {
				$moduleClass[] = 'bm-wrap-height-auto';
			}

			//Disable Gap
			$disableGap = false;
			$disableGap = get_post_meta( $post_id, '__ux_cb_module_group_disable_gap', true );
			if( $disableGap === 'on') {
				$moduleClass[] = 'bm-wrap-no-gap';
			}
			
			//offset
			if ( $offset = get_post_meta( $post_id, '__ux_cb_module_offset_base', true ) ) {
				$moduleClass[] = $offset;
			}
			
			$module['is_frontend'] = true;
			$moduleClass = array_unique( $moduleClass );
			$moduleDataTag = array_unique( $moduleDataTag );
			
			$html .= '<div class="' .esc_attr( join( ' ', $moduleClass ) ). '" ' .join( ' ', $moduleDataTag ). '>';
			$html .=   '<div class="module-inside ' .esc_attr( join( ' ', $moduleInsideClass ) ). '" style="' .esc_attr( join( ' ', $moduleInsideStyle ) ). '">';
			$html .=     apply_filters('ux_cb_module_container_' .$moduleID, $module, $atts['unique'], $content);
			$html .=   '</div>';
			$html .= '</div>';
		}else{
			$hasModules = get_post_meta($module['postID'], 'modules', true);
			if(!$hasModules){
				$hasModules = array();
			}
			
			if(!in_array($module['unique'], $hasModules)){
				$loop_post_id = ux_cb_get_the_module_post_id($module['unique']);
				if($loop_post_id){
					if ( ! $originalFields = get_post_meta( $loop_post_id, 'originalFields', true ) ) {
						$custom_keys = get_post_custom_keys($loop_post_id);
						list($t1, $t2) = explode(' ', microtime()); 
						$moduleTargetUnique = $t2 .  ceil( ($t1 * 1000) );
						
						$target_post_id = ux_cb_get_the_module_post_id($moduleTargetUnique);
						if(!$target_post_id){
							$post_fields = array(
								'post_title' => $moduleTargetUnique,
								'post_name' => $moduleTargetUnique,
								'post_status' => 'publish',
								'post_type' => 'ux-cb-modules'
							);
							
							$target_post_id = wp_insert_post($post_fields);
						}
						
						foreach($custom_keys as $key){
							$values = get_post_meta($loop_post_id, $key, true);
							update_post_meta($target_post_id, $key, $values);
						}
						
						$module['unique'] = $moduleTargetUnique;
						$atts['unique'] = $moduleTargetUnique;
					}
				}
			}
			
			$module['shortcode'] = '[' .$module['shortcodeTag']. ' unique="' .$atts['unique']. '" col="' .$atts['col']. '"]';
			
			if($moduleID == 'text' || $moduleID == 'group'){
				$module['shortcode'] = '[' .$module['shortcodeTag']. ' unique="' .$atts['unique']. '" col="' .$atts['col']. '"]' .$content. '[/' .$module['shortcodeTag']. ']';
			}
			
			$html .= $ux_cb_module_fields->templates($module, $atts, $atts['default'], $content);
		}
		
		return $html;
	}
}
if ( ! function_exists( 'ux_cb_get_meta' ) ) {
	/**
	 * Get The post meta
	 */
	function ux_cb_get_meta( $moduleUnique, $name ) {
		$value = false;
		
		$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
		
		$postmeta = get_post_meta( $post_id, $name, true );
		if ( $postmeta ) {
			$value = $postmeta;
		}
		
		return $value;
	}
}
if ( ! function_exists( 'ux_cb_media_handle_upload' ) ) {
	/**
	 * Media handle upload
	 */
	function ux_cb_media_handle_upload( $url, $post_id = 0 ) {
		if ( ! function_exists( 'media_handle_upload' ) ) {
			require_once( ABSPATH . "wp-admin" . '/includes/image.php' );
			require_once( ABSPATH . "wp-admin" . '/includes/file.php' );
			require_once( ABSPATH . "wp-admin" . '/includes/media.php' );
		}
	
		$tmp = download_url( $url );
		if( is_wp_error( $tmp ) ){
			return;
		}
		$fileArray = array();
		preg_match('/[^\?]+\.(jpg|jpeg|jpe|gif|png|svg|otf|woff2|woff|ttf|eot|mp4)/i', $url, $matches);
		$fileArray['name'] = basename( $matches[0] );
		$fileArray['tmp_name'] = $tmp;
	
		if ( is_wp_error( $tmp ) ) {
			@unlink( $fileArray['tmp_name'] );
			$fileArray['tmp_name'] = '';
		}
		
		$imageID = media_handle_sideload( $fileArray, $post_id );
	
		if ( is_wp_error( $imageID ) ) {
			@unlink( $fileArray['tmp_name'] );
		}
	
		return $imageID;
	}
}
if ( ! function_exists( 'ux_cb_ins_get_record_data' ) ) {
	/**
	 * ins get record data
	 */
	function ux_cb_ins_get_record_data( $name ) {
		$output = false;
		
		if ( $optionData = get_option( 'ux_cb_ins_record_data' ) ) {
			if ( is_array( $optionData ) ) {
				foreach ( $optionData as $data ) {
					if ( $data['name'] == $name ) {
						$output = $data['id'];
					}
				}
			}
		}
		
		return $output;
	}
}
if ( ! function_exists( 'ux_cb_ins_update_record_data' ) ) {
	/**
	 * ins update record data
	 */
	function ux_cb_ins_update_record_data( $name, $id ) {
		$recordData = array();
		
		if ( $optionData = get_option( 'ux_cb_ins_record_data' ) ) {
			if ( is_array( $optionData ) ) {
				$recordData = $optionData;
			}
		}
		$recordData[] = array( 'name' => $name, 'id' => $id );
		update_option( 'ux_cb_ins_record_data', $recordData );
	}
}
if ( ! function_exists( 'ux_cb_ins_set_record_data' ) ) {
	/**
	 * ins set record data
	 */
	function ux_cb_ins_set_record_data( $name, $imgUrl ) {
		$output = false;
		
		if ( $imgID = ux_cb_ins_get_record_data( $name ) ) {
			$output = $imgID;
		} else {
			if ( $imgID = ux_cb_media_handle_upload( $imgUrl ) ) {
				ux_cb_ins_update_record_data( $name, $imgID );
				update_post_meta( $imgID, 'original-image-url', $imgUrl );
				$output = $imgID;
			}
		}
		
		return $output;
	}
}
if ( ! function_exists( 'ux_cb_create_uq' )  ) {
	function ux_cb_create_uq() {
		list( $t1, $t2 ) = explode( ' ', microtime() ); 
		$uq = $t2 .ceil( ( $t1 * 1000 ) );
		
		return $uq;
	}
}

if ( ! function_exists( 'ux_cb_save_post' ) ) {
	function ux_cb_save_post( $post_id ) {
		$post = get_post( $post_id );
		if ( $post->post_content == '') {
			$post_fields = array(
				'ID' => $post_id,
				'post_content' => ' '
			);
			
			wp_update_post( $post_fields );
		}
	}
	add_action( 'save_post', 'ux_cb_save_post' );
} 

if ( ! function_exists( 'ux_cb_let_to_num' ) ) {
	function ux_cb_let_to_num( $size ) {
		$l    = substr( $size, -1 );
		$ret  = substr( $size, 0, -1 );
		$byte = 1024;
	
		switch ( strtoupper( $l ) ) {
			case 'P':
				$ret *= 1024;
				// No break.
			case 'T':
				$ret *= 1024;
				// No break.
			case 'G':
				$ret *= 1024;
				// No break.
			case 'M':
				$ret *= 1024;
				// No break.
			case 'K':
				$ret *= 1024;
				// No break.
		}
		return $ret;
	}
}

if ( ! function_exists( 'ux_cb_clean' ) ) {
	function ux_cb_clean( $var ) {
		if ( is_array( $var ) ) {
			return array_map( 'ux_cb_clean', $var );
		} else {
			return is_scalar( $var ) ? sanitize_text_field( $var ) : $var;
		}
	}
}

if ( ! function_exists( 'ux_cb_server_database_version' ) ) {
	function ux_cb_server_database_version() {
		global $wpdb;
	
		if ( empty( $wpdb->is_mysql ) ) {
			return array(
				'string' => '',
				'number' => '',
			);
		}
	
		if ( $wpdb->use_mysqli ) {
			$server_info = mysqli_get_server_info( $wpdb->dbh ); // @codingStandardsIgnoreLine.
		} else {
			$server_info = mysql_get_server_info( $wpdb->dbh ); // @codingStandardsIgnoreLine.
		}
	
		return array(
			'string' => $server_info,
			'number' => preg_replace( '/([^\d.]+).*/', '', $server_info ),
		);
	}
}

if ( ! function_exists( 'ux_cb_get_mod_config' ) ) {
	function ux_cb_get_mod_config( $moduleID, $key, $attribute='type' ) {
		$output = false;
		
		$moduleFields = apply_filters( 'ux_cb_module_fields', array() );
		if ( count( $moduleFields ) ) {
			foreach ( $moduleFields as $module_id => $module ) {
				if ( $moduleID == $module_id ) {
					foreach ( $module['region'] as $regionNum => $region ) {
						foreach ( $region['section'] as $sectionNum => $section ) {
							foreach ( $section['group'] as $groupNum => $group ) {
								foreach ( $group['items'] as $item ) {
									$item = wp_parse_args( $item, array(
										'type' => '',
										'name' => ''
									) );
									
									if ( $item['name'] == $key ) {
										switch ( $attribute ) {
											default: $output = $item[$attribute]; break;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return $output;
	}
}

//wp kses allowed html
if ( ! function_exists( 'ux_cb_kses_allowed_html' ) ) {

	function ux_cb_kses_allowed_html() {

		$ux_allowed_tags = array(
			'a' => array(
				'class' => array(),
				'href'  => array(),
				'rel'   => array(),
				'title' => array(),
				'id'	=> array(),
				'data-filter'=> array(),
				'data-catid'=> array(),
				'data-postid'=> array()
			),
			'abbr' => array(
				'title' => array(),
				'class' => array(),
			),
			'b' => array('class' => array(),),
			'br' => array(),
			'blockquote' => array(
				'cite'  => array(),
				'class' => array(),
			),
			'cite' => array(
				'title' => array(),
				'class' => array(),
			),
			'code' => array('class' => array(),),
			'del' => array(
				'datetime' => array(),
				'title' => array(),
			),
			'dd' => array(),
			'div' => array(
				'id'    => array(),
				'class' => array(),
				'title' => array(),
				'style' => array(),
				'data-bg' => array(),
				'data-unique' => array(),
				'data-source' => array(),
				'data-col' => array(),
				'data-found' => array(),
				'data-number' => array(),
				'data-mod' => array(),
				'data-ratio' => array(),
				'data-paged' => array(),
				'data-postid' => array(),
				'data-max' => array()
			),
			'dl' => array(),
			'dt' => array(),
			'em' => array(),
			'h1' => array('class' => array(),),
			'h2' => array('class' => array(),),
			'h3' => array('class' => array(),),
			'h4' => array('class' => array(),),
			'h5' => array('class' => array(),),
			'h6' => array('class' => array(),),
			'i' => array('class' => array(),),
			'iframe' => array(
				'width' => array(),
				'height' => array(),
				'src' => array(),
				'data-src' => array(),
				'frameborder' => array(),
				'allowfullscreen' =>array(),
				'webkitallowfullscreen' =>array(),
				'mozallowfullscreen' =>array(),
				'class' => array(),
			),
			'img' => array(
				'alt'    => array(),
				'class'  => array(),
				'height' => array(),
				'src'    => array(),
				'data-src' => array(),
				'width'  => array(),
			),
			'li' => array(
				'class' => array(),
			),
			'ol' => array(
				'class' => array(),
			),
			'p' => array(
				'class' => array(),
			),
			'q' => array(
				'cite' => array(),
				'title' => array(),
			),
			'section' => array(
				'class' => array(),
			),
			'span' => array(
				'class' => array(),
				'title' => array(),
				'style' => array(),
			),
			'p' => array(
				'class' => array(),
			),
			'li' => array(
				'class' => array(),
			),
			'strike' => array(),
			'strong' => array(),
			'style' => array(),
			'ul' => array(
				'class' => array(),
			),
			'svg' => array(
				'width' => array(),
				'height' => array(),
				'viewbox' => array(),
				'version' => array(),
				'xmlns' => array(),
				'xmlns:xlink' => array(),
			),
			'g' => array(
				'stroke' => array(),
				'stroke-width' => array(),
				// 'fill' => array(),
				'fill-rule' => array(),
			),
			'path' => array(
				'd' => array(),
				'id' => array(),
				'stroke' => array(),
				'stroke-width' => array(),
				'fill' => array()
			),
			'polyline' => array(
				'stroke' => array(),
				'stroke-width' => array(),
				'stroke-linejoin' => array(),
				'stroke-miterlimit' => array(),
				'points' => array(),
				'fill' => array()
			),
			'rect' => array(
				'x' => array(),
				'y' => array(),
				'stroke' => array(),
				'stroke-width' => array(),
				'width' => array(),
				'height' => array()
			),
			'video' => array(
				'class' => array(),
				'width' => array(),
				'height' => array(),
				'controls' => array(),
				'loop' => array(),
				'playsinline' => array(),
				'autoplay' => array(),
				'muted' => array(),
				'src' => array(),
				'data-src' => array(),
			),
			'source' => array(
				'class' => array(),
				'type' => array(),
				'src' => array(),
				'data-src' => array(),
			)
		);
		
		return $ux_allowed_tags;
	}
}

if ( ! function_exists( 'ux_cb_serialize_corrector' ) ) {
	function ux_cb_serialize_corrector( $serializedString ) {
		if ( @unserialize( $serializedString ) !== true &&  preg_match('/^[aOs]:/', $serializedString ) ) {
			$serializedString = preg_replace_callback( '/s\:(\d+)\:\"(.*?)\";/s', function( $matches ) {return 's:'.strlen( $matches[2]).':"'.$matches[2].'";'; }, $serializedString );
			$serializedString = preg_replace_callback(
				'/s:([0-9]+):\"(.*?)\";/',
				function ( $matches ) { return "s:".strlen($matches[2]).':"'.$matches[2].'";';     },
				$serializedString
			);
		}
		return $serializedString;
	}
}

if ( ! function_exists( 'ux_cb_remote_file_exist' ) ) {
	function ux_cb_remote_file_exist( $url ) {
		$return = false;
		if ( $getHeaders = wp_remote_get( $url) ) {
			if ( isset( $getHeaders['response'] ) ) {
				if ( $getHeaders['response']['code'] ) {
					if ( $getHeaders['response']['code'] == 200 ) {
						$return = true;
					}
				}
			}
		}
		return $return;
	}
}
?>