<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! function_exists( 'ux_cb_theme_config_fields' ) ) {
	/**
	 * theme config fields
	 */
	function ux_cb_theme_config_fields() {
		global $ux_theme_config_fields;
		
		$return = array();
		
		if ( $ux_theme_config_fields ) {
			if ( isset( $ux_theme_config_fields['general'] ) ) {
				foreach ( $ux_theme_config_fields as $areaSlug => $area ) {
					foreach ( $area['region'] as $regionNum => $region ) {
						foreach ( $region['section'] as $sectionNum => $section ) {
							foreach ( $section['group'] as $groupNum => $group ) {
								foreach ( $group['items'] as $item ) {
									if ( ( $item[ 'type' ] == 'upload' || $item[ 'type' ] == 'category' || $item[ 'type' ] == 'post' ) ||
										( $item[ 'type' ] == 'checkbox-group' && isset( $item[ 'taxonomy' ] ) ) ) {
										$item = wp_parse_args( $item, array(
											'pType'   => 'post'
										) );
										array_push( $return, array( 'name' => $item[ 'name' ], 'type' => $item[ 'type' ], 'pType' => $item['pType'] ) );
									}
								}
							}
						}
					}
				}
			} else {
				foreach ( $ux_theme_config_fields as $option ) {
					foreach ( $option[ 'section' ] as $section ) {
						if ( isset( $section[ 'item' ] ) ){
							foreach ( $section[ 'item' ] as $item ) {
								if ( ( $item[ 'type' ] == 'upload' || $item[ 'type' ] == 'category' || $item[ 'type' ] == 'page' ) ||
									 ( $item[ 'type' ] == 'checkbox-group' && isset( $item[ 'taxonomy' ] ) ) ) {
									array_push( $return, array( 'name' => $item[ 'name' ], 'type' => $item[ 'type' ] ) );
								}
								
								if ( isset( $item[ 'bind' ] ) ) {
									foreach ( $item[ 'bind' ] as $bind ) {
										if ( ( $bind[ 'type' ] == 'upload' || $bind[ 'type' ] == 'category' || $bind[ 'type' ] == 'page' ) || 
											 ( $bind[ 'type' ] == 'checkbox-group' && isset( $bind[ 'taxonomy' ] ) )  ) {
											array_push( $return, array( 'name' => $bind[ 'name' ], 'type' => $bind[ 'type' ] ) );
										}
									}
								}
							}
						}
					}
				}
			}
		}
		
		return $return;
	}
}

require_once ux_cb_path_dir( 'CONFIG_DIR', 'tools/config.php' );
require_once ux_cb_path_dir( 'AUTOLOAD_DIR', 'ux-cb-tools/tools-menus.php' );



?>