<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder register post type for modules.
 */
if ( ! function_exists( 'ux_cb_register_modules_post' ) ) {
	function ux_cb_register_modules_post() {
		register_post_type( 'ux-cb-modules', array( 'label' => __( 'Modules (CB)', 'bm-builder' ), 'show_ui' => true ) );
	}
	add_action( 'ux_cb_after_init', 'ux_cb_register_modules_post' );
}

/**
 * UX Content Builder modules module id column.
 */
if ( ! function_exists( 'ux_cb_modules_module_id_column' ) ) {
	function ux_cb_modules_module_id_column( $column, $post_id ) {
		if ( $column == 'module_id' ) {
			if ( $moduleID = get_post_meta( $post_id, 'module_id', true ) ) {
				echo '<div class="ux-cb-modules_posts_custom_column ux-cb-module-' .$moduleID. '-selector"></div>';
			}
		} else if ( $column == 'module_apply' ) {
			$module = get_post( $post_id );
			
			global $wpdb;
			$getPosts = $wpdb->get_results( $wpdb->prepare("
				SELECT 
				`$wpdb->postmeta`.`post_id` as 'ID',
				`$wpdb->postmeta`.`meta_key` as 'meta_key',
				`$wpdb->postmeta`.`meta_value` as 'meta_value',
				`$wpdb->posts`.`post_title` as 'post_title'
				
				FROM  $wpdb->postmeta, $wpdb->posts
				
				WHERE ((`$wpdb->postmeta`.`post_id` = `$wpdb->posts`.`ID`)
				AND (`$wpdb->postmeta`.`meta_key` LIKE '%s')
				AND (`$wpdb->postmeta`.`meta_value` LIKE '%s'))
				", 'modules', '%' .$module->post_name. '%'
			));
			
			if ( $getPosts ) {
				foreach ( $getPosts as $post ) {
					echo '<a href="#">' .$post->post_title. '</a>, ';
				}
			}
		}
	}
	add_filter( 'manage_ux-cb-modules_posts_custom_column', 'ux_cb_modules_module_id_column', 10, 3 );
}

/**
 * UX Content Builder modules module id columns.
 */
if ( ! function_exists( 'ux_cb_modules_module_id_columns' ) ) {
	function ux_cb_modules_module_id_columns( $columns ) {
		wp_enqueue_style( 'ux-cb-backend-style' );
		$columns[ 'module_id' ] = __( 'Module Type', 'bm-builder' );
		$columns[ 'module_apply' ] = __( '', 'bm-builder' );
		return $columns;
	}
	add_filter( 'manage_edit-ux-cb-modules_columns', 'ux_cb_modules_module_id_columns' );
}
?>