<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module field custom fonts group.
 */
if ( ! function_exists( 'ux_cb_module_field_custom_fonts_group' ) ) {
	function ux_cb_module_field_custom_fonts_group( $item, $post_id, $item_val, $get_val ) {
		if ( $item['type'] == 'customFontsGroup' ) {
			$groupFontSize = array( 'Size', '8px','10px', '11px', '12px', '13px', '14px', '15px', '16px', '17px', '18px', '19px', '20px', '22px', '24px', '26px', '28px', '30px', '32px','34px', '36px', '38px', '40px', '42px','44px','46px', '50px', '52px','56px', '60px', '62px','66px', '70px','72px','76px', '80px', '82px','86px', '90px','92px', '98px' );
			$groupFontSpacing = array( 'Spacing','0px','1px', '2px', '3px', '4px', '5px', '6px', '7px', '8px', '9px', '10px', '11px', '12px', '13px', '14px', '15px' );
			$groupFontMobileSize = array( 'Mobile Size', '8px','10px', '11px', '12px', '13px', '14px', '15px', '16px', '17px', '18px', '19px', '20px', '22px', '24px', '26px', '28px', '30px', '32px','34px', '36px', '38px', '40px', '42px','44px','46px', '50px', '52px','56px', '60px', '62px','66px', '70px','72px','76px', '80px', '82px','86px', '90px','92px', '98px' );
			$groupFontLineheight = array( 'Line Height', '1.0', '1.1','1.2','1.3','1.4','1.5','1.6','1.7','1.8','1.9', '2.0', '2.1','2.2','2.3','2.4','2.5','2.6','2.7','2.8','2.9', '3.0', '3.5', '4.0', '4.5', '5.0' );
			
			if ( $item['group'] ) {
				$group = explode( '|', $item['group'] );
				$item_val = $item['default'];
				$fontAssignment = get_option( 'ux-font-assignment' );
				$fontAssignmentNot = true;
				if ( $fontAssignment ) {
					$fontAssignmentNot = false;
					$item_val = $fontAssignment;
				} else {
					if ( is_array( $item_val ) ) {
						$itemValArray = array();
						foreach ( $item_val as $itemType => $itemVal ) {
							$itemValArray[$item['name']. '_' .$itemType] = $itemVal;
						}
						$item_val = $itemValArray;
					}
				}
				
				foreach ( $group as $groupType ) {
					$typeName = $item['name']. '_' .$groupType;
					if ( isset( $item_val[$typeName] ) ) {
						if ( ! is_array( $item_val[$typeName] ) ) {
							$item_val[$typeName] = array( $item_val[$typeName] );
						}
					}
				}
				
				$num = 1;
				if ( isset( $item_val[$item['name']. '_tag'] ) ) {
					$num = count( $item_val[$item['name']. '_tag'] );
				}
				
				for ( $i=0; $i<$num; $i++) {
					echo '<div class="ux-cb-module-field-fonts-group custom-fonts-group">';
					
					foreach ( $group as $groupType ) {
						$typeName = $item['name']. '_' .$groupType;
						$typeValue = false;
						if ( isset( $item_val[$typeName][$i] ) ) {
							$typeValue = $item_val[$typeName][$i];
						}
						
						$place = false;
						if ( is_array( $item['place'] ) ) {
							if ( isset( $item['place'][$groupType] ) ) {
								$place = $item['place'][$groupType];
							}
						}
						
						$dataLists = array();
						switch( $groupType ) {
							case 'family':
								$fontLists = get_option( 'ux-font-lists' );
								if ( $fontLists ) {
									$dataLists[] = array( 'name' => 'Default', 'value' => '-1' );
									foreach ( $fontLists as $fontItem ) {
										$unique = trim( $fontItem['value'] );
										$fontFields = get_option( 'ux-font-' .$unique );
										$dataLists[] = array( 'name' => $fontFields[0]['value'], 'value' => $unique );
									}
								}
							break;
							
							case 'spacing':
								foreach ( $groupFontSpacing as $fontSpacing ) { 
									$dataLists[] = array( 'name' => $fontSpacing, 'value' => $fontSpacing );
								}
							break;
							
							case 'size':
								foreach ( $groupFontSize as $fontSize ) { 
									$dataLists[] = array( 'name' => $fontSize, 'value' => $fontSize );
								}
							break;
							
							case 'm-size':
								foreach ( $groupFontMobileSize as $fontSize ) { 
									$dataLists[] = array( 'name' => $fontSize, 'value' => $fontSize );
								}
							break;
	
							case 'line_height':
								foreach ( $groupFontLineheight as $fontLineheight ) { 
									$dataLists[] = array( 'name' => $fontLineheight, 'value' => $fontLineheight );
								}
							break;
						}
						
						if ( $groupType == 'tag' ) {
							echo '<input name="' .esc_attr( $typeName ). '" type="text" value="' .esc_attr( $typeValue ). '" class="group-font-' .$groupType. ' regular-text" placeholder="' .esc_attr( $place ). '">';
						} else {
							echo '<select name="' .esc_attr( $typeName ). '" class="group-font-' .$groupType. '">';
							if ( count( $dataLists) ) {
								foreach ( $dataLists as $dataItem ) {
									$dataItemSelected = selected( $typeValue, $dataItem['value'], false );
									if ( $fontAssignmentNot ) {
										$dataItemSelected = selected( $typeValue, $dataItem['name'], false );
									}
									echo '<option value="' .esc_attr( $dataItem['value'] ). '" ' .$dataItemSelected. '>' .esc_html( $dataItem['name'] ). '</option>';
								}
							}else{
								echo '<option selected="selected" value="0">' .esc_html__( 'No options', 'bm-builder' ). '</option>';
							}
							echo '</select>';
						}
					}
					
					$hiddenAdd = $i == 0 ? false : 'hidden';
					$hiddenRemove = $i != 0 ? false : 'hidden';
					
					echo '<button type="button" class="button add-item ' .esc_attr( $hiddenAdd ). '">' .esc_html__('Add', 'bm-builder'). '</button>';
					echo '<button type="button" class="button remove-item ' .esc_attr( $hiddenRemove ). '">' .esc_html__('Remove', 'bm-builder'). '</button>';
					echo '</div>';
				}
			}
		}
	}
	add_action( 'ux_cb_module_fields_field', 'ux_cb_module_field_custom_fonts_group', 10, 4 );
}

?>