<?php
/**
 * UX Content Builder Tools config fields.
 */
if ( ! function_exists( 'ux_cb_tools_fields' ) ) {
	function ux_cb_tools_fields( $fields ) {
		$fields['ux-cb-tools'] = array(
			'id'          => 'ux-cb-tools',
			'title'       => esc_html__( 'Import Demo', 'bm-builder' ),
			'parent_slug' => 'theme-option',
			'callback'    => 'ux_cb_page_option_interface',
			'disabled'    => true,
			'saveBtn'     => 'hidden',
			'region'      => array(
				array(
					'region-id' => 'import-options',
					'title'     => esc_html__( 'Import Options', 'bm-builder' ),
					'default'   => true,
					'name'      => 'import_options',
					'trigger'   => true,
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										//Please choose a demo
										array('title'   => esc_html__( 'Select demo data', 'bm-builder' ),
											  'type'    => 'import-demo',
											  'name'    => 'import_data',
											  'desc'    => '',
											  'wrap'    => 'fullwidth' ),

										array('title'   => esc_html__( 'Tips:', 'sea-theme' ), 
											  'name'	=> 'import_tips',   
											  'desc'    => esc_html__( 'Please deactivate all plugins except the BM Content Builder before start importing.','sea-theme').'<br>'. esc_html__('Please do not active child theme. ','sea-theme').'<br>'.esc_html__('Please contact us by uiueux@gmail.com if you meet trouble.', 'sea-theme' ),
											  'wrap'    => 'fullwidth' ),
										  
										array('class'   => 'improt-data-btn',
											  'type'    => 'button',
											  'disabled' => true,
											  'text'    => esc_html__( 'Import', 'bm-builder' ),
											  'name'    => 'import_data_submit',
											  'wrap'    => 'fullwidth' ),



									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'export-options',
					'title'     => esc_html__( 'Export Options', 'bm-builder' ),
					'default'   => false,
					'name'      => 'export_options',
					'hidden'    => true,
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										//Export name
										array('title'   => esc_html__( 'Demo Name', 'bm-builder' ),
											  'type'    => 'text',
											  'name'    => 'export_demo_name' ),
											  
										//Select export data
										array('title'   => esc_html__( 'Select export data', 'bm-builder' ),
											  'type'    => 'select',
											  'name'    => 'export_data',
											  'default' => 'none',
											  'fields'  => array(
												  array( esc_html__( 'Select export data', 'bm-builder' ), 'none' ),
												  array( esc_html__( 'All Content Data', 'bm-builder' ), 'all' ),
												  array( esc_html__( 'Portfolio Data', 'bm-builder' ), 'ux-portfolio' ),
												  array( esc_html__( 'Post Data', 'bm-builder' ), 'post' ),
												  array( esc_html__( 'Theme Option Data', 'bm-builder' ), 'theme-option' )
											  ) ),
										
										//Export Data submit
										array('text'    => esc_html__( 'Export Data', 'bm-builder' ),
											  'type'    => 'button',
											  'class'   => 'export-data-btn',
											  'name'    => 'export_data_submit',
											  'ctrl'    => 'export_data,all|theme-option|ux-portfolio|post' )
									
									)
								)
							)
						)
					)
				)
			)
		);
		
		$fields['ux-cb-tools-system-status'] = array(
			'id'          => 'ux-cb-tools-system-status',
			'title'       => esc_html__( 'System Status', 'bm-builder' ),
			'parent_slug' => 'theme-option',
			'callback'    => 'ux_cb_page_option_interface',
			'disabled'    => true,
			'saveBtn'     => 'hidden',
			'region'      => array(
				array(
					'region-id' => 'theme-information',
					'title'     => esc_html__( 'Theme Information', 'bm-builder' ),
					'default'   => true,
					'name'      => 'theme_information',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										
										//Theme Name
										array('title'   => esc_html__( 'Theme Name', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'theme_name' ),
											  
										//Current Version
										array('title'   => esc_html__( 'Current Version', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'current_version' ),
											  
										//Theme Directory
										array('title'   => esc_html__( 'Theme Directory', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'theme_directory' ),
											  
										//Child Theme
										array('title'   => esc_html__( 'Child Theme', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'child_theme' ),
											  
										//License Activated
										array('title'   => esc_html__( 'License Activated', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'license_activated' )
									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'wordpress-environment',
					'title'     => esc_html__( 'WordPress environment', 'bm-builder' ),
					'default'   => false,
					'name'      => 'wordpress_environment',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										
										//Home URL
										array('title'   => esc_html__( 'Home URL', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'home_url' ),
											  
										//Site Url
										array('title'   => esc_html__( 'Site Url', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'site_url' ),
											  
										//WP Path
										array('title'   => esc_html__( 'WP Path', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'wp_path' ),
											  
										//WP Content Path
										array('title'   => esc_html__( 'WP Content Path', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'wp_content_path' ),
											  
										//WordPress version
										array('title'   => esc_html__( 'WordPress version', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'wordpress_version' ),
											  
										//WordPress multisite
										array('title'   => esc_html__( 'WordPress multisite', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'wordpress_multisite' ),
											  
										//WordPress memory limit
										array('title'   => esc_html__( 'WordPress memory limit', 'bm-builder' ),
											  'desc'    => wp_kses_post( sprintf( __( '256M at least. See: <a href="%s" target="_blank">How to increase the WordPress Memory Limit</a>', 'bm-builder' ), 'https://docs.woocommerce.com/document/increasing-the-wordpress-memory-limit/' ) ),
											  'type'    => 'systemStatus',
											  'name'    => 'wordpress_memory_limit' ),
											  
										//WordPress debug mode
										array('title'   => esc_html__( 'WordPress debug mode', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'wordpress_debug_mode' ),
											  
										//Language
										array('title'   => esc_html__( 'Language', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'language' )
									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'server-environment',
					'title'     => esc_html__( 'Server environment', 'bm-builder' ),
					'default'   => false,
					'name'      => 'server_environment',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										
										//Server Info
										array('title'   => esc_html__( 'Server Info', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'server_info' ),
											  
										//PHP Version
										array('title'   => esc_html__( 'PHP Version', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'php_version' ),
											  
										//PHP Post Max Size
										array('title'   => esc_html__( 'PHP Post Max Size', 'bm-builder' ),
											  'desc'    => 'post_max_size',
											  'type'    => 'systemStatus',
											  'name'    => 'php_post_max_size' ),
											  
										//PHP Time Limit
										array('title'   => esc_html__( 'PHP Time Limit', 'bm-builder' ),
											  'desc'    => 'max_execution_time',
											  'type'    => 'systemStatus',
											  'name'    => 'php_time_limit' ),
											  
										//PHP Max Input Vars
										array('title'   => esc_html__( 'PHP Max Input Vars', 'bm-builder' ),
											  'desc'    => 'max_input_vars',
											  'type'    => 'systemStatus',
											  'name'    => 'php_max_input_vars' ),
											  
										//MySQL Version
										array('title'   => esc_html__( 'MySQL Version', 'bm-builder' ),
											  'type'    => 'systemStatus',
											  'name'    => 'mysql_version' )
									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'active-plugins',
					'title'     => esc_html__( 'Active Plugins', 'bm-builder' ),
					'default'   => false,
					'name'      => 'active_plugins',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										
										//Active Plugins
										array('type'    => 'systemStatus',
											  'wrap'    => 'fullwidth',
											  'name'    => 'active_plugins' )
									)
								)
							)
						)
					)
				)
			)
		);
		
		$fields['ux-cb-slugs-portfolio'] = array(
			'id'          => 'ux-cb-slugs-portfolio',
			'title'       => esc_html__( 'ux-portfolio slug', 'bm-builder' ),
			'parent_slug' => 'theme-option',
			'callback'    => 'ux_cb_page_option_interface',
			'disabled'    => true,
			'region'      => array(
				array(
					'region-id' => 'general-settings',
					'title'     => esc_html__( 'Configure the portfolio slugs(URL)', 'bm-builder' ), 
					'default'   => true,
					'name'      => 'general_settings',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(

										//Current Version
										array('title'   => esc_html__( 'ux-portfolio', 'bm-builder' ),
											  'desc'    => esc_html__( 'You can set the custom slug for following post types. Use alphabets only. Leave empty to use default slug.', 'sea-theme' ),
											  'type'    => 'text',
											  'default' => 'ux-portfolio',
											  'dataType' => 'option',
											  'name'    => 'ux-post-type-slugs' )
										
									)
								)
							)
						)
					)
				)
			)
		);
		
		$fields['ux-cb-fix-module-meta'] = array(
			'id'          => 'ux-cb-fix-module-meta',
			'title'       => esc_html__( 'Fix Module Meta', 'bm-builder' ),
			'parent_slug' => 'theme-option',
			'callback'    => 'ux_cb_page_option_interface',
			'disabled'    => true,
			'saveBtn'     => 'hidden',
			'region'      => array(
				array(
					'region-id' => 'general-settings',
					'title'     => esc_html__( 'Find known rule', 'bm-builder' ), 
					'default'   => true,
					'name'      => 'general_settings',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										  
										array('title'   => esc_html__( 'Need to fix list', 'bm-builder' ),
											  'type'    => 'modMetaFixList',
											  'name'    => 'mod_meta_fix_list' )
										
									)
								)
							)
						)
					)
				)
			)
		);
		
		return $fields;
	}
	add_filter( 'ux_cb_module_fields', 'ux_cb_tools_fields' );
}
?>