<?php
/**
 * UX Content Builder Module Masonry Grid Config.
 */
 
//masonry grid config fields
function ux_cb_module_masonry_grid_fields($fields){
	$fields['masonry-grid'] = array(
		'id'           => 'masonry-grid',
		'animation'    => true,
		'title'        => esc_html__('Masonry Grid','bm-builder'),
		'content'      => '',
		'shortcodeTag' => 'ux_cb_masonry_grid', 
		'shortcode'    => '[ux_cb_masonry_grid unique="" col="12"]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__('Source','bm-builder'),
										  'desc'    => '',
										  'type'    => 'source',
										  'name'    => '__ux_cb_module_masonry_grid_source',
										  'default' => 'attachment',
										  'fields'  => array(
										  	array(esc_html__('Media Library','bm-builder'),        'attachment'),
											  array(esc_html__('Portfolio','bm-builder'),            'ux-portfolio'),
											  array(esc_html__('Post','bm-builder'),                 'post'),
											  array(esc_html__('WooCommerce Product','bm-builder'), 'product')
											  )),
								
									// gallery
									array('title'   => esc_html__('Select Images','bm-builder'),
										  'desc'    => '',
										  'type'    => 'gallery',
										  'name'    => '__ux_cb_module_masonry_grid_media_images',
										  'ctrl'    => '__ux_cb_module_masonry_grid_source,attachment'),
								
									// ux-portfolio-cat
									array('title'   => esc_html__('Choose a Category','bm-builder'),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_masonry_grid_category_ux-portfolio',
										  'ptype'   => 'ux-portfolio-cat',
										  'ctrl'    => '__ux_cb_module_masonry_grid_source,ux-portfolio'),
								
									// category
									array('title'   => esc_html__('Choose a Category','bm-builder'),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_masonry_grid_category_post',
										  'ptype'   => 'category',
										  'ctrl'    => '__ux_cb_module_masonry_grid_source,post'),
								
									// product_cat
									array('title'   => esc_html__('Choose a Category','bm-builder'),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_masonry_grid_category_product',
										  'ptype'   => 'product_cat',
										  'ctrl'    => '__ux_cb_module_masonry_grid_source,product'),
								
									array('title'   => '',
										  'desc'    => '',
										  'type'    => 'custom-grid-layouts',
										  'text'    => esc_html__('Edit Your Portfolio Layout','bm-builder'),
										  'name'    => '__ux_cb_module_masonry_grid_layouts',
										  'source'  => '__ux_cb_module_masonry_grid_source',
										  'catname' => '__ux_cb_module_masonry_grid_category',
										  ),

									// Mobile layout
									array('title'   => esc_html__('keep original layout on mobile','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_origin_layout_mobile'),
								
										  
									array('type'    => 'divide'),
										  
									array('title'   => esc_html__( 'Item Spacing','bm-builder' ),
										  'desc'    => esc_html__( 'Insert a number, or leave it empty to use the Grid System default spacer','bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_masonry_grid_item_spacing',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									array('type'    => 'divide'),

									array('title'   => esc_html__('Fit Image into Container','bm-builder'),
										  'desc'	=> esc_html__('The image will not be cropped','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_img_fit_grid',
										  'default' => 'off'),

									array('title'   => esc_html__('Image Position in Container','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_img_posi',
										  'fields'  => array(
											  array(esc_html__('Center','bm-builder'), ''),
											  array(esc_html__('Top','bm-builder'), 'image_top')
										  ),
										  'default' => ''),
										  
									array('type'    => 'divide'),
								
									array('title'   => esc_html__('Show Filter','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_show_filter',
										  'default' => 'off'),

									array('title'   => esc_html__('Filter Align','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_filter_align',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'), 'filter_left'),
											  array(esc_html__('Center','bm-builder'), 'filter_center'),
											  array(esc_html__('Right','bm-builder'), 'filter_right'),
										  ),
										  'default' => 'filter_left',
										  'ctrl'    => '__ux_cb_module_masonry_grid_show_filter,on'
									),

									array('title'   => esc_html__('Filter Text Font','bm-builder'),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_filter_text_font',
										  'ctrl'    => '__ux_cb_module_masonry_grid_show_filter,on'),

									array('title'   => esc_html__('Filter Colour','bm-builder'),
											'desc'    => '',
											'type'    => 'colorPicker',
											'name'    => '__ux_cb_module_masonry_grid_style_image_text_filter_color',
											'ctrl'    => '__ux_cb_module_masonry_grid_show_filter,on'),
										  
									array('title'   => esc_html__('Filter Bottom Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'desc'    => '',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_masonry_grid_item_filter_spacing_bottom',
										  'ctrl'    => '__ux_cb_module_masonry_grid_show_filter,on',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									array('title'   => esc_html__('Filter Item Left Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_masonry_grid_item_filter_spacing_left',
										  'ctrl'    => '__ux_cb_module_masonry_grid_show_filter,on',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('20', '15'),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),

									array('title'   => esc_html__('Filter Item Right Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_masonry_grid_item_filter_spacing_right',
										  'ctrl'    => '__ux_cb_module_masonry_grid_show_filter,on',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array('20', '15'),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) 
									),
								
									array('title'   => esc_html__('Image Lazy Load','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_image_lazy_load',
										  'default' => 'on')
								 )
							 )
						 )
					 )
				 )
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__('Item Style','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_item_style',
										  'default' => 'image',
										  'fields'  => array(
											  array(esc_html__('Image','bm-builder'),        'image'),
											  array(esc_html__('Image + Text','bm-builder'), 'image-text')
										  ))
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image',
								'items'      => array(
									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect',
										  'default' => 'static-color-mask-text',
										  'ctrl'    => '__ux_cb_module_masonry_grid_source,ux-portfolio|post|product',
										  'fields'  => array(
											  array(esc_html__('Static Color Mask+Text','bm-builder'),     'static-color-mask-text'),
											  array(esc_html__('Second Featured Image','bm-builder'), 'show-second-featured-image'),
											  array(esc_html__('Second Featured Image+Text','bm-builder'), 'second-featured-image-text'),
											  array(esc_html__('No Effect','bm-builder'), 'no-effect')
										  )),
										  
									array('title'   => esc_html__('Mouseover Effect','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect-attachment',
										  'default' => 'static-color-mask-text',
										  'ctrl'    => '__ux_cb_module_masonry_grid_source,attachment',
										  'fields'  => array(
											  array(esc_html__('Static Color Mask+Text','bm-builder'), 'static-color-mask-text'),
											  array(esc_html__('No Effect','bm-builder'), 'no-effect')
										  )),
								
									array('title'   => esc_html__('Transparent for Mask','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_transparent_mask',
										  'default' => '1',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text',
										  'fields'  => array(
											  array(esc_html__('100%','bm-builder'), ''),
											  array(esc_html__('90%','bm-builder'),  '0.9'),
											  array(esc_html__('80%','bm-builder'),  '0.8'),
											  array(esc_html__('70%','bm-builder'),  '0.7'),
											  array(esc_html__('60%','bm-builder'),  '0.6'),
											  array(esc_html__('50%','bm-builder'),  '0.5'),
											  array(esc_html__('40%','bm-builder'),  '0.4'),
											  array(esc_html__('30%','bm-builder'),  '0.3'),
											  array(esc_html__('20%','bm-builder'),  '0.2'),
											  array(esc_html__('10%','bm-builder'),  '0.1'),
											  array(esc_html__('0%','bm-builder'),  '0.00000001'),
										  )),
										  
									array('title'   => esc_html__('Mask Colour','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_mask_color',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text')
								
								)
							)
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_masonry_grid_source,ux-portfolio|post',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image',
								'items'      => array(
									array('title'   => esc_html__( 'Text(Mouseover)','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_group',
										  'default' => array( 'title', 'category' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Category', 'bm-builder' ), 'category' )
										  )
									)
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image-text',
								'items'      => array(
									array('title'   => esc_html__( 'Text','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_text_group',
										  'default' => array( 'title', 'category' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Category', 'bm-builder' ), 'category' )
										  )
									)
								)
							)
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_masonry_grid_source,product',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image',
								'items'      => array(
									array('title'   => esc_html__( 'Text','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'name'    => '__ux_cb_module_masonry_grid_product_style_image_text_group',
										  'default' => array( 'title', 'price' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Price', 'bm-builder' ), 'price' )
										  )
									)
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image-text',
								'items'      => array(
									array('title'   => esc_html__( 'Text','bm-builder' ),
										  'desc'    => '',
										  'type'    => 'textGroup',
										  'name'    => '__ux_cb_module_masonry_grid_product_style_image_text_text_group',
										  'default' => array( 'title', 'price' ),
										  'fields'  => array(
											  array( esc_html__( 'Title', 'bm-builder' ), 'title' ),
											  array( esc_html__( 'Price', 'bm-builder' ), 'price' )
										  )
									)
								)
							)
						)
					),
					array(
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_masonry_grid_source,attachment',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image-text',
								'items'      => array( 

									array('title'   => esc_html__('Caption Text Font','bm-builder'),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_caption_text_font', 
										  'fontval' => array( 'family' => 'Poppins', 'weight' => 'normal', 'size' => '24px', 'lineheight' => '40px', 'letter_spacing' => 'normal', 'msize' => '14px' )), //family, weight, size, line height, letter spacing,
									
									array('title'   => esc_html__('Caption Text Colour','bm-builder'),
											'desc'    => '',
											'type'    => 'colorPicker',
											'name'    => '__ux_cb_module_masonry_grid_style_image_text_caption_color'),
								)

							), 
						)
					),
					array(		
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_masonry_grid_source,attachment',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image',
								'items'      => array(
										  
									array('title'   => esc_html__('Text Colour','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_masonry_grid_attachment_style_image_text_color',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect-attachment,static-color-mask-text')
								)
							),
						)
					),

					array(		
						'group' => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image',
								'items'      => array(
									array('title'   => esc_html__('Text Align','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_align',
										  'default' => 'grid-text-center',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),           'grid-text-left'),
											  array(esc_html__('Center','bm-builder'),         'grid-text-center'),
											  array(esc_html__('Right','bm-builder'),          'grid-text-right'),
											  array(esc_html__('Top Left','bm-builder'),       'grid-text-top-left'),
											  array(esc_html__('Top Center','bm-builder'),     'grid-text-top-center'),
											  array(esc_html__('Top Right','bm-builder'),      'grid-text-top-right'),
											  array(esc_html__('Bottom Left','bm-builder'),    'grid-text-bottom-left'),
											  array(esc_html__('Bottom Center','bm-builder'),  'grid-text-bottom-center'),
											  array(esc_html__('Bottom Right','bm-builder'),   'grid-text-bottom-right')
										  )
									),
									array('title'   => esc_html__('Text Padding on Left/Right','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_left_right_padding',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),
									array('title'   => esc_html__('Text Padding on Top/Bottom','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_top_bottom_padding',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_item_style,image-text',
								'items'      => array(
									array('title'   => esc_html__('Text Align','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_text_align',
										  'default' => 'grid-text-center',
										  'fields'  => array(
											  array(esc_html__('Left','bm-builder'),   'grid-text-left'),
											  array(esc_html__('Center','bm-builder'), 'grid-text-center'),
											  array(esc_html__('Right','bm-builder'),   'grid-text-right')
										  )),
										  
									array('title'   => esc_html__('Text Padding on Left/Right','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_show_text_left_right_padding',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_text_text_align,grid-text-left|grid-text-right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),
									
									array('title'   => esc_html__('Text Padding on Top','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_caption_text_top_spacing',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									array('title'   => esc_html__('Text Padding on Bottom','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_text_caption_text_bottom_spacing',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									)
								)
							), 
							array(
								'items' => array(
									array('title'   => esc_html__('List Inner Padding','bm-builder'),
										  'desc'    => '',
										  'type'    => 'multipleInput',
										  'inputType'=>'number',
										  'name'    => '__ux_cb_module_masonry_grid_style_inner_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									)
								)
							),
							array(
								'items' => array(
									array('title'   => esc_html__('List Background Colour','bm-builder'),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_masonry_grid_style_list_bg_color' ),
										  
									array('type'    => 'divide')
								)
							)
						)
					),
					array(		
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_masonry_grid_source,ux-portfolio|post',
						'group'        => array(
							array(
								'items' => array(
									array('title'   => esc_html__('What Thumbnail Does','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_style_image_what_thumb_does',
										  'default' => 'open-the-portfolio-item',
										  'fields'  => array(
											  array(esc_html__('Open The Portfolio/Post Item','bm-builder'), 'open-the-portfolio-item'),
											  array(esc_html__('Open Lightbox','bm-builder'), 'open-lightbox')
										  )
									),
									array('title'   => esc_html__('Open in New Window/Tab','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_what_thumb_does,open-the-portfolio-item',
										  'name'    => '__ux_cb_module_masonry_grid_what_thumb_does_new_tab',
										  'default' => 'off'
									),
									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_what_thumb_does,open-the-portfolio-item',
										  'name'    => '__ux_cb_module_masonry_grid_what_thumb_does_nofollow'),
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_style_image_what_thumb_does,open-lightbox',
								'items' => array(
									array('title'   => esc_html__('Open Second Featured Image in Lightbox','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_style_open_2nd_lighbox',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,show-second-featured-image|second-featured-image-text'
									),
									array('title'   => esc_html__('Click Title to Open the Portfolio/Post Item','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_style_click_title_open_item',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_masonry_grid_style_image_mouseover_effect,static-color-mask-text|second-featured-image-text'
									),
									array('title'   => esc_html__('Video Play Button Color','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_masonry_grid_style_videoplay_color',
									),
								),
							),
							
							array(
								'items' => array(
									array('type'    => 'divide'),
								)
							)
						)
					),
					array(		
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_masonry_grid_item_style,image',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_style_image_what_thumb_does,open-the-portfolio-item',
								'items' => array(
									array('title'   => esc_html__('Tap Once to Open Item on Touch Screen','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_style_touch_once',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_masonry_grid_source,ux-portfolio|post|product'
									),
									array('type'    => 'divide',
										'ctrl'    => '__ux_cb_module_masonry_grid_source,ux-portfolio|post|product'
									),
								)	
							)
						)
					),
					array(
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_source,attachment',
								'items' => array(
									array('title'   => esc_html__('What Thumbnail Does','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_masonry_grid_attachment_what_thumb_does',
										  'default' => 'open-lightbox',
										  'fields'  => array(
											  array(esc_html__('Open Lightbox','bm-builder'),   'open-lightbox'),
											  array(esc_html__('Open Custom URL','bm-builder'), 'open-custom-url'),
											  array(esc_html__('Nothing','bm-builder'),         'none')
				
										  )
									),
									array('title'   => esc_html__('Open in New Window/Tab','bm-builder'),
										  'desc'    => '',
										  'type'    => 'switch',
										  'ctrl'    => '__ux_cb_module_masonry_grid_attachment_what_thumb_does,open-custom-url',
										  'name'    => '__ux_cb_module_masonry_grid_attachment_what_thumb_does_new_tab',
										  'default' => 'off'
									),
									array('title'   => esc_html__('nofollow','bm-builder'),
										  'desc'    => esc_html__('It is necessary to enable it if the URL is an external link. ','bm-builder').'<a href="https://en.wikipedia.org/wiki/Nofollow" target="_blank" rel="noopener noreferrer nofollow">'.esc_html__('Learn more','bm-builder').'</a>',
										  'type'    => 'switch',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_masonry_grid_attachment_what_thumb_does,open-custom-url',
										  'name'    => '__ux_cb_module_masonry_grid_attachment_what_thumb_does_nofollow'),
										  
									array('type'    => 'divide')
								)
							)
						)
					),
					array(		
						'section-id'   => '',
						'section-ctrl' => '__ux_cb_module_masonry_grid_item_style,image',
						'group'        => array(
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_masonry_grid_source,attachment',
								'items' => array(
									array('title'   => esc_html__('Tap Once to Open Item on Touch Screen','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_masonry_grid_attachment_touch_once',
										  'default' => 'off',
										  'ctrl'    => '__ux_cb_module_masonry_grid_attachment_what_thumb_does,open-custom-url'
									),
									array('type'    => 'divide',
										'ctrl'    => '__ux_cb_module_masonry_grid_attachment_what_thumb_does,open-custom-url'
									)
								)	
							)
						)
					)
				)
			),
			array(
				'region-id' => 'custom-grid-layouts-settings',
				'title'     => esc_html__('Custom Grid Layouts','bm-builder'),
				'default'   => false,
				'hidden'    => true,
				'class'     => '',
				'name'      => '__ux_cb_module_custom_grid_layouts_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('type'    => 'ajax-content'),
										  
									array('type'    => 'divide'),
										  
									array('title'   => '',
										  'desc'    => '',
										  'class'   => 'custom-grid-layout-save-button',
										  'type'    => 'button',
										  'text'    => esc_html__('Save Item','bm-builder'),
										  'name'    => '__ux_cb_module_button_item_save')
								)
							)
						)
					)
				)
			)
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_masonry_grid_fields');
?>