(function($){

    "use strict";
	
	var UxCB                            = [];
	var UxCBModules                     = [];
	var uxMods                          = [];
	
	//window
	UxCB.win                            = $(window);
	
	//document
	UxCB.doc                            = $(document);
	
	//selector
	UxCB.body                           = $('body');
	UxCB.html                           = $('html');
	UxCB.toolAddModule                  = $('#ux-cb-page-options-add-module');
	UxCB.pageContentWrap                = $('#wp-content-wrap');
	UxCB.pageContentTextarea            = $('#content');
	UxCB.pageContentIframe              = $('#content_ifr');
	UxCB.pageOptionsButton              = $('#ux-cb-page-options-button');
	UxCB.pageCustomizeTools             = $('.ux-cb-customize-tools');
	UxCB.pageCustomizeSidebar           = $('.ux-cb-customize-sidebar');
	UxCB.pageCustomizePreview           = $('.ux-cb-customize-preview');
	UxCB.pageCustomizePreviewContainer  = $('.ux-cb-customize-preview-container');
	UxCB.pageCustomizeTemplates         = $('.ux-cb-customize-templates');
	UxCB.pageCustomizeTemplatesEditor   = UxCB.pageCustomizeTemplates.find('.wp-editor-wrap');
	UxCB.pageCustomizeTemplatesSelector = UxCB.pageCustomizeTemplates.find('.ux-cb-module-selector-tools');
	UxCB.pageCustomizeTemplatesColor    = UxCB.pageCustomizeTemplates.find('.ux-cb-module-theme-color');
	UxCB.pageCustomizeModuleSelector    = $('.ux-cb-customize-module-selector');
	UxCB.pageFullOverlay                = $('.ux-cb-full-overlay');
	UxCB.pageTemplatesSaveAsContainer   = $('.ux-cb-page-template-save-as-container');
	UxCB.pageChooseTemplates            = $('#ux-cb-choose-templates');
	UxCB.pluginPage                     = $('#ux-cb-current-plugin_page');
	UxCB.fontsPluginPageSave            = $('.__ux_theme_wrap[data-module-id*="ux-cb-fonts"] button.__ux_theme_save_button');
	UxCB.toolsPluginPageSave            = $('.__ux_theme_wrap[data-module-id*="ux-cb-tools"] button.__ux_theme_save_button');
	UxCB.slugsPluginPageSave            = $('.__ux_theme_wrap[data-module-id*="ux-cb-slugs"] button.__ux_theme_save_button');
	UxCB.module                         = UxCB.pageCustomizePreviewContainer.find('.module');
	UxCB.modal                          = UxCB.pageFullOverlay.find('.ux-modal');
	UxCB.modalTitle                     = UxCB.modal.find('.ux-modal-title');
	UxCB.modalBody                      = UxCB.modal.find('.ux-modal-body');
	UxCB.modalClose                     = UxCB.modal.find('.ux-modal-header .close');
	UxCB.modalSave                      = UxCB.modal.find('.ux-modal-header .save');
	UxCB.videoGuideWrap                 = $('#__ux_video_wrap');
	UxCB.videoGuidePlay					= $('#__ux_video_play_btn');
	UxCB.videoGuideClose				= UxCB.videoGuideWrap.find('#__ux_video_close');
	UxCB.videoIframe					= UxCB.videoGuideWrap.find('iframe');
	UxCB.blockEditor                    = $('.block-editor');
	
	UxCB.snButton                       = [];
	UxCB.snModule                       = [];
	UxCB.itemsAddClone                  = '';
	UxCB.addModulePrototype             = false;
	UxCB.addModuleGroupPosition         = false;
	UxCB.slideGroupTemplate             = false;
	UxCB.modalClickedOpenerEl           = '';
	UxCB.itemsFontsClone                = '';
	UxCB.activeModuleChangeRow          = false;
	UxCB.gridstackColumns               = 24;
	

	//Mark the browser
	function get_browser(){
		var ua=navigator.userAgent,tem,M=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || []; 
	    if(/trident/i.test(M[1])){
	        tem=/\brv[ :]+(\d+)/g.exec(ua) || []; 
	        return {name:'IE',version:(tem[1]||'')};
	        }   
	    if(M[1]==='Chrome'){
	        tem=ua.match(/\bOPR\/(\d+)/)
	        if(tem!=null)   {return {name:'Opera', version:tem[1]};}
	        }   
	    M=M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?'];
	    if((tem=ua.match(/version\/(\d+)/i))!=null) {M.splice(1,1,tem[1]);}
	    return {
	      name: M[0],
	      version: M[1]
	    };
	}
	
	var ux_browser = get_browser();
	var ux_browser_name = ux_browser.name;
	var ux_browser_version = ux_browser.version;

	if(navigator.appVersion.indexOf('Edge') > -1) {
		ux_browser_name = 'Edge';
		ux_browser_version = '';
	}
	
	UxCB.body.addClass(ux_browser_name + ux_browser_version);

	//Video Guide
	UxCB.videoGuide = function(){

		UxCB.videoGuidePlay.on('click',function(){
			var src = UxCB.videoIframe.attr('data-src').replace('autoplay=0', 'autoplay=1'); 
			if(!UxCB.videoGuideWrap.is(":visible")) {
				UxCB.videoGuideWrap.slideDown(300);
				UxCB.videoIframe.attr('src', src); 
			} else {
				UxCB.videoGuideWrap.slideUp(300);
				UxCB.videoIframe.attr('data-src', src).attr('src','');
			}
			return false;
		});
		UxCB.videoGuideClose.on('click',function(){
			if(UxCB.videoGuideWrap.is(":visible")) {
				UxCB.videoGuideWrap.slideUp(300); 
				UxCB.videoIframe.attr('data-src', src).attr('src','');
			}
			return false;
		});

	};
	
	//select control class
	UxCB.classSelectControl = function(selector, tagName){
		var itemRow = selector.parents('.ux-cb-module-field-item-row');
		
		switch(tagName){
			case 'SELECT':
				selector.change(function(event, triggerEvent, triggerResult){
					var thisName = $(this).attr('name');
					var thisValue = $(this).val();
					var thisControlContainer = $('tr[data-name="' +thisName+ '"], table[data-name="' +thisName+ '"], tbody[data-name="' +thisName+ '"]');
					
					if(thisControlContainer.length){
						thisControlContainer.each(function(){
							if($(this).is('.control-' +thisValue)){
								$(this).show();
							}else{
								$(this).hide();
							}
						});
					}
					
					switch(thisName){
						case '__ux_cb_module_fonts_resource': UxCB.fnLoadFontsResource($(this), triggerEvent, triggerResult); break;
						case '__ux_cb_module_single_image_svg_align':
							var svg = $('.__ux_cb_module_single_image_svg svg');
							UxCB.fnModuleSvgProcess(svg, 'single-image', false, false, thisValue);
						break;
					}
				});
			break;
			
			case 'BUTTON':
				selector.on('click', function(){
					var thisTextOn = $(this).data('text-on');
					var thisTextOff = $(this).data('text-off');
					var thisInput = $(this).next('input');
					var thisName = thisInput.attr('name');
					var thisControlContainer = $('tr[data-name="' +thisName+ '"], table[data-name="' +thisName+ '"], tbody[data-name="' +thisName+ '"]');
					var thisValue;
					
					switch(thisName){
						default:
							if($(this).hasClass('on')){
								$(this).removeClass('on').addClass('off').text(thisTextOff);
								thisValue = 'off';
							}else{
								$(this).removeClass('off').addClass('on').text(thisTextOn);
								thisValue = 'on';
							}
							thisInput.val(thisValue);
							
							if(thisControlContainer.length){
								thisControlContainer.each(function(){
									 if($(this).is('.control-' +thisValue)){
										 $(this).show();
									 }else{
										 $(this).hide();
									 }
								});
							}
						break;
					}
				});
			break;
			
			case 'UL':
				selector.find('> li').on('click', function(){
					var thisInput = selector.next('input');
					var thisName = thisInput.attr('name');
					var thisValue = $(this).attr('data-value');
					var thisControlContainer = $('tr[data-name="' +thisName+ '"], table[data-name="' +thisName+ '"], tbody[data-name="' +thisName+ '"]');
					
					thisInput.val(thisValue);
					
					if(thisControlContainer.length){
						thisControlContainer.each(function(){
							 if($(this).is('.control-' +thisValue)){
								 $(this).show();
							 }else{
								 $(this).hide();
							 }
						});
					}
				});
			break;
		}
		
		return selector;
	}
	
	//function convert string
	UxCB.fnConvertString = function(content){  
		var string = content;    
		try{  
			string = string.replace(/\r\n/g,"<br>")    
			string = string.replace(/\n/g,"<br>");    
		}catch(e) { }    
		return string;    
	}   
	
	//function theme color
	UxCB.fnThemeColor = function(colorID){
		if(colorID == ''){
			colorID = 'none';
		}
		
		var color = UxCB.pageCustomizeTemplatesColor.find('[data-value="' +colorID+ '"]');
		
		return color.data('rgb');
	}
	
	//function load fonts management container
	UxCB.fnLoadFontsManagementContainer = function(){
		var module = UxCB.pluginPage.parent('.__ux_theme_wrap');
		var moduleID = module.data('module-id');
		
		$.post(ajaxurl, {
			'action': 'ux_cb_ajax_load_module_fields',
			'moduleID': moduleID,
			'moduleUnique': UxCB.pluginPage.val()
		}).done(function(result){
			var content = $(result);
			
			if(content){
				UxCB.fnModuleFieldsProcess(content, module, false, module);
			}
		});
	}
	
	//function fonts management save ajax
	UxCB.fnFontsManagementSaveAjax = function(itemFields, moduleID, saveBtn, saveStatus, itemParents){
		saveBtn.text(saveStatus.ing);
		itemParents.css('opacity', 0.3).css('pointer-events','none');
		
		$.post(ajaxurl, {
			'action': 'ux_cb_fonts_lists_save',
			'itemFields': itemFields,
			'moduleID': moduleID
		}).done(function(result){
			result = UxCB.fnClearTrim(result);
			if(result == 'ok'){
				saveBtn.text(saveStatus.ed);
				itemParents.css('opacity', 1).css('pointer-events','auto');
				
				setTimeout(function(){
					saveBtn.text(saveStatus.sv);
				}, 100);
			}
		});
	}
	
	//function post type slugs save
	UxCB.fnPostTypeSlugSave = function(){
		UxCB.slugsPluginPageSave.each(function(){
			$(this).on('click', function(){
				var saveBtn = $(this),
					itemParents = $('.__ux_theme_wrap .ux-cb-module-fields-container'),
					itemFields = false,
					moduleID = UxCB.pluginPage.val(),
					textSave = saveBtn.data('save'),
					textSaving = saveBtn.data('saving'),
					textSaved = saveBtn.data('saved');
				
				var saveStatus = [];
				    saveStatus.ing = textSaving;
				    saveStatus.ed = textSaved;
				    saveStatus.sv = textSave;
				
				itemFields = itemParents.find('[name]').serializeArray();
				
				saveBtn.text(saveStatus.ing);
				itemParents.css('opacity', 0.3).css('pointer-events','none');

				$.post(ajaxurl, {
					'action': 'ux_cb_post_type_slugs_save',
					'itemFields': itemFields,
					'moduleID': moduleID
				}).done(function(result){
					result = UxCB.fnClearTrim(result);
					if(result == 'ok'){
						saveBtn.text(saveStatus.ed);
						itemParents.css('opacity', 1).css('pointer-events','auto');

						setTimeout(function(){
							saveBtn.text(saveStatus.sv);
							location.reload();
						}, 100);
					}
				});
			});
		});
	}
	
	//function fonts management save
	UxCB.fnFontsManagementSave = function(){
		UxCB.fontsPluginPageSave.each(function(){
			$(this).on('click', function(){
				var saveBtn = $(this);
				var itemParents = $('.__ux_theme_wrap .ux-cb-module-fields-container');
				var tabGeneralSettingsTab = itemParents.find('.ux-cb-module-field-region-tab[data-id="general-settings"]');
				var tabGeneralSettingsContent = itemParents.find('.ux-cb-module-field-region-content[id="general-settings"]');
				var tabSectionSettingsTab = itemParents.find('.ux-cb-module-field-region-tab[data-id="item-settings"]');
				var tabSectionSettingsContent = itemParents.find('.ux-cb-module-field-region-content[id="item-settings"]');
				var itemFields = false;
				var moduleID = UxCB.pluginPage.val();
				var textSave = saveBtn.data('save');
				var textSaving = saveBtn.data('saving');
				var textSaved = saveBtn.data('saved');
				
				var saveStatus = [];
				    saveStatus.ing = textSaving;
				    saveStatus.ed = textSaved;
				    saveStatus.sv = textSave;
				
				
				if(moduleID != 'ux-cb-fonts-definition'){
					itemFields = itemParents.find('[name]').serializeArray();
					UxCB.fnFontsManagementSaveAjax(itemFields, moduleID, saveBtn, saveStatus, itemParents);
				}else{
					if(!tabGeneralSettingsTab.hasClass('active')){
						var itemsItem = tabGeneralSettingsContent.find('.ux-cb-module-field-items > li.active');
						var unique = itemsItem.find('[name="_ux_cb_module_fonts_items"]');
						var itemName = tabSectionSettingsContent.find('[name="__ux_cb_module_fonts_style_name"]')
						var itemUnique = '';
						var doItemSave = true;
						
						if(unique.length){
							itemUnique = unique.val();
						}
						
						if(tabSectionSettingsContent.find('.item-save-button.itemsAdd').length){
							if(itemName.val() == ''){
								doItemSave = false;
								UxCB.itemsAddClone.remove();
								UxCB.itemsAddClone = '';
							}
							tabSectionSettingsContent.find('.item-save-button.itemsAdd').removeClass('itemsAdd');
						}
						
						if(doItemSave){
							saveBtn.text(saveStatus.ing);
							itemFields = tabSectionSettingsContent.find('[name]:visible').serializeArray();
							$.post(ajaxurl, {
								'action': 'ux_cb_fonts_definition_save',
								'itemFields': itemFields,
								'itemUnique': itemUnique
							}).done(function(result){
								var itemText = itemName.val();
								itemsItem.find('h6').text(itemText);
								itemsItem.find('input[name="_ux_cb_module_fonts_items"]').val(result);
								itemFields = tabGeneralSettingsContent.find('li [name]').serializeArray();
								UxCB.fnFontsManagementSaveAjax(itemFields, moduleID, saveBtn, saveStatus, itemParents);
							});
						}else{
							itemFields = tabGeneralSettingsContent.find('li [name]').serializeArray();
							UxCB.fnFontsManagementSaveAjax(itemFields, moduleID, saveBtn, saveStatus, itemParents);
						}
					}else{
						itemFields = tabGeneralSettingsContent.find('li:visible [name]').serializeArray();
						UxCB.fnFontsManagementSaveAjax(itemFields, moduleID, saveBtn, saveStatus, itemParents);
					}
				}
			});
		});
	}	
	
	//function load fonts Resource
	UxCB.fnLoadFontsResource = function(selector, triggerEvent, triggerResult){
		var name = selector.attr('name');
		var resource = selector.val();
		
		$.post(ajaxurl, {
			'action': 'ux_cb_fonts_load_resource',
			'resource': resource,
			'name': name,
			'triggerResult': triggerResult
		}).done(function(result){
			var wrap = $('#' +name+ '_' +resource);
			var content = $(result);
			
			wrap.html(content);
			
			switch(resource){
				case 'google-font':
					UxCB.fnLoadFontsStyle(resource, name, wrap, false, false);
					if(triggerEvent == 'itemsEdit'){
						var contentName = content.attr('name');
						$.each(triggerResult, function(index, field){
							if(contentName == field.name){
								content.val(field.value).trigger('change', [triggerEvent, triggerResult]);
							}
						});
					}
				break;
			}
		});
		
		if(resource == 'adobe-typekit'){
			var adobeTypekitSubmit = $('input[name="__ux_cb_module_fonts_resource_adobe-typekit-id"]').next();
			adobeTypekitSubmit.trigger('click', [triggerEvent, triggerResult]);
		}
	}
	
	//function adobe typekit submit
	UxCB.fnAdobeTypekitSubmit = function(content){
		var wrap = content.find('.ux-cb-module-fonts-adobe-typekit');
		
		wrap.find('.button').on('click', function(event, triggerEvent, triggerResult){
			var kitID = $(this).prev();
			var kitIdVal = kitID.val();
			var kitToken = content.find('.__ux_cb_module_fonts_resource_adobe-typekit-token [name="__ux_cb_module_fonts_resource_adobe-typekit-token"]');
			var kitTokenVal= kitToken.val();
			var resource = 'adobe-typekit';
			var name = '__ux_cb_module_fonts_resource';
			
			$.each(triggerResult, function(index, field){
				if(field.name == '__ux_cb_module_fonts_resource_adobe-typekit-token'){
					kitTokenVal = field.value;
				}else if(field.name == '__ux_cb_module_fonts_resource_adobe-typekit-id'){
					kitIdVal = field.value;
				}
			});
			
			if(kitID){
				$.post(ajaxurl, {
					'action': 'ux_cb_fonts_load_resource',
					'resource': resource,
					'name': name,
					'kitID': kitIdVal,
					'triggerResult': triggerResult
				}).done(function(result){
					var wrap = $('#' +name+ '_' +resource);
					var content = $(result);
					
					wrap.html(content);
					UxCB.fnLoadFontsStyle(resource, name, wrap, kitIdVal, kitTokenVal);
					
					if(triggerEvent == 'itemsEdit'){
						var contentName = content.attr('name');
						$.each(triggerResult, function(index, field){
							if(contentName == field.name){
								content.val(field.value).trigger('change', [triggerEvent, triggerResult]);
							}
						});
					}
				});
			}
		});
	}
	
	//function load fonts style
	UxCB.fnLoadFontsStyle = function(resource, name, wrap, kitID, kitToken){
		var fontFamily = wrap.find('select[name="__ux_cb_module_fonts_resource_' +resource+ '_family"]');
		
		fontFamily.change(function(event, triggerEvent, triggerResult){
			var fontFamilyVal = $(this).val();
			var fontFamilyText = fontFamily.find('[value="' +fontFamilyVal+ '"]').text();
			var fontStyle = wrap.find('select[name="__ux_cb_module_fonts_resource_' +resource+ '_style"]');
			var fontSubset = wrap.find('.ux-cb-module-field-checkbox-group');
			
			fontStyle.remove(); fontSubset.remove();
			if(fontFamilyVal != -1){
				fontFamily.attr('disabled', 'disabled');
				fontFamily.find('[value="' +fontFamilyVal+ '"]').prepend('Loading... ');
				$.post(ajaxurl, {
					'action': 'ux_cb_fonts_load_fonts_style',
					'name': name,
					'fontFamily': fontFamilyVal,
					'resource': resource,
					'kitID': kitID,
					'kitToken': kitToken,
					'triggerResult': triggerResult
				}).done(function(result){
					fontFamily.after(result);
					fontFamily.removeAttr('disabled');
					fontFamily.find('[value="' +fontFamilyVal+ '"]').text(fontFamilyText);
				});
			}
		});
	}
	
	UxCB.fnHtmlEncode = function(str) {
		var s = "";
		if (str.length === 0) {
		return "";
		}
		s = str.replace(/&/g, "&amp;");
		s = s.replace(/</g, "&lt;");
		s = s.replace(/>/g, "&gt;");
		s = s.replace(/ /g, "&nbsp;");
		s = s.replace(/\'/g, "&#39;");
		s = s.replace(/\"/g, "&quot;");
		return s;
	}
	
	//function load preview container
	UxCB.fnLoadPreviewContainer = function(){
		var content = ''
		var editorName = 'classic-editor';
		var textareaContent = $('#ux-cb-page-customize-textarea-content');
		if(UxCB.pageContentWrap.is('.tmce-active')){
			content = tinyMCE.get('content').getContent();
		}else if(UxCB.pageContentWrap.is('.html-active')){
			content = UxCB.pageContentTextarea.val();
		}
		
		if(UxCB.blockEditor.length){
			editorName = 'block-editor';
			if(textareaContent.length){
				if(textareaContent.val() != ''){
					content = textareaContent.val();
				}
			}
		}else{
			if(content == '' && textareaContent.length){
				if(textareaContent.val() != ''){
					content = textareaContent.val();
					UxCB.pageContentTextarea.val(content);
				}
			}
		}
		
		if(content != ''){
			UxCB.pageCustomizePreview.addClass('has-content');
			var postID = $('#post_ID').val();
			$.post(ajaxurl, {
				'action': 'ux_cb_customize_preview_container_ajax',
				'content': UxCB.fnHtmlEncode(content),
				'postID': postID,
				'editor': editorName
			}).done(function(result){
				UxCB.pageCustomizePreview.find('> .ux-cb-module-loading').addClass('hidden');
				
				if(result == 'not_ux_cb_wrap'){
					UxCB.pageCustomizeModuleSelector.find('button[data-module-id="text"]').trigger('click', content);
				}else{
					UxCB.pageCustomizePreviewContainer.html(result);
					UxCB.module = UxCB.pageCustomizePreviewContainer.find('.module');
					//page module
					if(UxCB.module.length){
						UxCB.module.each(function(){
							var module = $(this);
							var moduleID = module.data('module-id');
							var moduleDefault = module.data('default');
							var moduleUnique = module.data('module-unique');
							var moduleContent = module.find('> .module-inside > .module-content');
							var moduleBorder = module.find('> .module-inside > .module-border');
							
							if(moduleContent.is('.sub-module-sortable')){
								UxCB.fnModuleSortable(moduleContent);
							}
							
							UxCB.fnModuleHover(module);
							
							switch(moduleID){
								case 'masonry-grid':
									if(module.find('.grid-stack').length){
										UxCB.fnGridStackResize(module.find('.grid-stack'));
									}
								break;
								case 'grid':
									UxCB.fnModuleFieldCustomGridLoaded(module);
									if(module.find('.masonry-list')){
										if(module.find('.masonry-list').isotope()){
											module.find('.masonry-list').isotope('layout');
										}
									}
								break;
								case 'slider':
									if(module.find('.owl-carousel').length){
										UxCB.fnModuleCarousel(module.find('.owl-carousel'));
									}
								break;
							}
							
							if(module.hasClass('col-0')){
								var containerWidth = UxCB.pageCustomizePreviewContainer.outerWidth();
								var containerMargin = UxCB.pageCustomizePreviewContainer.css('padding-left');
								
								module.css({
									// 'margin-left': '-' +containerMargin,
									// 'margin-right': '-' +containerMargin,
									// 'width': containerWidth+ 'px'
								});
							}
							
							UxCB.fnModEditToolsEvent(module);
							
							switch(moduleID){
								case 'masonry-grid':
									if(moduleDefault){
										$.post(ajaxurl, {
											'action': 'ux_cb_module_field_custom_grid_layouts_ajax',
											'catID': '',
											'postID': postID,
											'source': 'ux-portfolio',
											'taxonomy': 'ux-portfolio-cat',
											'moduleUnique': moduleUnique
										}).done(function(result){
											var content = $(result),
												cellHeight = UxCB.fnGridstackCellHeight(UxCB.pageCustomizePreviewContainer.find('[data-module-unique="' +moduleUnique+ '"] > .module-inside > .module-content'), 20);
											
											UxCB.pageCustomizePreviewContainer.find('[data-module-unique="' +moduleUnique+ '"] > .module-inside > .module-content').html(result);
											UxCB.pageCustomizePreviewContainer.find('[data-module-unique="' +moduleUnique+ '"] > .module-inside > .module-content').find('.grid-stack').gridstack({
												verticalMargin: 20,
												width: UxCB.gridstackColumns,
												cellHeight: cellHeight,
												resizable: {
													handles: 'e, se, s, sw, w'
												}
											});
										});
									}else{
										if(module.find('.grid-stack').length){
											UxCB.fnGridStackResize(module.find('.grid-stack'));
										}
									}
								break;
								case 'grid':
									UxCB.fnModuleFieldCustomGridLoaded(module);
								break;
								case 'single-image':
									var embed = module.find('.single-image-embed');
									if(embed.length){
										UxCB.fnModuleSingleImageEmbed(embed);
									}
								break;
							}
						});
						UxCB.fnModuleRefreshSort();
					}
				}
			});
		}else{
			UxCB.pageCustomizePreview.find('> .ux-cb-module-loading').addClass('hidden');
			UxCB.pageCustomizePreview.removeClass('has-content');
			UxCB.pageCustomizePreviewContainer.html('');
			UxCB.pageCustomizeModuleSelector.addClass('fadein');
			setTimeout(function(){
				UxCB.pageCustomizeModuleSelector.addClass('on');
			}, 500);
			setTimeout(function(){
				UxCB.pageCustomizeModuleSelector.find('h1').addClass('fadein');
			}, 1000);
		}
	}
	
	//function module single image embed
	UxCB.fnModuleSingleImageEmbed = function(embed){
		var embedSrc = embed.attr('datasrc');
		var svgColor = embed.attr('data-color');
		var svgColorMouseover = embed.attr('data-color-mouseover');
		var svgColorFill = embed.attr('data-color-fill');
		var svgColorMouseoverFill = embed.attr('data-color-mouseover-fill');
		var svgWidth = embed.attr('data-width');
		
		$.get(embedSrc, 'html').done(function(result){
			var svg = $(result).find('svg');
			
			svg.find('path').css('stroke', svgColor).css('fill', svgColorFill);
			svg.find('rect').css('stroke', svgColor).css('fill', svgColorFill);
			svg.find('circle').css('stroke', svgColor).css('fill', svgColorFill);
			svg.find('ellipse').css('stroke', svgColor).css('fill', svgColorFill);
			svg.find('line').css('stroke', svgColor).css('fill', svgColorFill);
			svg.find('polyline').css('stroke', svgColor).css('fill', svgColorFill);
			svg.find('polygon').css('stroke', svgColor).css('fill', svgColorFill);
			svg.hover(function(){
				svg.find('path').css('stroke', svgColorMouseover).css('fill', svgColorMouseoverFill);
				svg.find('rect').css('stroke', svgColorMouseover).css('fill', svgColorMouseoverFill);
				svg.find('circle').css('stroke', svgColorMouseover).css('fill', svgColorMouseoverFill);
				svg.find('ellipse').css('stroke', svgColorMouseover).css('fill', svgColorMouseoverFill);
				svg.find('line').css('stroke', svgColorMouseover).css('fill', svgColorMouseoverFill);
				svg.find('polyline').css('stroke', svgColorMouseover).css('fill', svgColorMouseoverFill);
				svg.find('polygon').css('stroke', svgColorMouseover).css('fill', svgColorMouseoverFill);
			}, function(){
				svg.find('path').css('stroke', svgColor).css('fill', svgColorFill);
				svg.find('rect').css('stroke', svgColor).css('fill', svgColorFill);
				svg.find('circle').css('stroke', svgColor).css('fill', svgColorFill);
				svg.find('ellipse').css('stroke', svgColor).css('fill', svgColorFill);
				svg.find('line').css('stroke', svgColor).css('fill', svgColorFill);
				svg.find('polyline').css('stroke', svgColor).css('fill', svgColorFill);
				svg.find('polygon').css('stroke', svgColor).css('fill', svgColorFill);
			});
			
			if(Number(svgWidth)){
				svg.width(svgWidth).height('auto');
			}
			
			embed.after(svg);
			embed.remove();
		});
	}
	
	//function module selector tools clone
	UxCB.fnModuleSelectorToolsClone = function(target, direction){
		var moduleSelector = UxCB.pageCustomizeTemplatesSelector.clone();
	
		//page module selector tools
		UxCB.moduleSelectorTools = moduleSelector.find('.module-selector-tools');
		if(UxCB.moduleSelectorTools.length){
			if(target.is('.module-content') || target.parent().is('.module-content')){
				UxCB.moduleSelectorTools.find('button.ux-cb-module-group-selector').remove();
			}
			UxCB.moduleSelectorTools.find('button').each(function(){
				var btn = $(this);
				
				UxCB.fnModuleSelectorButton(btn);
			});
		}
		
		if(target.length){
			switch(direction){
				case 'before': target.before(moduleSelector.find('.item')); break;
				case 'after': target.after(moduleSelector.find('.item')); break;
				case 'append': target.append(moduleSelector.find('.item')); break;
			}
		}
		
		console.log(target);
		console.log(direction);
	}
	
	//function module get attribute
	UxCB.fnGetModuleAttr = function(module){
		if(module){
			var moduleAttr = [];
			
			moduleAttr.id = module.attr('data-module-id');
			moduleAttr.col = module.attr('data-module-col');
			moduleAttr.unique = module.attr('data-module-unique');
			moduleAttr.content = module.find('> .module-inside > .module-content');
			
			return moduleAttr;
		}
	}
	
	//function module refresh sort
	UxCB.fnModuleRefreshSort = function(container){
		container = container || UxCB.pageCustomizePreviewContainer.find('.bm-builder');
		
		var containerWidth = container.width();
		var containerModuleWidthSum = 0;
		var modules = container.find('> .module');
		var moduleRowNum = 0;
		var groupModules = container.find('[data-module-id="group"]');
		//var itemSelector = container.find('> .item.selector');
		
		container.find('.module-change-row').remove();
		container.removeClass('relative');
		
		if(groupModules.length){
			container.addClass('relative');
		}
		
		//itemSelector.remove();
		if(modules.length){
			modules.each(function(index){
				var module = $(this);
				var moduleContent = module.find('> .module-inside > .module-content');
				var moduleBorder = module.find('> .module-inside > .module-border');
				var moduleWidth = module.width();
				var moduleCol = Number(module.attr('data-module-col'));
				var buttonMoveUp = module.find('> .module-inside > .module-edit-tools > .move-up');
				var buttonMoveDown = module.find('> .module-inside > .module-edit-tools > .move-down');
				var moduleOffsetNumber = 0;
				
				var moduleOffset = module.attr('class').match(/col-offset-[1-9][0-9]?/);
				if(moduleOffset){
					switch(moduleOffset[0]){
						case 'col-offset-1': moduleOffsetNumber = 1; break;
						case 'col-offset-2': moduleOffsetNumber = 2; break;
						case 'col-offset-3': moduleOffsetNumber = 3; break;
						case 'col-offset-4': moduleOffsetNumber = 4; break;
						case 'col-offset-5': moduleOffsetNumber = 5; break;
						case 'col-offset-6': moduleOffsetNumber = 6; break;
						case 'col-offset-7': moduleOffsetNumber = 7; break;
						case 'col-offset-8': moduleOffsetNumber = 8; break;
						case 'col-offset-9': moduleOffsetNumber = 9; break;
						case 'col-offset-10': moduleOffsetNumber = 10; break;
						case 'col-offset-11': moduleOffsetNumber = 11; break;
					}
				}
				
				module.removeClass('ux-first-mod-row');
				containerModuleWidthSum = containerModuleWidthSum + moduleCol + moduleOffsetNumber;
				
				if(containerModuleWidthSum > 12 || index == 0 || moduleCol == 0){ /*UxCB.fnModuleSelectorToolsClone(module, 'before');*/
					module.addClass('ux-first-mod-row');
					moduleRowNum++;
					if(container.is('.bm-builder')){
						var moduleChangeRow = $('<div class="module-change-row" data-row="' +moduleRowNum+ '"></div>');
						container.append(moduleChangeRow);
						moduleChangeRow.width(UxCB.win.width());
						moduleChangeRow.css({
							'margin-left': - (UxCB.win.width() - container.width()) / 2 + 'px'
						});
					}
				}
				if(containerModuleWidthSum > 12){ containerModuleWidthSum = 0 + moduleCol + moduleOffsetNumber; }
				if(moduleCol == 0){ containerModuleWidthSum = 12; }
				if(index == 0){ buttonMoveUp.addClass('hidden'); }
					else{ buttonMoveUp.removeClass('hidden'); }
				
				if(index == modules.length - 1){ buttonMoveDown.addClass('hidden'); }
					else{ buttonMoveDown.removeClass('hidden'); }
				
				module.attr({
					'data-index': index,
					'data-row': moduleRowNum
				});
				
				if(moduleContent.find('> .module').length){
					moduleContent.removeClass('no-content');
					UxCB.fnModuleRefreshSort(moduleContent);
				}else{
					if(module.is('.has-droppable')){
						moduleContent.addClass('no-content');
					}
				}
				
				/*if(module.is('.has-droppable')){
					moduleContent.find('> .item.selector').remove();
					UxCB.fnModuleSelectorToolsClone(moduleContent, 'append');
				}*/
				
				if(moduleBorder.is(':visible')){
					moduleBorder.css('visibility', 'hidden');
				}
			});
			
			if(container.is('.bm-builder')){
				UxCB.fnModuleChangeRow(container);
			}
			
			//UxCB.fnModuleSelectorToolsClone(container, 'append');
			
			/*if(container.is('.module-content')){
				var moduleParent = container.parents('.module');
				var moduleParentWidth = moduleParent.attr('data-module-width');
				var moduleParentUnique = moduleParent.attr('data-module-unique');
				var moduleParentContent = moduleParent.find('> .module-inside > .module-content');
				var moduleParentShortcode = moduleParent.find('> .module-inside > .module-shortcode');
				var moduleParentCol = Number(moduleParent.attr('data-module-col'));
				var shortcodeHtml = '';
				
				shortcodeHtml += '[ux_cb_group unique="' +moduleParentUnique+ '" col="' +moduleParentCol+ '"]';
				moduleParentContent.find('> .module').each(function(){
					var subModule = $(this);
					var subModuleCol = Number(subModule.attr('data-module-col'));
					var subModuleShortcode = subModule.find('> .module-inside > .module-shortcode');
					var subModuleShortcodeHtml = subModuleShortcode.html();
					var subModuleCocTip = subModule.find('> .module-inside > .module-border > .col-number');
					
					if(subModuleCol > moduleParentCol || subModuleCol == 0){
						subModule.removeClass('col-' +subModuleCol).addClass('col-' +moduleParentCol);
						subModule.attr({
							'data-module-width': moduleParentWidth,
							'data-module-col': moduleParentCol
						});
						subModuleShortcode.html(subModuleShortcodeHtml.replace(/col=\"([^\"]*)\"/, 'col="' +moduleParentCol+ '"'));
						subModuleCocTip.html(moduleParentCol+ '/12');
					}
					
					shortcodeHtml += subModuleShortcode.html();
				});
				shortcodeHtml += '[/ux_cb_group]';
				
				if(shortcodeHtml != ''){
					moduleParentShortcode.html(shortcodeHtml);
				}
			}*/
		}else{
			if(!container.is('.module-content')){
				UxCB.pageCustomizePreview.removeClass('has-content');
				UxCB.pageCustomizeModuleSelector.addClass('fadein');
				UxCB.pageCustomizeModuleSelector.find('button').removeAttr('style');
				setTimeout(function(){
					UxCB.pageCustomizeModuleSelector.addClass('on');
				}, 500);
				setTimeout(function(){
					UxCB.pageCustomizeModuleSelector.find('h1').addClass('fadein');
				}, 1000);
			}
		}
	}
	
	UxCB.fnModuleUniverColor = function(bmUniverColor, sectionFrontcolor, sectionBackcolor){
		UxCB.pageCustomizePreviewContainer.css('background-color', sectionBackcolor);
		bmUniverColor.html('.ux-cb-customize-preview-container *{ color:'+sectionFrontcolor+'!important; border-color:'+sectionFrontcolor+'!important;fill:'+sectionFrontcolor+'!important;}.ux-cb-customize-preview-container *:before{ color:'+sectionFrontcolor+'!important; border-color:'+sectionFrontcolor+'!important;}.ux-cb-customize-preview-container *:after { color:'+sectionFrontcolor+'!important; border-color:'+sectionFrontcolor+'!important;}');
	}
	
	//function module 
	UxCB.fnModuleChangeRow = function(container){
		var moduleChangeRow = $('div.module-change-row');
		if(moduleChangeRow.length){
			var rowTop = 0;
			
			UxCB.pageCustomizePreviewContainer.removeAttr('style'); 
			moduleChangeRow.each(function(){
				var row = $(this),
					rowNum = row.attr('data-row'),
					rowHeight = 0,
					targetModules = container.find('> .module[data-row="' +rowNum+ '"]');
					
				row.attr({
					'data-frontcolor': '',
					'data-backcolor': '',
				});
				
				if(targetModules.length){
					targetModules.each(function(){
						var module = $(this),
							moduleIndex = module.attr('data-index'),
							moduleChangeColor = module.attr('data-change-color'),
							moduleForegroundColor = module.attr('data-frontcolor'),
							moduleBackgroundColor = module.attr('data-backcolor'),
							moduleHeight = $(this).height();
						
						if(moduleHeight > rowHeight){
							rowHeight = moduleHeight;
						}
						
						if(moduleChangeColor == 'on'){
							if(row.attr('data-frontcolor') == ''){
								row.attr({
									'data-frontcolor': moduleForegroundColor,
									'data-backcolor': moduleBackgroundColor,
									'data-module': moduleIndex
								});
							}
						}
					});
					
					$(this).height(rowHeight).css('top', rowTop+ 'px');
					rowTop = rowTop + rowHeight;
				}
			});
			
			var bmUniverColor = $('#bm-univer-color');
			if(!bmUniverColor.length){
				bmUniverColor = $('<style type="text/css" media="screen" id="bm-univer-color"></style>');
				$('head').append(bmUniverColor);		
			}
			bmUniverColor.html(' ');
			
			moduleChangeRow.each(function(){
                var thisSection = $(this),
					sectionBackcolor = thisSection.attr('data-backcolor'),
					sectionFrontcolor = thisSection.attr('data-frontcolor'),
					sectionPosition = 0.5; 
				
				setTimeout(function(){
					thisSection.waypoint({
						handler: function(direction){
							if(direction == 'down'){
								UxCB.fnModuleUniverColor(bmUniverColor, sectionFrontcolor, sectionBackcolor);
								
								if(!thisSection.is('[data-module]')){
									UxCB.pageCustomizePreviewContainer.removeAttr('style'); 
									bmUniverColor.html('');
								}
								thisSection.prev().removeAttr('style'); 
			
							} else if(direction == 'up'){
								if(!thisSection.prev().is('[data-module]') && !thisSection.prev()){
									UxCB.pageCustomizePreviewContainer.removeAttr('style'); 
									bmUniverColor.html('');
								}
							}
							
						},
						offset: function(){
							var height = Waypoint.viewportHeight() * sectionPosition;
							return height;
						},
						context: UxCB.pageCustomizePreviewContainer
					});
					
					thisSection.waypoint({
						handler: function(direction){
							if(direction == 'down'){
								if(!thisSection.next().is('[data-module]') && !thisSection.next()){
									UxCB.pageCustomizePreviewContainer.removeAttr('style'); 
									bmUniverColor.html('');
								}
							}else if(direction == 'up'){
								UxCB.fnModuleUniverColor(bmUniverColor, sectionFrontcolor, sectionBackcolor);
								
								if(!thisSection.is('[data-module]')){
									UxCB.pageCustomizePreviewContainer.removeAttr('style'); 
									bmUniverColor.html('');
								}
							}
						},
						offset: function(){
							//var height = Waypoint.viewportHeight() - (thisSection.height() + (Waypoint.viewportHeight() * (sectionPosition - 0.2)));
							var height = Waypoint.viewportHeight() - (thisSection.height() + (Waypoint.viewportHeight() * (40 / 100)));
							return height;
						},
						context: UxCB.pageCustomizePreviewContainer
					});
				}, 100);
			});
		}
	}
	
	//function module save
	UxCB.fnModuleSave = function(){
		UxCB.modalSave.on('click', function(){
			var moduleUnique = UxCB.modal.attr('data-module-unique');
			var module = UxCB.pageCustomizePreviewContainer.find('.module[data-module-unique="' +moduleUnique+ '"]');
			var moduleID = module.data('module-id');
			var moduleCol = Number(module.attr('data-module-col'));
			var moduleContent = module.find('> .module-inside > .module-content');
			var moduleShortcode = module.find('> .module-inside > .module-shortcode');
			var moduleShortcodeHtml = moduleShortcode.html();
			var moduleShortcodeTag = module.data('module-shortcodetag');
			//var moduleShortcodeTemplates = UxCB.pageCustomizeTemplates.find('.module[data-module-id="' +moduleID+ '"] .module-shortcode').clone().html(); //simplify
			var moduleGroupShortcodeContent = '';
			var textSave = UxCB.modalSave.data('save');
			var textSaving = UxCB.modalSave.data('saving');
			var textSaved = UxCB.modalSave.data('saved');
			var postID = $('#post_ID').val();
			var newFieldArray = [];
			var thisLayoutMap = false;
			var groupFields = [];
			
			if(UxCB.modal.find('table.ux-cb-module-slider-slide-group[data-section-mod="template"]')){
				UxCB.modal.find('table.ux-cb-module-slider-slide-group[data-section-mod="template"] [name]').removeAttr('name');
			}
			
			var fieldTextGroup = $('.ux-cb-module-field-text-group');
			
			if(fieldTextGroup.length){
				fieldTextGroup.each(function(){
					if(fieldTextGroup.is(':visible')){
						var applyTextGroup = $(this).find('button.textGroupApply');
						applyTextGroup.trigger('click');
					}
				});
			}
			
			UxCB.modal.find('input[name]').each(function(){
				if($(this).is('[type="number"]')){
					if($(this).val() == ''){
						$(this).val('0');
					}
				}
			});
			
			var fields = UxCB.modal.find('[name]').serializeArray();
			UxCBModules[moduleUnique] = fields;
			//moduleShortcodeHtml = moduleShortcodeHtml.replace(/unique=\"([^\"]*)\"/, 'unique="' +moduleUnique+ '"'); //simplify
			
			if(moduleID == 'masonry-grid'){
				/*var pushArray = {};
					
				pushArray.name = '__ux_cb_module_masonry_grid_media_images';
				pushArray.value = [];
				
				newFieldArray.push(pushArray);*/
				
				var galleryLists = UxCB.modal.find('.ux-cb-module-field-gallery-lists');
				thisLayoutMap = $.map(galleryLists.find('.grid-stack > .grid-stack-item'), function(el){
					el = $(el);
					var node = el.data('_gridstack_node');
					var post_id = el.data('postid');
					return {
						x: node.x,
						y: node.y,
						width: node.width,
						height: node.height,
						post_id: post_id
					};
				});
			}else if(moduleID == 'grid'){
				/*var pushArray = {};
					
				pushArray.name = '__ux_cb_module_grid_media_images';
				pushArray.value = [];
				
				newFieldArray.push(pushArray);*/
			}else if(moduleID == 'button' || moduleID == 'ux-cb-fonts-definition' || moduleID == 'social-media' ){
				var buttonfields = {};
					buttonfields.value = {};
					
				var tabSectionSettingsContent = UxCB.modalBody.find('.ux-cb-module-field-region-content[id="item-settings"]');
				tabSectionSettingsContent.find('[name]').remove();
				
				UxCB.modalBody.find('ul.ux-cb-module-field-items').find('> li').each(function(index){
					var itemFieldInput = $(this).find('[name]');
					var itemFields = {};
					
					buttonfields.value[index] = {};
					
					itemFieldInput.each(function(i){
						var fieldName = $(this).attr('name');
						
						buttonfields.value[index][i] = {};
						buttonfields.value[index][i].name = fieldName;
						buttonfields.value[index][i].value = $(this).val();
						
						$.each(fields, function(index, field){
							if(field['name'] == fieldName){
								fields[index]['name'] = '';
							}
						});
					});
				});
				buttonfields.name = '_ux_cb_module_button_items';
				
				if(moduleID == 'ux-cb-fonts-definition'){
					buttonfields.name = '_ux_cb_module_fonts_items';
				}else if(moduleID == 'social-media'){
					buttonfields.name = '__ux_cb_module_social_media_link_items';
					
					var pushArray = {};
						
					pushArray.name = '__ux_cb_module_social_media_share';
					pushArray.value = [];
					
					newFieldArray.push(pushArray);
				}
				
				fields.push(buttonfields); 
			}else if(moduleID == 'group'){
				var moduleChangeColor = UxCB.modal.find('input[name="__ux_cb_module_group_change_color_scroll_in"]'),
					moduleForegroundColor = UxCB.modal.find('input[name="__ux_cb_module_group_change_frontcolor"]'),
					moduleBackgroundColor = UxCB.modal.find('input[name="__ux_cb_module_group_change_backcolor"]'),
					moduleDataIndex = module.attr('data-index'),
					moduleDataRow = module.attr('data-row'),
					moduleChangeRow = $('div.module-change-row[data-row="' +moduleDataRow+ '"]');
				
				module.attr({
					'data-change-color': moduleChangeColor.val(),
					'data-frontcolor': moduleForegroundColor.val(),
					'data-backcolor': moduleBackgroundColor.val()
				});
				
				moduleChangeRow.attr({
					'data-frontcolor': moduleForegroundColor.val(),
					'data-backcolor': moduleBackgroundColor.val(),
					'data-module': moduleDataIndex
				});
			}
			
			$.each(fields, function(index, field){
				switch(moduleID){
					case 'text':
						if(field['name'] == '__ux_cb_module_content'){
							if(UxCB.modal.find('.ux-summernote')){
								var summernoteContent = UxCB.modal.find('.ux-summernote').summernote('code');
								fields[index]['value'] = summernoteContent;
								
								
								moduleShortcodeHtml = '[' +moduleShortcodeTag+ ' unique="' +moduleUnique+ '" col="' +moduleCol+ '"]' +summernoteContent+ '[/' +moduleShortcodeTag+ ']';
								moduleShortcode.html(moduleShortcodeHtml);
							}
						}
						
						/*switch(field['name']){
							case '__ux_cb_module_text_bg_color':
								module.css('background-color', UxCB.fnThemeColor(field['value']));
								//moduleShortcodeHtml = moduleShortcodeHtml.replace(/bg-color=\"([^\"]*)\"/, 'bg-color="' +field['value']+ '"'); //simplify
							break;
							
							case '__ux_cb_module_text_center_width': 
								moduleContent.find('.text_block_centered').css({
									'width': field['value']
								});
								//moduleShortcodeHtml = moduleShortcodeHtml.replace(/unique=\"([^\"]*)\"/, 'inner-width="' +field['value']+ '"'); //simplify
							break;
								
							case 'ux-cb-module-content':
								moduleContent.find('.text_block_centered').html(UxCB.fnConvertString(field['value']));
								//moduleShortcodeHtml = moduleShortcodeHtml.replace(/\](.*)\[/, ']' +field['value']+ '['); //simplify
							break;
								
							case '__ux_cb_module_scroll_in_animation':
								//moduleShortcodeHtml = moduleShortcodeHtml.replace(/unique=\"([^\"]*)\"/, 'animation="' +field['value']+ '"'); //simplify
							break;
								
							case '__ux_cb_module_scroll_animation_base':
								//moduleShortcodeHtml = moduleShortcodeHtml.replace(/unique=\"([^\"]*)\"/, 'animation-base="' +field['value']+ '"'); //simplify
							break;
						}*/
					break;
					
					/*case 'single-image':
						switch(field['name']){
							case '__ux_cb_module_single_image_image-url':
								moduleContent.find('.single-image-img').attr('src', field['value']);
							break;
						}
					
					break;*/
				}
				
				switch(field['name']){
					case '__ux_cb_module_top_padding':
						if(field['value'] == ''){
							field['value'] = '0';
						}
						moduleContent.parent('.module-inside').css('margin-top', field['value']+ 'px');
						module.attr('data-padding-top', field['value']);
						//moduleShortcodeHtml = moduleShortcodeHtml.replace(/padding-top=\"([^\"]*)\"/, 'padding-top="' +field['value']+ '"'); //simplify
					break;
					
					case '__ux_cb_module_top_padding_mobile':
						// if(field['value'] == ''){
						// 	field['value'] = '0';
						// }
						module.attr('data-padding-top-mobile', field['value']);
					break;
					
					case '__ux_cb_module_bottom_padding':
						if(field['value'] == ''){
							field['value'] = '0';
						}
						moduleContent.parent('.module-inside').css('margin-bottom', field['value']+ 'px');
						module.attr('data-padding-bottom', field['value']);
						//moduleShortcodeHtml = moduleShortcodeHtml.replace(/padding-bottom=\"([^\"]*)\"/, 'padding-bottom="' +field['value']+ '"'); //simplify
					break;
					
					case '__ux_cb_module_bottom_padding_mobile':
						// if(field['value'] == ''){
						// 	field['value'] = '0';
						// }
						module.attr('data-padding-bottom-mobile', field['value']);
					break;
					
					case '__ux_cb_module_offset_base':
						module.attr('class', module.attr('class').replace(/(.*)col-offset-[0-9](.*)/, '$1$2')).addClass(field['value']);
					break;
					
					case '__ux_cb_module_group_object_align':
						switch(field['value']){
							case 'top': moduleContent.removeClass('row-middle row-bottom row-equal_spacing_v').addClass('row-top'); break;
							case 'middle': moduleContent.removeClass('row-top row-bottom row-equal_spacing_v').addClass('row-middle'); break;
							case 'bottom': moduleContent.removeClass('row-middle row-top row-equal_spacing_v').addClass('row-bottom'); break;
							case 'equal_spacing_v': moduleContent.removeClass('row-middle row-top row-bottom').addClass('row-equal_spacing_v'); break;
						}
					break;

					case '__ux_cb_module_group_object_align_h':
						switch(field['value']){
							case 'left': moduleContent.removeClass('row-center row-right row-equal_spacing_h').addClass('row-left'); break;
							case 'center': moduleContent.removeClass('row-left row-right row-equal_spacing_h').addClass('row-center'); break;
							case 'right': moduleContent.removeClass('row-center row-left row-equal_spacing_h').addClass('row-right'); break;
							case 'equal_spacing_h': moduleContent.removeClass('row-center row-left row-right').addClass('row-equal_spacing_h'); break;
						}
					break;
					
					case '__ux_cb_module_group_height_type':
						switch(field['value']){
							// case 'custom':
							// 	var thisHeight = $('input[name="__ux_cb_module_group_custom_height"]').val();
							// 	moduleContent.css('min-height', thisHeight.replace('px', '')+ 'px');
							// break;
							case 'screen_height':
								// var heightSpacing = $('input[name="__ux_cb_module_group_screen_height_spacing"]').val();
								   
								// if(heightSpacing != ''){
								// 	heightSpacing = Number(heightSpacing) * 2;
								// 	moduleContent.css('min-height', 'calc(100vh - ' +heightSpacing+ 'px)');
								// }else{
								// 	moduleContent.css('min-height', '100vh');
								// }
								//var heightSpacing = $('input[id="__ux_cb_module_group_screen_height_spacing_0"]').val(); 
								var heightVaule   = $('select[id="__ux_cb_module_group_screen_height_0"]').val();
								if(heightVaule) {
									//if(heightSpacing != ''){
									//	heightSpacing = Number(heightSpacing) * 2;
									//	moduleContent.css('min-height', 'calc('+heightVaule+'vh - ' +heightSpacing+ 'px)');
									//}else{
										moduleContent.css('min-height', heightVaule+'vh');
									//}
								}
							break;
							case 'auto': moduleContent.css({'height':'auto', 'min-height':0}); break;
						}
					break;
					
					case '__ux_cb_module_group_background':
						var thisBgColor = 'transparent';
						if(field['value'] == 'background_color'){
							var thisBgColor = $('input[name="__ux_cb_module_group_bg_color"]').val();
						}
						//moduleContent.css('background-color', thisBgColor);
					break;
					
					/*default:
						if(field['name'] == '__ux_cb_module_social_media_share' || field['name'] == '__ux_cb_module_masonry_grid_media_images' || field['name'] == '__ux_cb_module_grid_media_images'){
							if(newFieldArray){
								$.each(newFieldArray, function(i, newField){
									if(newField['name'] == field['name']){
										newField['value'].push(field['value']);
									}
								});
							}
						}
					break;*/
					
					case '__ux_cb_module_group_fullwidth':
						moduleContent.removeClass('bm-force-full');
						if(field['value'] == 'on'){
							moduleContent.addClass('bm-force-full');
						}
					break;

					case '__ux_cb_module_group_disable_gap':
						module.removeClass('bm-wrap-no-gap');
						if(field['value'] == 'on'){
							module.addClass('bm-wrap-no-gap');
						}
					break;
				}
				
				if(field['name'] == '__ux_cb_module_slider_text_color' || field['name'] == '__ux_cb_module_slider_page_number_color' || field['name'] == '__ux_cb_module_slider_arrow_color'){
					if(field['value'] == ''){
						field['value'] = 'inherit';
					}
				}
				
			});
			
			if(newFieldArray){
				$.each(newFieldArray, function(index, newField){
					fields.push(newField);
				});
			}
			
			UxCB.modalSave.text(textSaving).attr('disabled', 'disabled');
			$.post(ajaxurl, {
				'action': 'ux_cb_ajax_save_module_fields',
				'moduleID': moduleID,
				'moduleUnique': moduleUnique,
				'moduleFields': fields,
				'postID': postID,
				'moduleShortcode': moduleShortcodeHtml,
				'layoutMap': thisLayoutMap,
				'moduleCol': moduleCol
			}).done(function(result){
				UxCB.modalSave.text(textSaved);
				
				if(moduleID == 'group'){
					moduleContent.find('> *:not(.item)').remove();
					moduleContent.prepend(result);
				}else{
					moduleContent.html(result);
				}
				
				if(moduleID == 'text'){
					UxCB.pageCustomizeTools.find('button#ux-cb-page-options-save').trigger('click');
				}
				
				setTimeout(function(){
					UxCB.modalSave.text(textSave).removeAttr('disabled');
					UxCB.modalClose.trigger('click');
					
					switch(moduleID){
						case 'masonry-grid':
							if(moduleContent.find('.grid-stack').length){
								UxCB.fnGridStackResize(moduleContent.find('.grid-stack'));
							}
						break;
						case 'grid':
							UxCB.fnModuleFieldCustomGridLoaded(moduleContent);
							var modulesIsotope = module.find('.container-masonry');
							var modulesIsotopeList = modulesIsotope.find('.masonry-list');
							
							if(!modulesIsotopeList.hasClass('masonry-auto')) {
								var isotope = modulesIsotopeList.isotope({
									itemSelector: '.grid-item',
									layoutMode: 'fitRows',
									stagger: 40,
									hiddenStyle: {
									  opacity: 0
									},
									visibleStyle: {
									  opacity: 1
									}
								});
			
							} else { 
								var isotope = modulesIsotopeList.isotope({ 
									itemSelector: '.grid-item',
									layoutMode: 'packery',
									stagger: 40,
									hiddenStyle: {
									  opacity: 0
									},
									visibleStyle: {
									  opacity: 1
									}
								}); 
							}
						break;
						case 'single-image':
							var embed = moduleContent.find('.single-image-embed');
							if(embed.length){
								UxCB.fnModuleSingleImageEmbed(embed);
							}
						break;
						case 'slider':
							if(moduleContent.find('.owl-carousel').length){
								UxCB.fnModuleCarousel(moduleContent.find('.owl-carousel'));
							}
						break;
						
						/*case 'group':
							if(moduleContent.find('.module').length){
								moduleContent.find('.module').each(function(index, element) {
                                    var subModule = $(this);
									UxCB.fnModuleHover(subModule);
									UxCB.fnModEditToolsEvent(subModule);
                                });
							}
						break;*/
					}
					UxCB.fnModuleRefreshSort();
				}, 200);
			});
			//moduleShortcode.html(moduleShortcodeHtml); //simplify
		});
	}
	
	//function array merge fields
	UxCB.fnArrayMergeFields = function(fields){
		if(fields.constructor === Array){
			var newFieldArray = [];
			$.each(fields, function(index, field){
				if(newFieldArray.hasOwnProperty(field['name'])){
					var subFields = [];
					if(newFieldArray[field['name']].constructor === Array){
						subFields = newFieldArray[field['name']];
					}else{
						subFields.push(newFieldArray[field['name']]);
					}
					subFields.push(field['value']);
					newFieldArray[field['name']] = subFields;
				}else{
					newFieldArray[field['name']] = field['value'];
				}
			});
			fields = newFieldArray;
		}
		
		return fields;
	}
	
	//function module selector button
	UxCB.fnModuleSelectorButton = function(btn){
		var moduleID = btn.data('module-id');
		
		if(moduleID == 'group-inside' || moduleID == 'group-outside'){
			btn.hover(function(){
				if(UxCB.addModulePrototype){
					UxCB.addModulePrototype.find('> .module-inside > .module-border').css('visibility', 'visible');
				}
			}, function(){
				if(UxCB.addModulePrototype){
					UxCB.addModulePrototype.find('> .module-inside > .module-border').css('visibility', 'hidden');
				}
			});
		}
		
		btn.on('click', function(event, targetContent){
			var btnParent = btn.parent();
			var date = new Date();
			var content = UxCB.pageCustomizeTemplates.find('.module[data-module-id="' +moduleID+ '"]').clone();
			var postID = $('#post_ID').val();
			
			if(!UxCB.pageCustomizePreviewContainer.find('.bm-builder').length){
				UxCB.pageCustomizePreviewContainer.append('<div class="bm-builder"></div>');
			}
			
			if(moduleID == 'group-inside' || moduleID == 'group-outside'){
				UxCB.addModuleGroupPosition = moduleID;
			}else{
				if(content){
					var moduleContent = content.find('> .module-inside > .module-content');
					var moduleUnique = date.getTime();
					var moduleShortcode = content.find('> .module-inside > .module-shortcode');
					var moduleShortcodeHtml = moduleShortcode.html();
						moduleShortcodeHtml = moduleShortcodeHtml.replace('unique=""', 'unique="' +moduleUnique+ '"');
						//moduleShortcodeHtml = moduleShortcodeHtml.replace('][', ']' +moduleContent.html()+ '['); //simplify

					if(targetContent && moduleID == 'text'){
						content.find('.text_block_centered').html(targetContent);
					}

					UxCB.fnModuleHover(content);
					UxCB.fnModEditToolsEvent(content);

					if(moduleContent.is('.sub-module-sortable')){
						UxCB.fnModuleSortable(moduleContent);
					}

					content.attr('data-module-unique', moduleUnique);
					UxCBModules[moduleUnique] = [];

					if(btnParent.hasClass('module-selector-tools')){
						var btnParents = btnParent.parent();
						btnParents.after(content);
						btnParents.remove();
					}else{
						if(UxCB.addModulePrototype){
							var currentModule = UxCB.fnGetModuleAttr(UxCB.addModulePrototype);
							
							if(currentModule.id == 'group'){
								if(UxCB.addModuleGroupPosition){
									if(UxCB.addModuleGroupPosition == 'group-inside'){
										currentModule.content.append(content);
									}else{
										UxCB.addModulePrototype.after(content);
									}
								}
							}else{
								UxCB.addModulePrototype.after(content);
							}
						}else{
							if(UxCB.pageCustomizePreviewContainer.find('.bm-builder').length){
								UxCB.pageCustomizePreviewContainer.find('.bm-builder').append(content);
							}
							UxCB.pageCustomizePreview.addClass('has-content');
						}
						UxCB.pageCustomizeModuleSelector.removeClass('fadein on cross-click').removeAttr('style');
						UxCB.pageCustomizeModuleSelector.find('h1').removeClass('fadein');
						UxCB.addModulePrototype = false;
						UxCB.addModuleGroupPosition = false;
					}
					UxCB.fnModuleRefreshSort();

					content.find('.edit').trigger('click', targetContent);

					moduleShortcode.html(moduleShortcodeHtml);

					switch(moduleID){
						case 'masonry-grid':
							$.post(ajaxurl, {
								'action': 'ux_cb_module_field_custom_grid_layouts_ajax',
								'catID': '',
								'postID': postID,
								'source': 'ux-portfolio',
								'taxonomy': 'ux-portfolio-cat',
								'moduleUnique': moduleUnique
							}).done(function(result){
								var content = $(result),
									cellHeight = UxCB.fnGridstackCellHeight(UxCB.pageCustomizePreviewContainer.find('[data-module-unique="' +moduleUnique+ '"] > .module-inside > .module-content'), 20);

								UxCB.pageCustomizePreviewContainer.find('[data-module-unique="' +moduleUnique+ '"] > .module-inside > .module-content').html(result);
								UxCB.pageCustomizePreviewContainer.find('[data-module-unique="' +moduleUnique+ '"] > .module-inside > .module-content').find('.grid-stack').gridstack({
									verticalMargin: 20,
									width: UxCB.gridstackColumns,
									cellHeight: cellHeight,
									resizable: {
										handles: 'e, se, s, sw, w'
									}
								});
							});
						break;
						case 'grid':
							moduleContent = UxCB.pageCustomizePreviewContainer.find('[data-module-unique="' +moduleUnique+ '"] > .module-inside > .module-content');
							UxCB.fnModuleFieldCustomGridLoaded(moduleContent);
						break;
					}
				}
			}
		});
	}
	
	//fn mod edit tools event
	UxCB.fnModEditToolsEvent = function(m){
		var mET = m.find('> .module-inside > .module-edit-tools'),
		    bS = mET.find('> button');
		
		bS.each(function() {
            var b = $(this);
			
			b.hover(function(){
				var mTI = m.find('> .module-inside > .module-border > .text-info');
				mTI.addClass('hidden');
			});
			
			if(b.hasClass('increase')){ UxCB.fnModEditToolCrease(b, 'in'); }
			if(b.hasClass('decrease')){ UxCB.fnModEditToolCrease(b, 'de'); }
			if(b.hasClass('offset-left-right')){ UxCB.fnModEditToolOffset(b, m, 'left-right'); }
			if(b.hasClass('offset-left')){ UxCB.fnModEditToolOffset(b, m, 'left'); }
			if(b.hasClass('offset-right')){ UxCB.fnModEditToolOffset(b, m, 'right'); }
			if(b.hasClass('spacer-top-bottom')){ UxCB.fnModEditToolSpacer(b, m, 'top-bottom'); }
			if(b.hasClass('increase-spacer-bottom')){ UxCB.fnModEditToolSpacer(b, m, 'in-bottom'); }
			if(b.hasClass('decrease-spacer-bottom')){ UxCB.fnModEditToolSpacer(b, m, 'de-bottom'); }
			if(b.hasClass('increase-spacer-top')){ UxCB.fnModEditToolSpacer(b, m, 'in-top'); }
			if(b.hasClass('decrease-spacer-top')){ UxCB.fnModEditToolSpacer(b, m, 'de-top'); }
			if(b.hasClass('move-up')){ UxCB.fnModEditToolMove(b, 'up'); }
			if(b.hasClass('move-down')){ UxCB.fnModEditToolMove(b, 'down'); }
			if(b.hasClass('edit')){ UxCB.fnModEditToolEdit(b); }
			if(b.hasClass('group-save-layout')){ UxCB.fnModEditToolSaveLayouts(b); }
			if(b.hasClass('clone')){ UxCB.fnModEditToolClone(b, m); }
			if(b.hasClass('trash')){ UxCB.fnModEditToolTrash(b); }
			if(b.hasClass('add-module')){ UxCB.fnModEditToolAddMod(b); }
        });
	}
	
	//fn edit tool offset event
	UxCB.fnModEditToolOffset = function(b, m, e){
		b.on('click', function(){
			var bP = b.parent(),
				cN = 'col-offset-',
				oC = Number(m.attr('data-offset')),
				mU = m.data('module-unique'),
				oOC = oC;
			
			switch(e){
				case 'left-right': bP.find('> [class*="offset"]').removeClass('hidden'); b.addClass('hidden'); break;
				case 'right': if(oC > 0){ m.removeClass(cN+ oC); oC--; m.addClass(cN+ oC); } break;
				case 'left': if(oC < 11){ m.removeClass(cN+ oC); oC++; m.addClass(cN+ oC); } break;
			}
			
			if(e != 'left-right'){
				m.attr('data-offset', oC);
				if(oOC != oC){ $.post(ajaxurl, { 'action': 'ux_cb_ajax_save_module_field', 'value': oC, 'field': 'offset', 'unique': mU}); }
			}
		});
	}
	
	//fn edit tool spacer event
	UxCB.fnModEditToolSpacer = function(b, m, e){
		b.on('click', function(){
			var bP = b.parent(),
			    mI = m.find('> .module-inside'),
				mU = m.data('module-unique'),
				mTT = mI.find('> .module-border > .spacer-top-info'),
				mTB = mI.find('> .module-border > .spacer-bottom-info'),
				sMT = mI.css('margin-top') || 0,
				sMB = mI.css('margin-bottom') || 0,
				cN = '',
				cV = 0;
			
			if(sMT){ sMT = Number(sMT.replace('px', '')); }
			if(sMB){ sMB = Number(sMB.replace('px', '')); }
			
			switch(e){
				case 'top-bottom': bP.find('> [class*="spacer"]').removeClass('hidden'); b.addClass('hidden'); break;
				case 'in-top': cN='margin-top'; cV=sMT+20;  break;
				case 'in-bottom': cN='margin-bottom'; cV=sMB+20; break;
				case 'de-top': cN='margin-top'; if(sMT >= 20){ cV=sMT-20; }else if(sMT > 0 && sMT < 20){ cV=0; } break;
				case 'de-bottom': cN='margin-bottom'; if(sMB >= 20){ cV=sMB-20 }else if(sMB > 0 && sMB < 20){ cV=0; } break;
			}
			
			if(e != 'top-bottom'){
				mI.css(cN, cV+'px');
				if(e == 'in-top' || e == 'de-top'){ mTT.text(cV); m.attr('data-padding-top', cV); } else if(e == 'in-bottom' || e == 'de-bottom'){ mTB.text(cV); m.attr('data-padding-bottom', cV); }
				if(sMT != cV && sMB != cV){ $.post(ajaxurl, { 'action': 'ux_cb_ajax_save_module_field', 'value': cV, 'field': cN, 'unique': mU}); }
			}
			
		}).hover(function(){
			var mTT = m.find('> .module-inside > .module-border > .spacer-top-info'),
			    mTB = m.find('> .module-inside > .module-border > .spacer-bottom-info');
			
			if(e == 'in-top' || e == 'de-top'){
				mTT.removeClass('hidden');
			}else if(e == 'in-bottom' || e == 'de-bottom'){
				mTB.removeClass('hidden');
			}
			
		});
	}
	
	//function edit tool increase and decrease
	UxCB.fnModEditToolCrease = function(btn, crease){
		btn.on('click', function(){
			var module = $(this).parent().parent().parent();
			var moduleID = module.data('module-id');
			var moduleWidth = module.attr('data-module-width');
			var moduleCol = Number(module.attr('data-module-col'));
			var moduleContent = module.find('> .module-inside > .module-content');
			var moduleBorder = module.find('> .module-inside > .module-border');
			var moduleShortcode = module.find('> .module-inside > .module-shortcode');
			var moduleShortcodeHtml = moduleShortcode.html();
			var moduleCocTip = module.find('> .module-inside > .module-border > .col-number');
			var moduleParentCol = 12;
			
			if(module.parent().is('.module-content')){
				var moduleParents = module.parents('.module');
				moduleParentCol = Number(moduleParents.attr('data-module-col'));
			}
			
			//module.find('.grid-item-inside').css('opacity', 0);
			
			switch(crease){
				case 'in':
					switch(moduleWidth){
						case 'fullwidth': break; 
						case '12/12':
							var containerWidth = UxCB.pageCustomizePreviewContainer.outerWidth();
							var containerMargin = UxCB.pageCustomizePreviewContainer.css('padding-left');
							
							moduleWidth = 'fullwidth'; moduleCol = '0';
							module.removeClass('col-12').addClass('col-0');
							moduleCocTip.html('Fullwidth');
						break;
						default:
							if(moduleCol < moduleParentCol || moduleParentCol == 0){
								if(moduleCol > 0 && moduleCol < 12){
									module.removeClass('col-' +moduleCol);
									moduleCol++;
									moduleWidth = moduleCol+ '/12';
									module.addClass('col-' +moduleCol);
									moduleCocTip.html(moduleCol+ '/12');
								}
							}
						break;
					}
				break;
				
				case 'de':
					switch(moduleWidth){
						case 'fullwidth':
							moduleWidth = '12/12'; moduleCol = '12';
							module.removeClass('col-0').addClass('col-12').removeAttr('style');
							moduleCocTip.html('12/12');
						break; 
						default:
							if(moduleCol > 1 && moduleCol <= 12){
								module.removeClass('col-' +moduleCol);
								moduleCol--;
								moduleWidth = moduleCol+ '/12';
								module.addClass('col-' +moduleCol);
								moduleCocTip.html(moduleCol+ '/12');
							}
						break;
					}
					
					if(moduleContent.find('> .module').length){
						var subModules = moduleContent.find('> .module');
						subModules.each(function(){
							var subModule = $(this);
							var subModuleID = subModule.data('module-id');
							var subModuleCol = Number(subModule.attr('data-module-col'));
							var subModuleShortcode = subModule.find('> .module-inside > .module-shortcode');
							var subModuleShortcodeHtml = subModuleShortcode.html();
							var subModuleCocTip = subModule.find('> .module-inside > .module-border > .col-number');
							
							if(subModuleCol > moduleCol){
								subModule.removeClass('col-' +subModuleCol).addClass('col-' +moduleCol);
								subModule.attr({
									'data-module-width': moduleWidth,
									'data-module-col': moduleCol
								});
								subModuleShortcode.html(subModuleShortcodeHtml.replace(/col=\"([^\"]*)\"/, 'col="' +moduleCol+ '"'));
								subModuleCocTip.html(moduleCol+ '/12');
								
								setTimeout(function(){
									switch(subModuleID){
										case 'masonry-grid':
											if(subModule.find('.grid-stack').length){
												UxCB.fnGridStackResize(subModule.find('.grid-stack'));
											}
										break;
									}
								}, 100);
							}
						});
					}
				break;
			}
			
			module.attr({
				'data-module-width': moduleWidth,
				'data-module-col': moduleCol
			});
			moduleShortcode.html(moduleShortcodeHtml.replace(/col=\"([^\"]*)\"/, 'col="' +moduleCol+ '"'));
			
			UxCB.fnModuleRefreshSort();
			
			moduleBorder.css('visibility', 'visible');
			setTimeout(function(){
				moduleBorder.css('visibility', 'hidden');
			}, 2000);
			
			setTimeout(function(){
				switch(moduleID){
					case 'masonry-grid':
						if(module.find('.grid-stack').length){
							UxCB.fnGridStackResize(module.find('.grid-stack'));
						}
					break;
					
					case 'grid':
						if(module.find('.masonry-list')){
							if(module.find('.masonry-list').isotope()){
								module.find('.masonry-list').isotope('layout');
							}
							/*setTimeout(function(){
								module.find('.grid-item-inside').css('opacity', 1);
							}, 300);*/
						}
					break;
				}
			}, 150);
		}).hover(function(){
			var module = $(this).parent().parent().parent();
			var moduleCocTip = module.find('> .module-inside > .module-border > .col-number');
			
			moduleCocTip.removeClass('hidden');
		});
	}
	
	//function edit tool move up and move down
	UxCB.fnModEditToolMove = function(btn, move){
		btn.on('click', function(){
			var module = $(this).parent().parent().parent();
			var moduleIndex = Number(module.attr('data-index'));
			var moduleMoveIndex = 0;
			var container = UxCB.pageCustomizePreviewContainer.find('.bm-builder');
			var targetModule;
			
			switch(move){
				case 'up': moduleMoveIndex = moduleIndex - 1; break;
				case 'down': moduleMoveIndex = moduleIndex + 1; break;
			}
			
			if(module.parent().is('.module-content')){ container = module.parent(); }
			targetModule = container.find('> .module[data-index="' +moduleMoveIndex+ '"]');
			
			switch(move){
				case 'up': targetModule.before(module); break;
				case 'down': targetModule.after(module); break;
			}
			UxCB.fnModuleRefreshSort();
		});
	}
	
	//fn edit tool save layouts
	UxCB.fnModEditToolSaveLayouts = function(btn){
		btn.on('click', function(){
			var module = $(this).parent().parent().parent();
			var moduleUnique = module.data('module-unique');
			UxCB.pageCustomizeTools.find('button#ux-cb-page-options-save-layouts').trigger('click', moduleUnique);
		});
	}
	
	//function module edit tool edit
	UxCB.fnModEditToolEdit = function(btn){
		btn.on('click', function(event, targetContent){
			var module = $(this).parent().parent().parent();
			var moduleTitle = module.data('module-title');
			var moduleID = module.data('module-id');
			var moduleUnique = module.data('module-unique');
			var moduleCol = Number(module.attr('data-module-col'));
			var moduleShortcode = module.find('> .module-inside > .module-shortcode');
			var moduleShortcodeHtml = moduleShortcode.html();
			var moduleShortcodeTag = module.data('module-shortcodetag');
			var postID = $('#post_ID').val();
			var postType = $('#post_type').val();
			var modulePaddingTop = module.attr('data-padding-top');
			var modulePaddingTopMobile = module.attr('data-padding-top-mobile');
			var modulePaddingBottom = module.attr('data-padding-bottom');
			var modulePaddingBottomMobile = module.attr('data-padding-bottom-mobile');
			var textContent = '';
			
			UxCB.modalBody.find('> .ux-cb-module-loading').removeClass('hidden');
			
			if(moduleID == 'text'){
				textContent = module.find('.text_block_centered').html();
			}
			
			$.post(ajaxurl, {
				'action': 'ux_cb_ajax_load_module_fields',
				'moduleID': moduleID,
				'moduleUnique': moduleUnique,
				'postID': postID,
				'postType': postType,
				'textContent': textContent
			}).done(function(result){
				var content = $(result);
				
				if(content){
					UxCB.fnModuleFieldsProcess(content, module, true, '');
				}
			});
			
			UxCB.modal.addClass('ux-fade');
			UxCB.modalTitle.html(moduleTitle+ ' <span>&ndash; ' +moduleUnique+ '</span>');
			UxCB.modal.attr('data-module-unique', moduleUnique);
		});
	}
	
	//function module edit tool trash
	UxCB.fnModEditToolTrash = function(btn){
		btn.on('click', function(){
			var module = $(this).parent().parent().parent();
			var confirm = UxCB.fnModuleConfirm('Delete Module?');
			
			if(confirm == true){
				module.remove();
				UxCB.fnModuleRefreshSort();
			}
		});
	}
	
	//fn edit tool clone
	UxCB.fnModEditToolClone_new = function(b, m){
		b.on('click', function(){
			var d = new Date(),
			    dU = d.getTime(),
				mU = m.data('module-unique'),
				mC = m.clone().removeClass('module-id-' +mU).addClass('module-id-' +dU+ ' begin-clone').attr('data-module-unique', dU),
				mCS = mC.find('> .module-inside > .module-shortcode'),
				mCSH = mCS.html(),
				mCSH = mCSH.replace(/unique=\"([^\"]*)\"/, 'unique="' +dU+ '"');
			
			mCS.html(mCSH);
			UxCB.fnModEditToolsEvent(mC);
			m.after(mC.css('min-height', '55px'));
			
			setTimeout(function(){
				mC.removeClass('begin-clone');
				/*$.post(ajaxurl, {
					'action': 'ux_cb_module_clone_ajax',
					'moduleUnique': moduleUnique,
					'moduleShortcode': moduleShortcodeHtml,
					'moduleTargetUnique': moduleTargetUnique
				}).done(function(result){
				});*/
			}, 150);
			
		});
	}
	
	//function module edit tool clone
	UxCB.fnModEditToolClone = function(btn){
		btn.on('click', function(event, container, targetModule){
			var module = $(this).parent().parent().parent();
			var moduleID = module.data('module-id');
			var moduleUnique = module.data('module-unique');
			var moduleShortcode = module.find('> .module-inside > .module-shortcode');
			var postID = $('#post_ID').val();
			var date = new Date();
			var moduleTargetUnique = date.getTime();
			var moduleShortcodeHtml = moduleShortcode.html();
				moduleShortcodeHtml = moduleShortcodeHtml.replace(/unique=\"([^\"]*)\"/, 'unique="' +moduleTargetUnique+ '"');
			
			$.post(ajaxurl, {
				'action': 'ux_cb_module_clone_ajax',
				'postID': postID,
				'moduleUnique': moduleUnique,
				'moduleShortcode': moduleShortcodeHtml,
				'moduleTargetUnique': moduleTargetUnique
			}).done(function(result){
				var content = $(result);
				
				if(result != 'error'){
					module.after(content);
					UxCB.fnModuleRefreshSort();
					
					UxCB.fnModuleHover(content);
					UxCB.fnModEditToolsEvent(content);
					
					if(container){
						if(container.find('.ux-cb-group-processing').length){
							var targetModuleUnique = targetModule.data('module-unique');
							var newModuleUnique = content.data('module-unique');
							var containerProcessing = container.find('.ux-cb-group-processing');
							var subModuleCount = Number(containerProcessing.attr('data-count'));
							var containerShortcode = container.find('> .module-inside > .module-shortcode');
							var containerShortcodeHtml = containerShortcode.html();
								containerShortcodeHtml = containerShortcodeHtml.replace(targetModuleUnique, 'unique="' +newModuleUnique+ '"');
							
							containerShortcode.html(containerShortcodeHtml);
							
							subModuleCount--;
							if(subModuleCount <= 0){
								containerProcessing.remove();
							}else{
								containerProcessing.attr('data-count', subModuleCount);
							}
						}
						targetModule.remove();
						//UxCB.fnModuleRefreshSort(container.find('> .module-inside > .module-content'));
					}
					
					switch(moduleID){
						case 'masonry-grid':
							if(content.find('.grid-stack').length){
								UxCB.fnGridStackResize(content.find('.grid-stack'));
							}
						break;
						
						case 'grid':
							var moduleContent = content.find('> .module-inside > .module-content');
							UxCB.fnModuleFieldCustomGridLoaded(moduleContent);
							var modulesIsotope = module.find('.container-masonry');
							var modulesIsotopeList = modulesIsotope.find('.masonry-list');
							
							if(!modulesIsotopeList.hasClass('masonry-auto')) {
								var isotope = modulesIsotopeList.isotope({
									itemSelector: '.grid-item',
									layoutMode: 'fitRows',
									stagger: 40,
									hiddenStyle: {
									  opacity: 0
									},
									visibleStyle: {
									  opacity: 1
									}
								});
			
							} else { 
								var isotope = modulesIsotopeList.isotope({ 
									itemSelector: '.grid-item',
									layoutMode: 'packery',
									stagger: 40,
									hiddenStyle: {
									  opacity: 0
									},
									visibleStyle: {
									  opacity: 1
									}
								}); 
							}
						break;
						
						case 'group':
							if(content.find('.module').length){
								content.find('.module').each(function(index, element) {
                                    var subModule = $(this);
									var buttonClone = subModule.find('> .module-inside > .module-edit-tools > .clone');
									
									UxCB.fnModuleHover(subModule);
									UxCB.fnModEditToolsEvent(subModule);
									
									buttonClone.trigger('click', [content, subModule]);
                                });
								content.find('> .module-inside > .module-content').prepend('<div class="ux-cb-group-processing" data-count="' +content.find('.module').length+ '"></div>');
							}
						break;
						
						case 'slider':
							if(content.find('.owl-carousel').length){
								UxCB.fnModuleCarousel(content.find('.owl-carousel'));
							}
						break;
					}
				}
			});
		});
	}
	
	//function module edit tool add module
	UxCB.fnModEditToolAddMod = function(btn){
		btn.on('click', function(){
			var module = $(this).parent().parent().parent();
			var moduleID = module.data('module-id');
			
			UxCB.addModulePrototype = module;
			UxCB.pageCustomizeModuleSelector.css('z-index', 999).addClass('fadein cross-click');
			
			if(moduleID == 'group' || module.parent().is('.module-content')){
				if(moduleID == 'group'){
					UxCB.pageCustomizeModuleSelector.find('button').hide();
					UxCB.pageCustomizeModuleSelector.find('button[data-parent="' +moduleID+ '"]').css('display', 'inline-block');
				}else{
					UxCB.pageCustomizeModuleSelector.find('button').removeAttr('style');
					UxCB.pageCustomizeModuleSelector.find('button.ux-cb-module-group-selector').hide();
				}
			}else{
				UxCB.pageCustomizeModuleSelector.find('button').css('display', 'inline-block');
				UxCB.pageCustomizeModuleSelector.find('button.ux-cb-module-group-selector, button[data-parent]').removeAttr('style');
			}
			setTimeout(function(){
				UxCB.pageCustomizeModuleSelector.addClass('on');
			}, 500);
			setTimeout(function(){
				UxCB.pageCustomizeModuleSelector.find('h1').addClass('fadein');
			}, 1000);
		});
	}
	
	//function update google fonts
	UxCB.fnUpdateGoogleFonts = function(btn){
		btn.on('click', function(){
			var btnText = btn.text();
			var API_KEY = btn.data('googlekey');
			
			if(API_KEY){
				btn.text('Getting the latest google fonts ...');
				$.get('https://www.googleapis.com/webfonts/v1/webfonts?key=' + API_KEY, function(data) {
					btn.text('Update the latest google fonts ...');
					$.post(ajaxurl, {
						'action': 'ux_cb_update_google_fonts',
						'data': data
					}).done(function(result){
						result = UxCB.fnClearTrim(result);
						if(result == 'ok'){
							btn.text('Update completed, refreshing font list');
							$.post(ajaxurl, {
								'action': 'ux_cb_update_google_fonts_refresh'
							}).done(function(result){
								var googleFontSelect = $('select[name="__ux_cb_module_fonts_resource_google-font_family"]');
								googleFontSelect.html(result);
							});
						}
					});
				}, 'text');
			}else{
				btn.text('The Google API key is not set ...').attr('disable', 'disable');
			}
		});
	}
	
	//function image svg process
	UxCB.fnModuleSvgProcess = function(svg, moduleID, svgColor, svgColorMouseover, svgAlign){
		switch(moduleID){
			case 'single-image':
				var svgParent = svg.parent();
				svgColor = svgColor || $('input[name="__ux_cb_module_single_image_svg_color"]').val();
				svgColorMouseover = svgColorMouseover || $('input[name="__ux_cb_module_single_image_svg_color_mouseover"]').val();
				svgAlign = svgAlign || $('select[name="__ux_cb_module_single_image_svg_align"]').val();
				
				switch(svgAlign){
					case 'left': svgParent.addClass('align-left').removeClass('align-right'); break;
					case 'center': svgParent.removeClass('align-left align-right'); break;
					case 'right': svgParent.addClass('align-right').removeClass('align-left'); break;
				}
				
				svg.find('path').css('fill', svgColor);
				svg.hover(function(){
					svg.find('path').css('fill', svgColorMouseover);
				}, function(){
					svg.find('path').css('fill', svgColor);
				});
			break;
			
			case 'summernote':
				svg.find('path').css('fill', svgColor);
			break;
		}
		
		return svg;
	}
	
	//function module ajax fields process
	UxCB.fnModuleFieldsProcess = function(content, module, isModule, container){
		var moduleTitle = module.data('module-title');
		var moduleID = module.data('module-id');
		var moduleUnique = module.data('module-unique');
		var moduleCol = Number(module.attr('data-module-col'));
		var moduleShortcode = module.find('> .module-inside > .module-shortcode');
		var moduleShortcodeHtml = moduleShortcode.html();
		var moduleShortcodeTag = module.data('module-shortcodetag');
		var modulePaddingTop = module.attr('data-padding-top');
		var modulePaddingTopMobile = module.attr('data-padding-top-mobile');
		var modulePaddingBottom = module.attr('data-padding-bottom');
		var modulePaddingBottomMobile = module.attr('data-padding-bottom-mobile');
		var postID = $('#post_ID').val();
		
		//select, switch
		UxCB.selectControl = content.find('select.ux-cb-module-field-select, button.ux-cb-module-field-switch, ul.ux-cb-module-field-image-select');
		if(UxCB.selectControl.length){
			UxCB.selectControl.each(function(){
				var selector = $(this);
				var tagName = selector[0].tagName;
				var selectCtrl = new UxCB.classSelectControl(selector, tagName);
			});
		}
		
		//tab
		UxCB.regionTab = content.find('.ux-cb-module-field-region-tab');
		if(UxCB.regionTab.length){
			UxCB.regionTab.on('click', function(){
				var thisID = $(this).data('id');
				var thisInput = $(this).parent().find('> input');
				var thisHidden = Number($(this).data('hidden'));
				
				UxCB.regionTab.removeClass('active');
				$(this).addClass('active');
				
				content.find('.ux-cb-module-field-region-content').each(function(){
					if($(this).attr('id') != ''){
						$(this).hide();
					}
				})
				content.find('.ux-cb-module-field-region-content#' +thisID).fadeIn();
				
				if(!thisHidden){
					content.find('.ux-cb-module-field-region-content[data-hidden="1"]').removeClass('on');
					content.find('.ux-cb-module-field-region-tab[data-hidden="1"]').addClass('hidden');
					if(UxCB.modalSave.is(':hidden')){
						UxCB.modalSave.show();
					}
				}else{
					content.find('.ux-cb-module-field-region-content#' +thisID).addClass('on');
				}
				
				if(UxCB.pluginPage.length){
					if(!$(this).is('[data-id="item-settings"]')){
						if(content.find('button.item-save-button.itemsAdd').length){
							content.find('button.item-save-button.itemsAdd').removeClass('itemsAdd');
							UxCB.itemsAddClone.remove();
							UxCB.itemsAddClone = '';
						}
					}
				}
			});
		}
		
		//row section
		UxCB.sectionRow = content.find('table[data-section-ctrl]');
		if(UxCB.sectionRow.length){
			UxCB.sectionRow.each(function(){
				var thisRow = $(this);
				var thisCtrl = $(this).data('section-ctrl');
				
				if(thisCtrl){
					thisCtrl = thisCtrl.split(',');
					thisRow.attr('data-name', thisCtrl[0]);
					
					if(thisCtrl[1].indexOf("!")){
						thisCtrl = thisCtrl[1].split('|');
						$.each(thisCtrl, function(index, val){
							thisRow.addClass('control-' +val);
						});
					}
				}
			});
		}
		
		//row group
		UxCB.groupRow = content.find('tbody[data-group-ctrl]');
		if(UxCB.groupRow.length){
			UxCB.groupRow.each(function(){
				var thisRow = $(this);
				var thisCtrl = $(this).data('group-ctrl');
				
				if(thisCtrl){
					thisCtrl = thisCtrl.split(',');
					thisRow.attr('data-name', thisCtrl[0]);
					
					if(thisCtrl[1].indexOf("!")){
						thisCtrl = thisCtrl[1].split('|');
						$.each(thisCtrl, function(index, val){
							thisRow.addClass('control-' +val);
						});
					}
				}
			});
		}
		
		//row item
		UxCB.itemRow = content.find('.ux-cb-module-field-item-row');
		if(UxCB.itemRow.length){
			UxCB.itemRow.each(function(){
				var thisRow = $(this);
				var thisCtrl = $(this).data('ctrl');
				
				if(thisCtrl){
					thisCtrl = thisCtrl.split(',');
					thisRow.attr('data-name', thisCtrl[0]);
					
					if(thisCtrl[1].indexOf("!")){
						thisCtrl = thisCtrl[1].split('|');
						$.each(thisCtrl, function(index, val){
							thisRow.addClass('control-' +val);
						});
					}else{
						thisCtrl[1] = thisCtrl[1].replace('!', '');
						
						var selectCtrl = content.find('#' +thisCtrl[0]);
						var selectTagName = selectCtrl[0].tagName;
						
						if(selectCtrl.val() != thisCtrl[1]){
							thisRow.show();
						}else{
							thisRow.hide();
						}
						
						switch(selectTagName){
							case 'SELECT':
								selectCtrl.find('option').each(function(){
									if($(this).val() != thisCtrl[1]){
										thisRow.addClass('control-' +$(this).val());
									}
								});
							break;
						}
					}
				}
			});
		}
		
		if(content.find('button.update-google-fonts').length){
			content.find('button.update-google-fonts').each(function() {
                UxCB.fnUpdateGoogleFonts($(this));
            });
		}
		
		if(content.find('.ux-summernote').length){
			content.find('.ux-summernote').each(function(){
				var textarea = $(this).next('textarea');

				$(this).summernote({
					'height': 300,
					toolbar: [
						['style', ['style']],
						['font', ['bold', 'underline', 'clear']],
						['mybutton', ['uxfontsize', 'uxheight', 'uxletterspacing','uxmobilesize']],
						['color', ['color']],
						['para', ['ul', 'ol', 'paragraph']],
						['table', ['table']],
						['insert', ['link', 'uxmedia', 'uxsvg', 'video']],
						['view', ['fullscreen', 'codeview', 'help']]
					],
					buttons: {
						uxfontsize: UxCB.snButton.fontSize,
						uxheight: UxCB.snButton.lineHeight,
						uxletterspacing: UxCB.snButton.letterSpacing,
						uxmobilesize: UxCB.snButton.mobileSize,
						uxmedia: UxCB.snButton.mediaLibrary,
						uxsvg: UxCB.snButton.mediaSvgLibrary
					},
					callbacks: {
						onChange: function(contents, $editable) {
							textarea.val(contents);
						}
					}
				});
			});
		}
		
		if(content.find('.ux-cb-module-field-theme-color').length){
			content.find('.ux-cb-module-field-theme-color').find('button').each(function(){
				var btn = $(this);
				UxCB.fnModuleFieldBgColor(btn);
			});
		}
		
		if(content.find('.ux-cb-module-field-upload').length){
			UxCB.fnModuleFieldUpload(content.find('.ux-cb-module-field-upload'), moduleID);
		}
		
		if(content.find('.ux-cb-module-field-items').length){
			content.find('.ux-cb-module-field-items').sortable({
				placeholder: 'ui-sortable-placeholder',
				forcePlaceholderSize: true
			});
			content.find('.ux-cb-module-field-items').disableSelection();
			content.find('.ux-cb-module-field-items').each(function() {
				var itemsContainer = $(this);
				var itemsName = itemsContainer.attr('data-set-name');
				var itemsType = itemsContainer.attr('data-type');
				var itemsAdd = itemsContainer.prev('.add');
				var itemsItem = itemsContainer.find('> li');
				var tabSectionSettingsContent = content.find('.ux-cb-module-field-region-content[id="item-settings"]');
				var itemFields = tabSectionSettingsContent.find('[name]').serializeArray();
				
				tabSectionSettingsContent.find('[name]').each(function() {
                    if($(this).parent().is('.ux-cb-module-field-upload')){
						var uploadUrlField = [];
						
						uploadUrlField.name = $(this).attr('name')+ '-url';
						uploadUrlField.value = '';
						
						itemFields.push(uploadUrlField);
					}
                });
				
				itemsItem.each(function(){
					var itemThis = $(this);
					var itemCloneButton = itemThis.find('.clone');
					var itemEdit = itemThis.find('.edit');
					var itemRemove = itemThis.find('.remove');
					var itemUndo = itemThis.find('.undo');
					
					$.each(itemFields, function(index, field){
						if(!itemThis.find('input[name="' +field['name']+ '"]').length){
							var value = field['value'];
							if((moduleID == 'button' && field['name'] == '__ux_cb_module_button_item_text') || (moduleID == 'ux-cb-fonts-definition' && field['name'] == '__ux_cb_module_fonts_style_name') || (moduleID == 'social-media' && field['name'] == '__ux_cb_module_social_media_item_name')){
								value = itemThis.find('h6').text();
							}
							
							if(moduleID != 'ux-cb-fonts-definition'){
								itemThis.append('<input type="hidden" name="' +field['name']+ '" value="' +value+ '">');
							}
						}
					});
					
					if(!itemThis.hasClass('hidden')){
						UxCB.fnModuleFieldItemClone(itemCloneButton);
						UxCB.fnModuleFieldItemEdit(itemEdit, itemsType);
						UxCB.fnModuleFieldItemRemove(itemRemove, itemsContainer);
						UxCB.fnModuleFieldItemUndo(itemUndo, itemsContainer);
					}
				});
				
				itemsAdd.on('click', function(){
					var itemClone;
					
					if(itemsContainer.find('> li').length == 0){
						itemsContainer.append(UxCB.itemsFontsClone.clone());
					}
					
					if(itemsContainer.find('> li:last').is('.hidden')){
						itemClone = itemsContainer.find('> li:last');
						itemClone.removeClass('hidden');
					}else{
						itemClone = itemsContainer.find('> li:last').clone();
					}
					
					var itemCloneButton = itemClone.find('.clone');
					var itemEdit = itemClone.find('.edit');
					var itemRemove = itemClone.find('.remove');
					var itemUndo = itemClone.find('.undo');
					
					UxCB.fnModuleFieldItemClone(itemCloneButton);
					UxCB.fnModuleFieldItemEdit(itemEdit);
					UxCB.fnModuleFieldItemRemove(itemRemove, itemsContainer);
					UxCB.fnModuleFieldItemUndo(itemUndo, itemsContainer);
					
					itemClone.find('input[name]').val('');
					itemsContainer.append(itemClone);
					
					if(UxCB.pluginPage.length){
						UxCB.itemsAddClone = itemClone;
						itemEdit.trigger('click', 'itemsAdd');
					}
					
				});
				
				UxCB.itemsFontsClone = itemsContainer.find('> li:last').clone();
			});
			
			if(content.find('button.item-save-button').length){
				content.find('button.item-save-button').each(function() {
					UxCB.fnModuleFieldItemSaveButton($(this));
				});
			}
		}
		
		if(content.find('.ux-cb-color-picker').length){
			content.find('.ux-cb-color-picker').wpColorPicker({
				change: function(event, ui) {
					
					if(event.target.name == '__ux_cb_module_single_image_svg_color' || event.target.name == '__ux_cb_module_single_image_svg_color_mouseover'){
						var svg = $('.__ux_cb_module_single_image_svg svg');
						
						if(event.target.name == '__ux_cb_module_single_image_svg_color'){
							UxCB.fnModuleSvgProcess(svg, moduleID, ui.color.toString());
						}else{
							UxCB.fnModuleSvgProcess(svg, moduleID, false, ui.color.toString());
						}
					}
				}
			});
		}
		
		//masonry grid item spacing
		if(content.find('.__ux_cb_module_masonry_grid_item_spacing').length){
			var itemSpacing = content.find('#__ux_cb_module_masonry_grid_item_spacing');
			
			itemSpacing.change(function(){
				var itemVal = Number($(this).val());
				var itemSpacingHalf = 0;
				var removeIconPosi = 10;
				if(itemVal && itemVal > 0){
					var galleryLists = content.find('.ux-cb-module-field-gallery-lists');
					if(galleryLists.length){
						if(itemVal > 0){
							itemSpacingHalf = itemVal / 2;
							removeIconPosi = itemSpacingHalf + 10;
						}
						galleryLists.find('.grid-stack').find('.grid-stack-item-content').css({'left': itemSpacingHalf+ 'px', 'right': itemSpacingHalf+ 'px'});
						galleryLists.find('.ui-resizable-sw').css({'left': itemSpacingHalf+ 'px'});
						galleryLists.find('.ui-resizable-se').css({'right': itemSpacingHalf+ 'px'});
						galleryLists.find('.grid-item-remove').css({'right': removeIconPosi+ 'px'});
						var grid = galleryLists.find('.grid-stack').data('gridstack');
						grid.verticalMargin(itemVal);
					}
				}
			});
		}

		//masonry grid item title top spacing
		if(content.find('.__ux_cb_module_masonry_grid_style_image_text_caption_text_top_spacing').length){
			var itemSpacing = content.find('#__ux_cb_module_masonry_grid_style_image_text_caption_text_top_spacing');
			
			itemSpacing.change(function(){
				var itemVal = Number($(this).val()); 
				if(itemVal && itemVal > 0){
					var galleryLists = content.find('.ux-cb-module-field-gallery-lists');
					if(galleryLists.length){ 
						galleryLists.find('.grid-stack').find('.title-show').css({'padding-top': itemVal+ 'px'});
						
						var grid = galleryLists.find('.grid-stack').data('gridstack');
						grid.verticalMargin(itemVal);
					}
				}
			});
		}

		//masonry grid Item style change
		if(content.find('.__ux_cb_module_masonry_grid_item_style').length){
			var itemStyle = content.find('#__ux_cb_module_masonry_grid_item_style');
		
			itemStyle.change(function(){ 
				var itemStyleVal = itemStyle.val();
				if(itemStyleVal) {
					var galleryLists = content.find('.ux-cb-module-field-gallery-lists');
					if(galleryLists.length){
						
						if (itemStyleVal === 'image') {
							if(galleryLists.find('.grid-stack').hasClass('image-text')) {
								galleryLists.find('.grid-stack').removeClass('image-text');
							}
						} else {
							if(!galleryLists.find('.grid-stack').hasClass('image-text')) {
								galleryLists.find('.grid-stack').addClass('image-text');
							}
						}
					}
				}
			});
		}
		
		//portfolio gallery select images
		if(content.find('.ux-cb-module-field-gallery-button').length){
			var galleryButton = content.find('.ux-cb-module-field-gallery-button');
			var galleryLists = content.find('.ux-cb-module-field-gallery-lists');
			
			if(moduleID != 'masonry-grid'){
				galleryLists.sortable();
				
				galleryLists.find('.gallery-button-remove').on('click', function(){
					var thisGalleryItem = $(this).parent();
					thisGalleryItem.remove();
				});
			}else{
				UxCB.fnModuleMasonryGridImages(galleryLists, moduleUnique, '', galleryButton, '');
			}
			
			galleryButton.on('click', function(){
				var galleryName = galleryButton.data('gallery-name');
				var galleryThumbnailID, galleryThumbnail;
				var galleryItem = '';
				var galleryImages = [];
				
				var frame = wp.media({
					title : 'Select Images',
					multiple : true,
					library : { type : [ 'image/jpeg', 'image/gif', 'image/png', 'image/bmp', 'image/tiff', 'image/x-icon' ] },
					button : { text : 'Insert' }
				});
				
				frame.on('select',function() {
					
					var attachments = frame.state().get('selection').toJSON();
					
					for(var i=0; i<attachments.length; i++){
						galleryThumbnailID = attachments[i]['id'];
						
						if(attachments[i].sizes.thumbnail){
							galleryThumbnail = attachments[i].sizes.thumbnail.url;
						}else{
							galleryThumbnail = attachments[i].sizes.full.url;
						}
						
						if(moduleID != 'masonry-grid'){
							galleryItem += '<div class="gallery-item">';
							galleryItem += '<button type="button" class="gallery-button-remove"><span class="dashicons dashicons-no-alt"></span></button>';
							galleryItem += '<a href="#" class="thumbnail"><img src="' +galleryThumbnail+ '"/></a><input type="hidden" name="' +galleryName+ '" value="' +galleryThumbnailID+ '" /></div>';
						}else{
							galleryItem += '<div class="grid-stack-item new-item" data-postid="' +galleryThumbnailID+ '">';
							galleryItem += '<div class="grid-stack-item-content" style="background-image:url(' +galleryThumbnail+ ');"></div>';
							galleryItem += '</div>';
							
							galleryImages.push(galleryThumbnailID);
						}
					}
					
					if(moduleID == 'masonry-grid'){
						UxCB.fnModuleMasonryGridImages(galleryLists, moduleUnique, galleryImages, galleryButton, galleryItem);
					}else{
						galleryItem = $(galleryItem);
						galleryLists.append(galleryItem);
						
						galleryItem.find('.gallery-button-remove').on('click', function(){
							var thisGalleryItem = $(this).parent();
							thisGalleryItem.remove();
						});
					}
				});
				frame.open();
			});
		}
		
		//Portfolio Layout button
		if(content.find('.ux-cb-module-field-custom-grid-layouts').length){
			var layoutSource = content.find('.ux-cb-module-field-custom-grid-layouts').data('source');
			var layoutCatname = content.find('.ux-cb-module-field-custom-grid-layouts').data('catname');
			var layoutID = content.find('.ux-cb-module-field-custom-grid-layouts').attr('id');
			var layoutCurrentSource = content.find('[name="' +layoutSource+ '"]');
			var layoutCurrentCategory = 0;
			var layoutCurrentCatname = layoutCatname+ '_' +layoutCurrentSource.val();
			
			content.find('select[name^="' +layoutCatname+ '"]').each(function(index) {
				$(this).change(function(){
					layoutCurrentCategory = $(this).val();
					if(layoutCurrentCategory == 0){
						content.find('.' +layoutID).hide();
					}else{
						content.find('.' +layoutID).show();
					}
				});
			});
			
			layoutCurrentSource.change(function(){
				var changeCatname = layoutCatname+ '_' +$(this).val();
				layoutCurrentCategory = content.find('select[name="' +changeCatname+ '"]').val();
				if(layoutCurrentCategory == 0 || layoutCurrentSource.val() == 'attachment'){
					content.find('.' +layoutID).hide();
				}else{
					content.find('.' +layoutID).show();
				}
			});
			
			layoutCurrentCategory = content.find('select[name="' +layoutCurrentCatname+ '"]').val();
			if(Number(layoutCurrentCategory) == 0){
				content.find('.' +layoutID).hide();
			}else{
				content.find('.' +layoutID).show();
			}
			
			if(layoutCurrentSource.val() == 'attachment'){
				content.find('.' +layoutID).hide();
			}else{
				content.find('.' +layoutID).show();
			}
			
			UxCB.fnModuleFieldCustomGridLayouts(content.find('.ux-cb-module-field-custom-grid-layouts'));
			
			if(content.find('button.custom-grid-layout-save-button').length){
				content.find('button.custom-grid-layout-save-button').each(function() {
					UxCB.fnModuleFieldCustomGridLayoutSaveButton($(this));
				});
			}
		}
		
		//Scroll Animation Base
		if(content.find('select[name="__ux_cb_module_scroll_animation_base"]')){
			var currentSelectClass = content.find('select[name="__ux_cb_module_scroll_animation_base"]').attr('class');
			content.find('select[name="__ux_cb_module_scroll_animation_base"]').change(function(){
				var currentSelect = $(this);
				var animationContainer = currentSelect.parents('.ux-modal-dialog');
				var animationEnd = 'fadeined';
				
				animationContainer.attr('class', 'ux-modal-dialog');
				
				animationContainer.parent().addClass('no-touchevents');
				animationContainer.addClass('animation-scroll-ux');
				animationContainer.addClass(currentSelect.val());
				
				switch(currentSelect.val()){
					case 'fadein':                     animationEnd = 'fadeined'; break;
					case 'zoomin':                     animationEnd = 'zoomined'; break;
					case 'zoomout':                    animationEnd = 'zoomouted'; break;
					case 'from-left-translate':        animationEnd = 'from-left-translated'; break;
					case 'from-right-translate':       animationEnd = 'from-right-translated'; break;
					case 'from-top-translate':         animationEnd = 'from-top-translated'; break;
					case 'from-bottom-translate':      animationEnd = 'from-bottom-translated'; break;
					case 'bouncdein-left-translate':   animationEnd = 'bouncdein-left-translated'; break;
					case 'bouncdein-right-translate':  animationEnd = 'bouncdein-right-translated'; break;
					case 'bouncdein-top-translate':    animationEnd = 'bouncdein-top-translated'; break;
					case 'bouncdein-bottom-translate': animationEnd = 'bouncdein-bottom-translated'; break;
					case 'flip-x-translate':           animationEnd = 'flip-x-translated'; break;
					case 'flip-y-translate':           animationEnd = 'flip-y-translated'; break;
					case 'rotate-downleft-translate':  animationEnd = 'rotate-downleft-translated'; break;
					case 'rotate-downright-translate': animationEnd = 'rotate-downright-translated'; break;
				}
				
				animationContainer.css({'opacity': 1});
				animationContainer.addClass(animationEnd);
			});
		}
		
		//adobe typekit
		if(content.find('.ux-cb-module-fonts-adobe-typekit').length){
			UxCB.fnAdobeTypekitSubmit(content)
		}
		
		//image select
		if(content.find('.ux-cb-module-field-image-select > li').length){
			var imageSelectItem = content.find('.ux-cb-module-field-image-select > li');
			
			imageSelectItem.each(function(index, element) {
               $(this).on('click', function(){
					imageSelectItem.removeClass('selected');
					$(this).addClass('selected');
			   });
            });
		}
		
		//slider mod slide duplicate and remove
		if(content.find('table.ux-cb-module-slider-slide-group .ux-cb-module-slider-slide-group-tools > button').length){
			content.find('table.ux-cb-module-slider-slide-group .ux-cb-module-slider-slide-group-tools > button').each(function(index, element) {
				if($(this).hasClass('slide-duplicate')){
					UxCB.fnModuleSliderSlideDuplicate($(this));
				}else if($(this).hasClass('slide-remove')){
					UxCB.fnModuleSliderSlideRemove($(this));
				}
            });
		}
		
		//slider mod slide group
		if(content.find('table.ux-cb-module-slider-slide-group[data-section-mod!="template"]').length){
			UxCB.fnModuleSliderSlideRefresh(content);
		}
		
		//slider mod add slide button
		if(content.find('button.add-slide-button').length){
			content.find('button.add-slide-button').on('click', function(){
				var btn = $(this);
				var targetWrap = btn.attr('data-target');
				var slideGroupTemplate = content.find(targetWrap+ '[data-section-mod="template"]');
				
				slideGroupTemplate.find('button.slide-duplicate').trigger('click', 'add-slide');
			});
		}
		
		//slider mod slide group template
		if(content.find('table.ux-cb-module-slider-slide-group[data-section-mod="template"]').length){
			var slideGroupTemplate = content.find('table.ux-cb-module-slider-slide-group[data-section-mod="template"]');
			var slideGroupParent = slideGroupTemplate.parent();
			var slideFields = slideGroupTemplate.find('[name]').serializeArray();
			
			$.post(ajaxurl, {
				'action': 'ux_cb_module_slider_slide_fields_ajax',
				'postID': postID,
				'moduleUnique': moduleUnique,
				'slideFields': slideFields
			}, function(result){
				$.each(result, function(index, fields){
					var slideGroupClone = slideGroupTemplate.clone();
					
					if(slideGroupClone.is('[data-section-mod="template"]')){
						slideGroupClone.removeAttr('data-section-mod');
					}
					
					slideGroupClone.addClass('slide-removed');
					slideGroupClone.find('.ux-cb-module-slider-slide-group-tools > button').each(function(index, element) {
						if($(this).hasClass('slide-duplicate')){
							UxCB.fnModuleSliderSlideDuplicate($(this));
						}else if($(this).hasClass('slide-remove')){
							UxCB.fnModuleSliderSlideRemove($(this));
						}
					});
					
					slideGroupClone.find('div.wp-picker-container').each(function(index, element) {
						var colorContainer = $(this);
						var colorPickerParent = colorContainer.parent();
						var colorPicker = colorContainer.find('.ux-cb-color-picker');
						var colorPickerName = colorPicker.attr('name');
						
						colorPicker.removeClass('wp-color-picker').val(fields[colorPickerName]);
						colorPickerParent.append(colorPicker);
						colorContainer.remove();
						colorPicker.wpColorPicker();
					});
					
					if(slideGroupClone.find('.ux-cb-module-field-upload').length){
						slideGroupClone.find('.ux-cb-module-field-upload input').each(function(index, element) {
                            var input = $(this);
                            var inputName = input.attr('name');
							
							if(input.prev().is('img')){
								input.prev().attr('src', fields[inputName]);
							}
							
							input.val(fields[inputName]);
                        });
						
						UxCB.fnModuleFieldUpload(slideGroupClone.find('.ux-cb-module-field-upload'), moduleID);
					}
					
					if(slideGroupClone.find('.ux-cb-module-field-select').length){
						slideGroupClone.find('.ux-cb-module-field-select').each(function() {
							var select = $(this),
								selectName = select.attr('name');
								
							select.val(fields[selectName]);
						});
					}
					
					
					var slideGroupLast = slideGroupParent.find('table.ux-cb-module-slider-slide-group:last');
					slideGroupLast.after(slideGroupClone);
					
					setTimeout(function(){
						slideGroupClone.removeClass('slide-removed');
						UxCB.fnModuleSliderSlideRefresh();
					}, 310);
					
					
				});
				//result = $(result);
				
				//slideGroupTemplate.after(result);
			}, "json");
		}
		
		if(content.find('.custom-fonts-group').length){
			function fnCustomFontsGroupAdd(addItem, content){
				addItem.click(function(){
					var last = content.find('.custom-fonts-group:last'),
						clone = last.clone(),
						cloneAdd = clone.find('button.add-item'),
						cloneRemove = clone.find('button.remove-item');
					
					cloneAdd.addClass('hidden');
					cloneRemove.removeClass('hidden');
					clone.find('option').removeAttr('selected');
					clone.find('input').val('');
					fnCustomFontsGroupRemove(cloneRemove, content);
					//fnCustomFontsGroupAdd(cloneAdd, content);
					last.after(clone);
				});
			}
			
			function fnCustomFontsGroupRemove(removeItem, content){
				removeItem.click(function(){
					var confirm = UxCB.fnModuleConfirm('Delete Item?'),
						thisItem = $(this).parent();
						
					if(confirm == true){
						thisItem.remove();
					}
				});
			}
			
			content.find('.custom-fonts-group').each(function(){
				var customFontsGroup = $(this),
					addItem = customFontsGroup.find('button.add-item'),
					removeItem = customFontsGroup.find('button.remove-item');
				
				fnCustomFontsGroupAdd(addItem, content);
				fnCustomFontsGroupRemove(removeItem, content);
			});
		}
		
		if(content.find('.ux-cb-module-field-select-icons').length){
			content.find('.ux-cb-module-field-select-icons').each(function(){
				var selectWrap = $(this),
					selectIcons = selectWrap.find('a'),
					selectInput = selectWrap.parent().find('input[name]');
				
				selectIcons.click(function(){
					var icon = $(this).find('i');
					var iconVal = icon.attr('class');
					var iconType = 'fontawesome';

					selectIcons.removeClass('current');
					$(this).addClass('current');
					selectInput.val(iconVal);
					return false;
				});
		   });
		}
		
		if(content.find('.ux-cb-module-field-mod-meta-fix-list').length){
			content.find('.ux-cb-module-field-mod-meta-fix-list').each(function(){
				var currentList = $(this);
				
				$.post(ajaxurl, {
					'action': 'ux_cb_module_field_mod_meta_fix_list_ajax',
				}).done(function(result){
					var ajaxContent = $(result);
					
					currentList.html(result);
					
					currentList.find('h6').click(function(){
						var itemTable = $(this).next('table');
						if(itemTable.is(':hidden')){
							itemTable.show();
						}else{
							itemTable.hide();
						}
					});
					
					currentList.find('button').each(function(){
						var btn = $(this),
							moduleID = btn.attr('data-id'),
							postID = btn.attr('data-postid'),
							btnParent = btn.parent().parent(),
							btnParents = btn.parents('.fix-item'),
							metaKey = btnParent.find('.meta_key').text();
						
						if(metaKey == 'module_id'){
							var hasError = btnParents.find('tr.error');
							
							btnParent.hide();
							if(hasError.length == 1){
								btnParent.show();
							}
						}
						
						btn.click(function(){
							$.post(ajaxurl, {
								'action': 'ux_cb_module_field_mod_meta_fix_button_ajax',
								'metaKey': metaKey,
								'moduleID': moduleID,
								'postID': postID
							}).done(function(result){
								if(result == 'ok'){
									btn.attr('disabled', 'disabled');
									btnParent.removeClass('error').addClass('normal');
									btnParent.find('span.error').removeClass('error').addClass('normal').text('normal');
									
									
									var hasError = btnParents.find('tr.error');
									if(hasError.length == 1){
										btnParents.find('tr.error').parent().show();
									}
								}
							});
						});
					});
				});
		   });
		}
		
		if(isModule){
			UxCB.modalBody.append(content);
			UxCB.modalBody.find('> .ux-cb-module-loading').addClass('hidden');
		}else{
			container.append(content);
		}
		
		if(!UxCBModules[moduleUnique]){
			var fields = UxCB.modal.find('[name]').serializeArray();
			UxCBModules[moduleUnique] = fields;
		}
		
		$.each(UxCBModules[moduleUnique], function(index, field){
			switch(field['name']){
				case '__ux_cb_module_top_padding':
					UxCB.modal.find('#__ux_cb_module_top_padding').val(Number(modulePaddingTop));
				break;
				
				case '__ux_cb_module_top_padding_mobile':
					UxCB.modal.find('#__ux_cb_module_top_padding_mobile').val(Number(modulePaddingTopMobile));
				break;
				
				case '__ux_cb_module_bottom_padding':
					UxCB.modal.find('#__ux_cb_module_bottom_padding').val(Number(modulePaddingBottom));
				break;
				
				case '__ux_cb_module_bottom_padding_mobile':
					UxCB.modal.find('#__ux_cb_module_bottom_padding_mobile').val(Number(modulePaddingBottomMobile));
				break;
			}
		});
	}
	
	//function module field upload
	UxCB.fnModuleFieldUpload = function(content, moduleID){
		content.each(function(){
			var uploadContainer = $(this);
			var uploadAddBtn = uploadContainer.find('button.add');
			var uploadRemoveBtn = uploadContainer.find('button.remove');
			var uploadInput = uploadContainer.find('> input');
			var uploadName = uploadInput.attr('name');
			var uploadImage = uploadContainer.find('.image');
			var uploadImageSvg = uploadImage.find('> img[src$=".svg"]');
			var uploadPlaceholder = uploadImage.find('.placeholder');
			var libraryType = uploadContainer.data('format');
			
			if(uploadContainer.parent().is('.ux-cb-module-field-upload-fonts')){
				libraryType = [ 'application', 'image' ];
			}
			
			if(uploadImageSvg.length){
				var svgURL = uploadImageSvg.attr('src');
				$.get(svgURL, 'html').done(function(result){
					var svg = $(result).find('svg');
					
					uploadImageSvg.parent().append(svg);
					UxCB.fnModuleSvgProcess(svg, 'single-image');
					uploadImageSvg.remove();
				});
			}
			
			uploadAddBtn.on('click', function(){
				var frame = wp.media({
					title : 'Choose Image',
					multiple : false,
					library : { type : libraryType },
					button : { text : 'Select' }
				});
				
				frame.on('select',function() {
					var first = frame.state().get('selection').first().toJSON();
					var attachments = frame.state().get('selection').toJSON();
					
					if(moduleID == 'ux-cb-fonts-definition'){
						uploadInput.val(first['url']);
					}else{
						uploadImage.find('img').remove();
						uploadImage.find('svg').remove();
						
						if(first['subtype'] == 'svg+xml'){
							$.get(first['url'], 'html').done(function(result){
								var svg = $(result).find('svg');
								
								uploadImage.append(svg);
								UxCB.fnModuleSvgProcess(svg, moduleID);
								
							});							
						}else{
							uploadImage.append('<img src="' +first['url']+ '">');
						}
						
						uploadImage.find('input[name="' +uploadName+ '-url"]').remove();
						uploadImage.append('<input type="hidden" name="' +uploadName+ '-url" value="' +first['url']+ '">');
						uploadInput.val(first['id']);
						
						setTimeout(function(){
							if(uploadImage.find('img').length || uploadImage.find('svg').length){
								uploadRemoveBtn.show();
								uploadPlaceholder.hide();
							}else{
								uploadPlaceholder.show();
							}
						}, 100);
					}
				});
					
				frame.open();
			});
			
			uploadRemoveBtn.on('click', function(){
				uploadImage.find('img, svg').remove();
				uploadInput.val('');
				uploadPlaceholder.show();
				uploadRemoveBtn.hide();
			});
		});
	}
	
	//function module slider slide duplicate
	UxCB.fnModuleSliderSlideDuplicate = function(btn){
		btn.on('click', function(event, mod){
			var btn = $(this);
			var slideGroup = btn.parents('table.ux-cb-module-slider-slide-group');
			var slideGroupIndex = Number(slideGroup.attr('data-index'));
			var slideGroupParent = slideGroup.parent();
			var slideGroups = slideGroupParent.find('table.ux-cb-module-slider-slide-group[data-section-mod!="template"]');
			var moduleID = UxCB.modalBody.find('[name="module_id"]').val();
			//var scrollTop = slideGroup.position().top;
			
			var slideGroupClone = slideGroup.clone();
			
			if(slideGroupClone.is('[data-section-mod="template"]')){
				slideGroupClone.removeAttr('data-section-mod');
			}
			
			slideGroupClone.addClass('slide-removed');
			slideGroupClone.find('.ux-cb-module-slider-slide-group-tools > button').each(function(index, element) {
				if($(this).hasClass('slide-duplicate')){
					UxCB.fnModuleSliderSlideDuplicate($(this));
				}else if($(this).hasClass('slide-remove')){
					UxCB.fnModuleSliderSlideRemove($(this));
				}
			});
			
			slideGroupClone.find('div.wp-picker-container').each(function(index, element) {
				var colorContainer = $(this);
				var colorPickerParent = colorContainer.parent();
                var colorPicker = colorContainer.find('.ux-cb-color-picker');
				
				colorPicker.removeClass('wp-color-picker');
				colorPickerParent.append(colorPicker);
				colorContainer.remove();
				colorPicker.wpColorPicker();
            });
			
			if(slideGroupClone.find('.ux-cb-module-field-upload').length){
				UxCB.fnModuleFieldUpload(slideGroupClone.find('.ux-cb-module-field-upload'), moduleID);
			}
			
			var slideGroupLast = slideGroupParent.find('table.ux-cb-module-slider-slide-group:last');
			
			slideGroupLast.after(slideGroupClone);
			UxCB.modalBodyScrollTop = UxCB.modalBody.scrollTop();
			if(mod == 'add-slide'){
				if(!slideGroupLast.is('[data-section-mod="template"]')){
					UxCB.modalBodyScrollTop = slideGroupLast.position().top + slideGroupLast.outerHeight();
				}
			}else{
				UxCB.modalBodyScrollTop = UxCB.modalBodyScrollTop + slideGroupClone.outerHeight();
			}
			
			if(!slideGroupLast.is('[data-section-mod="template"]')){
				UxCB.modalBody.animate({'scrollTop': UxCB.modalBodyScrollTop}, 300);
			}
			
			setTimeout(function(){
				slideGroupClone.removeClass('slide-removed');
				UxCB.fnModuleSliderSlideRefresh();
			}, 310);
			
			//wpUploader.find('.ux-cb-color-picker').wpColorPicker();
		});
	}
	
	//function module slider slide remove
	UxCB.fnModuleSliderSlideRemove = function(btn){
		btn.on('click', function(){
			var slideGroup = btn.parents('table.ux-cb-module-slider-slide-group');
			var slideGroupParent = slideGroup.parent();
			
			slideGroup.addClass('slide-removed');
			setTimeout(function(){
				slideGroup.remove();
				UxCB.fnModuleSliderSlideRefresh();
				
				var slideGroupLast = slideGroupParent.find('table.ux-cb-module-slider-slide-group:last');
				UxCB.modalBodyScrollTop = UxCB.modalBody.scrollTop();
				UxCB.modalBodyScrollTop = UxCB.modalBodyScrollTop - slideGroup.outerHeight();
				UxCB.modalBody.animate({'scrollTop': UxCB.modalBodyScrollTop}, 300);
			}, 310);
			
		});
	}
	
	//function module slider slide refresh
	UxCB.fnModuleSliderSlideRefresh = function(content){
		content = content || UxCB.modalBody;
		
		if(content.find('table.ux-cb-module-slider-slide-group[data-section-mod!="template"]').length){
			var slideGroupNum = content.find('table.ux-cb-module-slider-slide-group[data-section-mod!="template"]').length;
			
			content.find('table.ux-cb-module-slider-slide-group[data-section-mod!="template"] button.slide-remove').removeClass('hidden');
			content.find('table.ux-cb-module-slider-slide-group[data-section-mod!="template"]').each(function(index, element){
				var btnRemove = $(this).find('.slide-remove');
				var slideGroupIndex = index+1;
				var slideGroupTitle = $(this).find('.ux-cb-module-slider-slide-group-title');
				
				if(slideGroupNum == 1){
					btnRemove.addClass('hidden');
				}
				
				$(this).attr('data-index', index);
				slideGroupTitle.html('slide ' +slideGroupIndex++);
				
				/*btnRemove.removeClass('hidden');
				if(index == 0){
					btnRemove.addClass('hidden');
				}*/
			});
		}
	}
	
	//function module masonry grid images
	UxCB.fnModuleMasonryGridImages = function(galleryLists, moduleUnique, galleryImages, galleryButton, galleryItem){
		var postID = $('#post_ID').val();
		var galleryButtonText = galleryButton.text();
		
		galleryLists.addClass('hasgrid');
		
		if(galleryLists.find('.grid-stack-item').length){
			var grid = galleryLists.find('.grid-stack').data('gridstack');
			
			galleryItem = $(galleryItem);
			galleryItem.each(function(index, element) {
				grid.addWidget($(this), 0, 0, 3, 3, true);
            });
		}else{
			galleryButton.attr('disabled', 'disabled').text('loading layout');
			$.post(ajaxurl, {
				'action': 'ux_cb_module_field_custom_grid_layouts_ajax',
				'postID': postID,
				'source': 'attachment',
				'moduleUnique': moduleUnique,
				'galleryImages': galleryImages,
				'taxonomy': 'ux-attachment-cat',
				'catID': '-1'
			}).done(function(result){
				var content = $('<div class="ux_cb_module_field_custom_grid_layouts_ajax">' +result+ '</div>');
				var removeButton = '<button type="button" class="grid-item-remove"><span class="dashicons dashicons-no-alt"></span></button>';
				var itemSpacingWrap = $('[name="__ux_cb_module_masonry_grid_item_spacing"]');
				var itemSpacing = 0;
				var itemSpacingHalf = 0;
				var removeIconPosi = 10;
				
				content.find('.grid-stack-item').append(removeButton);
				
				galleryLists.html(content);
				galleryButton.removeAttr('disabled').text(galleryButtonText);
				
				if(galleryLists.find('.grid-stack').length){
					if(Number(itemSpacingWrap.val()) != ''){
						itemSpacing = Number(itemSpacingWrap.val());
					}
					
					if(itemSpacing > 0){
						itemSpacingHalf = itemSpacing / 2;
						removeIconPosi  = itemSpacingHalf+10;
					}
					galleryLists.find('.grid-stack').find('.grid-stack-item-content').css({'left': itemSpacingHalf + 'px', 'right': itemSpacingHalf + 'px'});
					
					var cellHeight = UxCB.fnGridstackCellHeight(galleryLists, itemSpacing);
					galleryLists.find('.grid-stack').gridstack({
						verticalMargin: itemSpacing,
						width: UxCB.gridstackColumns,
						cellHeight: cellHeight,
						resizable: {
							handles: 'e, se, s, sw, w'
						}
					});

					setTimeout(function(){
						content.find('.grid-stack-item').find('.grid-item-remove').css({'right': removeIconPosi+ 'px'});
						galleryLists.find('.ui-resizable-sw').css({'left': itemSpacingHalf+ 'px'});
						galleryLists.find('.ui-resizable-se').css({'right': itemSpacingHalf+ 'px'});
					},10);
				}
				
				content.find('.grid-item-remove').on('click', function(){
					var grid = content.find('.grid-stack').data('gridstack');
					var gridItem = $(this).parent();
					grid.removeWidget(gridItem);
				});
			});
		}
		
	}
	
	//function module bg color
	UxCB.fnModuleFieldBgColor = function(btn){
		btn.on('click', function(){
			var container = $(this).parent('.ux-cb-module-field-theme-color');
			var containerInput = container.find('input');
			var colorValue = $(this).data('value');
			
			container.find('button').removeClass('active');
			$(this).addClass('active');
			containerInput.val(colorValue);
		});
	}
	
	//function module field item clone
	UxCB.fnModuleFieldItemClone = function(btn){
		btn.on('click', function(){
			var itemThis = $(this).parent('li');
			var itemParent = itemThis.parent('ul');
			var itemClone = itemThis.clone();
			
			var itemCloneButton = itemClone.find('.clone');
			var itemEdit = itemClone.find('.edit');
			var itemRemove = itemClone.find('.remove');
			var itemUndo = itemClone.find('.undo');
			
			itemClone.find('> h6').append(' (clone)');
			
			UxCB.fnModuleFieldItemClone(itemCloneButton);
			UxCB.fnModuleFieldItemEdit(itemEdit);
			UxCB.fnModuleFieldItemRemove(itemRemove, itemParent);
			UxCB.fnModuleFieldItemUndo(itemRemove, itemParent);
			
			itemParent.append(itemClone);
		});
	}
	
	//function module field item edit
	UxCB.fnModuleFieldItemEdit = function(btn, itemType){
		itemType = itemType || false;
		btn.on('click', function(event, a){
			var itemThis = $(this).parent('li');
			var itemParent = itemThis.parent('ul');
			var itemInput = itemThis.find('input[name]');
			var itemParents = itemThis.parents('.ux-cb-module-fields-container');
			var tabSectionSettingsTab = itemParents.find('.ux-cb-module-field-region-tab[data-id="item-settings"]');
			var tabSectionSettingsContent = itemParents.find('.ux-cb-module-field-region-content[id="item-settings"]');
			var itemFields = tabSectionSettingsContent.find('[name]').serializeArray();
			
			if(UxCB.pluginPage.length){
				if(a == 'itemsAdd'){
					tabSectionSettingsContent.find('[name="__ux_cb_module_fonts_resource"]').val('none').trigger('change');
					tabSectionSettingsContent.find('[name="__ux_cb_module_fonts_style_name"]').val('');
					//tabSectionSettingsContent.find('.ux-cb-module-fonts-resource-wrap').html('');
					tabSectionSettingsContent.find('button.item-save-button').addClass('itemsAdd');
				}else{
					var unique = itemThis.find('input[name="_ux_cb_module_fonts_items"]').val(),
					    unique = UxCB.fnClearTrim(unique);
					
					$.post(ajaxurl, {
						'action': "ux_cb_fonts_load_font",
						'unique': unique
					}, function(result) {
						tabSectionSettingsContent.find('[name]').each(function(){
							var input = $(this);
							var name = $(this).attr('name');
							$.each(result, function(index, field){
								if(field.name == name){
									input.val(field.value);
									
									if(name == '__ux_cb_module_fonts_resource'){
										input.trigger('change', ['itemsEdit', result]);
									}
								}
							});
						});
						
						//tabSectionSettingsContent
					}, "json");
				}
			}else{
				if(itemType == 'textGroup'){
					var td = itemParent.parents('td'),
						tdWidth = td.width(),
						ulParent = itemParent.parent(),
						itemsName = itemParent.attr('data-set-name'),
						itemInput = itemThis.find('input[name="' +itemsName+ '"]'),
						textGroup = ulParent.find('.ux-cb-module-field-text-group'),
						selectGroup = textGroup.find('[name^="textGroupFontsGroup"]'),
						applyButton = textGroup.find('button.textGroupApply'),
						itemTitle = itemThis.find('h6').text();
						
					tdWidth = tdWidth + 5;
					textGroup.find('th > span').text(itemTitle);
					
					ulParent.css({
						'-webkit-transform': 'translateX(-'+tdWidth+'px)',
						    '-ms-transform': 'translateX(-'+tdWidth+'px)',
						     '-o-transform': 'translateX(-'+tdWidth+'px)',
						   '-moz-transform': 'translateX(-'+tdWidth+'px)',
						        'transform': 'translateX(-'+tdWidth+'px)'
					});

					textGroup.css('display','inline-block');
					
					if(selectGroup.length){
						selectGroup.each(function(){
							var selectName = $(this).attr('name'),
								selectID = $(this).attr('id'),
								selectSlug = selectName.replace('textGroupFontsGroup_', ''),
								mapInput = itemThis.find('input[name="' +itemsName+ '_' +itemInput.val()+ '_' +selectSlug+ '"]');
							
							if(selectSlug == 'color'){
								if(mapInput.val() != ''){
									$(this).wpColorPicker('color', mapInput.val());
								}else{
									var selectParent = $(this).parents('.wp-picker-container');
									selectParent.find('.wp-color-result').removeAttr('style');
								}
								
							}else if(selectSlug == 'spacing'){
								var selectNum = selectID.replace('textGroupFontsGroup_spacing_', ''),
									mapInputVal = mapInput.val().split(',');
									
								$(this).val(mapInputVal[Number(selectNum)]);
							}else{
								$(this).val(mapInput.val());
							}
					    });
					}
					
					applyButton.one('click', function(){
						ulParent.css({
							'-webkit-transform': 'translateX(0px)',
								'-ms-transform': 'translateX(0px)',
								 '-o-transform': 'translateX(0px)',
							   '-moz-transform': 'translateX(0px)',
									'transform': 'translateX(0px)'
						});
						textGroup.css('display','none');
						
						var spacingVal = [];
						
						if(selectGroup.length){
							selectGroup.each(function(){
								var selectName = $(this).attr('name'),
									selectSlug = selectName.replace('textGroupFontsGroup_', ''),
									mapInput = itemThis.find('input[name="' +itemsName+ '_' +itemInput.val()+ '_' +selectSlug+ '"]');
								
								if(selectSlug == 'spacing'){
									spacingVal.push($(this).val());
									mapInput.val(spacingVal.join(','));
								}else{
									mapInput.val($(this).val());
								}
							});
						}
					});
					
				}else{
					itemInput.each(function(){
						var input = $(this);
						var inputName = input.attr('name');
						var inputValue = input.val();
						var setting = tabSectionSettingsContent.find('[name="' +inputName+ '"]');
						
						inputValue = inputValue.split(',');
						
						if(setting.length){
							setting.each(function(index, element) {
								var setting = $(this);
								var settingName = setting.attr('name');
								
								if(setting.hasClass('ux-cb-color-picker')){
									var settingParent = setting.parents('.wp-picker-container');
									if(inputValue){
										settingParent.find('.wp-color-result').attr('style', 'background-color: ' +inputValue+ ';');
									}else{
										settingParent.find('.wp-color-result').removeAttr('style');
									}
								}
								
								if(setting.prev().is('button.ux-cb-module-field-switch')){
									var currentInputValue = inputValue[index];
									if(currentInputValue == ''){
										currentInputValue = 'off';
									}
									
									if(inputValue[index] == 'on'){
										if(!setting.prev().hasClass(inputValue[index])){
											setting.prev().trigger('click');
										}
									}
								}
								
								if(setting.prev().is('.ux-cb-module-field-select-icons')){
									var currentInputValue = inputValue[index];
									    currentInputValue = currentInputValue.replace('fa ', '');
									
									if(currentInputValue != ''){
										setting.prev('.ux-cb-module-field-select-icons').find('.current').removeClass('current');
										setting.prev('.ux-cb-module-field-select-icons').find('i.' +currentInputValue).parent().addClass('current');
									}
								}
								
								if(setting.parent().is('.ux-cb-module-field-upload')){
									var uploadImage = setting.parent().find('> .image'),
										uploadPlaceholder = uploadImage.find('.placeholder'),
										uploadAddBtn = setting.parent().find('button.add'),
										uploadRemoveBtn = setting.parent().find('button.remove');
									
									uploadRemoveBtn.hide();
									uploadPlaceholder.show();
									
									if(inputValue[index] != ''){
										$.post(ajaxurl, {
											'action': "ux_cb_field_upload_get_image",
											'postID': inputValue[index]
										}, function(result) {
											
											
											uploadImage.find('img').remove();
											uploadImage.find('svg').remove();
											
											if(result['post_mime_type'] == 'svg+xml'){
												$.get(result['guid'], 'html').done(function(result){
													var svg = $(result).find('svg');
													
													uploadImage.append(svg);
												});
											}else{
												uploadImage.append('<img src="' +result['guid']+ '">');
											}
											
											setTimeout(function(){
												if(uploadImage.find('img').length || uploadImage.find('svg').length){
													uploadRemoveBtn.show();
													uploadPlaceholder.hide();
												}else{
													uploadPlaceholder.show();
												}
											}, 100)
										}, 'json');
									}
								}
								
								setting.val(inputValue[index]);
							});
						}
					});
					UxCB.modalSave.hide();
				}
			}
			
			itemParent.find('> li').removeClass('active');
			itemThis.addClass('active');
			tabSectionSettingsTab.removeClass('hidden').trigger('click');
		});
	}
	
	//function module field item remove
	UxCB.fnModuleFieldItemRemove = function(btn, itemsContainer){
		btn.on('click', function(){
			var item = $(this).parent();
			var itemParents = btn.parents('.ux-cb-module-fields-container');
			var moduleID = itemParents.find('[name="module_id"]').val();
			
			if(moduleID != 'ux-cb-fonts-definition'){
				var containerName = itemsContainer.attr('data-set-name'),
					itemInput = item.find('input[name="' +containerName+ '"]'),
					itemInputVal = itemInput.val();
				
				item.find('button').addClass('hidden');
				item.find('button.undo').removeClass('hidden');
				item.find('h6').css('color', '#eee');
				itemInput.val(itemInputVal+ '_disabled');
				
				//var confirm = UxCB.fnModuleConfirm('Delete Item?');
				//if(confirm == true){
					if(moduleID == 'button'){
						if(itemsContainer.find('> li').length > 1){
							item.remove();
						}else{
							item.addClass('hidden');
							item.find('h6').text('Button 1');
							item.find('input').val('');
						}
					}
				//}
			}else{
				var confirm = UxCB.fnModuleConfirm('Delete Item?');
				if(confirm == true){
					if(itemsContainer.find('> li').length > 1){
						item.remove();
					}else{
						item.addClass('hidden');
						
						if(moduleID == 'button'){
							item.find('h6').text('Button 1');
						}else if(moduleID == 'social-media'){
							item.find('h6').text('Link 1');
						}else{
							item.find('h6').text('Item 1');
						}
						item.find('input').val('');
					}
				}
			}
		});
	}
	
	//function module field item undo
	UxCB.fnModuleFieldItemUndo = function(btn, itemsContainer){
		btn.on('click', function(){
			var item = $(this).parent();
			var itemParents = btn.parents('.ux-cb-module-fields-container');
			var moduleID = itemParents.find('[name="module_id"]').val();
			
			if(moduleID != 'ux-cb-fonts-definition'){
				var containerName = itemsContainer.attr('data-set-name'),
					itemInput = item.find('input[name="' +containerName+ '"]'),
					itemInputVal = itemInput.val();
				
				item.find('button').removeClass('hidden');
				item.find('button.undo').addClass('hidden');
				item.find('h6').removeAttr('style');
				
				itemInput.val(itemInputVal.replace('_disabled',''));
			}
		});
	}
	
	//function gridstack cellHeight
	UxCB.fnGridstackCellHeight = function(ajaxContentContainer, verticalMargin){
		var gridStackItemOne = ajaxContentContainer.find('.grid-stack > .grid-stack-item').eq(0),
			cellHeight = 30;

		if(gridStackItemOne.length){
		   var thisItemWidth = gridStackItemOne.width(),
			   thisItemGsWidth = Number(gridStackItemOne.attr('data-gs-width')),
			   thisItemGsHeight = Number(gridStackItemOne.attr('data-gs-height')),
			   thisCellHeight = thisItemWidth / thisItemGsWidth;

			cellHeight = thisCellHeight - verticalMargin;
		}
		
		return cellHeight;
	}
	
	//function module field custom grid layouts
	UxCB.fnModuleFieldCustomGridLayouts = function(btn){
		btn.on('click', function(){
			var tabCustomGridLayoutsSettingsTab = UxCB.modalBody.find('.ux-cb-module-field-region-tab[data-id="custom-grid-layouts-settings"]');
			var tabCustomGridLayoutsSettingsContent = UxCB.modalBody.find('.ux-cb-module-field-region-content[id="custom-grid-layouts-settings"]');
			var ajaxContentContainer = tabCustomGridLayoutsSettingsContent.find('.ux-cb-module-field-ajax-content');
			var layoutSource = btn.data('source');
			var layoutCatname = btn.data('catname');
			var layoutCurrentSource = UxCB.modalBody.find('[name="' +layoutSource+ '"]');
			var layoutCurrentCatname = layoutCatname+ '_' +layoutCurrentSource.val();
			var categorySource = UxCB.modalBody.find('[name="' +layoutCurrentCatname+ '"]');
			var categoryTaxonomy = categorySource.data('taxonomy');
			var postID = $('#post_ID').val();
			var moduleUnique = UxCB.modal.attr('data-module-unique');
			var layoutImages = UxCB.modalBody.find('input[name="__ux_cb_module_masonry_grid_media_images"]').serializeArray();
			
			$.post(ajaxurl, {
				'action': 'ux_cb_module_field_custom_grid_layouts_ajax',
				'catID': categorySource.val(),
				'postID': postID,
				'taxonomy': categoryTaxonomy,
				'source': layoutCurrentSource.val(),
				'moduleUnique': moduleUnique,
				'images': layoutImages
			}).done(function(result){
				var content = $('<div class="ux_cb_module_field_custom_grid_layouts_ajax">' +result+ '</div>');
				
				ajaxContentContainer.html(content);
				tabCustomGridLayoutsSettingsTab.removeClass('hidden').trigger('click');
				
				if(ajaxContentContainer.find('.grid-stack').length){
					var cellHeight = UxCB.fnGridstackCellHeight(ajaxContentContainer, 20);
					
					ajaxContentContainer.find('.grid-stack').gridstack({
						verticalMargin: 20,
						width: UxCB.gridstackColumns,
						cellHeight: cellHeight,
						resizable: {
							handles: 'e, se, s, sw, w'
						}
					});
					
					var grid = ajaxContentContainer.find('.grid-stack').data('gridstack');
					
					if(content.find('> .grid-stack-item').length){
						content.find('> .grid-stack-item').each(function(){
							grid.addWidget($(this), 0, 0, 3, 3, true);
						});
					}
				}
				
				UxCB.modalSave.hide();
				
				if(ajaxContentContainer.find('.grid-stack').length){
					//UxCB.fnGridStackResize(ajaxContentContainer.find('.grid-stack'));
				}
			});
		});
	}
	
	//function module field item save button
	UxCB.fnModuleFieldItemSaveButton = function(btn){
		btn.on('click', function(){
			var itemParents = btn.parents('.ux-cb-module-fields-container');
			var tabSectionSettingsContent = itemParents.find('.ux-cb-module-field-region-content[id="item-settings"]');
			var tabGeneralSettingsTab = itemParents.find('.ux-cb-module-field-region-tab[data-id="general-settings"]');
			var itemFields = tabSectionSettingsContent.find('[name]').serializeArray();
			var targetItems = btn.attr('data-target');
			var itemsContainer = itemParents.find(targetItems);
			var moduleID = itemParents.find('[name="module_id"]').val();
			
			tabSectionSettingsContent.find('input[name]').each(function(){
				if($(this).is('[type="number"]')){
					if($(this).val() == ''){
						$(this).val('0');
					}
				}
			});
			itemFields = tabSectionSettingsContent.find('[name]').serializeArray();
			
			if(itemsContainer.length){
				var itemsItem = itemsContainer.find('> li.active');
				
				if(moduleID == 'ux-cb-fonts-definition'){
					var unique = itemsItem.find('[name="_ux_cb_module_fonts_items"]');
					var itemUnique = '';
					
					if(unique.length){
						itemUnique = unique.val();
					}
					
					if($(this).hasClass('itemsAdd')){
						$(this).removeClass('itemsAdd');
					}
					
					itemFields = tabSectionSettingsContent.find('[name]:visible').serializeArray();
					$.post(ajaxurl, {
						'action': 'ux_cb_fonts_definition_save',
						'itemFields': itemFields,
						'itemUnique': itemUnique
					}).done(function(result){
						var itemText = tabSectionSettingsContent.find('[name="__ux_cb_module_fonts_style_name"]').val();
						itemsItem.find('h6').text(itemText);
						itemsItem.find('input[name="_ux_cb_module_fonts_items"]').val(result);
						tabGeneralSettingsTab.trigger('click');
					});
				}
				
				var newItemFields = [];
				$.each(itemFields, function(index, field){
					if(newItemFields[field['name']]){
						var pushArray = [];
						
						if(newItemFields[field['name']].constructor === Array){
							pushArray = newItemFields[field['name']];
						}else{
							pushArray.push(newItemFields[field['name']]);
						}
						pushArray.push(field['value']);
						newItemFields[field['name']] = pushArray;
					}else{
						newItemFields[field['name']] = field['value'];
					}
					
					var newValue = newItemFields[field['name']];
					if(newValue.constructor === Array){
						newValue = newValue.join(',');
					}
					
					if(itemsItem.find('input[name="' +field['name']+ '"]').length){
						itemsItem.find('input[name="' +field['name']+ '"]').val(newValue);
					}
				});
				
				switch(moduleID){
					case 'ux-cb-fonts-definition':
						var itemText = itemsItem.find('[name="__ux_cb_module_fonts_style_name"]').val();
						itemsItem.find('h6').text(itemText);
					break;
					case 'button':
						var itemText = itemsItem.find('[name="__ux_cb_module_button_item_text"]').val();
						itemsItem.find('h6').text(itemText);
					break;
					case 'social-media':
						var itemText = itemsItem.find('[name="__ux_cb_module_social_media_item_name"]').val();
						itemsItem.find('h6').text(itemText);
					break;
				}
			}
			
			if(moduleID != 'ux-cb-fonts-definition'){
				UxCB.modalSave.show();
				tabGeneralSettingsTab.trigger('click');
			}
		});
	}
	
	//function module field custom grid layout save button
	UxCB.fnModuleFieldCustomGridLayoutSaveButton = function(btn){
		btn.on('click', function(){
			var tabGeneralSettingsTab = UxCB.modalBody.find('.ux-cb-module-field-region-tab[data-id="general-settings"]');
			var tabCustomGridLayoutsSettingsTab = UxCB.modalBody.find('.ux-cb-module-field-region-tab[data-id="custom-grid-layouts-settings"]');
			var tabCustomGridLayoutsSettingsContent = UxCB.modalBody.find('.ux-cb-module-field-region-content[id="custom-grid-layouts-settings"]');
			var ajaxContentContainer = tabCustomGridLayoutsSettingsContent.find('.ux-cb-module-field-ajax-content');
			var layoutSource = UxCB.modalBody.find('.ux-cb-module-field-custom-grid-layouts').data('source');
			var layoutCatname = UxCB.modalBody.find('.ux-cb-module-field-custom-grid-layouts').data('catname');
			var layoutCurrentSource = UxCB.modalBody.find('[name="' +layoutSource+ '"]');
			var layoutCurrentCatname = layoutCatname+ '_' +layoutCurrentSource.val();
			var categorySource = UxCB.modalBody.find('[name="' +layoutCurrentCatname+ '"]');
			var categoryTaxonomy = categorySource.data('taxonomy');
			var postID = $('#post_ID').val();
			var moduleUnique = UxCB.modal.attr('data-module-unique');
			
			var thisLayoutMap = $.map(tabCustomGridLayoutsSettingsContent.find('.grid-stack > .grid-stack-item:visible'), function(el){
				el = $(el);
				var node = el.data('_gridstack_node');
				var post_id = el.data('postid');
				return {
					x: node.x,
					y: node.y,
					width: node.width,
					height: node.height,
					post_id: post_id
				};
			});
			
			$.post(ajaxurl, {
				'action': 'ux_cb_module_field_custom_grid_layouts_save_ajax',
				'layoutMap': thisLayoutMap,
				'catID': categorySource.val(),
				'postID': postID,
				'taxonomy': categoryTaxonomy,
				'moduleUnique': moduleUnique,
				'source': layoutCurrentSource.val()
			}).done(function(result){
				result = UxCB.fnClearTrim(result);
				if(result == 'ok'){
					ajaxContentContainer.html('');
					UxCB.modalSave.show();
					tabGeneralSettingsTab.trigger('click');
				}
			});
		});
	}
	
	//function module field grid stack resize
    UxCB.fnGridStackResize = function(gridStack){
		var gridStackWidth = gridStack.width();
		var gridStackSpacing = gridStack.data('spacing') || 20;
		var gridStackColWidth = (gridStackWidth + gridStackSpacing) / UxCB.gridstackColumns;
		var gridStackOffsetTop = gridStack.offset().top;
		var gridOffsetTop = [];
		
		gridStack.find('.grid-stack-item').each(function(){
			var gs_x = Number($(this).attr('data-gs-x'));
			var gs_y = Number($(this).attr('data-gs-y'));
			var gs_width = Number($(this).attr('data-gs-width'));
			var gs_height = Number($(this).attr('data-gs-height'));
			
			var set_height = gridStackColWidth * gs_height;
			var set_top = gridStackColWidth * gs_y;
			
			var gs_content = $(this).find('.grid-stack-item-content');
			var gs_brick_content = $(this).find('.brick-content');
			
			$(this).css({
				width: gridStackColWidth * gs_width + 'px',
				height: set_height + 'px',
				left: gridStackColWidth * gs_x + 'px',
				top: set_top + 'px',
				margin: '-' + gridStackSpacing / 2 + 'px'
			});
			
			gs_content.css({
				left: gridStackSpacing * 0.5 + 'px',
				right: gridStackSpacing * 0.5 + 'px',
				top: gridStackSpacing * 0.5 + 'px',
				bottom: gridStackSpacing * 0.5 + 'px'
			});
			
			if(gs_content.height() > 0 && gs_content.width() > 0){
				gs_brick_content.css('padding-top', (gs_content.height() / gs_content.width()) * 100 + '%');
			}
			
			gridOffsetTop.push(set_top + $(this).height());
			
			// if(!$(this).find(".grid-item-inside").hasClass('grid-show')){
			// 	$(this).find(".grid-item-inside").addClass('grid-show');
			// }

		});
		
		var gridStackHeight = Math.max.apply(Math,gridOffsetTop);
		gridStack.height(gridStackHeight);
		
		gridStack.find('.grid-item-inside').each(function(index, element) {
			if(!$(this).hasClass('grid-show')){
				$(this).addClass('grid-show');
			}
			
			var lazyload = $(this).find('.ux-lazyload-bgimg');
			var lazyload_bgimg = lazyload.data('bg');
			if(lazyload_bgimg) {
				lazyload.addClass('lazy-loaded').css('background-image', 'url("' +lazyload_bgimg+ '")');
			}
		});
	}
	
	//function module field grid loaded
	UxCB.fnModuleFieldCustomGridLoaded = function(container){
		container.find('.grid-item-inside').each(function(index, element) {
			if(!$(this).hasClass('grid-show')){
				$(this).addClass('grid-show');
			}
			
			var lazyload = $(this).find('.ux-lazyload-img');
			var lazyload_img = lazyload.data('src');
			if(lazyload_img) {
				lazyload.addClass('lazy-loaded').attr('src', lazyload_img);
			}
			
			var lazyload = $(this).find('.ux-lazyload-bgimg');
			var lazyload_bgimg = lazyload.data('bg');
			if(lazyload_bgimg) {
				lazyload.addClass('lazy-loaded').css('background-image', 'url("' +lazyload_bgimg+ '")');
			}
		});
	}
	
	//function module confirm
	UxCB.fnModuleConfirm = function(msg){
		return confirm(msg);
	}
	
	//summernote button font size
	UxCB.snButton.fontSize = function(context){
	  var ui = $.summernote.ui;
	  
	  var button = ui.buttonGroup([
          ui.button({
			  className: 'dropdown-toggle ux-note-current-fontsize',
			  contents: '&nbsp;',
			  data: {
				  toggle: 'dropdown'
			  }
          }),
          ui.dropdownCheck({
			  className: 'dropdown-fontsize',
			  items: ['8','9','10','11','12','13','14','15','16','17','18','20','22','24','26','28','30','32','34','36','38','40','42','44','46','48','50','52','54','56','58','60','72','84','96','120','144','168','192','1vw', '1.2vw', '1.4vw', '1.6vw', '1.8vw', '2vw', '2.2vw', '2.4vw', '2.6vw', '2.8vw', '3vw', '3.4vw', '3.8vw', '4vw', '4.4vw', '4.8vw', '5vw', '5.4vw', '5.8vw', '6vw', '6.4vw', '6.8vw', '7vw', '7.4vw', '7.8vw', '8vw', '8.4vw', '8.8vw', '9vw', '9.4vw', '9.8vw', '10vw'],
			  template: function(item){
				  var unit = 'px';
				  if(item.indexOf('vw') != -1){
					  unit = 'vw';
					  item = item.replace('vw', '');
				  }
				  
				  return item + unit;
			  },
			  click: context.createInvokeHandler('editor.fontSize')
			  /*click: function(e){
				  //var $note = context.layoutInfo.note;
				  //var dataValue = $(e.target).data('value');
				  //var editor = context.modules.editor;
				  //var rng = editor.createRange();
				  
				  //editor.fontSize(dataValue);
				  //console.log(editor);
				  
				  var rng = this.createRange();

				  if (rng && rng.isCollapsed()) {
					  var spans = style.styleNodes(rng);
					  var firstSpan = list.head(spans);
			
					  $(spans).css({
						  'font-size': value + 'px'
					  });
			  
					  // [workaround] added styled bogus span for style
					  //  - also bogus character needed for cursor position
					  if (firstSpan && !dom.nodeLength(firstSpan)) {
						  firstSpan.innerHTML = dom.ZERO_WIDTH_NBSP_CHAR;
						  range.createFromNodeAfter(firstSpan.firstChild).select();
						  $editable.data(KEY_BOGUS, firstSpan);
					  }
				  } else {
					beforeCommand();
					$(style.styleNodes(rng)).css({
						'font-size': value + 'px'
					});
					afterCommand();
				  }
				  
			  }*/
          })
	  ]);
	
	  return button.render();
	}
	
	//summernote button line height
	UxCB.snButton.lineHeight = function(context){
	  var ui = $.summernote.ui;
	  
	  var button = ui.buttonGroup([
          ui.button({
			  className: 'dropdown-toggle ux-note-current-lineheight',
			  contents: '&nbsp;',
			  data: {
				  toggle: 'dropdown'
			  }
          }),
          ui.dropdownCheck({
			  items: ['1.0','1.1','1.2','1.3','1.4','1.5', '1.6', '1.7', '1.8', '1.9', '2.0', '2.1', '2.2', '2.3', '2.4', '2.5', '2.6', '2.7', '2.8', '2.9', '3.0', '3.5', '4.0', '4.5', '5.0'],
			  className: 'dropdown-line-height',
			  click: context.createInvokeHandler('editor.lineHeight')
          })
	  ]);
	
	  return button.render();
	}
	
	//summernote button letter spacing
	UxCB.snButton.letterSpacing = function(context){
	  var ui = $.summernote.ui;
	  
	  var button = ui.buttonGroup([
          ui.button({
			  className: 'dropdown-toggle ux-note-current-letterSpacing',
			  contents: '&nbsp;',
			  data: {
				  toggle: 'dropdown'
			  }
          }),
          ui.dropdownCheck({
			  items: ['1px', '2px', '3px', '4px', '5px', '6px', '7px', '8px', '9px', '10px', '11px', '12px', '13px', '14px', '15px'],
			  className: 'dropdown-letter-spacing',
			  click: function(e){
				  /*var dataValue = $(e.target).data('value');
				  var range = document.getSelection().getRangeAt(0); 
				  $(range.startContainer).parent().css('letter-spacing', dataValue);*/
				  
				  var $note = context.layoutInfo.note;
				  var $editable = context.layoutInfo.editable;
				  var range = $note.summernote('createRange');
				  var dataValue = $(e.target).data('value');
				  
				  if(!$note.summernote('isEmpty')){
					  $(range.ec).parent().css('letter-spacing', dataValue);
				  }
				  
				  context.triggerEvent('change', $editable.html());

			  }
          })
	  ]);
	
	  return button.render();
	}

	//summernote button Mobile font size
	UxCB.snButton.mobileSize = function(context){
	  var ui = $.summernote.ui;
	  
	  var button = ui.buttonGroup([
          ui.button({
			  className: 'dropdown-toggle ux-note-current-mobileSize',
			  contents: '&nbsp;',
			  data: {
				  toggle: 'dropdown'
			  }
          }),
          ui.dropdownCheck({
			  items: ['4','6','8','9','10','11','12','13','14','15','16','17','18','20','22','24','26','28','30','32','34','36','38','40','42','44','46','48','50','52','54','56','58','60','72','84','96'],
			  className: 'dropdown-mobile-size',
			  click: function(e){ 
				  
				  var $note = context.layoutInfo.note;
				  var $editable = context.layoutInfo.editable;
				  var range = $note.summernote('createRange');
				  var dataValue = $(e.target).data('value');
				  
				  if(!$note.summernote('isEmpty')){
					  $(range.ec).parent().attr('data-msize', dataValue);
				  }
				  
				  context.triggerEvent('change', $editable.html());

			  }
          })
	  ]);
	
	  return button.render();
	}
	
	// summernote button media library svg
	UxCB.snButton.mediaSvgLibrary = function(context){
	  var ui = $.summernote.ui;
	  var frame = false;
	  
	  var button = ui.button({
		  contents: 'SVG',
		  tooltip: 'Insert SVG',
		  click: function(e){
			  if(!frame){
				  frame = wp.media({
					  multiple : false,
					  library : { type : 'image/svg+xml' }
				  });
			  }
			  
			  frame.on('select',function() {
				  var first = frame.state().get('selection').first().toJSON();
				  var wpUploader = $(frame.el);
				  
				  var $note = context.layoutInfo.note;
				  var $editable = context.layoutInfo.editable;
				  var range = $note.summernote('createRange');
				  
				  if(!$note.summernote('isEmpty')){
					  /*$.get(first['url'], 'html').done(function(result){
						  var svg = $(result).find('svg');
						  var wpUploader = $(frame.el);
						  $(range.ec).after(svg);
						  UxCB.fnModuleSvgProcess(svg, 'summernote', false, false, false);
					  });*/
					  if(wpUploader.find('.attachment.selected').length){
						  wpUploader.find('.attachment.selected').each(function(){
							  var attachment = $(this);
							  var svgWrap = attachment.find('.attachment-svg').clone();
							  var svgWrapWidth = svgWrap.attr('data-width');
							  
							  svgWrap.removeClass('attachment-svg').css({
								  'display': 'inline-block',
								  'width': svgWrapWidth+ 'px'
							  });
							  $(range.ec).after(svgWrap);
						  });
					  }
				  }
				  //context.triggerEvent('change', $editable.html());
				  
				  if(wpUploader.find('.attachment svg').length){
					  wpUploader.find('.attachment svg').each(function(){
						  UxCB.fnModuleSvgProcess($(this), 'summernote', '#000000');
					  });
				  }
			  });
			  
			  frame.on('open', function(){
				  var wpUploader = $(frame.el);
				  
				  wpUploader.ajaxComplete(function(event, request, settings) {
					  var data = UxCB.fnParseQuery(decodeURIComponent(settings.data));
					  
					  if(data['action'] == 'query-attachments' && data['query[post_mime_type]'] == 'image/svg+xml'){
						  $.each(JSON.parse(request.responseText).data, function(index, post){
							  UxCB.fnQueryAttachments(post.id, wpUploader);
						  });
					  }
					  
					  if(data['action'] == 'save-attachment-compat'){
						  var post = JSON.parse(request.responseText).data;
						  if(post.mime == 'image/svg+xml'){
							  UxCB.fnQueryAttachments(post.id, wpUploader);
						  }
					  }
					  
					  if(data['action'] == 'save-attachment'){
						  UxCB.fnQueryAttachments(data.id, wpUploader);
					  }
					  
				  });
			  });
			  
			  frame.open();
			  
		  }
	  });
	  return button.render();
	}
	
	//summernote button media library
	UxCB.snButton.mediaLibrary = function(context){
	  var ui = $.summernote.ui;
	  
	  var button = ui.button({
		  contents: '<i class="fa fa-picture-o"></i>',
		  tooltip: 'Insert Picture',
		  click: function(e){
			  var frame = wp.media({
				  multiple : false,
				  library : { type : [ 'image/jpeg', 'image/gif', 'image/png', 'image/bmp', 'image/tiff', 'image/x-icon' ] }
			  });
			  
			  frame.on('select',function() {
				  var first = frame.state().get('selection').first().toJSON();
				  var attachments = frame.state().get('selection').toJSON();
				  
				  /*var $note = context.layoutInfo.note;
				  var $editable = context.layoutInfo.editable;
				  var range = $note.summernote('createRange');
				  
				  if(!$note.summernote('isEmpty')){
					  $(range.ec).after('<img src="' +first['url']+ '">');
				  }
				  context.triggerEvent('change', $editable.html());*/
				  
				  context.invoke('editor.insertImage', first['url']);
				  
				  //context.invoke('editor.insertText', '<img src="' +first['url']+ '">');
			  });
			  
			  frame.open();
		  }
	  });
	
	  return button.render();
	}
	
	UxCB.fnQueryAttachments = function(id, wpUploader){
		var attachmentID = id;
		var attachment = wpUploader.find('.attachment[data-id="' +attachmentID+ '"]');
		var attachmentIco = attachment.find('.icon');
		
		attachment.find('.filename').remove();
		$.get(attachmentIco.attr('src'), 'html').done(function(result){
			var svg = $(result).find('svg');
			var svgColor = wpUploader.find('#attachments-' +attachmentID+ '-ux_svg_color');
			var svgWidth = wpUploader.find('#attachments-' +attachmentID+ '-ux_svg_width');
			
			if(svgColor.length){
				svgColor = svgColor.val();
			}else{
				svgColor = '#000000';
			}
			UxCB.fnModuleSvgProcess(svg, 'summernote', svgColor);
			
			attachmentIco.after('<div class="attachment-svg"></div>');
			attachmentIco.remove();
			attachment.find('.attachment-svg').html(svg);
			
			var svgWrap = attachment.find('.attachment-svg');
			if(svgWidth.length){
				svgWrap.attr('data-width', svgWidth.val());
			}else{
				svgWrap.attr('data-width', '24');
			}
		});
		
		attachment.on('click', function(){
			var svgWrap = attachment.find('.attachment-svg');
			var svgColor = wpUploader.find('#attachments-' +attachmentID+ '-ux_svg_color');
			var svgWidth = wpUploader.find('#attachments-' +attachmentID+ '-ux_svg_width');
			
			svgWrap.attr('data-width', svgWidth.val());
			
			svgColor.wpColorPicker({
				change: function(event, ui) {
					 var svg = attachment.find('svg');
					 if(svg){
						 UxCB.fnModuleSvgProcess(svg, 'summernote', ui.color.toString());
					 }
				}
			});
			
			svgWidth.change(function(){
				svgWrap.attr('data-width', $(this).val());
			});
		});
	}
	
	UxCB.fnParseQuery = function(query){
		var reg = /([^=&\s]+)[=\s]*([^=&\s]*)/g;
		var obj = {};
		while(reg.exec(query)){
			obj[RegExp.$1] = RegExp.$2;
		}
		return obj;
	}
	
	//page templates save as
	UxCB.fnPageTemplatesSaveAs = function(container, layout){
		var layoutFieldName = container.find('[name=layout-field-name]');
		var html = UxCB.fnModuleShortcodeProcess();
		var moduleUniqueArray = UxCB.fnModuleUniqueArrayProcess();
		var postID = $('#post_ID').val();
		
		if(layoutFieldName.val() != ''){
			$.post(ajaxurl, {
				'action': 'ux_cb_page_template_save_as_ajax',
				'postTitle': layoutFieldName.val(),
				'postID': postID,
				'moduleUniqueArray': moduleUniqueArray,
				'content': UxCB.fnHtmlEncode(html)
			}).done(function(result){
				result = UxCB.fnClearTrim(result);
				if(result == 'ok'){
					layout.removeClass('flip-y-translated').css('opacity', 0);
					layoutFieldName.val('');
				}
			});
		}
	}
	
	//function module sortable
	UxCB.fnModuleSortable = function(container){
		
		/*var items = '> .module';
		var connectWith = '.ux-cb-customize-preview-container, .sub-module-sortable';
		if(container.is('.ux-cb-customize-preview-container')){
			items = '> .bm-builder > .module';
			if(special){
				container = container.find('> .bm-builder');
				items = '> .module';
				connectWith = false;
			}else{
				items = '> .bm-builder > .no-droppable';
			}
		}*/
		
		container.sortable({
			items: '.module',
			//handle: '> .module-inside > .module-edit-tools > .dashicons-move',
			placeholder: 'ux-sortable-placeholder',
			connectWith: '.ux-cb-customize-preview-container, .sub-module-sortable',
			cursor: 'move',
			stop: function(event, ui){
				container.find('.ux-sortable-placeholder-image').remove();
				ui.item.removeAttr('style');
			},
			update: function(event, ui){
				UxCB.fnModuleRefreshSort();
			},
			beforeStop: function(event, ui){
				if(ui.item.parent().is('.module-content')){
					if(ui.item.hasClass('has-droppable')){
						$(this).sortable('cancel');
					}
				}
			},
			receive: function(event, ui){
				if(ui.item.parent().is('.module-content')){
					var module = ui.item;
					var moduleCol = Number(module.attr('data-module-col'));
					var moduleShortcode = module.find('> .module-inside > .module-shortcode');
					var moduleShortcodeHtml = moduleShortcode.html();
					var moduleCocTip = module.find('> .module-inside > .module-border > .col-number');
					var moduleParent = module.parents('.module');
					var moduleParentWidth = moduleParent.attr('data-module-width');
					var moduleParentCol = Number(moduleParent.attr('data-module-col'));
					
					if(moduleCol > moduleParentCol || moduleCol == 0){
						module.removeClass('col-' +moduleCol).addClass('col-' +moduleParentCol);
						module.attr({
							'data-module-width': moduleParentWidth,
							'data-module-col': moduleParentCol
						});
						moduleShortcode.html(moduleShortcodeHtml.replace(/col=\"([^\"]*)\"/, 'col="' +moduleParentCol+ '"'));
						moduleCocTip.html(moduleParentCol+ '/12');
					}
				}
				ui.item.removeAttr('style');
			},
			change: function(event, ui){
				if(ui.placeholder.parent().is('.module-content')){
					ui.placeholder.parent().parent().find('.module-border').css('visibility', 'visible');
				}
			},
			start: function(event, ui){
				var moduleID = ui.item.data('module-id'),
					moduleSelector = UxCB.pageCustomizeModuleSelector.find('button[data-module-id="' +moduleID+ '"]');
				
				ui.item.css('visibility', 'hidden');
				if(moduleSelector.length){
					container.append('<div class="ux-sortable-placeholder-image"></div>');
					container.find('.ux-sortable-placeholder-image').css('background-image', moduleSelector.css('background-image'));
				}
			},
			sort: function(event, ui){
				var containerScrollTop = UxCB.pageCustomizePreviewContainer.scrollTop(),
					eventPageX = event.pageX,
					eventPageY = containerScrollTop + event.pageY;
				
				container.find('.ux-sortable-placeholder-image').css({
					'left': eventPageX+ 'px',
					'top': eventPageY+ 'px'
				});
			}
		});
		container.disableSelection();
	}
	
	//function module hover
	UxCB.fnModuleHover = function(module){
		var moduleContent = module.find('> .module-inside > .module-content'),
			moduleBorder = module.find('> .module-inside > .module-border'),
			moduleID = module.attr('data-module-id');
		
		if(moduleContent.is('.sub-module-sortable')){
			module.hover(function(){
				moduleBorder.css('visibility', 'visible');
				module.find('.module > .module-inside > .module-border').css('visibility', 'hidden');
			}, function(){
				moduleBorder.css('visibility', 'hidden');
				module.find('.module > .module-inside > .module-border').css('visibility', 'hidden');
			});
		}else{
			module.hover(function(){
				//moduleContent.css({'z-index': 10, 'pointer-events': 'all'});
				moduleBorder.css('visibility', 'visible');
				module.parents('.module').find('> .module-inside > .module-border').css('visibility', 'hidden');
			}, function(){
				//moduleContent.removeAttr('style');
				moduleBorder.css('visibility', 'hidden');
				module.parents('.module').find('> .module-inside > .module-border').css('visibility', 'visible');
			});
		}
		
		module.mouseleave(function(){
			module.find('button[class*="offset"], button[class*="spacer"]').addClass('hidden');
			module.find('.offset-left-right, .spacer-top-bottom').removeClass('hidden');
			module.find('.text-info').addClass('hidden');
		});
		
		switch(moduleID){
			case 'text-no':console.log(module);
				moduleContent.find('.text_block_centered > *').hover(function(){
					$(this).addClass('ux-cb-text-inline-editor');
				}, function(){
					$(this).removeClass('ux-cb-text-inline-editor');
				}).click(function(){
					console.log($(this));
					
					moduleContent.find('.text_block_centered .ux-summernote').removeClass('ux-summernote').summernote('destroy');
					
					if(module.parent().is('.bm-builder')){
						UxCB.pageCustomizePreviewContainer.enableSelection();
					}
					
					/*$(this).parent().addClass('ux-summernote-wrap');
					$(this).css('width', '80%').addClass('ux-summernote').summernote({
						toolbar: [
							['style', ['style']],
							['font', ['bold', 'underline', 'clear']],
							['mybutton', ['uxfontsize', 'uxheight', 'uxletterspacing','uxmobilesize']],
							['color', ['color']],
							['para', ['ul', 'ol', 'paragraph']],
							['table', ['table']],
							['insert', ['link', 'uxmedia', 'uxsvg', 'video']],
							['view', ['fullscreen', 'codeview', 'help']]
						],
						buttons: {
							uxfontsize: UxCB.snButton.fontSize,
							uxheight: UxCB.snButton.lineHeight,
							uxletterspacing: UxCB.snButton.letterSpacing,
							uxmobilesize: UxCB.snButton.mobileSize,
							uxmedia: UxCB.snButton.mediaLibrary,
							uxsvg: UxCB.snButton.mediaSvgLibrary
						}
					});*/
					
					$(this).parent().addClass('ux-summernote-wrap');
					$(this).addClass('ux-summernote').summernote({
						focus: true,
						toolbar: [
							['style', ['style']],
							['font', ['bold', 'underline', 'clear']],
							['mybutton', ['uxfontsize', 'uxheight', 'uxletterspacing','uxmobilesize']],
							['color', ['color']],
							['para', ['ul', 'ol', 'paragraph']],
							['table', ['table']],
							['insert', ['link', 'uxmedia', 'uxsvg', 'video']],
							['view', ['fullscreen', 'codeview', 'help']]
						],
						buttons: {
							uxfontsize: UxCB.snButton.fontSize,
							uxheight: UxCB.snButton.lineHeight,
							uxletterspacing: UxCB.snButton.letterSpacing,
							uxmobilesize: UxCB.snButton.mobileSize,
							uxmedia: UxCB.snButton.mediaLibrary,
							uxsvg: UxCB.snButton.mediaSvgLibrary
						}
					})
				});
			break;
		}
				
	}
	
	//function module shortcode process
	UxCB.fnModuleShortcodeProcess = function(){
		var html = '';
		
		if(UxCB.pageCustomizePreviewContainer.find('.bm-builder > .module').length){
			html += '[ux_cb_wrap]';
			UxCB.pageCustomizePreviewContainer.find('.bm-builder > .module').each(function(){
				var module = $(this);
				var moduleContent = module.find('> .module-inside > .module-content');
				var moduleShortcode = module.find('> .module-inside > .module-shortcode').html(); 
				var moduleID = module.attr('data-module-id');
				var moduleUnique = module.attr('data-module-unique');
				var moduleCol = module.attr('data-module-col');
				
				if(moduleID == 'group'){
					html += '[ux_cb_group unique="' +moduleUnique+ '" col="' +moduleCol+ '"]';
					moduleContent.find('> .module').each(function(){
						var subModule = $(this);
						var subModuleShortcode = subModule.find('> .module-inside > .module-shortcode').html();
						
						html += subModuleShortcode;
                    });
					html += '[/ux_cb_group]';
				}else{
					html += moduleShortcode;
				}
			});
			html += '[/ux_cb_wrap]';
		}
		return html;
	}
	
	//function module unique array process
	UxCB.fnModuleUniqueArrayProcess = function(){
		var moduleUniqueArray = [];
		
		if(UxCB.pageCustomizePreviewContainer.find('.module').length){
			UxCB.pageCustomizePreviewContainer.find('.module').each(function(){
				var module = $(this);
				var moduleUnique = module.attr('data-module-unique');
				
				moduleUniqueArray.push(moduleUnique);
			});
		}
		return moduleUniqueArray;
	}
	
	//function carousel
	UxCB.fnModuleCarousel = function(carouselWrap){
		carouselWrap.each(function(){
			var carousel = $(this),
			carouselParent     = carousel.parent('.slider-mod-wrap'),
			carouselMargin     = carousel.data('margin'),
			carouselCenter     = carousel.data('center'),
			carouselItem       = carousel.data('item'),
			carouselAutoW      = carousel.data('autowidth'),
			carouselSlideby    = carousel.data('slideby'),
			carouselAuto       = carousel.data('auto'),
			carousePlayTimeout = carousel.data('autoplaytimeout'),
			carouselShowdot    = carousel.data('showdot'),
			carouselShownav    = carousel.data('nav'),
			carouselAnimateIn  = carousel.data('animatein'),
			carouselAnimateOut = carousel.data('animateout'),
			carouselLoop	   = carousel.data('loop'),
			carouselLazyLoad   = carousel.data('lazy');
			
			setTimeout(function(){
				carousel.owlCarousel({
					margin          : carouselMargin,
					loop            : carouselLoop,
					autoWidth       : carouselAutoW,
					center          : carouselCenter,
					animateIn       : carouselAnimateIn,
					animateOut      : carouselAnimateOut,
					slideSpeed      : 300,
					paginationSpeed : 400,
					items           : carouselItem,
					autoplay        : carouselAuto,
					responsiveClass : true,
					navText         : ["",""],
					slideBy         : carouselSlideby,
					dots            : carouselShowdot, 
					nav             : carouselShownav,
					autoplayTimeout : carousePlayTimeout,
					responsive: {
						0:{
							items:1,
							margin:0,
						}, 
						481:{
							items: carouselItem,
							margin:10
						}, 
						769:{
							items: carouselItem,
							margin: carouselMargin
						}
					}
				});

			},10)

		});
	}
	
	//fn mod attr
	UxCB.fnModAttr = function(m){
		var mod     = [];
		
		mod.m       = m,
		mod.id      = m.data('module-id'),
		mod.unique  = m.data('module-unique'),
		mod.inside  = m.find('> .module-inside'),
		mod.tool    = m.find('> .module-inside > .module-edit-tools'),
		mod.toolBtn = m.find('> .module-inside > .module-edit-tools > button'),
		mod.content = m.find('> .module-inside > .module-content'),
		mod.border  = m.find('> .module-inside > .module-border'),
		mod.info    = m.find('> .module-inside > .module-border > .text-info'),
		
		uxMods[mod.unique] = mod;
		
		return mod;
	}
	
	//fn set mod
	UxCB.fnSetMod = function(m){
		/**
		 m = module, mID = module_id, mC = moduleContent, mB = moduleBorder, mTI = moduleTextInfo, mCM = moduleContainerMasonry, mML = moduleMasonryList;
		 
		 mET = moduleEditTools;
		 mET_bS = moduleEditTools->button(s);
		**/
		
		var mID = m.data('module-id'),
		    mC = m.find('> .module-inside > .module-content'),
			mB = m.find('> .module-inside > .module-border'),
			mTI = m.find('> .module-inside > .module-border > .text-info'),
			mET = m.find('> .module-inside > .module-edit-tools'),
			mET_bS = mET.find('> button');
		
		if(!m.hasClass('m-rendered')){
			//module hover
			if(mC.is('.sub-module-sortable')){
				m.hover(function(){
					mB.css('visibility', 'visible');
					m.find('.module > .module-inside > .module-border').css('visibility', 'hidden');
				}, function(){
					mB.css('visibility', 'hidden');
					m.find('.module > .module-inside > .module-border').css('visibility', 'hidden');
				});
			}else{
				m.hover(function(){
					mB.css('visibility', 'visible');
					m.parents('.module').find('> .module-inside > .module-border').css('visibility', 'hidden');
				}, function(){
					mB.css('visibility', 'hidden');
					m.parents('.module').find('> .module-inside > .module-border').css('visibility', 'visible');
				});
			}
			
			m.mouseleave(function(){
				m.find('button[class*="offset"], button[class*="spacer"]').addClass('hidden');
				m.find('.offset-left-right, .spacer-top-bottom').removeClass('hidden');
				m.find('.text-info').addClass('hidden');
			});
			
			mET_bS.each(function() {
				var b = $(this);
				
				b.hover(function(){ mTI.addClass('hidden'); });
				
				if(b.hasClass('increase'))               { UxCB.fnModEditToolCrease(b, 'in'); }
				if(b.hasClass('decrease'))               { UxCB.fnModEditToolCrease(b, 'de'); }
				if(b.hasClass('offset-left-right'))      { UxCB.fnModEditToolOffset(b, m, 'left-right'); }
				if(b.hasClass('offset-left'))            { UxCB.fnModEditToolOffset(b, m, 'left'); }
				if(b.hasClass('offset-right'))           { UxCB.fnModEditToolOffset(b, m, 'right'); }
				if(b.hasClass('spacer-top-bottom'))      { UxCB.fnModEditToolSpacer(b, m, 'top-bottom'); }
				if(b.hasClass('increase-spacer-bottom')) { UxCB.fnModEditToolSpacer(b, m, 'in-bottom'); }
				if(b.hasClass('decrease-spacer-bottom')) { UxCB.fnModEditToolSpacer(b, m, 'de-bottom'); }
				if(b.hasClass('increase-spacer-top'))    { UxCB.fnModEditToolSpacer(b, m, 'in-top'); }
				if(b.hasClass('decrease-spacer-top'))    { UxCB.fnModEditToolSpacer(b, m, 'de-top'); }
				if(b.hasClass('move-up'))                { UxCB.fnModEditToolMove(b, 'up'); }
				if(b.hasClass('move-down'))              { UxCB.fnModEditToolMove(b, 'down'); }
				if(b.hasClass('edit'))                   { UxCB.fnModEditToolEdit(b); }
				if(b.hasClass('group-save-layout'))      { UxCB.fnModEditToolSaveLayouts(b); }
				if(b.hasClass('clone'))                  { UxCB.fnModEditToolClone(b, m); }
				if(b.hasClass('trash'))                  { UxCB.fnModEditToolTrash(b); }
				if(b.hasClass('add-module'))             { UxCB.fnModEditToolAddMod(b); }
			});
			
			//callback function
			switch(mID){
				case 'masonry-grid':
					if(m.find('.grid-stack').length){
						UxCB.fnGridStackResize(m.find('.grid-stack'));
					}
				break;
				
				case 'grid':
					UxCB.fnModuleFieldCustomGridLoaded(mC);
					var mCM = m.find('.container-masonry'),
					    mML = mCM.find('.masonry-list');
					
					if(!mML.hasClass('masonry-auto')) {
						var isotope = mML.isotope({
							itemSelector : '.grid-item',
							layoutMode   : 'fitRows',
							stagger      : 40,
							hiddenStyle  : { opacity: 0 },
							visibleStyle : { opacity: 1 }
						});
	
					} else { 
						var isotope = mML.isotope({ 
							itemSelector : '.grid-item',
							layoutMode   : 'packery',
							stagger      : 40,
							hiddenStyle  : { opacity: 0 },
							visibleStyle : { opacity: 1 }
						}); 
					}
				break;
				case 'slider':
					if(m.find('.owl-carousel').length){
						UxCB.fnModuleCarousel(m.find('.owl-carousel'));
					}
				break;
			}
			
			//set sign
			m.addClass('m-rendered');
		}
		
		//uxMods
	}
	
	//fn remove template
	UxCB.fnRemoveTpl = function(btn, modal){
		var removeBtn = btn,
			thisParent = btn.parent(),
			thisDataID = thisParent.data('id');
		
		removeBtn.on('click', function(){
			var confirm = UxCB.fnModuleConfirm('Are you sure you want to remove the current layout?');
				
			if(confirm == true){
				$.post(ajaxurl, {
					'action': 'ux_cb_remove_layout_ajax',
					'dirUq': thisDataID,
					'tplCat': 'user'
				}).done(function(rs){
					if(rs == 'ok'){
						thisParent.remove();
			
						var tplLayouts = $('script#tmpl-insert-layouts'),
							tplLayoutsHtml = tplLayouts.html(),
							tplLayoutsEL = $('<div>' +tplLayoutsHtml+ '</div>'),
							currSect = tplLayoutsEL.find('div.module-layout-section[data-id="user"]');
							
						currSect.find('li[data-id="' +thisDataID+ '"]').remove();
						tplLayouts.html(tplLayoutsEL.html());
					}
				});
			}
		});
	}
	
	
	//fn insert template
	UxCB.fnInsTpl = function(btn, modal){
		var insBtn = btn,
			sect = insBtn.parents('.module-layout-section'),
			tplCat = sect.attr('data-id'),
			item = insBtn.parent().parent(),
			dirUq = item.attr('data-id'),
			compBtn = item.find('.insert-completed'),
			insTplBtn = modal.$el.find('button.insert-template');
			
		insBtn.on('click', function(){
			insTplBtn.attr('disabled', 'disabled');
			insBtn.text('inserting...');
			if(!insBtn.hasClass('insert-shown')) {
				insBtn.addClass('insert-shown');
			}
			
			$.post(ajaxurl, {
				'action': 'ux_cb_ins_layout_ajax',
				'dirUq': dirUq,
				'tplCat': tplCat
			}).done(function(rs){
				if(!UxCB.pageCustomizePreviewContainer.find('.bm-builder').length){
					UxCB.pageCustomizePreviewContainer.append('<div class="bm-builder"></div>');
				}
				UxCB.pageCustomizePreview.addClass('has-content');
				UxCB.pageCustomizeModuleSelector.removeClass('fadein on cross-click').removeAttr('style');
				UxCB.pageCustomizeModuleSelector.find('h1').removeClass('fadein');
				
				if(rs != 'error'){
					var content = $('<div class="ins-mod-layout">' +rs+ '</div>');
					
					content.find('.module').each(function() {
						$(this).addClass('m-ins-mod');
					});
					
					if(UxCB.pageCustomizePreviewContainer.find('.bm-builder').length){
						content.find('> .module').each(function() {
							UxCB.pageCustomizePreviewContainer.find('.bm-builder').append($(this));
						});
					}
					
					if(UxCB.pageCustomizePreviewContainer.find('.module').length){
						UxCB.pageCustomizePreviewContainer.find('.module').each(function() {
							if($(this).hasClass('m-ins-mod')){
								UxCB.fnSetMod($(this));
							}
						});
					}
					
					UxCB.fnModuleRefreshSort();
					
					compBtn.removeClass('hidden');
					setTimeout(function(){
						compBtn.addClass('hidden');
						insBtn.text('Insert');
						insTplBtn.removeAttr('disabled');
						if(insBtn.hasClass('insert-shown')) {
							insBtn.removeClass('insert-shown');
						}
					}, 5000);
					
				}
			});
		});
	}
	
	//fn clear trim
	UxCB.fnClearTrim = function(s){
		s = s.replace(/<\/?.+?>/g, ""); 
        s = s.replace(/[\r\n]/g, ""); 
		s = s.replace(/^\s*/g,"");
		s = s.replace(/\s*$/g,""); 
		s = s.replace(/(^\s*)|(\s*$)/g, ""); 
		
		return s;
	}
	
	//document ready
	UxCB.doc.ready(function(){

		//Fonts Management interface
		if(UxCB.pluginPage.length){
			UxCB.fnLoadFontsManagementContainer();
		}
		
		//Fonts Management save
		if(UxCB.fontsPluginPageSave.length){
			UxCB.fnFontsManagementSave();
		}
		
		//Post type slug save
		if(UxCB.slugsPluginPageSave.length){
			UxCB.fnPostTypeSlugSave();
		}
		
		//page options button
		if(UxCB.pageOptionsButton.length){
			UxCB.pageOptionsButton.on('click', function(){
				UxCB.html.addClass('ux-page-show-preview');
				UxCB.fnLoadPreviewContainer();
			});
		}
		
		//page customize button
		if(UxCB.pageCustomizeTools.length){
			var modal = new wp.media.view.Modal({
				controller: { trigger: function() {} }
			});
			modal.$el.addClass('ux-cb-media-modal-layout');
			
			modal.on('open', function(event){
				modal.$el.addClass('opened');
				
				if(UxCB.modalClickedOpenerEl == 'ux-cb-page-options-insert-layouts'){
					var tplLayouts = $('script#tmpl-insert-layouts'),
						tplLayoutsHtml = tplLayouts.html();
						
					modal.$el.find('.media-modal-content').html(tplLayoutsHtml);
				}
				
				var itemTabs = modal.$el.find('.module-layout-sidebar li[data-id]');
				var sections = modal.$el.find('.module-layout-section');
				
				itemTabs.each(function(){
					$(this).on('click', function(){
						var itemTab = $(this);
						var itemID = itemTab.attr('data-id');
						var section = modal.$el.find('.module-layout-section[data-id="' +itemID+ '"]');
						itemTabs.removeClass('active'); itemTab.addClass('active');
						sections.removeClass('active'); section.addClass('active');
					});
				});
				
				var modalTitle = modal.$el.find('.module-layout-title');
				modalTitle.dblclick(function(){
					var templateCategory = modal.$el.find('select[name="module-template-category"]');
					templateCategory. css('display','block');
					templateCategory.find('option').removeAttr('disabled');
				});
				
				var saveBtn = modal.$el.find('button.save-layout');
				saveBtn.on('click', function(){
					var savedLocally = modal.$el.find('input[name="saved-locally"]'),
					    templateCategory = modal.$el.find('select[name="module-template-category"]'),
					    templateName = modal.$el.find('input[name="module-template-name"]'),
						uploadScreenshot = modal.$el.find('button[name="upload-screenshot"]'),
						saveGroup = $(this).attr('data-save-group'),
						shortcodeHtml = UxCB.fnModuleShortcodeProcess();
					
					var moduleArray = [];
					var modules = UxCB.pageCustomizePreviewContainer.find('.bm-builder > .module');
					
					if($(this).attr('data-save-group')){
						var groupUnique = $(this).attr('data-save-group'),
							modules = UxCB.pageCustomizePreviewContainer.find('.bm-builder > .module-id-' +groupUnique);
							shortcodeHtml = modules.find('> .module-inside > .module-shortcode').html();
							shortcodeHtml = '[ux_cb_wrap]' +shortcodeHtml+ '[/ux_cb_wrap]';
					}
					
					if(modules.length){
						modules.each(function(){
							var module = $(this),
								moduleUnique = module.attr('data-module-unique'),
								moduleCol = module.attr('data-module-col'),
								moduleContent = module.find('> .module-inside > .module-content'),
								moduleID = module.attr('data-module-id');
							
							if(moduleID == 'group'){
								var groupModuleUniqueArray = [];
								moduleContent.find('> .module').each(function(){
									var subModule = $(this),
									    subModuleUnique = subModule.attr('data-module-unique'),
										subModuleCol = subModule.attr('data-module-col');
									
									groupModuleUniqueArray.push({'unique': subModuleUnique, 'col': subModuleCol});
								});
								//moduleUniqueArray[moduleUnique] = groupModuleUniqueArray;
								moduleArray.push({'unique': moduleUnique, 'col': moduleCol, 'items': groupModuleUniqueArray});
							}else{
								moduleArray.push({'unique': moduleUnique, 'col': moduleCol});
							}
						});
					}
					
					$.post(ajaxurl, {
						'action': 'ux_cb_page_customize_save_layout_ajax',
						'moduleArray': moduleArray,
						'templateName': templateName.val(),
						'templateCategory': templateCategory.val(),
						'uploadScreenshot': uploadScreenshot.attr('data-url'),
						'shortcodeHtml': shortcodeHtml
					}).done(function(result){
						modal.$el.find('button.media-modal-close').trigger('click');
						if ( result != 'false' ) {
							var tplCat = templateCategory.val(),
							    tplLayouts = $('script#tmpl-insert-layouts'),
							    tplLayoutsHtml = tplLayouts.html(),
							    tplLayoutsEL = $('<div>' +tplLayoutsHtml+ '</div>'),
							    currSect = tplLayoutsEL.find('div.module-layout-section[data-id="' +tplCat+ '"]'),
								currSectNewItem = currSect.find('li:last').clone();
								
							currSectNewItem.attr('data-id', result);
							currSectNewItem.find('img').attr('src', uploadScreenshot.attr('data-url'));
							currSectNewItem.find('.item-name').text(templateName.val());
							currSect.find('> ul').append(currSectNewItem);
							
							tplLayouts.html(tplLayoutsEL.html());
						}
					});
				});
				
				var uploadScreenshot = modal.$el.find('button[name="upload-screenshot"]'); 
				uploadScreenshot.on('click', function(){
					var frame = wp.media({
						multiple : false,
						library : { type : [ 'image/jpeg', 'image/png' ] }
					});
					
					frame.on('select',function() {
						var first = frame.state().get('selection').first().toJSON();
						
						uploadScreenshot.attr('data-url', first['url']);
						uploadScreenshot.next('img').remove();
						uploadScreenshot.after('<img src="' +first['url']+ '" />');
					});
					
					frame.open();
				});
				
				var insertTemplateBtn = modal.$el.find('button.insert-template');
				insertTemplateBtn.each(function(){
					UxCB.fnInsTpl($(this), modal);
				});
				
				var removeTemplateBtn = modal.$el.find('button.remove-template');
				removeTemplateBtn.each(function(){
					UxCB.fnRemoveTpl($(this), modal);
				});
				
			}).on('close', function(){
				modal.$el.removeClass('opened save-layouts insert-layouts');
				modal.$el.find('button.save-layout').removeAttr('data-save-group');
				UxCB.modalClickedOpenerEl = '';
			});
			
			UxCB.pageCustomizeTools.find('button').each(function(){
				var btn = $(this);
				var btnID = btn.attr('id');
				
				btn.on('click', function(a, b){
					switch(btnID){
						case 'ux-cb-page-options-close': 
							UxCB.html.removeClass('ux-page-show-preview');
							UxCB.pageCustomizePreview.find('> .ux-cb-module-loading').removeClass('hidden');
							UxCB.pageCustomizeModuleSelector.removeClass('fadein').removeClass('on');
							UxCB.pageCustomizeModuleSelector.find('h1').removeClass('fadein');
							UxCB.pageCustomizePreviewContainer.html('');
						break;

						case 'ux-cb-page-options-expand':

							if(!UxCB.pageFullOverlay.hasClass('ux-cb-customize-tools-hide')) {
								UxCB.pageFullOverlay.addClass('ux-cb-customize-tools-hide');
							} else {
								UxCB.pageFullOverlay.removeClass('ux-cb-customize-tools-hide');
							} 

							setTimeout(function(){
								UxCB.fnGridStackResize($('.grid-stack'));
							},200);

						break;
						
						case 'ux-cb-page-options-save':
							var textSave = btn.data('save');
							var textSaving = btn.data('saving');
							var textSaved = btn.data('saved');
							var html = UxCB.fnModuleShortcodeProcess();
							var moduleUniqueArray = UxCB.fnModuleUniqueArrayProcess();
							var postID = $('#post_ID').val();
							var saveIcon = btn.find('.fa');
							var saveSpinner = btn.find('.save-spinner');
							var saveOverlay = UxCB.pageCustomizeTools.find('.save-overlay');
							
							var editorName = 'classic-editor';
							
							//btn.text(textSaving);
							
							if(!btn.hasClass('saving')){
								btn.addClass('saving');
								saveIcon.hide();
								saveSpinner.show();
								//saveOverlay.addClass('fadeIn');
								$('.bm-builder').css('opacity','.2').css('pointer-events','none');
								$('#content-html').trigger('click');
								UxCB.pageContentTextarea.val(html);
								
								if(UxCB.blockEditor.length){
									var textareaContent = $('#ux-cb-page-customize-textarea-content');
									editorName = 'block-editor';
									textareaContent.val(html);
								}
								
								//btn.text(textSaved);
								setTimeout(function(){
									//btn.text(textSave);
									//$('#ux-cb-page-options-close').trigger('click');
									
									$.post(ajaxurl, {
										'action': 'ux_cb_page_options_save',
										'moduleUniqueArray': moduleUniqueArray,
										'postID': postID,
										'content': UxCB.fnHtmlEncode(html),
										'editorName': editorName
									}).done(function(result){
										result = UxCB.fnClearTrim(result);
										if(result == 'ok' || html == ''){
											//UxCB.pageCustomizePreview.find('> .ux-cb-module-loading').removeClass('hidden');
											//UxCB.pageCustomizeModuleSelector.removeClass('fadein').removeClass('on');
											//UxCB.pageCustomizeModuleSelector.find('h1').removeClass('fadein');
											//UxCB.pageCustomizePreviewContainer.html('');
											btn.removeClass('saving');
											
											saveIcon.show();
											saveSpinner.hide();
											//saveOverlay.removeClass('fadeIn');
											$('.bm-builder').css('opacity','1').css('pointer-events','auto');
											if(b == 'preview'){
												$('#post-preview').trigger('click');
												
												if(UxCB.blockEditor.length){
													var previewUrl = $('.editor-post-preview').attr('href');
													window.location.href = previewUrl;
												}
											}
											
											//$('#ux-cb-page-options-close').trigger('click');
											
											//$('input#publish').trigger('click');
											
											$.post(ajaxurl, {
												'action': 'ux_cb_page_options_save_after',
												'postID': postID,
												'editorName': editorName
											}).done(function(result){
												result = UxCB.fnClearTrim(result);
												if(result == 'ok'){
													wp.data.dispatch( 'core/editor' ).resetBlocks([]);
												}
											});
										}
									});
								}, 200);
							}
						
						break;
						
						case 'ux-cb-page-options-preview':
							UxCB.pageCustomizeTools.find('button#ux-cb-page-options-save').trigger('click', 'preview');
						break;
						
						case 'ux-cb-page-options-add-module':
							UxCB.pageCustomizeModuleSelector.find('button').removeAttr('style');
							UxCB.pageCustomizeModuleSelector.css('z-index', 999).addClass('fadein cross-click');
							setTimeout(function(){
								UxCB.pageCustomizeModuleSelector.addClass('on');
							}, 500);
							setTimeout(function(){
								UxCB.pageCustomizeModuleSelector.find('h1').addClass('fadein');
							}, 1000);
						break;
						
						case 'ux-cb-page-options-save-layouts':
							var ModalContentView = wp.Backbone.View.extend({
								template: wp.template('save-layouts')
							});
							
							modal.content( new ModalContentView() );
							modal.open();
							modal.$el.addClass('save-layouts');
							
							if(b){
								modal.$el.find('button.save-layout').attr('data-save-group', b);
							}
						break;
						
						case 'ux-cb-page-options-insert-layouts':
							var ModalContentView = wp.Backbone.View.extend({
								template: wp.template('insert-layouts')
							});
							
							UxCB.modalClickedOpenerEl = 'ux-cb-page-options-insert-layouts';
							modal.open();
							
						break;
						
						case 'ux-cb-page-customize-tools-setting':
							if(!UxCB.pageFullOverlay.hasClass('show-float-sidebar')){
								UxCB.pageFullOverlay.addClass('show-float-sidebar');
							}else{
								UxCB.pageFullOverlay.removeClass('show-float-sidebar');
							}
						break;
						
						default:
							if(btn.hasClass('ux-cb-button')){
								UxCB.pageCustomizeSidebar.find('> [id]').addClass('hidden');
								UxCB.pageCustomizeSidebar.find('> #' +btnID).removeClass('hidden');
								
								UxCB.pageCustomizeTools.find('button.ux-cb-button').removeClass('active');
								btn.addClass('active');
							}
						
						break;
					}
					return false;
				});
			});
		}
		
		//page customize module selector button
		if(UxCB.pageCustomizeModuleSelector.length){
			UxCB.pageCustomizeModuleSelector.find('button').each(function(){
				var btn = $(this);
				
				UxCB.fnModuleSelectorButton(btn);
			});
		}
		
		//page customize modal close
		if(UxCB.modalClose.length){
			UxCB.modalClose.on('click', function(){
				if(UxCB.modal.find('.ux-summernote').length){
					$('.note-popover').remove();
				}
				
				UxCB.modal.removeClass('ux-fade');
				UxCB.modalTitle.html('');
				UxCB.modal.removeAttr('data-module-unique');
				UxCB.modal.find('#__ux_cb_module_top_padding, #__ux_cb_module_top_padding_mobile, #__ux_cb_module_bottom_padding, #__ux_cb_module_bottom_padding_mobile').val('');
				
				UxCB.pageCustomizeTemplates.append(UxCB.pageCustomizeTemplatesEditor);
				
				if($('.ux-cb-module-fields-container').length){
					$('.ux-cb-module-fields-container').remove();
				}
				
				if(UxCB.modalSave.is(':hidden')){
					UxCB.modalSave.show();
				}
			});
		}
		//page customize modal save
		if(UxCB.modalSave.length){
			UxCB.fnModuleSave();
		}
		
		//page module sortable init
		if(UxCB.pageCustomizePreviewContainer.length){
			UxCB.fnModuleSortable(UxCB.pageCustomizePreviewContainer);
			/*UxCB.pageCustomizePreviewContainer.sortable({
				items: '.module',
				placeholder: "ux-sortable-placeholder",
				connectWith: '.ux-cb-customize-preview-container, .sub-module-sortable',
				update: function(){
					UxCB.fnModuleRefreshSort();
				},
				receive: function(){
				}
			});
			UxCB.pageCustomizePreviewContainer.disableSelection();*/
		}
		
		//page module init
		if(UxCB.module.length){
			UxCB.module.each(function(){
				var module = $(this);
				
				if(module.hasClass('col-0')){
					var containerWidth = UxCB.pageCustomizePreviewContainer.outerWidth();
					var containerMargin = UxCB.pageCustomizePreviewContainer.css('padding-left');
					
					// module.css({
					// 	'margin-left': '-' +containerMargin,
					// 	'margin-right': '-' +containerMargin,
					// 	'width': containerWidth+ 'px'
					// });
				}
				
				UxCB.fnModEditToolsEvent(module);
			});
			UxCB.fnModuleRefreshSort();
		}
		
		//page templates save as container
		if(UxCB.pageTemplatesSaveAsContainer.length){
			var saveAsButton = UxCB.pageTemplatesSaveAsContainer.find('.ux-cb-page-template-save-as-button');
			var saveAsLayout = UxCB.pageTemplatesSaveAsContainer.find('.ux-cb-page-template-save-as-layout');
			var saveAsSubmit = UxCB.pageTemplatesSaveAsContainer.find('.ux-cb-page-template-save-as-submit');
			
			if($('#page-template.ux-theme-box').length){
				$('#page-template.ux-theme-box').find('.inside').append(UxCB.pageTemplatesSaveAsContainer);
				saveAsButton.on('click', function(){
					saveAsLayout.addClass('flip-y-translated').css('opacity', 1);
				});
				
				saveAsSubmit.on('click', function(){
					UxCB.fnPageTemplatesSaveAs(UxCB.pageTemplatesSaveAsContainer, saveAsLayout);
				});
			}
		}
		
		//page option template selector
		//UxCB.pageOptionTemplateSelector
		
		//page choose template
		if(UxCB.pageChooseTemplates.length){
			UxCB.pageChooseTemplates.change(function(){
				var confirm = UxCB.fnModuleConfirm('Are you sure you want to overwrite the current layout?');
				
				if(confirm == true){
					var choose = $(this);
					var postID = $('#post_ID').val();
					
					$.post(ajaxurl, {
						'action': 'ux_cb_page_choose_template_ajax',
						'templateID': choose.val(),
						'postID': postID
					}).done(function(result){
						if(result != ''){
							//window.location.reload()
							window.location.href = result;
						}
					});
				}
			});
		}

		//Call video guide 
		if(UxCB.videoGuideWrap.length) {
			UxCB.videoGuide();
		}
	});
	
	/*UxCB.doc.ajaxComplete(function(event, request, settings) {
		if($('.attachments-browser .js--select-attachment').length){
			$('.attachments-browser .js--select-attachment').each(function(index, element) {
                var attachment = $(this);
				var attachmentParents = attachment.parents('.attachments-browser');
				var attachmentIco = attachment.find('.icon');
				var mediaSidebar = attachmentParents.find('.media-sidebar');
				
				$.post(attachmentIco.attr('src'), 'html').done(function(result){
					var svg = $(result).find('svg');
					attachmentIco.after(svg);
					attachmentIco.remove();
				});
				
				if(mediaSidebar.length){
					if(mediaSidebar.find('.compat-field-ux_svg_color input')){
						setTimeout(function(){
							mediaSidebar.find('.compat-field-ux_svg_color input').wpColorPicker();
						}, 50);
					}
				}
            });
		}
	});*/
	
	//win resize
	UxCB.win.resize(function(){
		UxCB.fnModuleChangeRow($('.bm-builder'));
	});
	
	//win load
	UxCB.win.load(function(){
		//page module
		if(UxCB.module.length){
			UxCB.module.each(function(){
				var module = $(this);
				var moduleID = module.data('module-id');
				
				switch(moduleID){
					case 'masonry-grid':
						if(module.find('.grid-stack').length){
							UxCB.fnGridStackResize(module.find('.grid-stack'));
						}
					break;
					case 'grid':
						UxCB.fnModuleFieldCustomGridLoaded(module);
					break;
				}
			});
		}
		
		UxCB.pageCustomizeModuleSelector.on('click', function(){
			var moduleID = false;
			if(UxCB.addModulePrototype){
				moduleID = UxCB.addModulePrototype.data('module-id');
			}
			
			if(moduleID != 'group'){
				if(UxCB.pageCustomizeModuleSelector.hasClass('cross-click')){
					UxCB.pageCustomizeModuleSelector.removeClass('fadein on cross-click').removeAttr('style');
					UxCB.pageCustomizeModuleSelector.find('h1').removeClass('fadein');
				}
			}else{
				UxCB.pageCustomizeModuleSelector.find('button').removeAttr('style');
				UxCB.pageCustomizeModuleSelector.find('button.ux-cb-module-group-selector').hide();
			}
		});
		
		//wp 5.0
		UxCB.blockEditor = $('.block-editor');
		UxCB.editPostHeaderToolbar = UxCB.blockEditor.find('.edit-post-header-toolbar');
		
		if(UxCB.editPostHeaderToolbar.length){
			var pageOptionButton = $('<button id="ux-cb-page-options-block-button"></button>');
				
			UxCB.editPostHeaderToolbar.append(pageOptionButton);
			
			pageOptionButton.on('click', function(){
				UxCB.pageOptionsButton.trigger('click');
			})
		}
	});
	
	UxCB.pageCustomizePreviewContainer.scroll(function(){
		var pCST = $(this).scrollTop(),
			pCH = $(this).height(),
			cTH = UxCB.pageCustomizeTools.outerHeight();
		
		UxCB.module = UxCB.pageCustomizePreviewContainer.find('.module');
		UxCB.module.each(function(index){
			var m = $(this),
			    mP = m.parent(),
				mPT = m.offset().top,
				mPL = m.offset().left,
				mI = m.find('> .module-inside'),
				mIT = mI.css('margin-top') || 0,
				mIT = Number(mIT.replace('px', '')),
				mIH = mI.height(),
				mET = mI.find('> .module-edit-tools'),
				mTH = 42,
				mTPT = (mPT+mIT)-mTH,
				mTTY = mTH-mTPT;
				
			if(!mP.is('.sub-module-sortable')){
				if(mTPT <= cTH && mTTY <= mIH){
					mET.css({
						//'display': 'inline-block',
						'-webkit-transform': 'translateY('+mTTY+'px)',
						    '-ms-transform': 'translateY('+mTTY+'px)',
						     '-o-transform': 'translateY('+mTTY+'px)',
						   '-moz-transform': 'translateY('+mTTY+'px)',
						        'transform': 'translateY('+mTTY+'px)'
					});
				}else{
					mET.removeAttr('style');
				}
			}
		});
	});
	
})(jQuery);