<?php
/****************************************************************/
/*
/* Template
/*
/****************************************************************/

//Template Woocommerce Page Title
function seatheme_woocommerce_page_title(){
	seatheme_get_woo_template_part('title', 'bar');
}

//Template Woocommerce Page Title
function seatheme_woocommerce_sidebar_cart(){
	seatheme_get_woo_template_part('sidebar', 'cart');
}
/****************************************************************/
/*
/* Ajax
/*
/****************************************************************/

//Ajax loop add to cart button
function blocker_woocommerce_loop_add_to_cart($product_id, $quantity){
	if(function_exists('WC')){
		
		//WC()->cart->add_to_cart
		
		if ( empty( $product_id ) || ! is_numeric( $product_id ) ) {
			return;
		}

		$product_id          = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $product_id ) );
		$was_added_to_cart   = false;
		$adding_to_cart      = wc_get_product( $product_id );

		if ( ! $adding_to_cart ) {
			return;
		}
		
		$add_to_cart_handler = apply_filters( 'woocommerce_add_to_cart_handler', $adding_to_cart->get_type(), $adding_to_cart );

		// Variable product handling
		if ( 'variable' === $add_to_cart_handler ) {
			

		// Grouped Products
		} elseif ( 'grouped' === $add_to_cart_handler ) {
			

		// Custom Handler
		} elseif ( has_action( 'woocommerce_add_to_cart_handler_' . $add_to_cart_handler ) ){

		// Simple Products
		} else {
			$passed_validation 	= apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

			if ( WC()->cart->add_to_cart( $product_id, $quantity ) !== false ) {
				$was_added_to_cart = true;
			}
		}

		// If we added the product to the cart we can now optionally do a redirect.
		if ( $was_added_to_cart && wc_notice_count( 'error' ) === 0 ) {
			
			echo 'ok';
			
		}
	}
}

/****************************************************************/
/*
/* Show Sold Out on archive
/*
/****************************************************************/
if(!function_exists('seatheme_get_soldout_text')){
	function seatheme_get_soldout_text(){
	return seatheme_get_option('theme_option_descriptions_woo_sold_out');
	}
}
add_filter('ux-get-soldout-text','seatheme_get_soldout_text');

if(!function_exists('seatheme_display_sold_out_loop_woocommerce')){
	function seatheme_display_sold_out_loop_woocommerce() {
	    global $product;
	 	$sold_out_text = seatheme_get_option('theme_option_descriptions_woo_sold_out') ? seatheme_get_option('theme_option_descriptions_woo_sold_out') : esc_html__( 'Sold Out', 'sea-theme' );

	    if ( !$product->is_in_stock() ) {
	        echo '<span class="sold-out"><span class="sold-out-inn">' . esc_html($sold_out_text) . '</span></span>';
	    }
	}
}
add_action( 'woocommerce_before_shop_loop_item_title', 'seatheme_display_sold_out_loop_woocommerce' );

/****************************************************************/
/*
/* Ajax number for Cart icon
/*
/****************************************************************/

add_filter( 'woocommerce_add_to_cart_fragments', 'seatheme_wc_mini_cart_ajax_refresh' );

function seatheme_wc_mini_cart_ajax_refresh( $fragments ){
    $fragments['.woocomerce-cart-number'] = '<span class="woocomerce-cart-number">'.sizeof(WC()->cart->get_cart()).'</span>'; 
    return $fragments;
}

?>