<?php 
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' ); ?>

	<?php //** Do Woocommerce before main content
	do_action('woocommerce_before_main_content');
	
		$archivePageLayout = seatheme_get_option( 'fieldWooArchivePageLayout' ); 
		$sidebarClass = '';
		
		switch ( $archivePageLayout ) {
			case 'left-sidebar': 
				if ( is_active_sidebar( 'ux-shop-sidebar' )  ) { 
					$sidebarClass = 'col-md-9 col-sm-9 pull-right'; 
				}
			break;

			case 'right-sidebar': 
				if ( is_active_sidebar( 'ux-shop-sidebar' ) ) { 
					$sidebarClass = 'col-md-9 col-sm-9';
				}

			break;
		} ?>
    
        <div id="content_wrap">
        
            <?php //** switch page title
			if ( apply_filters( 'woocommerce_show_page_title', true ) ) {
				
				//** woo page title
				seatheme_woocommerce_page_title();
				
			} ?>
            
            <div class="product-wrap <?php echo esc_attr( $sidebarClass ); ?>">
        
				<?php if ( woocommerce_product_loop() ) {

					/**
					 * Hook: woocommerce_before_shop_loop.
					 *
					 * @hooked wc_print_notices - 10
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */
					do_action( 'woocommerce_before_shop_loop' );

					woocommerce_product_loop_start();

					if ( wc_get_loop_prop( 'total' ) ) {
						while ( have_posts() ) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 *
							 * @hooked WC_Structured_Data::generate_product_data() - 10
							 */
							do_action( 'woocommerce_shop_loop' );

							wc_get_template_part( 'content', 'product' );
						}
					}

					woocommerce_product_loop_end();

					/**
					 * Hook: woocommerce_after_shop_loop.
					 *
					 * @hooked woocommerce_pagination - 10
					 */
					do_action( 'woocommerce_after_shop_loop' );
				} else {
					/**
					 * Hook: woocommerce_no_products_found.
					 *
					 * @hooked wc_no_products_found - 10
					 */
					do_action( 'woocommerce_no_products_found' );
				} ?>
                
            </div>
            
            <?php 
			/**
			 * Hook: woocommerce_sidebar.
			 *
			 * @hooked woocommerce_get_sidebar - 10
			 */
			
			if ( $archivePageLayout != 'without-sidebar' && is_active_sidebar( 'ux-shop-sidebar' ) ) {
				do_action( 'woocommerce_sidebar' );
			} ?>
                
        </div>
        

	<?php //** Do Woocommerce after main content
	do_action('woocommerce_after_main_content'); ?>

<?php get_footer( 'shop' ); ?>