<?php
$seatheme_header_layout = seatheme_get_option( 'theme_option_header_layout' ) ? seatheme_get_option( 'theme_option_header_layout' ) : 'horizon-menu-right';
$menu_panle_type = seatheme_get_option( 'theme_option_menu_panle_type' ) ? seatheme_get_option( 'theme_option_menu_panle_type' ) : 'open_menu_panel_below';
$header_width = seatheme_get_option( 'theme_option_header_width' ) ? seatheme_get_option( 'theme_option_header_width' ) : false;
$header_width_class =  $header_width == 'fixed' ? 'container' : 'container-fluid';
$expanded_show_cart = seatheme_get_option( 'theme_option_show_shopping_cart' );
$header_show_social = seatheme_get_option( 'theme_option_show_social' );
$header_show_social_mobile = seatheme_get_option( 'theme_option_show_social_header_mobile' );
$header_show_social_enable_class = $header_show_social ? '' : 'hidden-desktop';
$header_show_social_enable_class_mobile = $header_show_social_mobile ? '' : 'hidden-mobile';
$menu_icon_style = seatheme_get_option('theme_option_menu_icon_style') ? seatheme_get_option('theme_option_menu_icon_style') : 'menu-icon-default';

$menu_onleft_outwrap_before = $seatheme_header_layout === 'horizon-menu-center' ? '<div class="menu_onleft_outwrap">' : false;
$menu_onleft_outwrap_after = $seatheme_header_layout === 'horizon-menu-center' ? '</div>' : false;
$start_from_page_top = false;
$scrollDownHeight = false;
$headerClass = false;
if ( is_page() ) {
	if ( $header_when_scroll_down = seatheme_get_post_meta( get_the_ID(), 'theme_meta_page_show_header_when_scroll_down' ) ) {
		$scrollDownHeight = seatheme_get_post_meta( get_the_ID(), 'theme_meta_page_scroll_down_height' );
		if ( intval( $scrollDownHeight ) ) {
			$headerClass = 'ux-header-hide';
		}
	}
}
if ( is_singular('ux-portfolio' ) ) {
    if ( $header_when_scroll_down = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_show_header_when_scroll_down' ) ) {
        $scrollDownHeight = seatheme_get_post_meta( get_the_ID(), 'theme_meta_portfolio_scroll_down_height');
        if ( intval( $scrollDownHeight ) ) {
            $headerClass = 'ux-header-hide';
        }
    }
}
?>

<header id="header" class="<?php echo sanitize_html_class( $headerClass ); ?>" data-scroll="<?php echo esc_attr( intval( $scrollDownHeight ) ); ?>">

    <div id="header-main" class="header-main <?php echo sanitize_html_class( $header_width_class ); ?>">

        <div class="navi-logo">

            <div class="logo-wrap">
                <?php //** Function Logo for header
                seatheme_interface_logo( 'header' ); ?>
            </div><!--End logo wrap-->

        </div><!--End navi-logo-->

        <div class="head-meta">

            <nav id="navi-header" class="navi-header">
                <?php //** Menu on header
                wp_nav_menu( array(
                    'theme_location'  => 'primary',
                    'container_id' => 'navi_wrap',
                    'items_wrap' => '<ul class="%2$s clearfix">%3$s</ul>'
                ) ); ?><!--End #navi_wrap-->
            </nav>

            <?php 
            echo wp_kses_post( $menu_onleft_outwrap_before );
                //** Function Social icons
                ?>
                <div class="header-bar-social <?php echo sanitize_html_class( $header_show_social_enable_class ); ?> <?php echo sanitize_html_class( $header_show_social_enable_class_mobile ); ?>">
                    <?php seatheme_interface_header_social(); ?>
                </div>
                <?php 
                
            //** Header icon(portfolio icon)
            seatheme_interface_header_portfolio_icon(); ?>

            <div class="navi-trigger-out <?php if ( $menu_icon_style === 'menu-icon-hamburg' )  { echo 'navi-trigger-hamburg'; } ?>">

                <a href="javascript:;" id="navi-trigger" class="navi-trigger">

                <?php if ( $menu_icon_style === 'menu-icon-hamburg' )  { ?>
                    <span class="navi-trigger-inn"></span>
                    <svg class="navi-trigger-svg svg-style01" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 380 380">
                        <rect class="svg-style01-line svg-style01-line1" width="380" height="50" />
                        <rect class="svg-style01-line svg-style01-line2" width="380" height="50" />
                        <rect class="svg-style01-line svg-style01-line3" width="380" height="50" />
                    </svg>

                <?php } else { ?>
                
                    <svg class="navi-trigger-svg svg-style02" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 380 380">
                        <g class="svg-style02-line2 svg-style02-line"><rect class="svg-style02-line-rect" width="380" height="50" /></g>
                        <g class="svg-style02-line1 svg-style02-line"><rect class="svg-style02-line-rect" width="380" height="50" /></g>
                    </svg>
                   
                <?php } ?>

                </a>

            </div>

            <?php //** Cart icon
                if ( $expanded_show_cart && class_exists( 'Woocommerce' ) ) {
                    do_action( 'seatheme_interface_wc_cart' ); 
                }
            echo wp_kses_post( $menu_onleft_outwrap_after ); ?> 
        </div><!--End header-meta-->
   
    </div><!--End header main-->
    
</header>