<?php 
$image_lazyload = seatheme_get_option( 'theme_option_enable_image_lazyload' );
$thumb_lazyclass = '';
if ( has_post_thumbnail() ) {    
    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
    $thumb_url = $thumb[0];
    $thumb_srcset = wp_get_attachment_image_srcset( get_post_thumbnail_id(), 'full' );
    $thumb_sizes = wp_get_attachment_image_sizes( get_post_thumbnail_id(), 'full' );
    $image_src = 'src="' .esc_url( $thumb_url ). '" srcset="'.wp_kses_post( $thumb_srcset ).'" sizes="'.wp_kses_post( $thumb_sizes ).'"';
    if ( $image_lazyload ) {
        $thumb_lazyclass = 'lazy'; 
        $image_src = 'src="' .esc_url( get_template_directory_uri() ). '/img/blank.gif" data-src="' .esc_url( $thumb_url ). '" data-srcset="'.wp_kses_post( $thumb_srcset ).'" data-sizes="'.wp_kses_post( $thumb_sizes ).'"';
    }
}
?>
<section <?php post_class('archive-item'); ?>>
    <h2 class="archive-tit"><a title="<?php esc_attr( the_title_attribute() ); ?>" href="<?php esc_url( the_permalink() ); ?>"><?php esc_html( the_title() ); ?></a></h2>
    <?php if ( has_post_thumbnail() ) { ?>
    <a class="archive-image" title="<?php esc_attr( the_title_attribute() ); ?>" href="<?php esc_url( the_permalink() ); ?>">
        <img class="archive-img <?php echo sanitize_html_class( $thumb_lazyclass ); ?>" <?php echo sanitize_text_field( $image_src ); ?> alt="<?php esc_attr( the_title_attribute() ); ?>"/>
    </a>
    <?php } ?>
    <div class="arvhive-excerpt">
        <?php seatheme_get_template_part( 'archive/content', 'desc' );  ?>
    </div>
    <div class="archive-meta clearfix">
        <?php seatheme_get_template_part('archive/content', 'meta'); ?> 
    </div>
    <?php
	seatheme_get_template_part('archive/content', 'social');
	if ( ! seatheme_has_more_link( get_the_ID() ) ) { 
        seatheme_get_template_part('archive/readmore', false); 
    } ?>
</section>