<?php
//theme icons
function seatheme_theme_icons_fields(){

// Fontawesome icons list
$pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"(.+)";\s+}/';
$fontawesome_path =  get_template_directory() . '/functions/theme/css/font-awesome-social.css';
if( file_exists( $fontawesome_path ) ) {
	$method = '';
	$url = wp_nonce_url('themes.php?page=theme-option');
	if (false === ($creds = request_filesystem_credentials($url, $method, false, false, false) ) ) {
		return true;
	}
	
	if ( ! WP_Filesystem($creds) ) {
		request_filesystem_credentials($url, $method, true, false, false);
		return true;
	}
	
	global $wp_filesystem;
	$subject = $wp_filesystem->get_contents($fontawesome_path);
}


preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);

$icons = array();

foreach($matches as $match){
	array_push($icons, 'fa ' . $match[1]);
}

return $icons;


}

function seatheme_theme_get_categories_fields($taxonomy='category', $number=50){
	$output = array();
	
	$terms = get_terms( array(
		'taxonomy' => $taxonomy,
		'hide_empty' => false,
		'number' => $number
	) );
	 
	if($terms){
		foreach($terms as $term){
			if (is_object($term) && isset($term->name) && isset($term->term_id)) {
				array_push($output, array(
					'title' => $term->name,
					'value' => $term->term_id
				));
			}
		}
	}else{
		$output = false;
	}
	
	return $output;
}

function seatheme_wp_get_nav_menus(){
	$output = array();
	$menus = wp_get_nav_menus();
	
	array_push($output, array(
		'title' => esc_html__('Select menu', 'sea-theme'),
		'value' => 0
	));
	
	if($menus){
		foreach($menus as $menu){
			array_push($output, array(
				'title' => $menu->name,
				'value' => $menu->term_id
			));
		}
	}
	return $output;
}

//theme color
function seatheme_theme_color(){
	$theme_color = array(
		array('id' => 'color1', 'value' => 'theme-color-1', 'rgb' => '#F9885C'),
		array('id' => 'color2', 'value' => 'theme-color-2', 'rgb' => '#BD9DD1'),
		array('id' => 'color3', 'value' => 'theme-color-3', 'rgb' => '#F1A1C3'),
		array('id' => 'color4', 'value' => 'theme-color-4', 'rgb' => '#92C3E3'),
		array('id' => 'color5', 'value' => 'theme-color-5', 'rgb' => '#5B6A81'),
		array('id' => 'color6', 'value' => 'theme-color-6', 'rgb' => '#B8B69A'),
		array('id' => 'color7', 'value' => 'theme-color-7', 'rgb' => '#69CE9B'),
		array('id' => 'color8', 'value' => 'theme-color-8', 'rgb' => '#FFD02E'),
		array('id' => 'color9', 'value' => 'theme-color-9', 'rgb' => '#C6A584'),
		array('id' => 'color10', 'value' => 'theme-color-10', 'rgb' => '#313139')
	);	

	//color 1-10
	for($color_num=1;$color_num<=10;$color_num++){
		$featured_color = seatheme_get_option('theme_option_featured_color_' .$color_num);
		if($featured_color){
			$i = $color_num - 1;
			$theme_color[$i]['rgb'] = $featured_color;
		}
	}
	
	return $theme_color;
}

//theme config color scheme
function seatheme_theme_options_color_scheme(){
	
	$color_scheme = array(
		'scheme-1' => array(
			array('name' => 'second_auxiliary_color', 		  'value' => '#F8F8F8'),
			array('name' => 'page_post_bg_color', 			  'value' => '#FFFFFF'),
			array('name' => 'theme_border_color', 			  'value' => '#48484d'),
			array('name' => 'logo_text_color', 				  'value' => '#313139'),
			array('name' => 'page_from_top_logo_text_color',  'value' => '#FFFFFF'),
			array('name' => 'expanded_panel_logo_text_color', 'value' => '#FFFFFF'),
			array('name' => 'logo_text_color_floating', 	  'value' => '#313139'), 
			array('name' => 'header_menu_item_text_color', 	  'value' => '#313139'),
			array('name' => 'top_menu_bar_bg_color', 	      'value' => '#FFFFFF'),
			array('name' => 'header_menu_transparent_color',  'value' => '#FFFFFF'),
			array('name' => 'menu_item_text_color',           'value' => '#FFFFFF'),
			array('name' => 'expanded_panel_bg_color', 		  'value' => '#313139'),
			array('name' => 'menu_item_text_mouseover_color', 'value' => '#5179FC'),
			array('name' => 'menu_item_text_active_color',    'value' => '#FFFFFF'),
			array('name' => 'heading_color', 				  'value' => '#313139'),
			array('name' => 'content_text_color', 			  'value' => '#414145'),
			array('name' => 'auxiliary_content_color', 		  'value' => '#ADADAD'),
			array('name' => 'selected_text_bg_color', 		  'value' => '#DBD7D2'),
			array('name' => 'sidebar_widget_title_color',     'value' => '#313139'),
			array('name' => 'sidebar_content_color', 	      'value' => '#606066'),
			array('name' => 'footer_text_color', 			  'value' => '#28282E'),
			array('name' => 'footer_bg_color', 				  'value' => '#FFFFFF')
		) 
	);
	return $color_scheme;
	
}

//theme config select fields
function seatheme_theme_options_config_select_fields(){
	$theme_config_select_fields = array();
	
	$theme_config_select_fields = apply_filters('theme_config_select_fields', $theme_config_select_fields);
	return $theme_config_select_fields;
}

function seatheme_theme_options_config_fields(){
	$theme_config_fields = array();
	return $theme_config_fields;
}

//theme config fonts fields
if(!function_exists( 'seatheme_theme_options_config_fonts_fields')){
	function seatheme_theme_options_config_fonts_fields($fonts_fields){
		$fonts_fields = array(
			array(
				'region-id' => 'logo-font',
				'title'     => esc_html__('Logo','sea-theme'),
				'default'   => true,
				'name'      => '__ux_cb_module_logo_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									// Plain Text Logo (for header)
									array('title' => esc_html__('Plain Text Logo (for header)','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_plain_text_header_logo',
										  'group' => 'family|size|spacing|line_height|m-size',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '24px',
											  'spacing' => '0px',
											  'm-size' => '24px'
										  )
									), 
										  
									// Plain Text Logo (for footer)
									array('title' => esc_html__('Plain Text Logo (for footer)','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_plain_text_footer_logo',
										  'group' => 'family|size|spacing|line_height|m-size'
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'menu-font',
				'title'     => esc_html__('Menu','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_menu_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									// Menu on Header
									array('title' => esc_html__('Menu on Header','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_menu_header',
										  'group' => 'family|size|spacing|m-size|line_height',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '16px',
											  'spacing' => '0px',
											  'm-size' => '16px'
										)
									),

									array('title' => esc_html__('Sub Menu on Header','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_submenu_header',
										  'group' => 'size|m-size'
									),
									
									// Menu on Expanded
									array('title' => esc_html__('Menu Item on Expanded Panel','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_menu_expanded',
										  'group' => 'family|size|spacing|m-size|line_height',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '16px',
											  'spacing' => '0px',
											  'm-size' => '16px'
										)
									),

									array('title' => esc_html__('Sub Menu on Expanded Panel','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_submenu_expanded',
										  'group' => 'size|m-size'
									),
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'post-page-font',
				'title'     => esc_html__('Posts & Pages','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_posts_and_pages_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array( 
									// Post Page Content Font
									array('title' => esc_html__('Content','sea-theme'),
										  'type' => 'fonts-group',
										  'name' => '_ux_cb_module_fonts_post_page_content',
										  'group' => 'family|size|spacing|m-size|line_height',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '20px',
											  'spacing' => '0px',
											  'm-size' => '16px',
											  'line_height' => '1.5'
										  )
									),

									// Post Page Heading 1-6 Font family
									array('title' => esc_html__('Heading','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_heading',
										  'group' => 'family',
										  'default' => array(
											  'family' => 'Roboto'
											)
									),

									
									// Post Page Heading 1 Font
									array('title' => esc_html__('Heading 1','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_heading_1',
										  'group' => 'size|spacing|m-size|line_height',
										  'default' => array(
											  'size' => '66px',
											  'spacing' => '0px',
											  'm-size' => '32px',
											  'line_height' => '1.2'
										  )
									),
									
									// Post Page Heading 2 Font
									array('title' => esc_html__('Heading 2','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_heading_2',
										  'group' => 'size|spacing|m-size|line_height',
										  'default' => array(
											  'size' => '46px',
											  'spacing' => '0px',
											  'm-size' => '28px',
											  'line_height' => '1.2'
										  )
									),
									
									// Post Page Heading 3 Font
									array('title' => esc_html__('Heading 3','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_heading_3',
										  'group' => 'size|spacing|m-size|line_height',
										  'default' => array(
											  'size' => '38px',
											  'spacing' => '0px',
											  'm-size' => '24px',
											  'line_height' => '1.2'
										  )
									),
									
									// Post Page Heading 4 Font
									array('title' => esc_html__('Heading 4','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_heading_4',
										  'group' => 'size|spacing|m-size|line_height',
										  'default' => array(
											  'size' => '26px',
											  'spacing' => '0px',
											  'm-size' => '22px',
											  'line_height' => '1.2'
										  )
									),
									
									// Post Page Heading 5 Font
									array('title' => esc_html__('Heading 5','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_heading_5',
										  'group' => 'size|spacing|m-size|line_height',
										  'default' => array(
											  'size' => '22px',
											  'spacing' => '0px',
											  'm-size' => '18px',
											  'line_height' => '1.2'
										  )
									),
									
									// Post Page Heading 6 Font
									array('title' => esc_html__('Heading 6','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_heading_6',
										  'group' => 'size|spacing|m-size|line_height',
										  'default' => array(
											  'size' => '16px',
											  'spacing' => '0px',
											  'm-size' => '14px',
											  'line_height' => '1.2'
										  )
									),

									// Post Page Title Font
									array('title' => esc_html__('Page/Post Title','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_title',
										  'group' => 'family|size|spacing|m-size|line_height',
										  'default' => array(
										  	  'family' => 'Roboto',
											  'size' => '42px',
											  'spacing' => '0px',
											  'm-size' => '26px',
											  'line_height' => '1.4'
										  )
									),
									
									// Post Page meta Font
									array('title' => esc_html__('Meta','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_meta',
										  'group' => 'family|size|m-size|line_height',
										  'default' => array(
										  	  'family' => 'Roboto',
											  'size' => '16px',
											  'spacing' => '0px',
											  'm-size' => '14px',
											  'line_height' => '1.8'
										  )
									),
			
									// All Images Caption
									array('title' => esc_html__('Image Caption','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_caption',
										  'group' => 'family|size|spacing|m-size|line_height'
									),
									
									// Post Previous $ Next
									array('title' => esc_html__('Post Previous & Next','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_navi',
										  'group' => 'family|size|m-size'
									),
			
									// Comment Title
									array('title' => esc_html__('Comments Title','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_comments_title',
										  'group' => 'family|size|m-size',
										  'default' => array(
										  	  'family' => 'Roboto',
											  'size' => '22px',
											  'spacing' => '0px',
											  'm-size' => '16px'
										  )
									),
			
									// Comment Content
									array('title' => esc_html__('Comments Content','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_comments_content',
										  'group' => 'family|size|m-size',
										  'default' => array(
										  	  'family' => 'Roboto',
											  'size' => '16px', 
											  'm-size' => '15px'
										  )
									),
			
									//Comment Author Name
									array('title' => esc_html__('Comments Author Name','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_post_page_comments_author',
										  'group' => 'size|m-size',
										  'default' => array( 
											  'size' => '18px', 
											  'm-size' => '16px'
										  )
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'button-font',
				'title'     => esc_html__('Button','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_button_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									// Buttons
									array('title' => esc_html__('Button','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_button',
										  'group' => 'family|size|spacing|m-size'
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'form-font',
				'title'     => esc_html__('Form','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_form_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									// Text Input Box
									array('title' => esc_html__('Text Input Box','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_form',
										  'group' => 'family|size|m-size'
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'archive-font',
				'title'     => esc_html__('Archive','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_archive_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									// Archive Title
									array('title' => esc_html__('Title','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_archive_title',
										  'group' => 'family|size|m-size',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '26px',
											  'm-size' => '20px'
										  )
									),
									
									// Archive Posts Title
									array('title' => esc_html__('Posts Title','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_archive_posts_title',
										  'group' => 'family|size|m-size',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '32px',
											  'm-size' => '22px'
										  )
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'widgets-font',
				'title'     => esc_html__('Widgets','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_widgets_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									// Widget Title
									array('title' => esc_html__('Widget Title','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_widget_title',
										  'group' => 'family|size|m-size',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '18px',
											  'm-size' => '16px'
										  )
									),
									
									// Widget Content
									array('title' => esc_html__('Widget Content','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_widget_content',
										  'group' => 'family|size|m-size',
										  'default' => array(
											  'family' => 'Roboto',
											  'size' => '16px',
											  'm-size' => '16px'
										  )
									)	 
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'footer-font',
				'title'     => esc_html__('Footer','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_footer_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									// Footer
									array('title' => esc_html__('Footer','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_footer',
										  'group' => 'family|size|m-size'
									),
									array('title' => esc_html__('Cookie Consent Message Bar','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_cookie_bar',
										  'group' => 'family|size|m-size'
									),
									array('title' => esc_html__('Cookie Consent Message Bar Button','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_cookie_bar_btn',
										  'group' => 'family|size|m-size'
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'woo-font',
				'title'     => esc_html__('WooCommerce','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_woo_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title' => esc_html__('Single Product Title','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_woo_single_tit',
										  'group' => 'family|size|spacing|m-size|line_height',
										  'default' => array( 
											  'size' => '28px',
											  'm-size' => '20px'
										  )
									),
									array('title' => esc_html__('Single Product Content','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_woo_single_con',
										  'group' => 'family|size|spacing|m-size|line_height'
									),
									array('title' => esc_html__('Single Product Price','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_woo_single_price',
										  'group' => 'family|size|spacing|m-size|line_height'
									),
									array('title' => esc_html__('Single Product Meta','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_woo_single_meta',
										  'group' => 'family|size|spacing|m-size|line_height'
									),
									array('title' => esc_html__('Archive(Shop) Items Title','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_woo_archive_item_tit',
										  'group' => 'family|size|spacing|m-size|line_height'
									),
									array('title' => esc_html__('Archive(Shop) Items Price','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_woo_archive_item_price',
										  'group' => 'family|size|spacing|m-size|line_height'
									),
									array('title' => esc_html__('Archive(Shop) Items Add-Cart Button','sea-theme'),
										  'type'  => 'fonts-group',
										  'name'  => '_ux_cb_module_fonts_woo_archive_item_add_cart',
										  'group' => 'family|size|spacing|m-size|line_height'
									),
								)
							)
						)
					)
				)
			)
		);
		
		return $fonts_fields;
	}
	add_filter( 'ux-cb-fonts-assignment-config', 'seatheme_theme_options_config_fonts_fields' );
}

//require theme options general config
require_once get_template_directory() . '/functions/theme/options/config/general.php';
require_once get_template_directory() . '/functions/theme/options/config/header.php';
require_once get_template_directory() . '/functions/theme/options/config/footer.php';
require_once get_template_directory() . '/functions/theme/options/config/layout.php';
require_once get_template_directory() . '/functions/theme/options/config/social.php';
require_once get_template_directory() . '/functions/theme/options/config/schemes.php';
require_once get_template_directory() . '/functions/theme/options/config/cookies.php';
require_once get_template_directory() . '/functions/theme/options/config/blog-list.php';

//woocommerce
if ( class_exists( 'WooCommerce' ) ) {
	require_once get_template_directory() . '/functions/theme/options/config/woocommerce.php';
}

//require theme options fields
require_once get_template_directory() . '/functions/theme/options/fields/field-switch.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-input.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-upload.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-select.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-post.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-social.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-checkbox.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-items.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-textarea.php';
require_once get_template_directory() . '/functions/theme/options/fields/field-divider.php';

//theme options config
if ( ! function_exists( 'seatheme_theme_options_config' ) ) {
	function seatheme_theme_options_config( $fields=array() ) {
		
		$fields = seatheme_theme_options_config_fields();
		$themeOptionsFields = apply_filters( 'seatheme_theme_options_fields', array() );
		if ( count( $themeOptionsFields ) > 0 ) {
			$switch = false;
			
			if ( isset( $_GET['page'] ) ) {
				if ( $_GET['page'] == 'theme-option' || 
					$_GET['page'] == 'ux-cb-tools' ) {
					$switch = true;
				}
			}
			
			if ( isset( $_POST['typeSlug'] ) ) {
				if ( $_POST['typeSlug'] == 'options' ) {
					$switch = true;
				}
			}
			
			global $pagenow;
			if ( $pagenow == 'customize.php' ) {
				$switch = true;
			}
			
			if ( $switch ) {
				$fields = $themeOptionsFields;
			}
		}
		
		return $fields;
	}
	add_filter( 'seatheme_theme_options_config', 'seatheme_theme_options_config' );
}

$GLOBALS['ux_theme_config_fields'] = seatheme_theme_options_config();
?>