<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field switch.
 */
if ( ! function_exists( 'seatheme_theme_options_field_switch' ) ) {
	function seatheme_theme_options_field_switch( $item, $key, $getValue ) {
		if ( $item['type'] == 'switch' ) {
			echo '<div class="switch make-switch" data-on="success" data-off="danger">';
			echo   '<input type="checkbox" value="true" ' .checked( esc_attr( $getValue ), 'true', false ). ' />';
			echo   '<input type="hidden" name="' .esc_attr( $key. '[' .$item['name']. ']' ). '" data-name="' .esc_attr( $item['name'] ). '" value="' .esc_attr( $getValue ). '" />';
			echo '</div>';
		}
		
		if ( $item['type'] == 'switchColor' ) {
			$schemeName = false;
			if ( $item['sName'] ) {
				$schemeName = 'data-scheme="scheme_' .esc_attr( $item['sName'] ). '"';
			}
			
            echo '<div class="ux-theme-switch-color" ' .sanitize_text_field( $schemeName ). ' style="' .esc_attr( $item['style'] ). '">';
            echo   '<input type="text" class="form-control switch-color" data-position="bottom left" value="' .sanitize_text_field( $getValue ). '" name="' .esc_attr( $key. '[' .$item['name']. ']' ). '" />';
            echo   '<span class="ux-theme-remove-color"></span>';
            echo '</div>';
			
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_switch', 10, 3 );
}

?>