<?php
//schemes setting config fields
if ( ! function_exists( 'seatheme_theme_options_schemes_fields' ) ) {
	function seatheme_theme_options_schemes_fields( $fields ) {
		$fields['schemes'] = array(
			'id' => 'options-schemes',
			'title' => esc_html__( 'Colors', 'sea-theme' ),
			'region' => array(
				array(
					'region-id' => 'schemes-main',
					'title' => esc_html__( 'Global', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Page Post Bg Color
										array('title'   => esc_html__( 'Background Color', 'sea-theme' ),
											  'desc'    => esc_html__( 'background color for the page area', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_bg_page_post',
											  'sName'   => 'page_post_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),
				
										// Page Post Bg Color
										array('title'   => esc_html__( 'Header Bg Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_bg_header',
											  'sName'   => 'header_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),
				
										// Page Post Bg Color
										array('title'   => esc_html__( 'Page Loader Bg Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_bg_page_loader',
											  'sName'   => 'page_loader_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ), 
				
										//** Auxiliary Color
										array('title'   => esc_html__( 'Auxiliary Color', 'sea-theme' ),
											  'desc'    => esc_html__( 'for audio player bar, widgets divide line etc', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_second_auxiliary',
											  'sName'   => 'second_auxiliary_color',
											  'style'   => 'width: 200px;',
											  'default' => '#F8F8F8' ),
									)
								)
							)
						)
					)
				),
                             
				array(
					'region-id' => 'schemes-menu',
					'title' => esc_html__( 'Menu', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Menu on Header Dark
										array('title'   => esc_html__( 'Default Menu Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_menu_icon_dark',
											  'sName'   => 'menu_icon_dark',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),


										// Menu Item Mouseover Color
										array('title'   => esc_html__( 'Default Menu Color Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_menu_mouseover_color',
											  'sName'   => 'menu_mouseover_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),

										// Menu Current Item Color
										array('title'   => esc_html__( 'Default Current Item Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_menu_current_color',
											  'sName'   => 'menu_current_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										// Alternative Menu color
										array('title'   => esc_html__( 'Alternative Menu Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_menu_icon_alt',
											  'sName'   => 'menu_icon_alt',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),

										// Alternative Menu Item Mouseover Color
										array('title'   => esc_html__( 'Alternative Menu Color Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_menu_mouseover_color_alt',
											  'sName'   => 'menu_mouseover_color_alt',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),

										// Alternative Menu Current Item Color
										array('title'   => esc_html__( 'Alternative Current Item Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_menu_current_color_alt',
											  'sName'   => 'menu_current_color_alt',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' )
									)
								)
							)
						)
					)
				),
							  
				array(
					'region-id' => 'schemes-post-page',
					'title' => esc_html__( 'Posts & Pages', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Title
										array('title'   => esc_html__( 'Title Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_heading',
											  'sName'   => 'heading_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
											  
										// Content 
										array('title'   => esc_html__( 'Content Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_content_text',
											  'sName'   => 'content_text_color',
											  'style'   => 'width: 200px;',
											  'default' => '#414145' ),

										// Content linked text
										array('title'   => esc_html__( 'Content Link Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_content_linked_text',
											  'sName'   => 'content_text_linked_color',
											  'style'   => 'width: 200px;',
											  'default' => '#B8A772' ),

										// Content mouseover
										array('title'   => esc_html__( 'Content Link Text Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_content_hover_text',
											  'sName'   => 'content_text_hover_color',
											  'style'   => 'width: 200px;',
											  'default' => '#414145' ),
											  
										// Meta
										array('title'   => esc_html__( 'Meta Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_auxiliary_content',
											  'sName'   => 'auxiliary_content_color',
											  'style'   => 'width: 200px;',
											  'default' => '#adadad' ),

										// Meta link text
										array('title'   => esc_html__( 'Meta Link Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_meta_link',
											  'sName'   => 'meta_link_color',
											  'style'   => 'width: 200px;',
											  'default' => '#B8A772' ),

										// Meta link text mouseover
										array('title'   => esc_html__( 'Meta Link Text Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_meta_link_hover',
											  'sName'   => 'meta_link_hover_color',
											  'style'   => 'width: 200px;',
											  'default' => '' ),
				
										// All Images Caption 
										array('title'   => esc_html__( 'Image Caption', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_gallery_caption',
											  'sName'   => 'gallery_caption_color',
											  'style'   => 'width: 200px;',
											  'default' => '#666666' ),
											  
										// Prev & Next
										array('title'   => esc_html__( 'Previous & Next', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_post_navi',
											  'sName'   => 'post_navi_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										// Comment Title
										array('title'   => esc_html__( 'Comment Title', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_comment_tit',
											  'sName'   => 'comment_tit_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										// Comment Content
										array('title'   => esc_html__( 'Comment Content', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_comment_con',
											  'sName'   => 'comment_con_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										// Comment Author
										array('title'   => esc_html__( 'Comment Author Name', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_comment_author',
											  'sName'   => 'comment_author_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),

										// Archive Title mouseover
										array('title'   => esc_html__( 'Archive Item Title Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_arvhive_tit_hover',
											  'sName'   => 'arcive_tit_hover_color',
											  'style'   => 'width: 200px;',
											  'default' => '' ),
				
										// Selected Text Color
										array('title'   => esc_html__( 'Selected Text Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_selected_text_font',
											  'sName'   => 'selected_text_font_color',
											  'style'   => 'width: 200px;',
											  'default' => '#000000' ),
				
										// Selected Text Bg Color
										array('title'   => esc_html__( 'Selected Text Bg Color', 'sea-theme' ),
											  'desc'    => esc_html__( 'the color for selected text background', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_selected_text_bg',
											  'sName'   => 'selected_text_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#DBD7D2' ), 
									)
								)
							)
						)
					)
				),
				
				array(
					'region-id' => 'schemes-logo',
					'title' => esc_html__( 'Plain Text Logo', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Logo Text Color
										array('title'   => esc_html__( 'Default Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_logo',
											  'sName'   => 'logo_text_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										//  Logo Text Alt Color (Light)
										array('title'   => esc_html__( 'Alternative Color', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_logo_text_color_alt',
											  'sName'   => 'logo_text_color_alt',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' )
									)
								)
							)
						)
					)
				),

				array(
					'region-id' => 'schemes-button',
					'title' => esc_html__( 'Button', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									  
										array('title'   => esc_html__( 'Text & Border', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_button',
											  'sName'   => 'button_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										array('title'   => esc_html__( 'Text Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_button_mouseover',
											  'sName'   => 'button_mouseover_color',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),
				
										array('title'   => esc_html__( 'Bg Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_button_bg_mouseover',
											  'sName'   => 'button_bg_mouseover_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' )
									)
								)
							)
						)
					)
				),

				array(
					'region-id' => 'schemes-form',
					'title' => esc_html__( 'Form', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										array('title'   => esc_html__( 'Text Input Box by Default', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_form',
											  'sName'   => 'form_color',
											  'style'   => 'width: 200px;',
											  'default' => '#adadad' ),
				
										array('title'   => esc_html__( 'Text Input Box Focused', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_form_focused',
											  'sName'   => 'form_focused_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' )
									)
								)
							)
						)
					)
				),
				
				array(
					'region-id' => 'schemes-widget',
					'title' => esc_html__( 'Widget', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Widget Title Color
										array('title'   => esc_html__( 'Title Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_widget_title_sidebar',
											  'sName'   => 'widget_title_sidebar_color',
											  'style'   => 'width: 200px;',
											  'default' => '' ), 
											  
										// Widget Content Color
										array('title'   => esc_html__( 'Content Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_widget_content_color',
											  'sName'   => 'widget_content_color',
											  'style'   => 'width: 200px;',
											  'default' => '' ),

										// Widget Content Link Color
										array('title'   => esc_html__( 'Content Link Text', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_widget_content_link',
											  'sName'   => 'widget_content_link_color',
											  'style'   => 'width: 200px;',
											  'default' => '' ),

										// Widget Content Link Mouseover
										array('title'   => esc_html__( 'Content Link Text Mouseover', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_color_widget_content_link_hover',
											  'sName'   => 'widget_content_link_color',
											  'style'   => 'width: 200px;',
											  'default' => '#C2AB6B' )
									)
								)
							)
						)
					)
				),
							  
				array(
					'region-id' => 'schemes-footer',
					'title' => esc_html__( 'Footer', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(

										// Footer Bg Color
										array('title'   => esc_html__( 'Footer Bg Color', 'sea-theme' ),
											  'desc'    => '',
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_footer_bg_color',
											  'sName'   => 'footer_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),
									
										// Footer Text Color
										array('title'   => esc_html__( 'Footer Text', 'sea-theme' ),
											  'desc'    => '',
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_footer_text_color',
											  'sName'   => 'footer_text_color',
											  'style'   => 'width: 200px;',
											  'default' => '#28282E' ),

										// Footer Text Link Color
										array('title'   => esc_html__( 'Footer Text Link', 'sea-theme' ),
											  'desc'    => '',
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_footer_text_link_color',
											  'sName'   => 'footer_text_link_color',
											  'style'   => 'width: 200px;',
											  'default' => '' ),
											  
										// Footer Text Link Mouseover Color
										array('title'   => esc_html__( 'Footer Text Link Mouseover', 'sea-theme' ),
											  'desc'    => '',
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_footer_text_link_hover_color',
											  'sName'   => 'footer_text_link_hover_color',
											  'style'   => 'width: 200px;',
											  'default' => '' ),
									)
								)
							)
						)
					)
				),

				array(
					'region-id' => 'schemes-general-default-skin',
					'title' => esc_html__( 'Others', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(

										//Lightbox Color Skin
										array('title'   => esc_html__( 'Lightbox Color Skin', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_color_skin_lightbox',
											  'sName'   => 'color_skin_lightbox',
											  'style'   => 'width: 140px;',
											  'default' => 'pswp-dark-skin',
											  'fields'  => array(
												  array( esc_html__( 'Dark', 'sea-theme' ),  'pswp-dark-skin' ),
												  array( esc_html__( 'Light', 'sea-theme' ), 'pswp-light-skin' )
											  ) )
									)
								)
							)
						)
					)
				)
			)
		);
		
		return $fields;
		
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_schemes_fields' );
}