<?php
//header setting config fields
if ( ! function_exists( 'seatheme_theme_options_header_fields' ) ) {
	function seatheme_theme_options_header_fields( $fields ) {
		$fields['header'] = array(
			'id' => 'options-header',
			'title' => esc_html__( 'Header', 'sea-theme' ),
			'region' => array(
				array(
					'region-id' => 'header-layout',
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(

										// Menu Style
										array('title'   => esc_html__( 'Header Layout', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '90:64',
											  'name'    => 'theme_option_header_layout',
											  'default' => 'horizon-menu-right',
											  'data'    => array( 'position' => 'right bottom' ),
											  'fields'  => array(
												  array( esc_html__( 'Horizon Menu Right', 'sea-theme' ),       'horizon-menu-right' ),
												  array( esc_html__( 'Horizon Menu Center', 'sea-theme' ),      'horizon-menu-center' ),
												  array( esc_html__( 'Show Menu Icon', 'sea-theme' ),           'show-menu-icon' ),
												  array( esc_html__( 'Menu Icon - Popup2', 'sea-theme' ),       'menu-icon-popup2' ),
												  array( esc_html__( 'Menu Icon - Horizon Menu', 'sea-theme' ), 'menu-icon-horizon-menu' ),
												  array( esc_html__( 'Logo Centered', 'sea-theme' ),            'logo-centered' ),
												  array( esc_html__( 'Menu Justified', 'sea-theme' ),           'navi-justified' ),
												  array( esc_html__( 'Menu Corner', 'sea-theme' ),           	'navi-corner' )
											  ) 
										),

										// Menu Items Padding Top
										array('title'   => esc_html__( 'Menu Items Padding on Top', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_corner_menu_padding_top',
											  'ctrl'	=> 'theme_option_header_layout,navi-corner',
											  'default' => '60',
											  'style'   => 'width: 102px;' 
										),
										// Menu Items Padding Bottom
										array('title'   => esc_html__( 'Menu Items Padding on Bottom', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_corner_menu_padding_bottom',
											  'ctrl'	=> 'theme_option_header_layout,navi-corner',
											  'default' => '60',
											  'style'   => 'width: 102px;' 
										),
										// Menu Items Padding Left/Right
										array('title'   => esc_html__( 'Menu Items Padding on Left/Right', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_corner_menu_padding_left_right',
											  'ctrl'	=> 'theme_option_header_layout,navi-corner',
											  'default' => '60',
											  'style'   => 'width: 102px;' 
										)
									)
								)
							)
						),
					//)
				//),

				//array(
				//	'region-id' => 'header-layout2',
				//	'section' => array(
						array(
							//'section-ctrl' => 'theme_option_header_layout,horizon-menu-right|horizon-menu-center|show-menu-icon|menu-icon-popup2|menu-icon-horizon-menu|logo-centered|navi-justified',
							'group' => array(
								array(
									'group-ctrl' => 'theme_option_header_layout,horizon-menu-right|horizon-menu-center|show-menu-icon|menu-icon-popup2|menu-icon-horizon-menu|logo-centered|navi-justified',
									'items' => array(
										// Menu Width
										array('title'   => esc_html__( 'Header & Footer Width', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_header_width',
											  'style'   => 'width: 132px;',
											  'default' => 'fluid',
											  'fields'  => array( 
												  array( esc_html__( 'Fluid Width', 'sea-theme' ), 'fluid' ),
												  array( esc_html__( 'Fixed Width', 'sea-theme' ), 'fixed' ) 
											  ) 
										), 
				
										// Header Fluid Padding
										array('title'   => esc_html__( 'Header & Footer Fluid Padding', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_header_padding',
											  'ctrl' => 'theme_option_header_width,fluid',
											  'default' => '',
											  'style'   => 'width: 102px;' ),
									 
											  
										// Header Height
										array('title'   => esc_html__( 'Header Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_header_height', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
											  
										// Header Bar Sticky Top
										array('title'   => esc_html__( 'Header Bar Sticky', 'sea-theme' ),
											  'type'    => 'select',
											  'style'   => 'width: 102px;',
											  'name'    => 'theme_option_header_sticky',
											  'default' => 'header-sticky-none',
											  'fields'  => array(
												  array( esc_html__( 'None', 'sea-theme' ),                    'header-sticky-none' ),
												  array( esc_html__( 'Always sticky', 'sea-theme' ),           'header-sticky' ),
												  array( esc_html__( 'Sticky when scrolling back', 'sea-theme' ), 'header-sticky-back' )
											  ) ),
											  
										// Header Height
										array('title'   => esc_html__( 'Sticky Header Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_header_sticky_height', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
									 
											  
										//Logo bottom spacing
										array('title'   => esc_html__( 'Bottom Spacing for Logo', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_logo_bottom_spacing',
											  'ctrl' => 'theme_option_header_layout,logo-centered',
											  'style'   => 'width: 102px;' )
									)
								),
								array(
									'items' => array(
				
										// Menu Icon style
										array('title'   => esc_html__( 'Menu Icon Style', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '50:50',
											  'name'    => 'theme_option_menu_icon_style', 
											  'default' => 'menu-icon-default',
											  'fields'  => array(
												  array( esc_html__( 'Default', 'sea-theme' ), 'menu-icon-default' ),
												  array( esc_html__( 'Classic', 'sea-theme' ), 'menu-icon-hamburg' )
											  ) ),
									
										//  Menu Icon Container
										array('title'   => esc_html__( 'Menu Icon Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_menu_icon_height',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				
										//Menu Icon left spacing
										array('title'   => esc_html__( 'Left Spacing for Menu Icon', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_menu_icon_left_spacing', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				 
									)
								),
								array(
									'group-ctrl' => 'theme_option_header_layout,horizon-menu-right|horizon-menu-center|show-menu-icon|menu-icon-popup2|menu-icon-horizon-menu|logo-centered|navi-justified',
									'items' => array(
				
										// Hide Menu Item 
										array('title'   => esc_html__( 'Hide Menu on Header', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_hide_menu',
											  'ctrl' => 'theme_option_header_layout,horizon-menu-right|horizon-menu-center|logo-centered',
											  'default' => 'false' 
										),
				
										// Header Menu Left Spacing  
										array('title'   => esc_html__( 'Left Spacing for Header Menu', 'sea-theme' ),
											  'type'    => 'input',
											  'style'   => 'width: 102px;',
											  'ctrl' => 'theme_option_header_layout,horizon-menu-center',
											  'name'    => 'theme_option_menu_left_spacing' 
										),
				
										// Menu Item Spacing Horizontal
										array('title'   => esc_html__( 'Horizontal Spacing for Menu Items on Header', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_menu_item_spacing_h',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),
				
										// Show Header Icon
										array('title'   => esc_html__( 'Show Header Icon', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_portfolio_icon',
											  'default' => 'false' 
										),
				
										// Header Icon style
										array('title'   => esc_html__( 'Header Icon Style', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '50:50',
											  'name'    => 'theme_option_header_icon_style', 
											  'default' => 'header-icon-default',
											  'ctrl' => 'theme_option_portfolio_icon,true',
											  'fields'  => array(
												  array( esc_html__( 'Default','sea-theme' ), 'header-icon-default' ),
												  array( esc_html__( 'Classic','sea-theme' ), 'header-icon-classic' )
											  ) 
										),
											  
										// Choose a Page for Header Icon
										array('title'   => esc_html__( 'Choose a Page for Header Icon to Pop-up', 'sea-theme' ),
											  'type'    => 'post',
											  'pType'   => 'page',
											  'name'    => 'theme_option_show_portfolio_icon_page_id',
											  'ctrl' => 'theme_option_portfolio_icon,true',
											  'default' => 0 
										),
				
										// Header Icon height
										array('title'   => esc_html__( 'Header Icon Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_portfolio_icon_height',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'ctrl' => 'theme_option_portfolio_icon,true',
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),

										//Header Icon left spacing
										array('title'   => esc_html__( 'Left Spacing for Header Icon', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_portfolio_icon_left_spacing', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'ctrl' => 'theme_option_portfolio_icon,true',
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),
				
										// Show Social Links 
										array('title'   => esc_html__( 'Show Social Links', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_social',
											  'default' => 'false' 
										), 
				
										//Social links left spacing
										array('title'   => esc_html__( 'Left Spacing for Social Links', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_social_links_left_spacing', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'ctrl'	=> 'theme_option_show_social,true',
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),
									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'header-menu-hover',
					'title' => esc_html__( 'Menu Hover', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(

										// Menu Item Hover Effect
										array('title'   => esc_html__( 'Menu Item Mouseover Effect', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '100:50',
											  'name'    => 'theme_option_menu_hover_effect', 
											  'default' => 'menu_hover_default',
											  'fields'  => array(
												  array( esc_html__( 'Default', 'sea-theme' ),  	 'menu-hover-default' ),
												  array( esc_html__( 'Under line 1', 'sea-theme' ),  'menu-hover-underline1' ),
												 // array( esc_html__( 'Around line 1', 'sea-theme' ), 'menu-hover-aroundline1' ),
												  array( esc_html__( 'Diagonal line', 'sea-theme' ), 'menu-hover-diagonalline' ),
												  array( esc_html__( 'Camera', 'sea-theme' ),        'menu-hover-camera' )
											  ) )
										)
									),

								array(
									'group-ctrl' => 'theme_option_menu_hover_effect,menu-hover-underline1',
									'items' => array(
				
										// Distance
										array('title'   => esc_html__( 'The Underline Distance from Text', 'sea-theme' ),
											  'default' => esc_html__( '9', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_menu_hover_effect_underline_distance',
											  'style'   => 'width: 102px;',
											  'fields'  => array(
												  array( esc_html__( '0', 'sea-theme' ),   ''),
												  array( esc_html__( '1', 'sea-theme' ), '1'),
												  array( esc_html__( '2', 'sea-theme' ), '2'),
												  array( esc_html__( '3', 'sea-theme' ), '3'),
												  array( esc_html__( '4', 'sea-theme' ), '4'),
												  array( esc_html__( '5', 'sea-theme' ), '5'),
												  array( esc_html__( '6', 'sea-theme' ), '6'),
												  array( esc_html__( '7', 'sea-theme' ), '7'),
												  array( esc_html__( '8', 'sea-theme' ), '8'),
												  array( esc_html__( '9', 'sea-theme' ), '9'),
												  array( esc_html__( '10', 'sea-theme' ), '10'),
											  )
										)
				 
									)
								),
								 
								array(
									'group-ctrl' => 'theme_option_menu_hover_effect,menu-hover-diagonalline',
									'items' => array(
				
										// Hover Line Color
										array('title'   => esc_html__( 'Hover Line Color', 'sea-theme' ), 
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_menu_hover_effect_diagonalline_color',
											  'style'   => 'width: 200px;' ),
				
										// Hover Line Width
										array('title'   => esc_html__( 'Hover Line Length', 'sea-theme' ),
											  'default' => esc_html__( '70', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_menu_hover_effect_diagonalline_width',
											  'style'   => 'width: 102px;' ),
				
										// Hover Line Border
										array('title'   => esc_html__( 'Hover Line Thickness', 'sea-theme' ),
											  'default' => esc_html__( '4', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_menu_hover_effect_diagonalline_border',
											  'style'   => 'width: 102px;' )
									)
								),
									 
							)
						)
					)
				),
				array(
					'region-id' => 'header-expanded-panel',
					'title' => esc_html__( 'Expanded Panel', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Show Search Button On Menu panel
										array('title'   => esc_html__( 'Show Search on Expanded Panel', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_search_on_expanded_menu_panel',
											  'default' => 'false' ),
				
										//Menu algin on Menu panel
										array('title'   => esc_html__( 'Menu List Align', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_menu_align_on_expanded_menu_panel',
											  'style'   => 'width: 102px;',
											  'fields'  => array(
												  array( esc_html__( 'Left', 'sea-theme' ),   ''),
												  array( esc_html__( 'Center', 'sea-theme' ), 'menu-panel-align-center'),
												  array( esc_html__( 'Right', 'sea-theme' ), 'menu-panel-align-right')
											  ) ),
				
										// Menu Item Spacing vertical
										array('title'   => esc_html__( 'Vertical Spacing for Menu Items', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_menu_item_spacing_v',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) )
									)
								),
								array(
									'group-ctrl' => 'theme_option_header_layout,menu-icon-popup2',
									'items' => array(
				
										// Menu Item Spacing Horizontal
										array('title'   => esc_html__( 'Horizontal Spacing for Menu Items', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_menu_item_spacing_h_expand_panel',
											  'style'   => 'width: 102px;' )
									)
								)
							)
						)
					)
				),
 				array(
					'region-id' => 'header-layout-mobile',
					'title' => esc_html__( 'Header on Mobile', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Menu Style
										array('title'   => esc_html__( 'Header Layout on Mobile', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '90:64',
											  'name'    => 'theme_option_header_layout_mobile',
											  'default' => 'show-menu-icon-mobile',
											  'data'    => array( 'position' => 'right bottom' ),
											  'fields'  => array(
												  array( esc_html__( 'Show Menu Icon', 'sea-theme' ),     'show-menu-icon-mobile' ),
												  array( esc_html__( 'Horizon Menu Right', 'sea-theme' ), 'show-menu-item-mobile' ),
												  array( esc_html__( 'Logo Centered', 'sea-theme' ),      'logo-centered-mobile' )
											  ) )
									)
								),
								array(
									'group-ctrl' => 'theme_option_header_layout_mobile,logo-centered-mobile',
									'items' => array(
				
										//Logo bottom spacing mobile
										array('title'   => esc_html__( 'Bottom Spacing for Logo on Mobile', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_logo_bottom_spacing_mobile', 
											  'style'   => 'width: 102px;' )
									)
								),
								array(
									'items' => array(
				
										// Show Social Links on mobile
										array('title'   => esc_html__( 'Show Social Links on Mobile', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_social_header_mobile',
											  'default' => 'false' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_portfolio_icon,true',
									'items' => array(
				
										// Show Portfolio Icon Mobile
										array('title'   => esc_html__( 'Show Portfolio Icon on Mobile', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_portfolio_icon_mobile',
											  'default' => 'false' )
									)
								)
							)
						)
					)
				)
			)
		);
		
		return $fields;
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_header_fields' );
}