<?php
//blog list setting config fields
if ( ! function_exists( 'seatheme_theme_options_blog_list_fields' ) ) {
	function seatheme_theme_options_blog_list_fields( $fields ) {
		$fields['blog-list'] = array(
			'id' => 'options-blog-list',
			'title' => esc_html__( 'Blog List', 'sea-theme' ),
			'region' => array(
				array(
					'region-id' => 'blog-list',
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Layout
										array('title'   => esc_html__( 'Layout', 'sea-theme' ),
											  'type'    => 'imageSelect',
											  'size'    => '126:80',
											  'name'    => 'theme_option_blog_list_sidebar',
											  'default' => 'without-sidebar',
											  'data'    => array( 'position' => 'right bottom' ),
											  'fields'  => array(
												  array( esc_html__( 'Right Sidebar', 'sea-theme' ),   'right-sidebar' ),
												  array( esc_html__( 'Left Sidebar', 'sea-theme' ),    'left-sidebar' ),
												  array( esc_html__( 'Without Sidebar', 'sea-theme' ), 'without-sidebar' )
											  ) ),
									
										// widgets
										array('type'    => 'select',
											  'name'    => 'theme_option_blog_list_sidebar_widgets',
											  'default' => 'without-sidebar',
											  'ctrl'    => 'theme_option_blog_list_sidebar,left-sidebar|right-sidebar',
											  'style'   => 'width: 200px;',
											  'fields'  => theme_option_blog_list_sidebar_widgets() ),
											  
										// List Width
										array('title'   => esc_html__( 'List Width', 'sea-theme' ),
											  'type'    => 'select',
											  'style'   => 'width: 200px;',
											  'name'    => 'theme_option_blog_list_width',
											  'ctrl'    => 'theme_option_blog_list_sidebar,without-sidebar',
											  'default' => 'bm-width-100',
											  'fields'  => array(
												  array( esc_html__( '100%', 'sea-theme' ), 'bm-width-100' ),
												  array( esc_html__( '90%', 'sea-theme' ), 'bm-width-90' ),
												  array( esc_html__( '80%', 'sea-theme' ), 'bm-width-80' ),
												  array( esc_html__( '70%', 'sea-theme' ), 'bm-width-70' ),
												  array( esc_html__( '60%', 'sea-theme' ), 'bm-width-60' ),
												  array( esc_html__( '50%', 'sea-theme' ), 'bm-width-50' )
											  ) ),
				
										// Blog Title & Description
										array('title'   => esc_html__( 'Blog Title & Description', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_blog_list_switch_title',
											  'default' => 'false' ),
				
										// Blog Title 
										array('title'   => esc_html__( 'Blog Title', 'sea-theme' ),
											  'desc'    => esc_html__( 'For Blog Page set by "Settings > Reading: Posts page"', 'sea-theme' ),
											  'type'    => 'input',
											  'style'   => 'width: 50%;',
											  'ctrl'    => 'theme_option_blog_list_switch_title,true',
											  'name'    => 'theme_option_blog_list_blog_title' ),
				
										// Blog Description (subtitle) 
										array('title'   => esc_html__( 'Blog Description (subtitle)', 'sea-theme' ),
											 'desc'    => esc_html__( 'For Blog Page set by "Settings > Reading: Posts page"', 'sea-theme' ),
											  'type'    => 'textarea',
											  'style'   => 'width: 50%;',
											  'ctrl'    => 'theme_option_blog_list_switch_title,true',
											  'name'    => 'theme_option_blog_list_blog_desc' ),
											  
										// Columns
										array('title'   => esc_html__( 'Columns', 'sea-theme' ),
											  'type'    => 'multipleSelect',
											  'style'   => 'width: 102px; display: inline-block; margin-right: 15px;',
											  'name'    => 'theme_option_blog_list_column_s',
											  'default' => array( 'desktop' => 'archive-list-col1', 'mobile' => 'archive-list-col1_m' ),
											  'colSlug' => array( 'desktop', 'mobile' ),
											  'fields'  => array(
												  array( esc_html__( '1', 'sea-theme' ), 'archive-list-col1' ),
												  array( esc_html__( '2', 'sea-theme' ), 'archive-list-col2' ),
												  array( esc_html__( '3', 'sea-theme' ), 'archive-list-col3' ),
												  array( esc_html__( '4', 'sea-theme' ), 'archive-list-col4' ),
												  array( esc_html__( '5', 'sea-theme' ), 'archive-list-col5' ),
												  array( esc_html__( '6', 'sea-theme' ), 'archive-list-col6' )
											  ) ),

										// Items Horizontal Spacing
										array('title'   => esc_html__( 'Items Horizontal spacing', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_blog_list_items_spacing_h',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'default' => array('30', '20'),
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),

										//Vertical spacing
										array('title'   => esc_html__( 'Items Vertical spacing', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_blog_list_items_spacing_v',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'default' => array('100', '40'),
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) 
										),
											  
										// Item Layout
										array('title'   => esc_html__( 'Item Layout', 'sea-theme' ),
											  'type'    => 'select',
											  'style'   => 'width: 200px;',
											  'name'    => 'theme_option_blog_list_item_layout',
											  'default' => 'title+thumb+des',
											  'fields'  => array(
												  array( esc_html__( 'Title + Thumb + Des', 'sea-theme' ), 'title+thumb+des' ),
												  array( esc_html__( 'Thumb + Title + Des', 'sea-theme' ), 'thumb+title+des' )
											  ) ),
				
										array('type'    => 'divider'),
										
										// Read More
										array('title'   => esc_html__( 'Read More', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_blog_list_item_read_more',
											  'default' => 'true' ),
				
										// Social Share
										array('title'   => esc_html__( 'Social Share', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_blog_list_item_social_share',
											  'default' => 'true' ),
											  
										// Descriptions
										array('title'   => esc_html__( 'Item Summary', 'sea-theme' ),
											  'type'    => 'select',
											  'style'   => 'width: 200px;',
											  'name'    => 'theme_option_blog_list_item_descriptions',
											  'default' => 'excerpt',
											  'fields'  => array(
												  array( esc_html__( 'Excerpt', 'sea-theme' ), 'excerpt' ),
												  array( esc_html__( 'Whole Content', 'sea-theme' ), 'whole_content' ),
												  array( esc_html__( 'None', 'sea-theme' ), 'none' )
											  ) ),
				
										// Show Meta
										array('title'   => esc_html__( 'Show Meta', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_blog_list_item_show_meta',
											  'default' => 'true' ),
				  
										array('type'    => 'checkboxGroup',
											  'source'  => 'custom',
											  'name'    => 'theme_option_blog_list_item_meta',
											  'ctrl'    => 'theme_option_blog_list_item_show_meta,true',
											  'default' => array( 'date', 'category', 'author' ),
											  'fields'  => array(
												  array( esc_html__( 'Date', 'sea-theme' ),     'date' ), 
												  array( esc_html__( 'Category', 'sea-theme' ), 'category' ), 
												  array( esc_html__( 'Author', 'sea-theme' ),   'author' )
											  ) ),
				
										array('type'    => 'divider'),
				
										// Show Content Built by Content Builder on Blog
										array('title'   => esc_html__( 'Show Content Built by BM Content Builder on Blog Page', 'sea-theme' ),
											 'desc'    => esc_html__( 'For Blog Page set by "Settings > Reading : Posts page"', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_blog_list_show_cb',
											  'default' => 'false' )
									)
								)
							)
						)
					)
				)
			)
		);
		return $fields;
		
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_blog_list_fields' );
}

//blog list sidebar widgets fields
if ( ! function_exists( 'theme_option_blog_list_sidebar_widgets' ) ) {
	function theme_option_blog_list_sidebar_widgets() {
		$sidebars = array();
		
		for ( $i=1; $i<=10; $i++ ) {
			$sidebars[] = array(
				sprintf( esc_html__('Sidebar %s for Post/Page', 'sea-theme' ), $i ),
				sprintf( 'sidebar_%s', $i )
			);
		}
		
		return $sidebars;
	}
}